/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.IdentCaseSensitivity;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.metadata.LoadMetadataHelpers;
import com.adbs.metadata.MetadataFieldsFetcherFromQuery;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourcePropertiesDialog;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPropertiesDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.SybaseParser;
import com.adbs.syntax.SybaseQueryPropertiesDialog;
import com.adbs.syntax.SybaseScanner;
import com.adbs.syntax.SybaseServerVersion;
import com.adbs.syntax.SybaseSubQuerySelectExpressionExtender;
import com.adbs.utils.Str;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SybaseSyntaxProvider
extends BaseSyntaxProvider {
    private static final long serialVersionUID = 1L;
    private SybaseServerVersion serverVersion = SybaseServerVersion.SybaseASA;
    private SQLQualifiedName defaultDatabaseName = null;

    public SybaseSyntaxProvider() {
        try {
            this.registerExtender(SQLSubQuerySelectExpression.class, SybaseSubQuerySelectExpressionExtender.class);
        }
        catch (Exception ex) {
            Logger.getLogger(SybaseSyntaxProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void dispose() {
        if (this.defaultDatabaseName != null) {
            this.defaultDatabaseName.dispose();
            this.defaultDatabaseName = null;
        }
        super.dispose();
    }

    @Override
    public BaseSyntaxProvider clone() {
        SybaseSyntaxProvider result = (SybaseSyntaxProvider)super.clone();
        result.serverVersion = this.serverVersion;
        return result;
    }

    public SybaseServerVersion getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(SybaseServerVersion serverVersion) {
        if (this.serverVersion != serverVersion) {
            this.serverVersion = serverVersion;
            this.sendNotifications();
        }
    }

    @Override
    protected Class getScannerClass() {
        return SybaseScanner.class;
    }

    @Override
    protected Class getParserClass() {
        return SybaseParser.class;
    }

    @Override
    public String getDescription() {
        return "Sybase";
    }

    @Override
    public IdentCaseSensitivity getIdentCaseSens() {
        return IdentCaseSensitivity.Insensitive;
    }

    @Override
    public void getStarAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Count", false);
        names.addIdentifier("Count_Big", false);
    }

    @Override
    public void get1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("StdDev", false);
        names.addIdentifier("StdDev_Pop", false);
        names.addIdentifier("StdDev_Samp", false);
        names.addIdentifier("Var_Pop", false);
        names.addIdentifier("Var_Samp", false);
        names.addIdentifier("Variance", false);
    }

    @Override
    public void getPrefixed1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Avg", false);
        names.addIdentifier("Count", false);
        names.addIdentifier("Count_Big", false);
        names.addIdentifier("Max", false);
        names.addIdentifier("Min", false);
        names.addIdentifier("Sum", false);
    }

    public void getComparisonOperators(List sl) {
        sl.clear();
        sl.add("=");
        sl.add("<");
        sl.add("<=");
        sl.add(">");
        sl.add(">=");
        sl.add("<>");
        sl.add("!=");
        sl.add("!>");
        sl.add("!<");
    }

    @Override
    public String getQuoteBegin() {
        return "[";
    }

    @Override
    public String getQuoteEnd() {
        return "]";
    }

    @Override
    public boolean isSupportProcedures() {
        return true;
    }

    public void getUnionOperatorList(List sl) {
        super.getUnionOperatorList(sl);
        if (this.serverVersion == SybaseServerVersion.SybaseASA) {
            sl.add("Except");
            sl.add("Intersect");
        }
    }

    @Override
    public boolean isSupportSchemas() {
        return true;
    }

    @Override
    public Class getEditPropsFormClass(Object forObj) {
        if (forObj instanceof Link) {
            return LinkPropertiesDialog.class;
        }
        if (forObj instanceof DataSource) {
            return DataSourcePropertiesDialog.class;
        }
        if (forObj instanceof UnionSubQuery) {
            return SybaseQueryPropertiesDialog.class;
        }
        return super.getEditPropsFormClass(forObj);
    }

    @Override
    public void getBuiltinFunctionNames(SQLQualifiedNameList names) {
        super.getBuiltinFunctionNames(names);
        names.addBuiltin("Cast");
        names.addBuiltin("Convert");
        names.addBuiltin("HexToInt");
        names.addBuiltin("IntToHex");
        names.addBuiltin("IsDate");
        names.addBuiltin("IsNumeric");
        names.addBuiltin("Date");
        names.addBuiltin("DateAdd");
        names.addBuiltin("DateDiff");
        names.addBuiltin("DateFormat");
        names.addBuiltin("DateName");
        names.addBuiltin("DatePart");
        names.addBuiltin("DateTime");
        names.addBuiltin("Day");
        names.addBuiltin("DayName");
        names.addBuiltin("Days");
        names.addBuiltin("DoW");
        names.addBuiltin("GetDate");
        names.addBuiltin("Hour");
        names.addBuiltin("Hours");
        names.addBuiltin("Minute");
        names.addBuiltin("Minutes");
        names.addBuiltin("Month");
        names.addBuiltin("MonthName");
        names.addBuiltin("Months");
        names.addBuiltin("Now");
        names.addBuiltin("Quarter");
        names.addBuiltin("Second");
        names.addBuiltin("Seconds");
        names.addBuiltin("Today");
        names.addBuiltin("Weeks");
        names.addBuiltin("Year");
        names.addBuiltin("Years");
        names.addBuiltin("YMD");
        names.addBuiltin("ArgN");
        names.addBuiltin("Coalesce");
        names.addBuiltin("Compress");
        names.addBuiltin("Conflict");
        names.addBuiltin("Decompress");
        names.addBuiltin("Decrypt");
        names.addBuiltin("Encrypt");
        names.addBuiltin("ErrorMsg");
        names.addBuiltin("Estimate");
        names.addBuiltin("Estimate_Source");
        names.addBuiltin("Expirience_Estimate");
        names.addBuiltin("Explanation");
        names.addBuiltin("ExprType");
        names.addBuiltin("Get_Identity");
        names.addBuiltin("Graphical_Plan");
        names.addBuiltin("Graphical_ULPlan");
        names.addBuiltin("Greather");
        names.addBuiltin("Hash");
        names.addBuiltin("Identity");
        names.addBuiltin("IfNull");
        names.addBuiltin("Index_Estimate");
        names.addBuiltin("IsNull");
        names.addBuiltin("Lesser");
        names.addBuiltin("Long_ULPlan");
        names.addBuiltin("NewId");
        names.addBuiltin("NullIf");
        names.addBuiltin("Number");
        names.addBuiltin("Plan");
        names.addBuiltin("ReWrite");
        names.addBuiltin("Short_ULPlan");
        names.addBuiltin("SQLDialect");
        names.addBuiltin("TraceBack");
        names.addBuiltin("TransactSQL");
        names.addBuiltin("VarExists");
        names.addBuiltin("WatcomSQL");
        names.addBuiltin("Abs");
        names.addBuiltin("ACos");
        names.addBuiltin("ASin");
        names.addBuiltin("ATan");
        names.addBuiltin("ATn2");
        names.addBuiltin("Ceiling");
        names.addBuiltin("Cos");
        names.addBuiltin("Cot");
        names.addBuiltin("Degrees");
        names.addBuiltin("Exp");
        names.addBuiltin("Floor");
        names.addBuiltin("Log");
        names.addBuiltin("Log10");
        names.addBuiltin("Mod");
        names.addBuiltin("Pi");
        names.addBuiltin("Power");
        names.addBuiltin("Radians");
        names.addBuiltin("Rand");
        names.addBuiltin("Remainder");
        names.addBuiltin("Round");
        names.addBuiltin("Sign");
        names.addBuiltin("Sin");
        names.addBuiltin("SqRt");
        names.addBuiltin("Tan");
        names.addBuiltin("Truncate");
        names.addBuiltin("TruncNum");
        names.addBuiltin("HTML_Decode");
        names.addBuiltin("HTML_Encode");
        names.addBuiltin("HTTP_Decode");
        names.addBuiltin("HTTP_Encode");
        names.addBuiltin("HTTP_Variable");
        names.addBuiltin("Next_HTTP_Header");
        names.addBuiltin("Next_HTTP_Variable");
        names.addBuiltin("ASCII");
        names.addBuiltin("Base64_Decode");
        names.addBuiltin("Base64_Encode");
        names.addBuiltin("Byte_Length");
        names.addBuiltin("Byte_Substr");
        names.addBuiltin("Char");
        names.addBuiltin("CharIndex");
        names.addBuiltin("Char_Length");
        names.addBuiltin("Compare");
        names.addBuiltin("Compress");
        names.addBuiltin("CSConvert");
        names.addBuiltin("Decompress");
        names.addBuiltin("Decrypt");
        names.addBuiltin("Difference");
        names.addBuiltin("Encrypt");
        names.addBuiltin("Hash");
        names.addBuiltin("InsertStr");
        names.addBuiltin("LCase");
        names.addBuiltin("Left");
        names.addBuiltin("Length");
        names.addBuiltin("Locate");
        names.addBuiltin("Lower");
        names.addBuiltin("LTrim");
        names.addBuiltin("OpenXML");
        names.addBuiltin("PatIndex");
        names.addBuiltin("Repeat");
        names.addBuiltin("Replace");
        names.addBuiltin("Replicate");
        names.addBuiltin("Right");
        names.addBuiltin("RTrim");
        names.addBuiltin("Similar");
        names.addBuiltin("SortKey");
        names.addBuiltin("SoundEx");
        names.addBuiltin("Space");
        names.addBuiltin("Str");
        names.addBuiltin("String");
        names.addBuiltin("StrToUUID");
        names.addBuiltin("Stuff");
        names.addBuiltin("SubString");
        names.addBuiltin("Trim");
        names.addBuiltin("UCase");
        names.addBuiltin("Upper");
        names.addBuiltin("UUIDToStr");
        names.addBuiltin("XMLAgg");
        names.addBuiltin("XMLConcat");
        names.addBuiltin("XMLElement");
        names.addBuiltin("XMLForest");
        names.addBuiltin("XMLGen");
        names.addBuiltin("Connection_Property");
        names.addBuiltin("DataLength");
        names.addBuiltin("Db_Id");
        names.addBuiltin("Db_Name");
        names.addBuiltin("Db_Extended_Property");
        names.addBuiltin("Db_Property");
        names.addBuiltin("Event_Condition");
        names.addBuiltin("Event_Condition_Name");
        names.addBuiltin("Event_Parameter");
        names.addBuiltin("Next_Connection");
        names.addBuiltin("Next_Database");
        names.addBuiltin("Property");
        names.addBuiltin("Property_Description");
        names.addBuiltin("Property_Name");
        names.addBuiltin("Property_Number");
        names.addBuiltin("Col_Length");
        names.addBuiltin("Col_Name");
        names.addBuiltin("CurUnreservedPgs");
        names.addBuiltin("Data_Pgs");
        names.addBuiltin("DataLength");
        names.addBuiltin("Db_Id");
        names.addBuiltin("Db_Name");
        names.addBuiltin("Host_Id");
        names.addBuiltin("Host_Name");
        names.addBuiltin("Index_Col");
        names.addBuiltin("Lct_Admin");
        names.addBuiltin("Object_Id");
        names.addBuiltin("Object_Name");
        names.addBuiltin("Proc_Role");
        names.addBuiltin("Reserved_Pgs");
        names.addBuiltin("RowCnt");
        names.addBuiltin("Show_Role");
        names.addBuiltin("SUser_Id");
        names.addBuiltin("SUser_Name");
        names.addBuiltin("TSEqual");
        names.addBuiltin("Used_Pgs");
        names.addBuiltin("User_Id");
        names.addBuiltin("User_Name");
        names.addBuiltin("Valid_Name");
        names.addBuiltin("Valid_User");
        names.addBuiltin("TextPtr");
    }

    @Override
    public void getDatabaseList(BaseSQLContext sqlContext, SQLQualifiedNameList databaseList) {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        try {
            if (!LoadMetadataHelpers.getDatabaseListSybase(sqlContext, databaseList)) {
                super.getDatabaseList(sqlContext, databaseList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataObjectsSybase(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataRelationsSybase(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadFieldsForObjectFromServer(BaseSQLContext sqlContext, MetadataObject metadataObject) throws QueryBuilderException {
        String fieldsInfoASA = "select * from sys.syscolumns where creator='%1$s' and tname='%2$s'";
        String fieldsInfoASE = "select *, column_type=isnull(X.xtname, isnull(get_xtypename(C.xtype,C.xdbid), T.name)), nulls=case when status&8=8 then 'Y' else 'N' end from %1$sdbo.syscolumns C, %1$sdbo.systypes T, %1$sdbo.sysxtypes X where C.usertype *= T.usertype and C.xtype *= X.xtid and C.id = object_id('%2$s')";
        assert (sqlContext != null);
        assert (sqlContext.getMetadataProvider() != null);
        assert (sqlContext.getMetadataProvider().canExecSQL());
        assert (metadataObject != null);
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        String objectName = metadataObject.getName().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
        String objectSchema = metadataObject.getSchema().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
        String db = metadataObject.getDatabase().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServer());
        String db_dot = !Str.IsNullOrEmpty(db) ? db + "." : "";
        if (this.serverVersion == SybaseServerVersion.SybaseASA) {
            if (sqlContext.isTableExists("sys.syscolumns")) {
                MetadataFieldsFetcherFromQuery mff = new MetadataFieldsFetcherFromQuery(sqlContext);
                mff.setQuery(String.format(fieldsInfoASA, objectSchema, objectName));
                mff.setNameFieldName("cname");
                mff.setServerTypeFieldName("coltype");
                mff.setSizeFieldName("length");
                mff.setDefaultValueFieldName("default_value");
                mff.setNullableFieldName("nulls");
                mff.setNullableValue("N");
                mff.setPrimaryFieldName("in_primary_key");
                mff.setPrimaryValue("Y");
                mff.loadFields(metadataObject.getFields());
            }
        } else if (this.serverVersion == SybaseServerVersion.SybaseASE && sqlContext.isTableExists("dbo.syscolumns")) {
            MetadataFieldsFetcherFromQuery mff = new MetadataFieldsFetcherFromQuery(sqlContext);
            mff.setQuery(String.format(fieldsInfoASE, db_dot, db_dot + objectSchema + "." + objectName));
            mff.setNameFieldName("name");
            mff.setServerTypeFieldName("column_type");
            mff.setSizeFieldName("length");
            mff.setPrecisionFieldName("prec");
            mff.setScaleFieldName("scale");
            mff.setNullableFieldName("nulls");
            mff.setNullableValue("N");
            mff.loadFields(metadataObject.getFields());
        }
    }

    @Override
    public void resetCachedDefaultDatabaseName() {
        if (this.defaultDatabaseName != null) {
            this.defaultDatabaseName.dispose();
        }
        this.defaultDatabaseName = null;
    }

    @Override
    public SQLQualifiedName getDefaultDatabaseName(BaseSQLContext sqlContext) throws QueryBuilderException {
        if (this.defaultDatabaseName != null) {
            return this.defaultDatabaseName;
        }
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        this.defaultDatabaseName = LoadMetadataHelpers.getDefaultDatabaseNameSybase(sqlContext);
        if (this.defaultDatabaseName == null) {
            this.defaultDatabaseName = super.getDefaultDatabaseName(sqlContext);
        }
        return this.defaultDatabaseName;
    }

    @Override
    public void getDefaultSchemaNames(BaseSQLContext sqlContext, SQLIdentifiersCollection defaultSchemaNames) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.getDefaultSchemaNamesSybase(sqlContext, defaultSchemaNames)) {
            super.getDefaultSchemaNames(sqlContext, defaultSchemaNames);
        }
    }

    @Override
    public String getQueryToLoadFieldsForObject(String fieldName, String objectExpression) {
        String fieldExpression = Str.IsNullOrEmpty(fieldName) ? "*" : fieldName;
        return "select " + fieldExpression + " from " + objectExpression + " a where 0<>0";
    }

    @Override
    public SyntaxSupportsConectedServer isSupportConectedServer(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        SyntaxSupportsConectedServer result = LoadMetadataHelpers.isConnectedServerIsSybase(metadataProvider);
        if (result == SyntaxSupportsConectedServer.Unknown) {
            result = super.isSupportConectedServer(metadataProvider);
        }
        return result;
    }

    @Override
    public boolean isFixedSizeType(String type) {
        return type.compareToIgnoreCase("char") != 0 && type.compareToIgnoreCase("nchar") != 0 && type.compareToIgnoreCase("varchar") != 0 && type.compareToIgnoreCase("nvarchar") != 0 && type.compareToIgnoreCase("binary") != 0 && type.compareToIgnoreCase("varbinary") != 0;
    }

    @Override
    public void getSchemaList(BaseSQLContext sqlContext, SQLIdentifiersCollection schemaList, SQLQualifiedName fromDatabase) {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.getSchemaListSybase(sqlContext, schemaList, fromDatabase)) {
            super.getSchemaList(sqlContext, schemaList, fromDatabase);
        }
    }

    @Override
    public boolean isSupportTransactSQLJoins() {
        return true;
    }

    @Override
    public boolean isSupportCTE() {
        return this.serverVersion == SybaseServerVersion.SybaseASA;
    }

    @Override
    public boolean isDetectServerVersion() {
        return super.isDetectServerVersion();
    }

    @Override
    public void setDetectServerVersion(boolean detectServerVersion) {
        super.setDetectServerVersion(detectServerVersion);
    }

    @Override
    public void doDetectServerVersion(BaseMetadataProvider metadataProvider) {
        super.doDetectServerVersion(metadataProvider);
        if (LoadMetadataHelpers.isConnectedServerIsSybaseASA(metadataProvider)) {
            this.setServerVersion(SybaseServerVersion.SybaseASA);
        } else {
            this.setServerVersion(SybaseServerVersion.SybaseASE);
        }
    }
}

