/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseParser;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLFromObject;
import com.adbs.ast.SQLFromQuery;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSelectStatement;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.metadata.LoadMetadataHelpers;
import com.adbs.metadata.MetadataFieldsFetcherFromQuery;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourcePropertiesDialog;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPropertiesDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.OracleParser;
import com.adbs.syntax.OracleQueryPropertiesDialog;
import com.adbs.syntax.OracleSQLFromObjectExtender;
import com.adbs.syntax.OracleSQLFromQueryExtender;
import com.adbs.syntax.OracleSQLSelectStatementExtender;
import com.adbs.syntax.OracleSQLSubQueryExtender;
import com.adbs.syntax.OracleScanner;
import com.adbs.syntax.OracleServerVersion;
import com.adbs.utils.Str;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OracleSyntaxProvider
extends BaseSyntaxProvider {
    private static final long serialVersionUID = 1L;
    private OracleServerVersion serverVersion = OracleServerVersion.Oracle11;

    public OracleSyntaxProvider() {
        try {
            this.registerExtender(SQLFromQuery.class, OracleSQLFromQueryExtender.class);
            this.registerExtender(SQLFromObject.class, OracleSQLFromObjectExtender.class);
            this.registerExtender(SQLSubQuerySelectExpression.class, OracleSQLSubQueryExtender.class);
            this.registerExtender(SQLSelectStatement.class, OracleSQLSelectStatementExtender.class);
        }
        catch (Exception ex) {
            Logger.getLogger(OracleSyntaxProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public OracleServerVersion getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(OracleServerVersion serverVersion) {
        if (this.serverVersion != serverVersion) {
            this.serverVersion = serverVersion;
            this.sendNotifications();
        }
    }

    @Override
    public BaseSyntaxProvider clone() {
        OracleSyntaxProvider result = (OracleSyntaxProvider)super.clone();
        result.serverVersion = this.serverVersion;
        return result;
    }

    @Override
    protected Class getScannerClass() {
        return OracleScanner.class;
    }

    @Override
    protected Class getParserClass() {
        return OracleParser.class;
    }

    @Override
    public String getDescription() {
        return "Oracle";
    }

    @Override
    protected void setParserParams(BaseParser parser) {
        super.setParserParams(parser);
        switch (this.serverVersion) {
            case Oracle7: {
                parser.serverVersion = 7;
                break;
            }
            case Oracle8: {
                parser.serverVersion = 8;
                break;
            }
            case Oracle9: {
                parser.serverVersion = 9;
                break;
            }
            case Oracle10: {
                parser.serverVersion = 10;
                break;
            }
            default: {
                parser.serverVersion = 10;
            }
        }
    }

    public void getUnionOperatorList(List sl) {
        sl.clear();
        sl.add("Union");
        sl.add("Union All");
        sl.add("Intersect");
        sl.add("Minus");
    }

    @Override
    public void getStarAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Count", false);
    }

    @Override
    public void get1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Grouping", false);
        if (this.serverVersion.compareTo(OracleServerVersion.Oracle8) > 0) {
            names.addIdentifier("Grouping_Id", false);
            names.addIdentifier("Median", false);
        }
        if (this.serverVersion.compareTo(OracleServerVersion.Oracle9) > 0) {
            names.addIdentifier("Stats_Mode", false);
        }
        names.addIdentifier("StdDev_Pop", false);
        names.addIdentifier("StdDev_Samp", false);
        if (this.serverVersion.compareTo(OracleServerVersion.Oracle10) > 0) {
            names.addIdentifier("Sys_XmlAgg", false);
        }
        names.addIdentifier("Var_Pop", false);
        names.addIdentifier("Var_Samp", false);
        if (this.serverVersion.compareTo(OracleServerVersion.Oracle10) > 0) {
            names.addIdentifier("XmlAgg", false);
        }
    }

    @Override
    public void getPrefixed1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Avg", false);
        if (this.serverVersion.compareTo(OracleServerVersion.Oracle9) > 0) {
            names.addIdentifier("Collect", false);
        }
        names.addIdentifier("Count", false);
        names.addIdentifier("Max", false);
        names.addIdentifier("Min", false);
        names.addIdentifier("StdDev", false);
        names.addIdentifier("Sum", false);
        names.addIdentifier("Variance", false);
    }

    public void getComparisonOperators(List sl) {
        sl.clear();
        sl.add("=");
        sl.add("<");
        sl.add("<=");
        sl.add(">");
        sl.add(">=");
        sl.add("<>");
        sl.add("!=");
        sl.add("!>");
        sl.add("!<");
    }

    @Override
    public boolean isSupportANSIJoins() {
        return this.serverVersion.compareTo(OracleServerVersion.Oracle9) >= 0;
    }

    @Override
    public boolean isSupportOracleJoins() {
        return true;
    }

    @Override
    public boolean isSupportCrossJoin() {
        return this.serverVersion.compareTo(OracleServerVersion.Oracle9) >= 0;
    }

    @Override
    public boolean isSupportSchemas() {
        return true;
    }

    @Override
    public boolean isSupportDatabases() {
        return false;
    }

    @Override
    public boolean isSupportSynonyms() {
        return true;
    }

    @Override
    public boolean isSupportNullOrdering() {
        return true;
    }

    @Override
    public boolean isSupportCTE() {
        return this.serverVersion.compareTo(OracleServerVersion.Oracle9) >= 0;
    }

    @Override
    public boolean isSupportRecursiveCTE() {
        return false;
    }

    @Override
    public boolean isFromClauseMandatory() {
        return true;
    }

    @Override
    public String getSimpleEmptyFromSubquery() {
        return "(SELECT NULL FROM DUAL)";
    }

    @Override
    public Class getEditPropsFormClass(Object forObj) {
        if (forObj instanceof Link) {
            return LinkPropertiesDialog.class;
        }
        if (forObj instanceof DataSource) {
            return DataSourcePropertiesDialog.class;
        }
        if (forObj instanceof UnionSubQuery) {
            return OracleQueryPropertiesDialog.class;
        }
        return super.getEditPropsFormClass(forObj);
    }

    @Override
    public void getBuiltinFunctionNames(SQLQualifiedNameList names) {
        super.getBuiltinFunctionNames(names);
        names.addBuiltin("Abs");
        names.addBuiltin("ACos");
        names.addBuiltin("ASin");
        names.addBuiltin("ATan");
        names.addBuiltin("ATan2");
        names.addBuiltin("BitAnd");
        names.addBuiltin("Ceil");
        names.addBuiltin("Cos");
        names.addBuiltin("CosH");
        names.addBuiltin("Exp");
        names.addBuiltin("Floor");
        names.addBuiltin("Ln");
        names.addBuiltin("Log");
        names.addBuiltin("Mod");
        names.addBuiltin("NanVl");
        names.addBuiltin("Power");
        names.addBuiltin("Remainder");
        names.addBuiltin("Round");
        names.addBuiltin("Sign");
        names.addBuiltin("Sin");
        names.addBuiltin("SinH");
        names.addBuiltin("SqRt");
        names.addBuiltin("Tan");
        names.addBuiltin("TanH");
        names.addBuiltin("Trunc");
        names.addBuiltin("Width_Bucket");
        names.addBuiltin("Chr");
        names.addBuiltin("Concat");
        names.addBuiltin("InitCap");
        names.addBuiltin("Lower");
        names.addBuiltin("LPad");
        names.addBuiltin("LTrim");
        names.addBuiltin("NLS_InotCap");
        names.addBuiltin("NLS_Lower");
        names.addBuiltin("NLSSort");
        names.addBuiltin("NLS_Upper");
        names.addBuiltin("RegExp_Replace");
        names.addBuiltin("RegExp_SubStr");
        names.addBuiltin("Replace");
        names.addBuiltin("RPad");
        names.addBuiltin("RTrim");
        names.addBuiltin("SoundEx");
        names.addBuiltin("SubStr");
        names.addBuiltin("Translate");
        names.addBuiltin("Treat");
        names.addBuiltin("Trim");
        names.addBuiltin("Upper");
        names.addBuiltin("NLS_Charset_Decl_Len");
        names.addBuiltin("NLS_Charset_Id");
        names.addBuiltin("NLS_Charset_Name");
        names.addBuiltin("ASCII");
        names.addBuiltin("Instr");
        names.addBuiltin("Length");
        names.addBuiltin("RegExp_Instr");
        names.addBuiltin("add_Months");
        names.addBuiltin("Current_Timestamp");
        names.addBuiltin("DbTimeZone");
        names.addBuiltin("Extract");
        names.addBuiltin("From_TZ");
        names.addBuiltin("Last_Day");
        names.addBuiltin("LocalTimestamp");
        names.addBuiltin("Months_Between");
        names.addBuiltin("New_Time");
        names.addBuiltin("Next_Day");
        names.addBuiltin("NumToDSInterval");
        names.addBuiltin("NumToYMInterval");
        names.addBuiltin("Round");
        names.addBuiltin("SessionTimeZone");
        names.addBuiltin("Sys_Extract_UTC");
        names.addBuiltin("SysDate");
        names.addBuiltin("SysTimestamp");
        names.addBuiltin("To_Char");
        names.addBuiltin("To_Timestamp");
        names.addBuiltin("To_Timestamp_TZ");
        names.addBuiltin("To_DSInterval");
        names.addBuiltin("To_YMInterval");
        names.addBuiltin("Trunc");
        names.addBuiltin("TZ_Offset");
        names.addBuiltin("Greatest");
        names.addBuiltin("Least");
        names.addBuiltin("ASCIIStr");
        names.addBuiltin("Bin_To_Num");
        names.addBuiltin("Cast");
        names.addBuiltin("CharToRowId");
        names.addBuiltin("Compose");
        names.addBuiltin("Convert");
        names.addBuiltin("Decompose");
        names.addBuiltin("HexToRaw");
        names.addBuiltin("NumToDSInterval");
        names.addBuiltin("NumToYMInterval");
        names.addBuiltin("RawToHex");
        names.addBuiltin("RawToNHex");
        names.addBuiltin("RowIdToChar");
        names.addBuiltin("RowIdToNChar");
        names.addBuiltin("SCN_To_Timestamp");
        names.addBuiltin("Timestamp_To_SCN");
        names.addBuiltin("To_Binary_Double");
        names.addBuiltin("To_Binary_Float");
        names.addBuiltin("To_Char");
        names.addBuiltin("To_CLOB");
        names.addBuiltin("To_Date");
        names.addBuiltin("To_DSInterval");
        names.addBuiltin("To_LOB");
        names.addBuiltin("To_Multi_Byte");
        names.addBuiltin("To_NChar");
        names.addBuiltin("To_NCLOB");
        names.addBuiltin("To_Number");
        names.addBuiltin("To_DSInterval");
        names.addBuiltin("To_Single_Byte");
        names.addBuiltin("To_Timestamp");
        names.addBuiltin("To_Timestamp_TZ");
        names.addBuiltin("To_YMInterval");
        names.addBuiltin("UniStr");
        names.addBuiltin("BFileName");
        names.addBuiltin("Empty_BLOB");
        names.addBuiltin("Empty_CLOB");
        names.addBuiltin("Cardinality");
        names.addBuiltin("Collect");
        names.addBuiltin("PowerMultiSet");
        names.addBuiltin("PowerMultiSet_By_Cardinality");
        names.addBuiltin("SET");
        names.addBuiltin("Sys_Connect_By_Path");
        names.addBuiltin("Cluster_Id");
        names.addBuiltin("Cluster_Probability");
        names.addBuiltin("Cluster_Set");
        names.addBuiltin("Feature_Id");
        names.addBuiltin("Feature_Set");
        names.addBuiltin("Feature_Value");
        names.addBuiltin("Prediction");
        names.addBuiltin("Prediction_Bounds");
        names.addBuiltin("Prediction_Cost");
        names.addBuiltin("Prediction_Details");
        names.addBuiltin("Prediction_Probability");
        names.addBuiltin("Prediction_Set");
        names.addBuiltin("AppendChildXML");
        names.addBuiltin("DeleteXML");
        names.addBuiltin("Depth");
        names.addBuiltin("Extract");
        names.addBuiltin("ExistsNode");
        names.addBuiltin("ExtractValue");
        names.addBuiltin("InsertChildXML");
        names.addBuiltin("InsertXMLBefore");
        names.addBuiltin("Path");
        names.addBuiltin("Sys_DbURIGen");
        names.addBuiltin("Sys_XMLAgg");
        names.addBuiltin("Sys_XMLGen");
        names.addBuiltin("UpdateXML");
        names.addBuiltin("XMLAgg");
        names.addBuiltin("XMLCast");
        names.addBuiltin("XMLCData");
        names.addBuiltin("XMLColAttVal");
        names.addBuiltin("XMLComment");
        names.addBuiltin("XMLConcat");
        names.addBuiltin("XMLDiff");
        names.addBuiltin("XMLElement");
        names.addBuiltin("XMLExists");
        names.addBuiltin("XMLForest");
        names.addBuiltin("XMLParse");
        names.addBuiltin("XMLPatch");
        names.addBuiltin("XMLPi");
        names.addBuiltin("XMLQuery");
        names.addBuiltin("XMLRoot");
        names.addBuiltin("XMLSequence");
        names.addBuiltin("XMLSerialize");
        names.addBuiltin("XMLTable");
        names.addBuiltin("XMLTransform");
        names.addBuiltin("Decode");
        names.addBuiltin("Dump");
        names.addBuiltin("Ora_Hash");
        names.addBuiltin("VSize");
        names.addBuiltin("Coalesce");
        names.addBuiltin("LnNVL");
        names.addBuiltin("NullIf");
        names.addBuiltin("NVL");
        names.addBuiltin("NVL2");
        names.addBuiltin("Sys_Context");
        names.addBuiltin("Sys_GUID");
        names.addBuiltin("Sys_TypeId");
        names.addBuiltin("UId");
        names.addBuiltin("User");
        names.addBuiltin("UserEnv");
        names.addBuiltin("Value");
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataObjectsOracle(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataRelationsOracle(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void getDefaultSchemaNames(BaseSQLContext sqlContext, SQLIdentifiersCollection defaultSchemaNames) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.getDefaultSchemaNamesOracle(sqlContext, defaultSchemaNames)) {
            super.getDefaultSchemaNames(sqlContext, defaultSchemaNames);
        }
    }

    @Override
    public AstTokenIdentifier getEmptySchemaName(BaseSQLContext sqlContext) {
        return new AstTokenIdentifier(sqlContext, "PUBLIC", false);
    }

    @Override
    public String getQueryToLoadFieldsForObject(String fieldName, String objectExpression) {
        String fieldExpression = Str.IsNullOrEmpty(fieldName) ? "*" : fieldName;
        return "select " + fieldExpression + " from " + objectExpression + " a where rownum<0 and 0<>0";
    }

    @Override
    public SyntaxSupportsConectedServer isSupportConectedServer(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        SyntaxSupportsConectedServer result = LoadMetadataHelpers.isConnectedServerIsOracle(metadataProvider);
        if (result == SyntaxSupportsConectedServer.Unknown) {
            return super.isSupportConectedServer(metadataProvider);
        }
        return result;
    }

    @Override
    public void loadFieldsForObjectFromServer(BaseSQLContext sqlContext, MetadataObject metadataObject) throws QueryBuilderException {
        assert (sqlContext != null);
        assert (sqlContext.getMetadataProvider() != null);
        assert (sqlContext.getMetadataProvider().canExecSQL());
        assert (metadataObject != null);
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        String objectName = metadataObject.getName().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
        String objectSchema = metadataObject.getSchema().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
        if (sqlContext.isTableExists("ALL_TAB_COLUMNS") && sqlContext.isTableExists("ALL_IND_COLUMNS") && sqlContext.isTableExists("ALL_CONSTRAINTS")) {
            MetadataFieldsFetcherFromQuery mff = new MetadataFieldsFetcherFromQuery(sqlContext);
            mff.setQuery("SELECT C.COLUMN_NAME, C.DATA_TYPE, C.CHAR_LENGTH, C.DATA_PRECISION, C.DATA_SCALE, C.NULLABLE, C.DATA_DEFAULT, SUB.COLUMN_POSITION PK, COM.COMMENTS COMMENTS FROM ALL_TAB_COLUMNS C, (SELECT COLUMN_NAME,COLUMN_POSITION FROM ALL_IND_COLUMNS WHERE (INDEX_OWNER,INDEX_NAME) = (SELECT OWNER,INDEX_NAME FROM ALL_CONSTRAINTS WHERE OWNER = '" + objectSchema + "' AND " + "TABLE_NAME = '" + objectName + "' " + "AND CONSTRAINT_TYPE = 'P')) SUB, " + "( SELECT COLUMN_NAME, COMMENTS FROM ALL_COL_COMMENTS " + "WHERE OWNER='" + objectSchema + "' AND " + "TABLE_NAME='" + objectName + "') COM " + "WHERE C.COLUMN_NAME = SUB.COLUMN_NAME(+) " + "AND C.COLUMN_NAME = COM.COLUMN_NAME(+) " + "AND C.OWNER = '" + objectSchema + "' " + "AND C.TABLE_NAME = '" + objectName + "' " + "ORDER BY SUB.COLUMN_POSITION,COLUMN_ID");
            mff.setNameFieldName("COLUMN_NAME");
            mff.setServerTypeFieldName("DATA_TYPE");
            mff.setSizeFieldName("CHAR_LENGTH");
            mff.setPrecisionFieldName("DATA_PRECISION");
            mff.setScaleFieldName("DATA_SCALE");
            mff.setDefaultValueFieldName("DATA_DEFAULT");
            mff.setNullableFieldName("NULLABLE");
            mff.setNullableValue("Y");
            mff.setPrimaryFieldName("PK");
            mff.setNonPrimaryValue(null);
            mff.setLongDescriptionFieldName("COMMENTS");
            mff.loadFields(metadataObject.getFields());
        }
    }

    @Override
    public boolean isFixedSizeType(String type) {
        return type.compareToIgnoreCase("char") != 0 && type.compareToIgnoreCase("nchar") != 0 && type.compareToIgnoreCase("varchar") != 0 && type.compareToIgnoreCase("nvarchar") != 0 && type.compareToIgnoreCase("varchar2") != 0 && type.compareToIgnoreCase("nvarchar2") != 0 && type.compareToIgnoreCase("raw") != 0;
    }

    @Override
    public void getSchemaList(BaseSQLContext sqlContext, SQLIdentifiersCollection schemaList, SQLQualifiedName fromDatabase) {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.getSchemaListOracle(sqlContext, schemaList, fromDatabase)) {
            super.getSchemaList(sqlContext, schemaList, fromDatabase);
        }
    }

    @Override
    public boolean isDetectServerVersion() {
        return super.isDetectServerVersion();
    }

    @Override
    public void setDetectServerVersion(boolean detectServerVersion) {
        super.setDetectServerVersion(detectServerVersion);
    }

    @Override
    public void doDetectServerVersion(BaseMetadataProvider metadataProvider) {
        super.doDetectServerVersion(metadataProvider);
        int version = LoadMetadataHelpers.calcServerVersionOracle(metadataProvider);
        switch (version) {
            case 7: {
                this.setServerVersion(OracleServerVersion.Oracle7);
                break;
            }
            case 8: {
                this.setServerVersion(OracleServerVersion.Oracle8);
                break;
            }
            case 9: {
                this.setServerVersion(OracleServerVersion.Oracle9);
                break;
            }
            case 10: {
                this.setServerVersion(OracleServerVersion.Oracle10);
                break;
            }
            case 11: {
                this.setServerVersion(OracleServerVersion.Oracle11);
                break;
            }
            default: {
                this.setServerVersion(OracleServerVersion.Oracle11);
            }
        }
    }

    @Override
    public void beginBuildWrapperForStoredProc(SQLBuilder builder, SQLBuilderSelectFormat format) {
        builder.writeKeyword("Table");
        builder.writeSymbol("(");
    }

    @Override
    public void endBuildWrapperForStoredProc(SQLBuilder builder, SQLBuilderSelectFormat format) {
        builder.writeSymbol(")");
    }
}

