/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseParser;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSelectStatement;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.metadata.LoadMetadataHelpers;
import com.adbs.metadata.MetadataFieldsFetcherFromQuery;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourcePropertiesDialog;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPropertiesDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.FirebirdParser;
import com.adbs.syntax.FirebirdQueryPropertiesDialog;
import com.adbs.syntax.FirebirdSQLSelectStatementExtender;
import com.adbs.syntax.FirebirdSQLSubQuerySelectExpressionExtender;
import com.adbs.syntax.FirebirdScanner;
import com.adbs.syntax.FirebirdVersion;
import com.adbs.utils.Str;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FirebirdSyntaxProvider
extends BaseSyntaxProvider {
    private static final long serialVersionUID = 1L;
    private FirebirdVersion serverVersion = FirebirdVersion.Firebird2;

    public FirebirdSyntaxProvider() {
        try {
            this.registerExtender(SQLSelectStatement.class, FirebirdSQLSelectStatementExtender.class);
            this.registerExtender(SQLSubQuerySelectExpression.class, FirebirdSQLSubQuerySelectExpressionExtender.class);
        }
        catch (Exception ex) {
            Logger.getLogger(FirebirdSyntaxProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public BaseSyntaxProvider clone() {
        FirebirdSyntaxProvider result = (FirebirdSyntaxProvider)super.clone();
        result.serverVersion = this.serverVersion;
        return result;
    }

    public FirebirdVersion getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(FirebirdVersion value) {
        if (this.serverVersion != value) {
            this.serverVersion = value;
            this.sendNotifications();
        }
    }

    @Override
    protected Class getParserClass() {
        return FirebirdParser.class;
    }

    @Override
    protected Class getScannerClass() {
        return FirebirdScanner.class;
    }

    @Override
    public String getDescription() {
        return "Firebird";
    }

    @Override
    public void get1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
    }

    public void getComparisonOperators(List sl) {
        sl.clear();
        sl.add("=");
        sl.add("<");
        sl.add(">");
        sl.add("<=");
        sl.add(">=");
        sl.add("!<");
        sl.add("!>");
        sl.add("<>");
        sl.add("!=");
    }

    @Override
    public Class getEditPropsFormClass(Object forObj) {
        if (forObj instanceof Link) {
            return LinkPropertiesDialog.class;
        }
        if (forObj instanceof DataSource) {
            return DataSourcePropertiesDialog.class;
        }
        if (forObj instanceof UnionSubQuery) {
            return FirebirdQueryPropertiesDialog.class;
        }
        return super.getEditPropsFormClass(forObj);
    }

    @Override
    public void getPrefixed1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Avg", false);
        names.addIdentifier("Count", false);
        names.addIdentifier("Max", false);
        names.addIdentifier("Min", false);
        names.addIdentifier("Sum", false);
        if (this.serverVersion.compareTo(FirebirdVersion.Firebird2) >= 0) {
            names.addIdentifier("List", false);
        }
    }

    @Override
    public void getStarAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Count", false);
    }

    @Override
    public boolean isSupportBracketsInUnions() {
        return false;
    }

    @Override
    public boolean isSupportCrossJoin() {
        return false;
    }

    @Override
    public boolean isSupportDerivedTables() {
        return this.serverVersion.compareTo(FirebirdVersion.Firebird2) >= 0;
    }

    @Override
    public boolean isSupportProcedures() {
        return true;
    }

    @Override
    public boolean isSupportSubQueryBracketsInUnions() {
        return false;
    }

    @Override
    public boolean isSupportSubQueryDerivedTables() {
        return this.serverVersion.compareTo(FirebirdVersion.Firebird2) >= 0;
    }

    @Override
    public boolean isSupportSchemas() {
        return false;
    }

    @Override
    public boolean isSupportDatabases() {
        return false;
    }

    @Override
    public boolean isSupportEmptyBracketsInStoredProcs() {
        return false;
    }

    @Override
    public boolean isSupportNullOrdering() {
        return this.serverVersion.compareTo(FirebirdVersion.Firebird1_5) >= 0;
    }

    @Override
    public boolean isSupportCTE() {
        return true;
    }

    @Override
    protected void setParserParams(BaseParser parser) {
        super.setParserParams(parser);
        switch (this.serverVersion) {
            case Firebird1: {
                parser.serverVersion = 10;
                break;
            }
            case Firebird1_5: {
                parser.serverVersion = 15;
                break;
            }
            case Firebird2: {
                parser.serverVersion = 20;
                break;
            }
            case Firebird2_5: {
                parser.serverVersion = 25;
                break;
            }
            default: {
                parser.serverVersion = 20;
            }
        }
    }

    @Override
    public void getBuiltinFunctionNames(SQLQualifiedNameList names) {
        names.addBuiltin("Abs");
        names.addBuiltin("ACos");
        names.addBuiltin("ASCII_Char");
        names.addBuiltin("ASCII_Val");
        names.addBuiltin("ASin");
        names.addBuiltin("ATan");
        names.addBuiltin("ATan2");
        names.addBuiltin("Bin_And");
        names.addBuiltin("Bin_Or");
        names.addBuiltin("Bin_Shl");
        names.addBuiltin("Bin_Shr");
        names.addBuiltin("Bin_Xor");
        names.addBuiltin("Bit_Length");
        names.addBuiltin("Ceil");
        names.addBuiltin("Ceiling");
        names.addBuiltin("Char_Length");
        names.addBuiltin("Cos");
        names.addBuiltin("CosH");
        names.addBuiltin("Cot");
        names.addBuiltin("Dateadd");
        names.addBuiltin("DateDiff");
        names.addBuiltin("Decode");
        names.addBuiltin("Exp");
        names.addBuiltin("Floor");
        names.addBuiltin("Gen_UUID");
        names.addBuiltin("Hash");
        names.addBuiltin("Left");
        names.addBuiltin("Ln");
        names.addBuiltin("Log");
        names.addBuiltin("Log10");
        names.addBuiltin("Lower");
        names.addBuiltin("LPad");
        names.addBuiltin("MaxValue");
        names.addBuiltin("MinValue");
        names.addBuiltin("Mod");
        names.addBuiltin("Octet_Length");
        names.addBuiltin("Overlay");
        names.addBuiltin("Pi");
        names.addBuiltin("Position");
        names.addBuiltin("Power");
        names.addBuiltin("Rand");
        names.addBuiltin("Replace");
        names.addBuiltin("Reverse");
        names.addBuiltin("Right");
        names.addBuiltin("Round");
        names.addBuiltin("RPad");
        names.addBuiltin("Sign");
        names.addBuiltin("Sin");
        names.addBuiltin("SinH");
        names.addBuiltin("SqRt");
        names.addBuiltin("Tan");
        names.addBuiltin("TanH");
        names.addBuiltin("Trim");
        names.addBuiltin("Trunc");
    }

    @Override
    public String getQueryToLoadFieldsForObject(String fieldName, String objectExpression) {
        String fieldExpression = Str.IsNullOrEmpty(fieldName) ? "*" : fieldName;
        return "select first 1 " + fieldExpression + " from " + objectExpression + " a where 0<>0";
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (!LoadMetadataHelpers.loadMetadataObjectsFirebird(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (!LoadMetadataHelpers.loadMetadataRelationsFirebird(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadFieldsForObjectFromServer(BaseSQLContext sqlContext, MetadataObject metadataObject) throws QueryBuilderException {
        assert (sqlContext != null);
        assert (sqlContext.getMetadataProvider() != null);
        assert (sqlContext.getMetadataProvider().canExecSQL());
        assert (metadataObject != null);
        if (sqlContext.isTableExists("RDB$RELATION_FIELDS") && sqlContext.isTableExists("RDB$FIELDS") && sqlContext.isTableExists("RDB$RELATION_CONSTRAINTS") && sqlContext.isTableExists("RDB$INDICES") && sqlContext.isTableExists("RDB$INDEX_SEGMENTS") && sqlContext.isTableExists("RDB$TYPES")) {
            String objectName = metadataObject.getName().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
            MetadataFieldsFetcherFromQuery mff = new MetadataFieldsFetcherFromQuery(sqlContext);
            mff.setQuery("Select r.RDB$FIELD_NAME As field_name, tn.RDB$TYPE_NAME As field_type, f.RDB$FIELD_LENGTH As field_length, f.RDB$FIELD_PRECISION As field_precision, f.RDB$FIELD_SCALE As field_scale, r.RDB$NULL_FLAG As field_not_null_constraint, r.RDB$DEFAULT_VALUE As field_default_value, iseg.RDB$FIELD_POSITION As field_pk, r.RDB$DESCRIPTION As field_description From RDB$RELATION_FIELDS r Left Join RDB$FIELDS f On r.RDB$FIELD_SOURCE = f.RDB$FIELD_NAME Left Join RDB$RELATION_CONSTRAINTS c On r.RDB$RELATION_NAME = c.RDB$RELATION_NAME And c.RDB$CONSTRAINT_TYPE = 'PRIMARY KEY' Left Join RDB$INDICES i On i.RDB$INDEX_NAME = c.RDB$INDEX_NAME Left Join RDB$INDEX_SEGMENTS iseg On iseg.RDB$INDEX_NAME = i.RDB$INDEX_NAME And r.RDB$FIELD_NAME = iseg.RDB$FIELD_NAME Inner Join RDB$TYPES tn On tn.RDB$TYPE = f.RDB$FIELD_TYPE And tn.RDB$FIELD_NAME = 'RDB$FIELD_TYPE' Where r.RDB$RELATION_NAME = '" + objectName + "' " + "Order By r.RDB$FIELD_POSITION");
            mff.setNameFieldName("field_name");
            mff.setServerTypeFieldName("field_type");
            mff.setSizeFieldName("field_length");
            mff.setPrecisionFieldName("field_precision");
            mff.setScaleFieldName("field_scale");
            mff.setDefaultValueFieldName("field_default_value");
            mff.setNullableFieldName("field_not_null_constraint");
            mff.setNonNullableValue(null);
            mff.setPrimaryFieldName("field_pk");
            mff.setNonPrimaryValue(null);
            mff.setLongDescriptionFieldName("field_description");
            mff.setTrimSpaces(true);
            mff.loadFields(metadataObject.getFields());
        }
    }

    @Override
    public SyntaxSupportsConectedServer isSupportConectedServer(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        SyntaxSupportsConectedServer result = LoadMetadataHelpers.isConnectedServerIsFirebird(metadataProvider);
        if (result == SyntaxSupportsConectedServer.Unknown) {
            result = super.isSupportConectedServer(metadataProvider);
        }
        return result;
    }

    @Override
    public boolean isFixedSizeType(String type) {
        return type.compareToIgnoreCase("char") != 0 && type.compareToIgnoreCase("character") != 0 && type.compareToIgnoreCase("nchar") != 0 && type.compareToIgnoreCase("national char") != 0 && type.compareToIgnoreCase("national chararacter") != 0 && type.compareToIgnoreCase("varchar") != 0 && type.compareToIgnoreCase("char varying") != 0 && type.compareToIgnoreCase("character varying") != 0;
    }

    @Override
    public boolean isInnerKeywordInLinksMandatory() {
        return false;
    }
}

