/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseParser;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.IdentCaseSensitivity;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.metadata.LoadMetadataHelpers;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourcePropertiesDialog;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPropertiesDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.syntax.AccessParser;
import com.adbs.syntax.AccessQueryPropertiesDialog;
import com.adbs.syntax.AccessScanner;
import com.adbs.syntax.AccessServerVersion;
import com.adbs.syntax.AccessSubQuerySelectExpressionExtender;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.utils.Str;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AccessSyntaxProvider
extends BaseSyntaxProvider {
    private static final long serialVersionUID = 1L;
    private AccessServerVersion serverVersion = AccessServerVersion.MSJET4;
    private boolean denyIntoClause = false;

    public AccessSyntaxProvider() {
        try {
            this.registerExtender(SQLSubQuerySelectExpression.class, AccessSubQuerySelectExpressionExtender.class);
        }
        catch (Exception ex) {
            Logger.getLogger(AccessSyntaxProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public AccessServerVersion getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(AccessServerVersion serverVersion) {
        this.serverVersion = serverVersion;
        this.sendNotifications();
    }

    @Override
    public BaseSyntaxProvider clone() {
        AccessSyntaxProvider result = (AccessSyntaxProvider)super.clone();
        result.serverVersion = this.serverVersion;
        return result;
    }

    @Override
    protected Class getScannerClass() {
        return AccessScanner.class;
    }

    @Override
    protected Class getParserClass() {
        return AccessParser.class;
    }

    @Override
    public String getDescription() {
        return "Microsoft Access";
    }

    @Override
    protected void setParserParams(BaseParser parser) {
        super.setParserParams(parser);
        switch (this.serverVersion) {
            case MSJET3: {
                parser.serverVersion = 3;
                break;
            }
            case MSJET4: {
                parser.serverVersion = 4;
            }
        }
    }

    @Override
    public IdentCaseSensitivity getIdentCaseSens() {
        return IdentCaseSensitivity.Insensitive;
    }

    @Override
    public void getStarAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Count", false);
    }

    @Override
    public void get1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Count", false);
        names.addIdentifier("Avg", false);
        names.addIdentifier("Max", false);
        names.addIdentifier("Min", false);
        names.addIdentifier("Sum", false);
    }

    @Override
    public void getPrefixed1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
    }

    public void getComparisonOperators(List sl) {
        sl.clear();
        sl.add("=");
        sl.add("<>");
        sl.add(">");
        sl.add(">=");
        sl.add("<");
        sl.add("<=");
    }

    @Override
    public String getQuoteBegin() {
        return "[";
    }

    @Override
    public String getQuoteEnd() {
        return "]";
    }

    @Override
    public boolean isUniversalExpressions() {
        return true;
    }

    @Override
    public boolean isForceBinaryANSIJoins() {
        return true;
    }

    @Override
    public boolean isSupportCrossJoin() {
        return false;
    }

    @Override
    public boolean isSupportFullANSIJoin() {
        return false;
    }

    @Override
    public boolean isSupportDerivedTables() {
        return this.serverVersion.compareTo(AccessServerVersion.MSJET4) >= 0;
    }

    @Override
    public boolean isSupportSchemas() {
        return false;
    }

    @Override
    public boolean isSupportDatabases() {
        return false;
    }

    @Override
    public boolean isAsKeywordInExpressionAliasMandatory() {
        return true;
    }

    @Override
    public Class getEditPropsFormClass(Object forObj) {
        if (forObj instanceof Link) {
            return LinkPropertiesDialog.class;
        }
        if (forObj instanceof DataSource) {
            return DataSourcePropertiesDialog.class;
        }
        if (forObj instanceof UnionSubQuery) {
            return AccessQueryPropertiesDialog.class;
        }
        return super.getEditPropsFormClass(forObj);
    }

    @Override
    public String getQueryToLoadFieldsForObject(String fieldName, String objectExpression) {
        String fieldExpression = Str.IsNullOrEmpty(fieldName) ? "*" : fieldName;
        return "select top 1 " + fieldExpression + " from " + objectExpression + " a where 0<>0";
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        super.loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
    }

    @Override
    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        super.loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database);
    }

    @Override
    public SyntaxSupportsConectedServer isSupportConectedServer(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        SyntaxSupportsConectedServer result = LoadMetadataHelpers.isConnectedServerIsMSAccess(metadataProvider);
        if (result == SyntaxSupportsConectedServer.Unknown) {
            result = super.isSupportConectedServer(metadataProvider);
        }
        return result;
    }

    @Override
    public boolean isDenyIntoClause() {
        return this.denyIntoClause;
    }

    @Override
    public void setDenyIntoClause(boolean value) {
        this.denyIntoClause = value;
    }

    @Override
    public String getUpperCaseFunctionName() {
        return "UCase";
    }
}

