/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstNode;
import com.adbs.ast.SQLFromClause;
import com.adbs.ast.SQLSelectItems;
import com.adbs.ast.SQLSubQueryExpression;
import com.adbs.ast.SQLSubQueryExpressions;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.querybuilder.Bracket;
import com.adbs.querybuilder.ControlOwner;
import com.adbs.querybuilder.LeftBracket;
import com.adbs.querybuilder.QueryBase;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.RightBracket;
import com.adbs.querybuilder.UnionOperator;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.utils.Helpers;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class UnionGroup
extends QueryBase
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected SQLSubQueryExpressions astUnionGroup;
    protected final ArrayList<QueryBase> items = new ArrayList();

    public QueryBase get(int index) {
        return this.items.get(index);
    }

    public int getCount() {
        return this.items.size();
    }

    Bracket getLeftBracket() {
        if (this.controls.size() >= 1) {
            return (Bracket)this.controls.get(0);
        }
        return null;
    }

    Bracket getRightBracket() {
        if (this.controls.size() >= 2) {
            return (Bracket)this.controls.get(1);
        }
        return null;
    }

    public UnionGroup(ControlOwner owner, QueryBuilder queryBuilder) {
        super(owner, queryBuilder);
    }

    @Override
    public void dispose() {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            this.items.get(i).dispose();
        }
        this.items.clear();
        super.dispose();
    }

    @Override
    public int getControlsCount() {
        return 3;
    }

    @Override
    protected Component createControlInternal(int i) {
        switch (i) {
            case 0: {
                LeftBracket lb = new LeftBracket(this);
                this.getRootQuery().getQueryPage().getUnionNavBar().add(lb);
                this.controls.set(i, lb);
                return lb;
            }
            case 1: {
                RightBracket rb = new RightBracket(this);
                this.getRootQuery().getQueryPage().getUnionNavBar().add(rb);
                this.controls.set(i, rb);
                return rb;
            }
            case 2: {
                UnionOperator o = new UnionOperator(this);
                this.getRootQuery().getQueryPage().getUnionNavBar().add(o);
                this.controls.set(i, o);
                return o;
            }
        }
        return null;
    }

    @Override
    protected void restoreControlParams(int i) {
        super.restoreControlParams(i);
        if (i == 2) {
            this.updateUnionOperator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToBegin(QueryBase from) {
        UnionGroup parentQuery = this.getParentQuery();
        parentQuery.beginUpdate();
        try {
            QueryBase q;
            int i = parentQuery.items.indexOf(this);
            do {
                q = parentQuery.items.get(--i);
                q.setParentQuery(this);
                int j = this.items.indexOf(q);
                Helpers.listMove(this.items, j, 0);
            } while (q != from);
            this.getRootQuery().updateUnionSubQueriesOrder();
        }
        finally {
            parentQuery.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromBegin(QueryBase to) {
        UnionGroup parentQuery = this.getParentQuery();
        parentQuery.beginUpdate();
        try {
            QueryBase q;
            int base = parentQuery.items.indexOf(this);
            int i = 0;
            do {
                q = this.items.get(0);
                q.setParentQuery(parentQuery);
                int j = parentQuery.items.indexOf(q);
                Helpers.listMove(parentQuery.items, j, base + i);
                ++i;
            } while (q != to);
            this.getRootQuery().updateUnionSubQueriesOrder();
        }
        finally {
            parentQuery.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToEnd(QueryBase to) {
        UnionGroup parentQuery = this.getParentQuery();
        parentQuery.beginUpdate();
        try {
            QueryBase q;
            int i = parentQuery.items.indexOf(this) + 1;
            do {
                q = parentQuery.items.get(i);
                q.setParentQuery(this);
            } while (q != to);
            this.getRootQuery().updateUnionSubQueriesOrder();
        }
        finally {
            parentQuery.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromEnd(QueryBase from) {
        UnionGroup parentQuery = this.getParentQuery();
        parentQuery.beginUpdate();
        try {
            QueryBase q;
            int base = parentQuery.items.indexOf(this);
            int i = this.items.size() - 1;
            do {
                q = this.items.get(i);
                q.setParentQuery(parentQuery);
                int j = parentQuery.items.indexOf(q);
                Helpers.listMove(parentQuery.items, j, base + i);
                --i;
            } while (q != from);
            this.getRootQuery().updateUnionSubQueriesOrder();
        }
        finally {
            parentQuery.endUpdate();
        }
    }

    @Override
    UnionOperator getUnionOperatorControl() {
        if (this.controls.size() >= 3) {
            return (UnionOperator)this.controls.get(2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UnionSubQuery addAST(SQLSubQuerySelectExpression subQuery) {
        UnionSubQuery result;
        this.beginUpdate();
        try {
            result = new UnionSubQuery(this.getRootQuery(), this.getQueryBuilder());
            result.beginUpdate();
            try {
                result.setParentQuery(this);
                result.loadFromAST(subQuery);
            }
            finally {
                result.endUpdate();
            }
        }
        finally {
            this.endUpdate();
        }
        if (result.canCreateControls()) {
            result.createControls();
        }
        if (result.getUnionButton() != null) {
            result.getRootQuery().requestAlignUnionNavbar();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UnionGroup addGroupAST(SQLSubQueryExpressions subQuery) {
        UnionGroup result;
        this.beginUpdate();
        try {
            result = new UnionGroup(this.getRootQuery(), this.getQueryBuilder());
            result.beginUpdate();
            try {
                result.setParentQuery(this);
                result.loadFromAST(subQuery);
            }
            finally {
                result.endUpdate();
            }
        }
        finally {
            this.endUpdate();
        }
        if (result.canCreateControls()) {
            result.createControls();
        }
        if (result.getLeftBracket() != null) {
            result.getRootQuery().requestAlignUnionNavbar();
        }
        return result;
    }

    @Override
    protected AstNode createResultAST() {
        AstNode result = this.astUnionGroup.clone(this.getSQLContext());
        for (int i = 0; i < this.getCount(); ++i) {
            ((SQLSubQueryExpressions)result).add((SQLSubQueryExpression)this.items.get(i).getResultAST());
        }
        return result;
    }

    public UnionSubQuery add() throws QueryBuilderException {
        UnionSubQuery result;
        if (this.getRootQuery().plainUnionSubQueries.size() > 0) {
            if (this.getRootQuery().isMainQuery() && !this.getQueryBuilder().getSyntaxProvider().isSupportUnions()) {
                throw new QueryBuilderException(Helpers.localizer.getString("strDialectDontSupportUnions", "This server does not support unions."));
            }
            if (this.getRootQuery().isSubQuery() && !this.getQueryBuilder().getSyntaxProvider().isSupportSubQueryUnions()) {
                throw new QueryBuilderException(Helpers.localizer.getString("strDialectDontSupportUnionsInSubQueries", "This server does not support unions in subqueries."));
            }
        }
        if (!this.isDisposing()) {
            SQLSubQuerySelectExpression usq = new SQLSubQuerySelectExpression(this.getSQLContext());
            usq.selectItems = new SQLSelectItems(this.getSQLContext());
            usq.from = new SQLFromClause(this.getSQLContext());
            result = this.addAST(usq);
        } else {
            result = null;
        }
        return result;
    }

    public UnionGroup addGroup() throws QueryBuilderException {
        if (this.getQueryBuilder().getQuery() == this && !this.getQueryBuilder().getSyntaxProvider().isSupportBracketsInUnions()) {
            throw new QueryBuilderException(Helpers.localizer.getString("strDialectDontSupportUnionsBrackets", "This server does not support brackets in unions."));
        }
        if (this.getQueryBuilder().getQuery() != this && !this.getQueryBuilder().getSyntaxProvider().isSupportSubQueryBracketsInUnions()) {
            throw new QueryBuilderException(Helpers.localizer.getString("strDialectDontSupportUnionsBracketsInSubQuery", "This server doesn't support brackets in unions in subqueries."));
        }
        if (!this.isDisposing()) {
            SQLSubQueryExpressions usq = new SQLSubQueryExpressions(this.getSQLContext());
            return this.addGroupAST(usq);
        }
        return null;
    }

    public int indexOf(QueryBase item) {
        return this.items.indexOf(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnionSubQuery insert(int index) throws QueryBuilderException {
        UnionSubQuery result;
        if (index < 0 || index > this.items.size()) {
            throw new IndexOutOfBoundsException("List index out of bounds.");
        }
        if (this.getRootQuery().plainUnionSubQueries.size() > 0) {
            if (this.getRootQuery().isMainQuery() && !this.getQueryBuilder().getSyntaxProvider().isSupportUnions()) {
                throw new QueryBuilderException(Helpers.localizer.getString("strDialectDontSupportUnions", "This server does not support unions."));
            }
            if (this.getRootQuery().isSubQuery() && !this.getQueryBuilder().getSyntaxProvider().isSupportSubQueryUnions()) {
                throw new QueryBuilderException(Helpers.localizer.getString("strDialectDontSupportUnionsInSubQueries", "This server does not support unions in subqueries."));
            }
        }
        this.beginUpdate();
        try {
            result = this.add();
            result.setParentQuery(this);
            this.moveItem(this.items.indexOf(result), index);
            if (result.canCreateControls()) {
                result.createControls();
            }
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnionGroup insertGroup(int index) throws QueryBuilderException {
        UnionGroup result;
        if (index < 0 || index > this.items.size()) {
            throw new IndexOutOfBoundsException("List index out of bounds.");
        }
        if (this.getQueryBuilder().getQuery() == this && !this.getQueryBuilder().getSyntaxProvider().isSupportBracketsInUnions()) {
            throw new QueryBuilderException(Helpers.localizer.getString("strDialectDontSupportUnionsBrackets", "This server does not support brackets in unions."));
        }
        if (this.getQueryBuilder().getQuery() != this && !this.getQueryBuilder().getSyntaxProvider().isSupportSubQueryBracketsInUnions()) {
            throw new QueryBuilderException(Helpers.localizer.getString("strDialectDontSupportUnionsBracketsInSubQuery", "This server doesn't support brackets in unions in subqueries."));
        }
        this.beginUpdate();
        try {
            result = this.addGroup();
            result.setParentQuery(this);
            this.moveItem(this.items.indexOf(result), index);
            if (result.canCreateControls()) {
                result.createControls();
            }
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    public void moveItem(int curIndex, int newIndex) {
        Helpers.listMove(this.items, curIndex, newIndex);
        this.notifySQLUpdated();
    }

    public void delete(int index) {
        this.items.remove(index);
    }

    public int remove(QueryBase item) {
        int x = this.items.indexOf(item);
        if (x != -1) {
            this.items.remove(x);
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.beginUpdate();
        try {
            for (int i = this.getCount() - 1; i >= 0; --i) {
                this.items.get(i).dispose();
            }
            this.items.clear();
        }
        finally {
            this.endUpdate();
        }
    }

    public JPopupMenu getLeftBracketPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        boolean enabled = this.getParentQuery().indexOf(this) > 0;
        JMenuItem item = new JMenuItem(Helpers.localizer.getString("strMoveBackward", "Move left"));
        item.setActionCommand("move left bracket to the left");
        item.setEnabled(enabled);
        item.addActionListener(this);
        menu.add(item);
        enabled = this.getCount() > 0;
        item = new JMenuItem(Helpers.localizer.getString("strMoveForward", "Move right"));
        item.setActionCommand("move left bracket to the right");
        item.setEnabled(enabled);
        item.addActionListener(this);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(Helpers.localizer.getString("strRemoveBrackets", "Remove brackets"));
        item.setActionCommand("remove brackets");
        item.addActionListener(this);
        menu.add(item);
        return menu;
    }

    public JPopupMenu getRightBracketPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        boolean enabled = this.getCount() > 0;
        JMenuItem item = new JMenuItem(Helpers.localizer.getString("strMoveBackward", "Move left"));
        item.setActionCommand("move right bracket to the left");
        item.setEnabled(enabled);
        item.addActionListener(this);
        menu.add(item);
        enabled = this.getParentQuery().indexOf(this) < this.getParentQuery().getCount() - 1;
        item = new JMenuItem(Helpers.localizer.getString("strMoveForward", "Move right"));
        item.setActionCommand("move right bracket to the right");
        item.setEnabled(enabled);
        item.addActionListener(this);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(Helpers.localizer.getString("strRemoveBrackets", "Remove brackets"));
        item.setActionCommand("remove brackets");
        item.addActionListener(this);
        menu.add(item);
        return menu;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(Helpers.localizer.getString("strRemoveBrackets", "Remove brackets"));
        item.setActionCommand("remove brackets");
        item.addActionListener(this);
        menu.add(item);
        return menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromAST(SQLSubQueryExpressions subQuery) {
        super.loadFromAST(subQuery);
        this.astUnionGroup = subQuery;
        this.beginUpdate();
        try {
            int i;
            for (i = 0; i < subQuery.getCount(); ++i) {
                if (subQuery.get(i) instanceof SQLSubQuerySelectExpression) {
                    this.addAST((SQLSubQuerySelectExpression)subQuery.get(i));
                    continue;
                }
                if (!(subQuery.get(i) instanceof SQLSubQueryExpressions)) continue;
                this.addGroupAST((SQLSubQueryExpressions)subQuery.get(i));
            }
            for (i = subQuery.getCount() - 1; i >= 0; --i) {
                subQuery.extract(subQuery.get(i));
            }
            this.notifySQLUpdated();
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("move left bracket to the left")) {
            int i = this.getParentQuery().indexOf(this);
            if (i > 0) {
                this.addToBegin(this.getParentQuery().get(i - 1));
                this.getRootQuery().requestAlignUnionNavbar();
            }
            if (this.getCount() == 0) {
                this.dispose();
            }
        } else if (command.equals("move left bracket to the right")) {
            if (this.getCount() > 0) {
                this.removeFromBegin(this.get(0));
                this.getRootQuery().requestAlignUnionNavbar();
            }
            if (this.getCount() == 0) {
                this.dispose();
            }
        } else if (command.equals("move right bracket to the right")) {
            int i = this.getParentQuery().indexOf(this);
            if (i < this.getParentQuery().getCount() - 1) {
                this.addToEnd(this.getParentQuery().get(i + 1));
                this.getRootQuery().requestAlignUnionNavbar();
            }
            if (this.getCount() == 0) {
                this.dispose();
            }
        } else if (command.equals("move right bracket to the left")) {
            if (this.getCount() > 0) {
                this.removeFromEnd(this.get(this.getCount() - 1));
                this.getRootQuery().requestAlignUnionNavbar();
            }
            if (this.getCount() == 0) {
                this.dispose();
            }
        } else if (command.equals("remove brackets")) {
            if (this.getCount() > 0) {
                this.beginUpdate();
                try {
                    this.get(0).setUnionOperator(this.getUnionOperator());
                    this.removeFromBegin(this.get(this.getCount() - 1));
                }
                finally {
                    this.endUpdate();
                }
            }
            this.dispose();
            this.getRootQuery().getQueryPage().doLayout();
        }
    }

    public void gatherUnionSubQueries(List<UnionSubQuery> toList) {
        for (int i = 0; i < this.getCount(); ++i) {
            QueryBase item = this.get(i);
            if (item instanceof UnionSubQuery) {
                toList.add((UnionSubQuery)item);
                continue;
            }
            assert (item instanceof UnionGroup);
            ((UnionGroup)item).gatherUnionSubQueries(toList);
        }
    }

    public List<UnionSubQuery> getUnionSubQueryList() {
        ArrayList<UnionSubQuery> result = new ArrayList<UnionSubQuery>(this.getCount());
        this.gatherUnionSubQueries(result);
        return result;
    }
}

