/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.IdentCaseSensitivity;
import com.adbs.ast.MetadataContainer;
import com.adbs.querybuilder.BasePropertyPanel;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.syntax.AccessServerVersion;
import com.adbs.syntax.AccessSyntaxProvider;
import com.adbs.syntax.AutoSyntaxProvider;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.DB2SyntaxProvider;
import com.adbs.syntax.FirebirdSyntaxProvider;
import com.adbs.syntax.FirebirdVersion;
import com.adbs.syntax.InformixSyntaxProvider;
import com.adbs.syntax.InformixVersion;
import com.adbs.syntax.MSSQLCESyntaxProvider;
import com.adbs.syntax.MSSQLServerVersion;
import com.adbs.syntax.MSSQLSyntaxProvider;
import com.adbs.syntax.MySQLSyntaxProvider;
import com.adbs.syntax.OracleServerVersion;
import com.adbs.syntax.OracleSyntaxProvider;
import com.adbs.syntax.PostgreSQLSyntaxProvider;
import com.adbs.syntax.SQL2003SyntaxProvider;
import com.adbs.syntax.SQL89SyntaxProvider;
import com.adbs.syntax.SQL92SyntaxProvider;
import com.adbs.syntax.SQLiteSyntaxProvider;
import com.adbs.syntax.SybaseServerVersion;
import com.adbs.syntax.SybaseSyntaxProvider;
import com.adbs.syntax.UniversalSyntaxProvider;
import com.adbs.utils.Helpers;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

class SqlSyntaxPage
extends BasePropertyPanel {
    private static final long serialVersionUID = -2887964918136964460L;
    private QueryBuilder queryBuilder = null;
    private MetadataContainer metadataContainer = null;
    private BaseSyntaxProvider syntaxProvider = null;
    private JCheckBox cbQuoteAllIdentifiers;
    private JComboBox comboIdentCaseSens;
    private JComboBox comboSqlDialect;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label4;
    private JLabel label5;
    private JScrollPane spNote;
    private JTextArea taNote;
    private JTextField textBeginQuotationSymbol;
    private JTextField textEndQuotationSymbol;

    public SqlSyntaxPage(QueryBuilder queryBuilder, MetadataContainer metadataContainer, BaseSyntaxProvider syntaxProvider) {
        this.queryBuilder = queryBuilder;
        this.metadataContainer = metadataContainer;
        this.syntaxProvider = syntaxProvider;
        this.initComponents();
        Helpers.localizer.localizePanel(this);
        this.spNote.setVisible(false);
        this.comboIdentCaseSens.addItem(Helpers.localizer.getString("strCaseInsesitive", "All identifiers are case insensitive"));
        this.comboIdentCaseSens.addItem(Helpers.localizer.getString("strCaseSensitiveUppercase", "Quoted are sensitive, Unquoted are converted to uppercase"));
        this.comboIdentCaseSens.addItem(Helpers.localizer.getString("strCaseSensitiveLowercase", "Quoted are sensitive, Unquoted are converted to lowercase"));
        this.comboSqlDialect.addItem("Auto");
        this.comboSqlDialect.addItem("ANSI SQL-2003");
        this.comboSqlDialect.addItem("ANSI SQL-89");
        this.comboSqlDialect.addItem("ANSI SQL-92");
        this.comboSqlDialect.addItem("Firebird 1.0");
        this.comboSqlDialect.addItem("Firebird 1.5");
        this.comboSqlDialect.addItem("Firebird 2.0");
        this.comboSqlDialect.addItem("Firebird 2.5");
        this.comboSqlDialect.addItem("IBM DB2");
        this.comboSqlDialect.addItem("IBM Informix 8");
        this.comboSqlDialect.addItem("IBM Informix 9");
        this.comboSqlDialect.addItem("IBM Informix 10");
        this.comboSqlDialect.addItem("MS Access 97 (MS Jet 3.0)");
        this.comboSqlDialect.addItem("MS Access 2000 (MS Jet 4.0)");
        this.comboSqlDialect.addItem("MS Access XP (MS Jet 4.0)");
        this.comboSqlDialect.addItem("MS Access 2003 (MS Jet 4.0)");
        this.comboSqlDialect.addItem("MS SQL Server 7");
        this.comboSqlDialect.addItem("MS SQL Server 2000");
        this.comboSqlDialect.addItem("MS SQL Server 2005");
        this.comboSqlDialect.addItem("MS SQL Server 2008");
        this.comboSqlDialect.addItem("MS SQL Server Compact Edition");
        this.comboSqlDialect.addItem("MySQL 3.xx");
        this.comboSqlDialect.addItem("MySQL 4.0");
        this.comboSqlDialect.addItem("MySQL 4.1");
        this.comboSqlDialect.addItem("MySQL 5.0");
        this.comboSqlDialect.addItem("Oracle 7");
        this.comboSqlDialect.addItem("Oracle 8");
        this.comboSqlDialect.addItem("Oracle 9");
        this.comboSqlDialect.addItem("Oracle 10");
        this.comboSqlDialect.addItem("PostgreSQL");
        this.comboSqlDialect.addItem("SQLite");
        this.comboSqlDialect.addItem("Sybase ASE");
        this.comboSqlDialect.addItem("Sybase SQL Anywhere");
        this.comboSqlDialect.addItem("Universal");
        BaseSyntaxProvider qbsp = queryBuilder.getSyntaxProvider();
        if (qbsp instanceof SQL92SyntaxProvider) {
            this.comboSqlDialect.setSelectedItem("ANSI SQL-92");
        } else if (qbsp instanceof AutoSyntaxProvider) {
            this.comboSqlDialect.setSelectedItem("Auto");
        } else if (qbsp instanceof SQL89SyntaxProvider) {
            this.comboSqlDialect.setSelectedItem("ANSI SQL-89");
        } else if (qbsp instanceof SQL2003SyntaxProvider) {
            this.comboSqlDialect.setSelectedItem("ANSI SQL-2003");
        } else if (qbsp instanceof FirebirdSyntaxProvider) {
            switch (((FirebirdSyntaxProvider)qbsp).getServerVersion()) {
                case Firebird1: {
                    this.comboSqlDialect.setSelectedItem("Firebird 1.0");
                    break;
                }
                case Firebird1_5: {
                    this.comboSqlDialect.setSelectedItem("Firebird 1.5");
                    break;
                }
                case Firebird2_5: {
                    this.comboSqlDialect.setSelectedItem("Firebird 2.5");
                    break;
                }
                default: {
                    this.comboSqlDialect.setSelectedItem("Firebird 2.0");
                    break;
                }
            }
        } else if (qbsp instanceof DB2SyntaxProvider) {
            this.comboSqlDialect.setSelectedItem("IBM DB2");
        } else if (qbsp instanceof InformixSyntaxProvider) {
            switch (((InformixSyntaxProvider)qbsp).getServerVersion()) {
                case DS8: {
                    this.comboSqlDialect.setSelectedItem("IBM Informix 8");
                    break;
                }
                case DS9: {
                    this.comboSqlDialect.setSelectedItem("IBM Informix 9");
                    break;
                }
                default: {
                    this.comboSqlDialect.setSelectedItem("IBM Informix 10");
                    break;
                }
            }
        } else if (qbsp instanceof AccessSyntaxProvider) {
            switch (((AccessSyntaxProvider)qbsp).getServerVersion()) {
                case MSJET3: {
                    this.comboSqlDialect.setSelectedItem("MS Access 97 (MS Jet 3.0)");
                    break;
                }
                case MSJET4: {
                    this.comboSqlDialect.setSelectedItem("MS Access 2003 (MS Jet 4.0)");
                    break;
                }
                default: {
                    this.comboSqlDialect.setSelectedItem("MS Access 2003 (MS Jet 4.0)");
                    break;
                }
            }
        } else if (qbsp instanceof MSSQLCESyntaxProvider) {
            this.comboSqlDialect.setSelectedItem("MS SQL Server Compact Edition");
        } else if (qbsp instanceof MSSQLSyntaxProvider) {
            switch (((MSSQLSyntaxProvider)qbsp).getServerVersion()) {
                case MSSQL7: {
                    this.comboSqlDialect.setSelectedItem("MS SQL Server 7");
                    break;
                }
                case MSSQL2000: {
                    this.comboSqlDialect.setSelectedItem("MS SQL Server 2000");
                    break;
                }
                case MSSQL2005: {
                    this.comboSqlDialect.setSelectedItem("MS SQL Server 2005");
                    break;
                }
                case MSSQL2008: {
                    this.comboSqlDialect.setSelectedItem("MS SQL Server 2008");
                    break;
                }
                default: {
                    this.comboSqlDialect.setSelectedItem("MS SQL Server 7");
                    break;
                }
            }
        } else if (qbsp instanceof MySQLSyntaxProvider) {
            if (((MySQLSyntaxProvider)qbsp).getServerVersionInt() < 40000) {
                this.comboSqlDialect.setSelectedItem("MySQL 3.xx");
            } else if (((MySQLSyntaxProvider)qbsp).getServerVersionInt() <= 40099) {
                this.comboSqlDialect.setSelectedItem("MySQL 4.0");
            } else if (((MySQLSyntaxProvider)qbsp).getServerVersionInt() < 50000) {
                this.comboSqlDialect.setSelectedItem("MySQL 4.1");
            } else {
                this.comboSqlDialect.setSelectedItem("MySQL 5.0");
            }
        } else if (qbsp instanceof OracleSyntaxProvider) {
            switch (((OracleSyntaxProvider)qbsp).getServerVersion()) {
                case Oracle7: {
                    this.comboSqlDialect.setSelectedItem("Oracle 7");
                    break;
                }
                case Oracle8: {
                    this.comboSqlDialect.setSelectedItem("Oracle 8");
                    break;
                }
                case Oracle9: {
                    this.comboSqlDialect.setSelectedItem("Oracle 9");
                    break;
                }
                case Oracle10: {
                    this.comboSqlDialect.setSelectedItem("Oracle 10");
                    break;
                }
                default: {
                    this.comboSqlDialect.setSelectedItem("Oracle 10");
                    break;
                }
            }
        } else if (qbsp instanceof PostgreSQLSyntaxProvider) {
            this.comboSqlDialect.setSelectedItem("PostgreSQL");
        } else if (qbsp instanceof SQLiteSyntaxProvider) {
            this.comboSqlDialect.setSelectedItem("SQLite");
        } else if (qbsp instanceof SybaseSyntaxProvider) {
            switch (((SybaseSyntaxProvider)qbsp).getServerVersion()) {
                case SybaseASE: {
                    this.comboSqlDialect.setSelectedItem("Sybase ASE");
                    break;
                }
                case SybaseASA: {
                    this.comboSqlDialect.setSelectedItem("Sybase SQL Anywhere");
                    break;
                }
                default: {
                    this.comboSqlDialect.setSelectedItem("Sybase SQL Anywhere");
                }
            }
        }
        if (qbsp instanceof UniversalSyntaxProvider) {
            this.comboSqlDialect.setSelectedItem("Universal");
        }
        if (qbsp != null) {
            this.comboIdentCaseSens.setSelectedIndex(qbsp.getIdentCaseSens().ordinal());
            this.textBeginQuotationSymbol.setText(qbsp.getQuoteBegin());
            this.textEndQuotationSymbol.setText(qbsp.getQuoteEnd());
        }
        this.cbQuoteAllIdentifiers.setSelected(queryBuilder.isQuoteAllIdentifiers());
        this.comboSqlDialect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SqlSyntaxPage.this.comboSqlDialectActionPerformed(evt);
            }
        });
        this.comboIdentCaseSens.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SqlSyntaxPage.this.comboIdentCaseSensActionPerformed(evt);
            }
        });
        this.cbQuoteAllIdentifiers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SqlSyntaxPage.this.cbQuoteAllIdentifiersActionPerformed(evt);
            }
        });
    }

    private void comboSqlDialectActionPerformed(ActionEvent evt) {
        String item = (String)this.comboSqlDialect.getSelectedItem();
        if (item.equals("ANSI SQL-92")) {
            this.syntaxProvider = new SQL92SyntaxProvider();
        } else if (item.equals("Auto")) {
            this.syntaxProvider = new AutoSyntaxProvider();
        } else if (item.equals("ANSI SQL-89")) {
            this.syntaxProvider = new SQL89SyntaxProvider();
        } else if (item.equals("ANSI SQL-2003")) {
            this.syntaxProvider = new SQL2003SyntaxProvider();
        } else if (item.equals("Firebird 1.0")) {
            this.syntaxProvider = new FirebirdSyntaxProvider();
            ((FirebirdSyntaxProvider)this.syntaxProvider).setServerVersion(FirebirdVersion.Firebird1);
        } else if (item.equals("Firebird 1.5")) {
            this.syntaxProvider = new FirebirdSyntaxProvider();
            ((FirebirdSyntaxProvider)this.syntaxProvider).setServerVersion(FirebirdVersion.Firebird1_5);
        } else if (item.equals("Firebird 2.0")) {
            this.syntaxProvider = new FirebirdSyntaxProvider();
            ((FirebirdSyntaxProvider)this.syntaxProvider).setServerVersion(FirebirdVersion.Firebird2);
        } else if (item.equals("Firebird 2.5")) {
            this.syntaxProvider = new FirebirdSyntaxProvider();
            ((FirebirdSyntaxProvider)this.syntaxProvider).setServerVersion(FirebirdVersion.Firebird2_5);
        } else if (item.equals("IBM DB2")) {
            this.syntaxProvider = new DB2SyntaxProvider();
        } else if (item.equals("IBM Informix 8")) {
            this.syntaxProvider = new InformixSyntaxProvider();
            ((InformixSyntaxProvider)this.syntaxProvider).setServerVersion(InformixVersion.DS8);
        } else if (item.equals("IBM Informix 9")) {
            this.syntaxProvider = new InformixSyntaxProvider();
            ((InformixSyntaxProvider)this.syntaxProvider).setServerVersion(InformixVersion.DS9);
        } else if (item.equals("IBM Informix 10")) {
            this.syntaxProvider = new InformixSyntaxProvider();
            ((InformixSyntaxProvider)this.syntaxProvider).setServerVersion(InformixVersion.DS10);
        } else if (item.equals("MS Access 97 (MS Jet 3.0)")) {
            this.syntaxProvider = new AccessSyntaxProvider();
            ((AccessSyntaxProvider)this.syntaxProvider).setServerVersion(AccessServerVersion.MSJET3);
        } else if (item.equals("MS Access 2000 (MS Jet 4.0)") || item.equals("MS Access XP (MS Jet 4.0)") || item.equals("MS Access 2003 (MS Jet 4.0)")) {
            this.syntaxProvider = new AccessSyntaxProvider();
            ((AccessSyntaxProvider)this.syntaxProvider).setServerVersion(AccessServerVersion.MSJET4);
        } else if (item.equals("MS SQL Server 7")) {
            this.syntaxProvider = new MSSQLSyntaxProvider();
            ((MSSQLSyntaxProvider)this.syntaxProvider).setServerVersion(MSSQLServerVersion.MSSQL7);
        } else if (item.equals("MS SQL Server 2000")) {
            this.syntaxProvider = new MSSQLSyntaxProvider();
            ((MSSQLSyntaxProvider)this.syntaxProvider).setServerVersion(MSSQLServerVersion.MSSQL2000);
        } else if (item.equals("MS SQL Server 2005")) {
            this.syntaxProvider = new MSSQLSyntaxProvider();
            ((MSSQLSyntaxProvider)this.syntaxProvider).setServerVersion(MSSQLServerVersion.MSSQL2005);
        } else if (item.equals("MS SQL Server 2008")) {
            this.syntaxProvider = new MSSQLSyntaxProvider();
            ((MSSQLSyntaxProvider)this.syntaxProvider).setServerVersion(MSSQLServerVersion.MSSQL2008);
        } else if (item.equals("MS SQL Server Compact Edition")) {
            this.syntaxProvider = new MSSQLCESyntaxProvider();
        } else if (item.equals("MySQL 3.xx")) {
            this.syntaxProvider = new MySQLSyntaxProvider();
            ((MySQLSyntaxProvider)this.syntaxProvider).setServerVersionInt(39999);
        } else if (item.equals("MySQL 4.0")) {
            this.syntaxProvider = new MySQLSyntaxProvider();
            ((MySQLSyntaxProvider)this.syntaxProvider).setServerVersionInt(40099);
        } else if (item.equals("MySQL 4.1")) {
            this.syntaxProvider = new MySQLSyntaxProvider();
            ((MySQLSyntaxProvider)this.syntaxProvider).setServerVersionInt(49999);
        } else if (item.equals("MySQL 5.0")) {
            this.syntaxProvider = new MySQLSyntaxProvider();
            ((MySQLSyntaxProvider)this.syntaxProvider).setServerVersionInt(50000);
        } else if (item.equals("Oracle 7")) {
            this.syntaxProvider = new OracleSyntaxProvider();
            ((OracleSyntaxProvider)this.syntaxProvider).setServerVersion(OracleServerVersion.Oracle7);
        } else if (item.equals("Oracle 8")) {
            this.syntaxProvider = new OracleSyntaxProvider();
            ((OracleSyntaxProvider)this.syntaxProvider).setServerVersion(OracleServerVersion.Oracle8);
        } else if (item.equals("Oracle 9")) {
            this.syntaxProvider = new OracleSyntaxProvider();
            ((OracleSyntaxProvider)this.syntaxProvider).setServerVersion(OracleServerVersion.Oracle9);
        } else if (item.equals("Oracle 10")) {
            this.syntaxProvider = new OracleSyntaxProvider();
            ((OracleSyntaxProvider)this.syntaxProvider).setServerVersion(OracleServerVersion.Oracle10);
        } else if (item.equals("PostgreSQL")) {
            this.syntaxProvider = new PostgreSQLSyntaxProvider();
        } else if (item.equals("SQLite")) {
            this.syntaxProvider = new SQLiteSyntaxProvider();
        } else if (item.equals("Sybase ASE")) {
            this.syntaxProvider = new SybaseSyntaxProvider();
            ((SybaseSyntaxProvider)this.syntaxProvider).setServerVersion(SybaseServerVersion.SybaseASE);
        } else if (item.equals("Sybase SQL Anywhere")) {
            this.syntaxProvider = new SybaseSyntaxProvider();
            ((SybaseSyntaxProvider)this.syntaxProvider).setServerVersion(SybaseServerVersion.SybaseASA);
        } else if (item.equals("Universal")) {
            this.syntaxProvider = new UniversalSyntaxProvider();
            ((UniversalSyntaxProvider)this.syntaxProvider).redetectServer(this.queryBuilder.getSQLContext());
        } else {
            this.syntaxProvider = new UniversalSyntaxProvider();
        }
        this.comboIdentCaseSens.setSelectedIndex(this.syntaxProvider.getIdentCaseSens().ordinal());
        this.textBeginQuotationSymbol.setText(this.syntaxProvider.getQuoteBegin());
        this.textEndQuotationSymbol.setText(this.syntaxProvider.getQuoteEnd());
        this.setModified(true);
    }

    private void comboIdentCaseSensActionPerformed(ActionEvent evt) {
        this.syntaxProvider.setIdentCaseSens(IdentCaseSensitivity.values()[this.comboIdentCaseSens.getSelectedIndex()]);
        this.comboIdentCaseSens.setSelectedIndex(this.syntaxProvider.getIdentCaseSens().ordinal());
        this.setModified(true);
    }

    private void cbQuoteAllIdentifiersActionPerformed(ActionEvent evt) {
        this.setModified(true);
    }

    @Override
    public void applyChanges() {
        if (this.isModified()) {
            if (this.queryBuilder.getSyntaxProvider() != null) {
                // empty if block
            }
            this.queryBuilder.setSyntaxProvider(this.syntaxProvider);
            this.queryBuilder.setQuoteAllIdentifiers(this.cbQuoteAllIdentifiers.isSelected());
        }
    }

    private void initComponents() {
        this.cbQuoteAllIdentifiers = new JCheckBox();
        this.label5 = new JLabel();
        this.label4 = new JLabel();
        this.label3 = new JLabel();
        this.textBeginQuotationSymbol = new JTextField();
        this.textEndQuotationSymbol = new JTextField();
        this.comboIdentCaseSens = new JComboBox();
        this.label2 = new JLabel();
        this.label1 = new JLabel();
        this.comboSqlDialect = new JComboBox();
        this.spNote = new JScrollPane();
        this.taNote = new JTextArea();
        this.setBackground(new Color(255, 255, 255));
        this.setFont(new Font("Dialog", 0, 11));
        this.setName("SqlSyntaxPage");
        this.setPreferredSize(new Dimension(417, 361));
        this.cbQuoteAllIdentifiers.setBackground(new Color(255, 255, 255));
        this.cbQuoteAllIdentifiers.setFont(this.cbQuoteAllIdentifiers.getFont());
        this.cbQuoteAllIdentifiers.setText("Quote All Identifiers");
        this.cbQuoteAllIdentifiers.setHorizontalTextPosition(2);
        this.cbQuoteAllIdentifiers.setIconTextGap(38);
        this.cbQuoteAllIdentifiers.setMargin(new Insets(2, 0, 2, 2));
        this.cbQuoteAllIdentifiers.setName("cbQuoteAllIdentifiers");
        this.label5.setFont(this.label5.getFont());
        this.label5.setText("End:");
        this.label5.setName("label5");
        this.label4.setFont(this.label4.getFont());
        this.label4.setText("Start:");
        this.label4.setName("label4");
        this.label3.setFont(this.label3.getFont());
        this.label3.setText("Identifier Quotation Symbols:");
        this.label3.setName("label3");
        this.textBeginQuotationSymbol.setEditable(false);
        this.textBeginQuotationSymbol.setFont(this.textBeginQuotationSymbol.getFont());
        this.textBeginQuotationSymbol.setHorizontalAlignment(0);
        this.textEndQuotationSymbol.setEditable(false);
        this.textEndQuotationSymbol.setFont(this.textEndQuotationSymbol.getFont());
        this.textEndQuotationSymbol.setHorizontalAlignment(0);
        this.comboIdentCaseSens.setFont(this.comboIdentCaseSens.getFont());
        this.label2.setFont(this.label2.getFont());
        this.label2.setText("Identifiers Case Sensitivity:");
        this.label2.setName("label2");
        this.label1.setFont(this.label1.getFont());
        this.label1.setText("SQL Dialect:");
        this.label1.setName("label1");
        this.comboSqlDialect.setFont(this.comboSqlDialect.getFont());
        this.comboSqlDialect.setMaximumRowCount(16);
        this.taNote.setBackground(SystemColor.info);
        this.taNote.setColumns(20);
        this.taNote.setEditable(false);
        this.taNote.setFont(new Font("Dialog", 0, 11));
        this.taNote.setLineWrap(true);
        this.taNote.setRows(3);
        this.taNote.setText("Note that the Free Edition has following limitations: only the Universal SQL dialect parser is available and the offline mode is disabled.");
        this.taNote.setWrapStyleWord(true);
        this.taNote.setMargin(new Insets(2, 5, 2, 2));
        this.spNote.setViewportView(this.taNote);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spNote, -1, 397, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.label2).addComponent(this.label1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboSqlDialect, 0, 261, Short.MAX_VALUE).addComponent(this.comboIdentCaseSens, 0, 261, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.label3).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.label5).addGap(24, 24, 24).addComponent(this.textEndQuotationSymbol, -1, 36, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.label4).addGap(18, 18, 18).addComponent(this.textBeginQuotationSymbol, -1, 36, Short.MAX_VALUE))).addGap(156, 156, 156)).addComponent(this.cbQuoteAllIdentifiers)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label1).addComponent(this.comboSqlDialect, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label2).addComponent(this.comboIdentCaseSens, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label3).addComponent(this.label4).addComponent(this.textBeginQuotationSymbol, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label5).addComponent(this.textEndQuotationSymbol, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbQuoteAllIdentifiers).addGap(18, 18, 18).addComponent(this.spNote, -2, -1, -2).addContainerGap(136, Short.MAX_VALUE)));
    }
}

