/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstNodeBase;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.BaseScanner;
import com.adbs.ast.IdentQuotation;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataObjectVisibleEvent;
import com.adbs.ast.MetadataObjectVisibleEventListener;
import com.adbs.ast.MetadataProcedure;
import com.adbs.ast.MetadataSynonym;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.MetadataView;
import com.adbs.ast.ObjectPrefixSkipping;
import com.adbs.ast.ParsingException;
import com.adbs.ast.SQLBuilderFast;
import com.adbs.ast.SQLDatabaseObject;
import com.adbs.ast.SQLFromClause;
import com.adbs.ast.SQLFromObject;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSelectItemAllColumns;
import com.adbs.ast.SQLSelectItems;
import com.adbs.ast.SQLSelectStatement;
import com.adbs.ast.SQLSubQueryExpressions;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SkipKeywordMode;
import com.adbs.ast.SyntaxProviderChangedEvent;
import com.adbs.ast.SyntaxProviderChangedEventListener;
import com.adbs.ast.UpdatedEvent;
import com.adbs.ast.UpdatedEventListener;
import com.adbs.querybuilder.AboutDialog;
import com.adbs.querybuilder.ActiveSubQueryChangedEvent;
import com.adbs.querybuilder.ActiveSubQueryChangedEventListener;
import com.adbs.querybuilder.ActiveUnionSubQueryChangedEvent;
import com.adbs.querybuilder.ActiveUnionSubQueryChangedEventListener;
import com.adbs.querybuilder.AddObjectDialog;
import com.adbs.querybuilder.AddObjectDialogOptions;
import com.adbs.querybuilder.AfterPropertiesDialogEvent;
import com.adbs.querybuilder.AfterPropertiesDialogEventListener;
import com.adbs.querybuilder.BaseSQLBuilder;
import com.adbs.querybuilder.BeforeDatasourceFieldDragEvent;
import com.adbs.querybuilder.BeforeDatasourceFieldDragEventListener;
import com.adbs.querybuilder.BeforePropertiesDialogEvent;
import com.adbs.querybuilder.BeforePropertiesDialogEventListener;
import com.adbs.querybuilder.ComponentCreatedEvent;
import com.adbs.querybuilder.ComponentCreatedEventListener;
import com.adbs.querybuilder.ComponentDestroyingEvent;
import com.adbs.querybuilder.ComponentDestroyingEventListener;
import com.adbs.querybuilder.ControlOwner;
import com.adbs.querybuilder.CriteriaListOptions;
import com.adbs.querybuilder.CustomExpressionBuilderEvent;
import com.adbs.querybuilder.CustomExpressionBuilderEventListener;
import com.adbs.querybuilder.CustomTabbedPane;
import com.adbs.querybuilder.CustomTreeNode;
import com.adbs.querybuilder.CustomizeDatasourceCaptionEvent;
import com.adbs.querybuilder.CustomizeDatasourceCaptionEventListener;
import com.adbs.querybuilder.CustomizeDatasourceFieldListEvent;
import com.adbs.querybuilder.CustomizeDatasourceFieldListEventListener;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourceObject;
import com.adbs.querybuilder.DatasourceFieldAddedEvent;
import com.adbs.querybuilder.DatasourceFieldAddedEventListener;
import com.adbs.querybuilder.DatasourceFieldAddingEvent;
import com.adbs.querybuilder.DatasourceFieldAddingEventListener;
import com.adbs.querybuilder.DatasourceFieldRemovedEvent;
import com.adbs.querybuilder.DatasourceFieldRemovedEventListener;
import com.adbs.querybuilder.DatasourceFieldRemovingEvent;
import com.adbs.querybuilder.DatasourceFieldRemovingEventListener;
import com.adbs.querybuilder.DatasourceGroup;
import com.adbs.querybuilder.DiagramObjectAddedEvent;
import com.adbs.querybuilder.DiagramObjectAddedEventListener;
import com.adbs.querybuilder.DiagramObjectAddingEvent;
import com.adbs.querybuilder.DiagramObjectAddingEventListener;
import com.adbs.querybuilder.DiagramObjectDeletingEvent;
import com.adbs.querybuilder.DiagramObjectDeletingEventListener;
import com.adbs.querybuilder.FieldListOptions;
import com.adbs.querybuilder.FilterProcedureEvent;
import com.adbs.querybuilder.FilterProcedureEventListener;
import com.adbs.querybuilder.FilterSynonymEvent;
import com.adbs.querybuilder.FilterSynonymEventListener;
import com.adbs.querybuilder.FilterTableEvent;
import com.adbs.querybuilder.FilterTableEventListener;
import com.adbs.querybuilder.FilterViewEvent;
import com.adbs.querybuilder.FilterViewEventListener;
import com.adbs.querybuilder.GetDiagramObjectWidthEvent;
import com.adbs.querybuilder.GetDiagramObjectWidthEventListener;
import com.adbs.querybuilder.GetProcedureParametersEvent;
import com.adbs.querybuilder.GetProcedureParametersEventListener;
import com.adbs.querybuilder.GridCellValueChangedEvent;
import com.adbs.querybuilder.GridCellValueChangedEventListener;
import com.adbs.querybuilder.GridCellValueChangingEvent;
import com.adbs.querybuilder.GridCellValueChangingEventListener;
import com.adbs.querybuilder.LinkChangedEvent;
import com.adbs.querybuilder.LinkChangedEventListener;
import com.adbs.querybuilder.LinkChangingEvent;
import com.adbs.querybuilder.LinkChangingEventListener;
import com.adbs.querybuilder.LinkCreatedEvent;
import com.adbs.querybuilder.LinkCreatedEventListener;
import com.adbs.querybuilder.LinkCreatingEvent;
import com.adbs.querybuilder.LinkCreatingEventListener;
import com.adbs.querybuilder.LinkDeletingEvent;
import com.adbs.querybuilder.LinkDeletingEventListener;
import com.adbs.querybuilder.LinkDragOverEvent;
import com.adbs.querybuilder.LinkDragOverEventListener;
import com.adbs.querybuilder.LinkOptions;
import com.adbs.querybuilder.LinkPainter;
import com.adbs.querybuilder.LinkPainterAccess;
import com.adbs.querybuilder.MetadataContainerEditorDialog;
import com.adbs.querybuilder.MetadataContainerLoadDialog;
import com.adbs.querybuilder.MetadataTree;
import com.adbs.querybuilder.MetadataTreeOptions;
import com.adbs.querybuilder.ParameterList;
import com.adbs.querybuilder.Query;
import com.adbs.querybuilder.QueryAwakeEvent;
import com.adbs.querybuilder.QueryAwakeEventListener;
import com.adbs.querybuilder.QueryBase;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.QueryBuilderProperties;
import com.adbs.querybuilder.QueryBuilderPropertiesDialog;
import com.adbs.querybuilder.QueryPart;
import com.adbs.querybuilder.QueryStatistics;
import com.adbs.querybuilder.QueryStructureTree;
import com.adbs.querybuilder.QueryStructureTreeOptions;
import com.adbs.querybuilder.SQLUpdatedEvent;
import com.adbs.querybuilder.SQLUpdatedEventListener;
import com.adbs.querybuilder.SleepModeChangedEvent;
import com.adbs.querybuilder.SleepModeChangedEventListener;
import com.adbs.querybuilder.SqlErrorEvent;
import com.adbs.querybuilder.SqlErrorEventListener;
import com.adbs.querybuilder.SubQuery;
import com.adbs.querybuilder.SubQueryList;
import com.adbs.querybuilder.TextAndObject;
import com.adbs.querybuilder.UnionGroup;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.querybuilder.UserMessageEvent;
import com.adbs.querybuilder.UserMessageEventListener;
import com.adbs.querybuilder.UserMessageId;
import com.adbs.querybuilder.ValidatePopupMenuEvent;
import com.adbs.querybuilder.ValidatePopupMenuEventListener;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.UniversalSyntaxProvider;
import com.adbs.utils.Constants;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import com.adbs.utils.Wrapper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public final class QueryBuilder
extends JPanel
implements Serializable,
SyntaxProviderChangedEventListener,
MetadataObjectVisibleEventListener,
UpdatedEventListener {
    private static final long serialVersionUID = -770202421593889660L;
    private PropertyChangeSupport propertySupport;
    private BaseSQLContext sqlContext;
    private Query query;
    private SQLSelectStatement resultQueryAST;
    private SQLSelectStatement tmpSQL;
    private ParameterList parameters;
    private QueryStatistics statistics;
    private boolean controlsCreated;
    private SubQuery activeSubquery;
    private final SubQueryList subQueries = new SubQueryList();
    private int updating = 0;
    AddObjectDialog addObjectDialog;
    private boolean snapDiagramObjects = false;
    private Dimension snapSize = new Dimension(5, 5);
    CustomTabbedPane tabs;
    private QueryStructureTreeOptions queryStructureTreeOptions;
    private QueryStructureTree queryStructureTree;
    JScrollPane queryStructureScrollPane;
    JSplitPane queryStructureSplitPane;
    private MetadataTreeOptions metadataTreeOptions;
    MetadataTree metadataTree;
    JScrollPane metadataScrollPane;
    JSplitPane metadataSplitPane;
    private CriteriaListOptions criteriaListOptions;
    private FieldListOptions fieldListOptions;
    private LinkOptions linkOptions;
    private AddObjectDialogOptions addObjectDialogOptions;
    private int maxDiagramObjectHeight = -1;
    private boolean sortDiagramObjectFields = false;
    private boolean tableChecksCountInCaption = false;
    private Color diagramObjectColor = new Color(7);
    private Font diagramObjectFont = null;
    private boolean diagramPaneVisible = true;
    private Font treeFont = null;
    private LinkPainter linkStyle;
    private MetadataFilter metadataFilter;
    MetadataContainer metadataContainer;
    private boolean canReorderDatasources = true;
    private boolean quoteAllIdentifiers = false;
    private ObjectPrefixSkipping objectPrefixSkipping = ObjectPrefixSkipping.SkipAll;
    private boolean disposing = false;
    private boolean unionNavBarVisible = true;
    private boolean parsingErrorOnUnknownObjects = false;
    private boolean allowSleepMode = true;
    private boolean sleepMode = false;
    private String sleepModeText;
    private boolean sleepModeSettingText;
    private boolean loadJoinsFromWhereClause = true;
    private int uniqueQueryNameCounter = 1;
    private boolean activeSubQueryChanged = false;
    private boolean activeUnionSubQueryChanged = false;
    private QueryPart filterTabsByActiveQueryPart = QueryPart.Query;
    private DropTarget customDiagramPaneDropTarget = null;
    private DropTarget customCriteriaListDropTarget = null;
    protected ArrayList<SqlErrorEventListener> sqlErrorEventListenerList = new ArrayList();
    protected ArrayList<DiagramObjectAddingEventListener> diagramObjectAddingEventListenerList = new ArrayList();
    protected ArrayList<DiagramObjectAddedEventListener> diagramObjectAddedEventListenerList = new ArrayList();
    protected ArrayList<DiagramObjectDeletingEventListener> diagramObjectDeletingEventListenerList = new ArrayList();
    protected ArrayList<ValidatePopupMenuEventListener> validatePopupMenuEventListenerList = new ArrayList();
    protected ArrayList<FilterTableEventListener> filterTableEventListenerList = new ArrayList();
    protected ArrayList<FilterViewEventListener> filterViewEventListenerList = new ArrayList();
    protected ArrayList<FilterProcedureEventListener> filterProcedureEventListenerList = new ArrayList();
    protected ArrayList<FilterSynonymEventListener> filterSynonymEventListenerList = new ArrayList();
    protected ArrayList<ActiveSubQueryChangedEventListener> activeSubQueryChangedEventListenerList = new ArrayList();
    protected ArrayList<ActiveUnionSubQueryChangedEventListener> activeUnionSubQueryChangedEventListenerList = new ArrayList();
    protected ArrayList<SleepModeChangedEventListener> sleepModeChangedEventListenerList = new ArrayList();
    protected ArrayList<QueryAwakeEventListener> queryAwakeEventListenerList = new ArrayList();
    protected ArrayList<CustomExpressionBuilderEventListener> customExpressionBuilderEventListenerList = new ArrayList();
    protected ArrayList<CustomizeDatasourceFieldListEventListener> customizeDatasourceFieldListEventListenerList = new ArrayList();
    protected ArrayList<LinkDeletingEventListener> linkDeletingEventListenerList = new ArrayList();
    protected ArrayList<LinkCreatedEventListener> linkCreatedEventListenerList = new ArrayList();
    protected ArrayList<LinkDragOverEventListener> linkDragOverEventListenerList = new ArrayList();
    protected ArrayList<LinkCreatingEventListener> linkCreatingEventListenerList = new ArrayList();
    protected ArrayList<LinkChangingEventListener> linkChangingEventListenerList = new ArrayList();
    protected ArrayList<LinkChangedEventListener> linkChangedEventListenerList = new ArrayList();
    protected ArrayList<BeforeDatasourceFieldDragEventListener> beforeDatasourceFieldDragEventListenerList = new ArrayList();
    protected ArrayList<GridCellValueChangingEventListener> gridCellValueChangingEventListenerList = new ArrayList();
    protected ArrayList<GridCellValueChangedEventListener> gridCellValueChangedEventListenerList = new ArrayList();
    protected ArrayList<CustomizeDatasourceCaptionEventListener> customizeDatasourceCaptionEventListenerList = new ArrayList();
    protected ArrayList<BeforePropertiesDialogEventListener> beforePropertiesDialogEventListenerList = new ArrayList();
    protected ArrayList<AfterPropertiesDialogEventListener> afterPropertiesDialogEventListenerList = new ArrayList();
    protected ArrayList<DatasourceFieldAddingEventListener> datasourceFieldAddingEventListenerList = new ArrayList();
    protected ArrayList<DatasourceFieldAddedEventListener> datasourceFieldAddedEventListenerList = new ArrayList();
    protected ArrayList<DatasourceFieldRemovingEventListener> datasourceFieldRemovingEventListenerList = new ArrayList();
    protected ArrayList<DatasourceFieldRemovedEventListener> datasourceFieldRemovedEventListenerList = new ArrayList();
    protected ArrayList<SQLUpdatedEventListener> updatedEventListenerList = new ArrayList();
    protected ArrayList<GetDiagramObjectWidthEventListener> getDiagramObjectWidthEventListenerList = new ArrayList();
    protected ArrayList<UserMessageEventListener> userMessageEventListenerList = new ArrayList();
    protected ArrayList<GetProcedureParametersEventListener> getProcedureParametersEventListenerList = new ArrayList();
    protected ArrayList<ComponentCreatedEventListener> componentCreatedEventListenerList = new ArrayList();
    protected ArrayList<ComponentDestroyingEventListener> componentDestroyingEventListenerList = new ArrayList();
    protected static final Logger LOGGER = Logger.getLogger(QueryBuilder.class.getName());

    public QueryBuilder() throws QueryBuilderException {
        this.initialize(!Beans.isGuiAvailable());
    }

    public QueryBuilder(boolean nonVisualMode) throws QueryBuilderException {
        this.initialize(nonVisualMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(boolean nonVisualMode) throws QueryBuilderException {
        this.propertySupport = new PropertyChangeSupport(this);
        this.setPreferredSize(new Dimension(700, 500));
        this.sqlContext = new BaseSQLContext(null);
        this.setSyntaxProvider(new UniversalSyntaxProvider());
        this.sqlContext.addSyntaxProviderChangedEventListener(this);
        this.metadataContainer = new MetadataContainer(null, this.sqlContext);
        this.metadataContainer.addMetadataObjectVisibleEventListener(this);
        this.sqlContext.setMetadataContainer(this.metadataContainer);
        this.metadataFilter = new MetadataFilter();
        this.query = new Query(this);
        this.parameters = new ParameterList(this);
        this.statistics = new QueryStatistics(this, this.sqlContext);
        this.addObjectDialogOptions = new AddObjectDialogOptions(this);
        this.queryStructureTreeOptions = new QueryStructureTreeOptions(this);
        this.metadataTreeOptions = new MetadataTreeOptions(this);
        this.criteriaListOptions = new CriteriaListOptions(this);
        this.fieldListOptions = new FieldListOptions(this);
        this.linkOptions = new LinkOptions(null);
        if (!nonVisualMode) {
            this.linkStyle = new LinkPainterAccess(this);
            this.queryStructureScrollPane = new JScrollPane();
            this.queryStructureTree = new QueryStructureTree(this);
            this.queryStructureSplitPane = new JSplitPane();
            this.metadataScrollPane = new JScrollPane();
            this.metadataTree = new MetadataTree(this);
            this.metadataSplitPane = new JSplitPane();
            this.tabs = new CustomTabbedPane();
            this.setLayout(new BorderLayout());
            this.queryStructureSplitPane.setBorder(BorderFactory.createEmptyBorder());
            this.queryStructureScrollPane.setPreferredSize(new Dimension(200, 200));
            this.queryStructureScrollPane.setViewportView(this.queryStructureTree);
            this.queryStructureSplitPane.setLeftComponent(this.queryStructureScrollPane);
            this.queryStructureSplitPane.setRightComponent(this.metadataSplitPane);
            this.queryStructureSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (QueryBuilder.this.queryStructureTreeOptions.isTreeVisible()) {
                        int width = QueryBuilder.this.queryStructureSplitPane.getDividerLocation() - QueryBuilder.this.queryStructureSplitPane.getInsets().left;
                        QueryBuilder.this.queryStructureScrollPane.setPreferredSize(new Dimension(width, 200));
                        ((QueryBuilder)QueryBuilder.this).queryStructureTreeOptions.treeWidth = width;
                    }
                }
            });
            this.metadataSplitPane.setBorder(BorderFactory.createEmptyBorder());
            this.metadataSplitPane.setResizeWeight(1.0);
            this.metadataScrollPane.setViewportView(this.metadataTree);
            this.metadataScrollPane.setPreferredSize(new Dimension(200, 200));
            this.metadataSplitPane.setLeftComponent(this.tabs);
            this.metadataSplitPane.setRightComponent(this.metadataScrollPane);
            this.metadataSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (QueryBuilder.this.metadataTreeOptions.isTreeVisible()) {
                        int width = QueryBuilder.this.metadataSplitPane.getWidth() - QueryBuilder.this.metadataSplitPane.getInsets().right - QueryBuilder.this.metadataSplitPane.getDividerSize() - QueryBuilder.this.metadataSplitPane.getDividerLocation();
                        QueryBuilder.this.metadataScrollPane.setPreferredSize(new Dimension(width, 200));
                        ((QueryBuilder)QueryBuilder.this).metadataTreeOptions.treeWidth = width;
                    }
                }
            });
            this.add((Component)this.queryStructureSplitPane, "Center");
            this.tabs.setPreferredSize(new Dimension(50, 50));
            this.tabs.setQueryBuilder(this);
            this.queryStructureTree.setQueryBuilder(this);
            this.metadataTree.setQueryBuilder(this);
            this.metadataTree.setMetadataContainer(this.metadataContainer);
        }
        this.resetUniqueQueryNameCounter();
        this.beginUpdate();
        try {
            SQLSelectStatement s = new SQLSelectStatement(this.sqlContext);
            this.query.loadFromAST(s);
            this.activeSubquery = this.query;
            this.query.setActiveUnionSubquery(this.query.add());
        }
        finally {
            this.endUpdate();
        }
        if (!nonVisualMode) {
            this.createControls();
            this.doUpdateControlParams();
        }
        this.metadataContainer.addUpdatedEventListener(this);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertySupport != null) {
            this.propertySupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    boolean isDisposing() {
        return this.disposing;
    }

    boolean isControlsCreated() {
        return this.controlsCreated;
    }

    public String getLanguage() {
        return Helpers.localizer.getLanguage();
    }

    public void setLanguage(String language) {
        Helpers.localizer.setLanguage(language);
        this.query.languageChanged();
        this.queryStructureTree.updateTree();
    }

    public boolean isOfflineMode() {
        return this.metadataContainer.isOfflineMode();
    }

    public void setOfflineMode(boolean value) {
        this.metadataContainer.setOfflineMode(value);
    }

    public BaseSyntaxProvider getSyntaxProvider() {
        return this.sqlContext.getSyntaxProvider();
    }

    public void setSyntaxProvider(BaseSyntaxProvider value) {
        this.sqlContext.setSyntaxProvider(value);
    }

    public BaseMetadataProvider getMetadataProvider() {
        return this.sqlContext.getMetadataProvider();
    }

    public void setMetadataProvider(BaseMetadataProvider value) {
        if (value != this.getMetadataProvider()) {
            this.sqlContext.setMetadataProvider(value);
        }
    }

    public MetadataFilter getMetadataFilter() {
        return this.metadataFilter;
    }

    public void setMetadataFilter(MetadataFilter value) {
        this.metadataFilter = value;
    }

    public BaseSQLContext getSQLContext() {
        return this.sqlContext;
    }

    public Query getQuery() {
        return this.query;
    }

    public SQLSelectStatement getResultQueryAST() throws QueryBuilderException {
        if (!this.isResultQueryASTGenerated()) {
            this.generateResultQueryAST();
        }
        return this.resultQueryAST;
    }

    private void digUnionSubQuery(UnionSubQuery u) {
        u.getCriteriaList().destroyControls();
        u.getCriteriaList().createControls();
    }

    private void digUnionGroup(UnionGroup g) {
        for (int i = 0; i < g.getCount(); ++i) {
            if (g.get(i) instanceof UnionGroup) {
                this.digUnionGroup((UnionGroup)g.get(i));
                continue;
            }
            if (!(g.get(i) instanceof UnionSubQuery)) continue;
            this.digUnionSubQuery((UnionSubQuery)g.get(i));
        }
    }

    private void digQuery(SubQuery q) {
        if (q.getCount() == 1 && q.get(0) instanceof UnionSubQuery) {
            this.digUnionSubQuery((UnionSubQuery)q.get(0));
        } else {
            this.digUnionGroup(q);
        }
        for (int i = 0; i < q.getSubQueryCount(); ++i) {
            this.digQuery(q.getSubQueries().get(i));
        }
    }

    void recreateCriteriaListControl() {
        this.digQuery(this.getQuery());
    }

    public SubQuery getActiveSubquery() {
        return this.activeSubquery;
    }

    public void setActiveSubquery(SubQuery value) {
        if (this.activeSubquery != value) {
            this.activeSubquery = value;
            if (this.controlsCreated && this.activeSubquery != null) {
                if (!this.activeSubquery.isControlsCreated()) {
                    this.activeSubquery.createControls();
                }
                this.tabs.setSelectedComponent(this.activeSubquery.getQueryPage());
                if (this.activeSubquery.getActiveUnionSubquery() != null) {
                    this.activeSubquery.updateActiveUnionSubQueryControls();
                }
            }
            this.updateTreePosition(this.activeSubquery);
            this.notifyActiveSubQueryChanged();
        }
    }

    public SubQueryList getSubQueries() {
        return this.subQueries;
    }

    public String getSQL() throws QueryBuilderException {
        if (!this.isSleepMode()) {
            if (!this.isResultQueryASTGenerated()) {
                this.generateResultQueryAST();
            }
            if (!Helpers.isQueryEmpty(this.getResultQueryAST())) {
                return this.query.getResultSQL(this.sqlContext.getSQLBuilderExpressionForServer());
            }
            return "";
        }
        return this.getSleepModeText();
    }

    public void setSQL(String value) throws QueryBuilderException {
        this.setSyncSQL(value);
    }

    private void setSyncSQL(String value) throws QueryBuilderException {
        if (!this.getAllowSleepMode() || value.trim().equals("") || this.isSelectStatement(value)) {
            SQLSelectStatement newSQL;
            this.setSleepMode(false);
            try {
                newSQL = this.parseSQL(value);
            }
            catch (Exception exception) {
                throw new QueryBuilderException("Parsing error:\n" + exception.getMessage(), exception);
            }
            if (newSQL != null) {
                String oldSQLText = this.query.getResultSQL(this.sqlContext.getSQLBuilderExpressionForServer());
                String newSQLText = newSQL.getSimpleSQL(this.sqlContext.getSQLBuilderExpressionForServer());
                if (!newSQLText.equals(oldSQLText)) {
                    if (this.tmpSQL != null) {
                        this.tmpSQL.dispose();
                    }
                    this.tmpSQL = newSQL;
                    try {
                        this.setSqlInternal();
                    }
                    catch (QueryBuilderException ex) {
                        QueryBuilder.log(ex);
                    }
                    this.tmpSQL = null;
                } else {
                    newSQL.dispose();
                }
            }
        } else {
            this.setSleepMode(true);
            this.setSleepModeText(value);
        }
    }

    public void setSQLAsync(String value) throws QueryBuilderException {
        if (!this.getAllowSleepMode() || value.trim().equals("") || this.isSelectStatement(value)) {
            SQLSelectStatement newSQL;
            this.setSleepMode(false);
            try {
                newSQL = this.parseSQL(value);
            }
            catch (Exception exception) {
                throw new QueryBuilderException("Parsing error:\n" + exception.getMessage(), exception);
            }
            if (newSQL != null) {
                String oldSQLText = this.query.getResultSQL(this.sqlContext.getSQLBuilderExpressionForServer());
                String newSQLText = newSQL.getSimpleSQL(this.sqlContext.getSQLBuilderExpressionForServer());
                if (!newSQLText.equals(oldSQLText)) {
                    if (this.tmpSQL != null) {
                        this.tmpSQL.dispose();
                    }
                    this.tmpSQL = newSQL;
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                QueryBuilder.this.setSqlInternal();
                            }
                        });
                    }
                    catch (QueryBuilderException ex) {
                        QueryBuilder.log(ex);
                    }
                    this.tmpSQL = null;
                } else {
                    newSQL.dispose();
                }
            }
        } else {
            this.setSleepMode(true);
            this.setSleepModeText(value);
        }
    }

    public MetadataContainer getMetadataContainer() {
        return this.metadataContainer;
    }

    public ParameterList getParameters() {
        return this.parameters;
    }

    public QueryStatistics getQueryStatistics() throws QueryBuilderException {
        if (!this.isSleepMode()) {
            if (!this.isResultQueryASTGenerated()) {
                this.generateResultQueryAST();
            }
            if (!this.statistics.isStatisticsValid()) {
                this.reloadStatistics();
            }
        } else {
            this.statistics.setStatisticsValid();
            this.statistics.getUsedDatabaseObjects().setStatisticsValid();
            this.statistics.getUsedDatabaseObjectColumns().setStatisticsValid();
            this.statistics.getOutputColumns().setStatisticsValid();
        }
        return this.statistics;
    }

    public QueryStructureTree getQueryStructureTree() {
        return this.queryStructureTree;
    }

    public MetadataTree getMetadataTree() {
        return this.metadataTree;
    }

    public boolean isFreeVersion() {
        return false;
    }

    public boolean isUpdating() {
        return this.updating > 0;
    }

    public boolean isCanReorderDatasources() {
        return this.canReorderDatasources;
    }

    public void setCanReorderDatasources(boolean value) {
        if (this.canReorderDatasources != value) {
            this.canReorderDatasources = value;
            this.clear();
        }
    }

    public boolean isSnapDiagramObjects() {
        return this.snapDiagramObjects;
    }

    public void setSnapDiagramObjects(boolean value) {
        this.snapDiagramObjects = value;
    }

    public Dimension getSnapSize() {
        return this.snapSize;
    }

    public void setSnapSize(Dimension value) {
        if (value.width < 0) {
            value.width = 0;
        }
        if (value.width > 20) {
            value.width = 20;
        }
        if (value.height < 0) {
            value.height = 0;
        }
        if (value.height > 20) {
            value.height = 20;
        }
        if (this.snapSize != value) {
            this.snapSize = value;
        }
    }

    public boolean isQuoteAllIdentifiers() {
        return this.quoteAllIdentifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQuoteAllIdentifiers(boolean value) {
        if (value != this.quoteAllIdentifiers) {
            this.quoteAllIdentifiers = value;
            IdentQuotation quoteIdentifiers = value ? IdentQuotation.All : IdentQuotation.IfNeed;
            this.sqlContext.beginUpdate();
            try {
                this.sqlContext.getSQLBuilderExpression().setQuoteIdentifiers(quoteIdentifiers);
                this.sqlContext.getSQLBuilderExpressionForServer().setQuoteIdentifiers(quoteIdentifiers);
                this.query.notifySQLUpdatedRecursive();
            }
            finally {
                this.sqlContext.endUpdate();
            }
        }
    }

    public ObjectPrefixSkipping getObjectPrefixSkipping() {
        return this.objectPrefixSkipping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectPrefixSkipping(ObjectPrefixSkipping value) {
        if (this.objectPrefixSkipping != value) {
            this.sqlContext.beginUpdate();
            try {
                this.sqlContext.getSQLBuilderExpression().setObjectPrefixSkipping(value);
                this.sqlContext.getSQLBuilderExpressionQuoted().setObjectPrefixSkipping(value);
                this.sqlContext.getSQLBuilderExpressionNonQuoted().setObjectPrefixSkipping(value);
                this.sqlContext.getSQLBuilderMetadata().setObjectPrefixSkipping(value);
                this.sqlContext.getSQLBuilderExpressionForServer().setObjectPrefixSkipping(value);
                this.sqlContext.getSQLBuilderExpressionForServerWithoutQuotes().setObjectPrefixSkipping(value);
                this.query.notifySQLUpdatedRecursive();
            }
            finally {
                this.sqlContext.endUpdate();
            }
            this.objectPrefixSkipping = value;
        }
    }

    public LinkPainter getLinkStyle() {
        return this.linkStyle;
    }

    public void setLinkStyle(LinkPainter value) {
        if (this.linkStyle != value) {
            this.linkStyle = value;
        }
    }

    public Color getDiagramObjectColor() {
        return this.diagramObjectColor;
    }

    public void setDiagramObjectColor(Color value) {
        if (this.diagramObjectColor != value) {
            this.diagramObjectColor = value;
            this.doUpdateControlParams();
        }
    }

    public Font getDiagramObjectFont() {
        return this.diagramObjectFont;
    }

    public void setDiagramObjectFont(Font value) {
        this.diagramObjectFont = value;
        this.doUpdateControlParams();
    }

    public boolean isDiagramPaneVisible() {
        return this.diagramPaneVisible;
    }

    public void setDiagramPaneVisible(boolean value) {
        if (this.diagramPaneVisible != value) {
            this.diagramPaneVisible = value;
            this.doUpdateControlParams();
        }
    }

    public Font getTreeFont() {
        return this.treeFont;
    }

    public void setTreeFont(Font value) {
        this.treeFont = value;
        this.doUpdateControlParams();
    }

    public AddObjectDialogOptions getAddObjectDialogOptions() {
        return this.addObjectDialogOptions;
    }

    public void setAddObjectDialogOptions(AddObjectDialogOptions value) {
        this.addObjectDialogOptions.assign(value);
    }

    public QueryStructureTreeOptions getQueryStructureTreeOptions() {
        return this.queryStructureTreeOptions;
    }

    public void setQueryStructureTreeOptions(QueryStructureTreeOptions value) {
        this.queryStructureTreeOptions = value;
    }

    public MetadataTreeOptions getMetadataTreeOptions() {
        return this.metadataTreeOptions;
    }

    public void setMetadataTreeOptions(MetadataTreeOptions value) {
        this.metadataTreeOptions.assign(value);
    }

    public CriteriaListOptions getCriteriaListOptions() {
        return this.criteriaListOptions;
    }

    public void setCriteriaListOptions(CriteriaListOptions value) {
        this.criteriaListOptions.assign(value);
    }

    public FieldListOptions getFieldListOptions() {
        return this.fieldListOptions;
    }

    public void setFieldListOptions(FieldListOptions options) {
        if (this.fieldListOptions != options) {
            this.fieldListOptions.assign(options);
        }
    }

    public int getDefaultDiagramObjectWidth() {
        return this.fieldListOptions.getDefaultFieldListWidth();
    }

    public void setDefaultDiagramObjectWidth(int value) {
        this.fieldListOptions.setDefaultFieldListWidth(value);
    }

    public int getMaxDiagramObjectHeight() {
        return this.maxDiagramObjectHeight;
    }

    public void setMaxDiagramObjectHeight(int value) {
        if (this.maxDiagramObjectHeight != value) {
            this.maxDiagramObjectHeight = value;
            this.doUpdateControlParams();
        }
    }

    boolean isDesignMode() {
        return Beans.isDesignTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLayoutSQL() {
        String result;
        SQLBuilderFast tmpSQLBuilder = new SQLBuilderFast(null);
        try {
            tmpSQLBuilder.assign(this.sqlContext.getSQLBuilderExpressionForServer());
            tmpSQLBuilder.setExpandVirtualFields(false);
            tmpSQLBuilder.setExpandVirtualObjects(false);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.newDocument();
            Element root = doc.createElement("ActiveQueryBuilderLayout");
            doc.appendChild(root);
            Element sql = doc.createElement("SQL");
            sql.setTextContent(this.getResultQueryAST().getSimpleSQL(tmpSQLBuilder));
            root.appendChild(sql);
            Element subqueries = doc.createElement("SubQueries");
            root.appendChild(subqueries);
            for (int i = 0; i < this.getSubQueries().size(); ++i) {
                this.subQueries.get(i).saveLayout(doc, subqueries, tmpSQLBuilder);
            }
            DOMSource src = new DOMSource(doc.getDocumentElement());
            StringWriter sw = new StringWriter();
            TransformerFactory tranFact = TransformerFactory.newInstance();
            Transformer transformer = tranFact.newTransformer();
            StreamResult dest = new StreamResult(sw);
            transformer.transform(src, dest);
            result = sw.toString();
        }
        catch (Exception ex) {
            result = "";
        }
        finally {
            tmpSQLBuilder.dispose();
        }
        return result;
    }

    public void setLayoutSQL(String layout) {
        SQLBuilderFast tmpSQLBuilder = new SQLBuilderFast(null);
        try {
            Element sql;
            tmpSQLBuilder.assign(this.sqlContext.getSQLBuilderExpressionForServer());
            tmpSQLBuilder.setExpandVirtualFields(false);
            tmpSQLBuilder.setExpandVirtualObjects(false);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            StringReader sr = new StringReader(layout);
            Document doc = parser.parse(new InputSource(sr));
            Element root = doc.getDocumentElement();
            if (root != null && (sql = (Element)Helpers.findChildByName("SQL", root)) != null) {
                this.setSyncSQL(sql.getTextContent());
                Element subqueries = (Element)Helpers.findChildByName("SubQueries", root);
                if (subqueries != null) {
                    for (int i = 0; i < this.getSubQueries().size(); ++i) {
                        this.subQueries.get(i).loadLayout(subqueries, tmpSQLBuilder);
                    }
                }
            }
        }
        catch (Exception ex) {
            tmpSQLBuilder.dispose();
        }
    }

    public boolean isUnionNavBarVisible() {
        return this.unionNavBarVisible;
    }

    public void setUnionNavBarVisible(boolean value) {
        if (this.unionNavBarVisible != value) {
            this.unionNavBarVisible = value;
            this.doUpdateControlParams();
        }
    }

    public boolean getParsingErrorOnUnknownObjects() {
        return this.parsingErrorOnUnknownObjects;
    }

    public void setParsingErrorOnUnknownObjects(boolean value) {
        this.parsingErrorOnUnknownObjects = value;
    }

    public boolean isSortDiagramObjectFields() {
        return this.sortDiagramObjectFields;
    }

    public void setSortDiagramObjectFields(boolean value) {
        if (this.sortDiagramObjectFields != value) {
            this.sortDiagramObjectFields = value;
            this.doUpdateControlParams();
        }
    }

    public boolean isTableChecksCountInCaption() {
        return this.tableChecksCountInCaption;
    }

    public void setTableChecksCountInCaption(boolean value) {
        if (this.tableChecksCountInCaption != value) {
            this.tableChecksCountInCaption = value;
            this.doUpdateControlParams();
        }
    }

    public boolean isUseAltNames() {
        return this.sqlContext.getSQLBuilderExpression().isUseAltNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseAltNames(boolean value) {
        this.sqlContext.beginUpdate();
        try {
            this.sqlContext.getSQLBuilderExpression().setUseAltNames(value);
            this.sqlContext.getSQLBuilderExpressionQuoted().setUseAltNames(value);
            this.sqlContext.getSQLBuilderExpressionNonQuoted().setUseAltNames(value);
            this.sqlContext.getSQLBuilderMetadata().setUseAltNames(value);
            if (this.metadataTree != null) {
                this.metadataTree.reloadNodes(true);
            }
            this.doUpdateControlParams();
        }
        finally {
            this.sqlContext.endUpdate();
        }
    }

    public boolean getAllowSleepMode() {
        return this.allowSleepMode;
    }

    public void setAllowSleepMode(boolean value) {
        this.allowSleepMode = value;
    }

    public String getSleepModeText() {
        return this.sleepModeText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSleepModeText(String value) {
        if (!value.equals(this.sleepModeText)) {
            this.sleepModeSettingText = true;
            try {
                this.beginUpdate();
                try {
                    this.clear();
                    this.sleepModeText = value;
                    this.sqlUpdated();
                }
                finally {
                    this.endUpdate();
                }
            }
            finally {
                this.sleepModeSettingText = false;
            }
        }
    }

    public boolean isSleepMode() {
        return this.sleepMode;
    }

    public void addSqlErrorEventListener(SqlErrorEventListener listener) {
        this.sqlErrorEventListenerList.add(listener);
    }

    public void removeSqlErrorEventListener(SqlErrorEventListener listener) {
        this.sqlErrorEventListenerList.remove(listener);
    }

    protected void fireSqlErrorEvent(SqlErrorEvent evt) {
        Iterator<SqlErrorEventListener> listeners = this.sqlErrorEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().sqlErrorEventOccurred(evt);
        }
    }

    public void addDiagramObjectAddingEventListener(DiagramObjectAddingEventListener listener) {
        this.diagramObjectAddingEventListenerList.add(listener);
    }

    public void removeDiagramObjectAddingEventListener(DiagramObjectAddingEventListener listener) {
        this.diagramObjectAddingEventListenerList.remove(listener);
    }

    protected void fireDiagramObjectAddingEvent(DiagramObjectAddingEvent evt) {
        Iterator<DiagramObjectAddingEventListener> listeners = this.diagramObjectAddingEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().diagramObjectAddingEventOccurred(evt);
        }
    }

    public void addDiagramObjectAddedEventListener(DiagramObjectAddedEventListener listener) {
        this.diagramObjectAddedEventListenerList.add(listener);
    }

    public void removeDiagramObjectAddedEventListener(DiagramObjectAddedEventListener listener) {
        this.diagramObjectAddedEventListenerList.remove(listener);
    }

    protected void fireDiagramObjectAddedEvent(DiagramObjectAddedEvent evt) {
        Iterator<DiagramObjectAddedEventListener> listeners = this.diagramObjectAddedEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().diagramObjectAddedEventOccurred(evt);
        }
    }

    public void addDiagramObjectDeletingEventListener(DiagramObjectDeletingEventListener listener) {
        this.diagramObjectDeletingEventListenerList.add(listener);
    }

    public void removeDiagramObjectDeletingEventListener(DiagramObjectDeletingEventListener listener) {
        this.diagramObjectDeletingEventListenerList.remove(listener);
    }

    protected void fireDiagramObjectDeletingEvent(DiagramObjectDeletingEvent evt) {
        Iterator<DiagramObjectDeletingEventListener> listeners = this.diagramObjectDeletingEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().diagramObjectDeletingEventOccurred(evt);
        }
    }

    public void addValidatePopupMenuEventListener(ValidatePopupMenuEventListener listener) {
        this.validatePopupMenuEventListenerList.add(listener);
    }

    public void removeValidatePopupMenuEventListener(ValidatePopupMenuEventListener listener) {
        this.validatePopupMenuEventListenerList.remove(listener);
    }

    private void fireValidatePopupMenuEvent(ValidatePopupMenuEvent evt) {
        Iterator<ValidatePopupMenuEventListener> listeners = this.validatePopupMenuEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().validatePopupMenuEventOccurred(evt);
        }
    }

    public void addFilterTableEventListener(FilterTableEventListener listener) {
        this.filterTableEventListenerList.add(listener);
    }

    public void removeFilterTableEventListener(FilterTableEventListener listener) {
        this.filterTableEventListenerList.remove(listener);
    }

    protected void fireFilterTableEvent(FilterTableEvent evt) {
        Iterator<FilterTableEventListener> listeners = this.filterTableEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().filterTableEventOccurred(evt);
        }
    }

    public void addFilterViewEventListener(FilterViewEventListener listener) {
        this.filterViewEventListenerList.add(listener);
    }

    public void removeFilterViewEventListener(FilterViewEventListener listener) {
        this.filterViewEventListenerList.remove(listener);
    }

    protected void fireFilterViewEvent(FilterViewEvent evt) {
        Iterator<FilterViewEventListener> listeners = this.filterViewEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().filterViewEventOccurred(evt);
        }
    }

    public void addFilterProcedureEventListener(FilterProcedureEventListener listener) {
        this.filterProcedureEventListenerList.add(listener);
    }

    public void removeFilterProcedureEventListener(FilterProcedureEventListener listener) {
        this.filterProcedureEventListenerList.remove(listener);
    }

    protected void fireFilterProcedureEvent(FilterProcedureEvent evt) {
        Iterator<FilterProcedureEventListener> listeners = this.filterProcedureEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().filterProcedureEventOccurred(evt);
        }
    }

    public void addFilterSynonymEventListener(FilterSynonymEventListener listener) {
        this.filterSynonymEventListenerList.add(listener);
    }

    public void removeFilterSynonymEventListener(FilterSynonymEventListener listener) {
        this.filterSynonymEventListenerList.remove(listener);
    }

    protected void fireFilterSynonymEvent(FilterSynonymEvent evt) {
        Iterator<FilterSynonymEventListener> listeners = this.filterSynonymEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().filterSynonymEventOccurred(evt);
        }
    }

    void notifyActiveSubQueryChanged() {
        if (!this.isDisposing()) {
            if (this.isUpdating()) {
                this.activeSubQueryChanged = true;
            } else {
                this.fireActiveSubQueryChangedEvent(new ActiveSubQueryChangedEvent(this));
            }
        }
    }

    public void addActiveSubQueryChangedEventListener(ActiveSubQueryChangedEventListener listener) {
        this.activeSubQueryChangedEventListenerList.add(listener);
    }

    public void removeActiveSubQueryChangedEventListener(ActiveSubQueryChangedEventListener listener) {
        this.activeSubQueryChangedEventListenerList.remove(listener);
    }

    protected void fireActiveSubQueryChangedEvent(ActiveSubQueryChangedEvent evt) {
        this.activeSubQueryChanged = false;
        Iterator<ActiveSubQueryChangedEventListener> listeners = this.activeSubQueryChangedEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().activeSubQueryChangedEventOccurred(evt);
        }
        this.fireActiveUnionSubQueryChangedEvent(new ActiveUnionSubQueryChangedEvent(this));
    }

    void notifyActiveUnionSubQueryChanged() {
        if (!this.isDisposing()) {
            if (this.isUpdating()) {
                this.activeUnionSubQueryChanged = true;
            } else {
                this.fireActiveUnionSubQueryChangedEvent(new ActiveUnionSubQueryChangedEvent(this));
            }
        }
    }

    public void addActiveUnionSubQueryChangedEventListener(ActiveUnionSubQueryChangedEventListener listener) {
        this.activeUnionSubQueryChangedEventListenerList.add(listener);
    }

    public void removeActiveUnionSubQueryChangedEventListener(ActiveUnionSubQueryChangedEventListener listener) {
        this.activeUnionSubQueryChangedEventListenerList.remove(listener);
    }

    protected void fireActiveUnionSubQueryChangedEvent(ActiveUnionSubQueryChangedEvent evt) {
        this.activeUnionSubQueryChanged = false;
        Iterator<ActiveUnionSubQueryChangedEventListener> listeners = this.activeUnionSubQueryChangedEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().activeUnionSubQueryChangedEventOccurred(evt);
        }
        this.updateVisibleSubQueries();
    }

    public void addSleepModeChangedEventListener(SleepModeChangedEventListener listener) {
        this.sleepModeChangedEventListenerList.add(listener);
    }

    public void removeSleepModeChangedEventListener(SleepModeChangedEventListener listener) {
        this.sleepModeChangedEventListenerList.remove(listener);
    }

    protected void fireSleepModeChangedEvent(SleepModeChangedEvent evt) {
        Iterator<SleepModeChangedEventListener> listeners = this.sleepModeChangedEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().sleepModeChangedEventOccurred(evt);
        }
    }

    public void addQueryAwakeEventListener(QueryAwakeEventListener listener) {
        this.queryAwakeEventListenerList.add(listener);
    }

    public void removeQueryAwakeEventListener(QueryAwakeEventListener listener) {
        this.queryAwakeEventListenerList.remove(listener);
    }

    protected void fireQueryAwakeEvent(QueryAwakeEvent evt) {
        Iterator<QueryAwakeEventListener> listeners = this.queryAwakeEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().queryAwakeEventOccurred(evt);
        }
    }

    public void addCustomExpressionBuilderEventListener(CustomExpressionBuilderEventListener listener) {
        this.customExpressionBuilderEventListenerList.add(listener);
    }

    public void removeCustomExpressionBuilderEventListener(CustomExpressionBuilderEventListener listener) {
        this.customExpressionBuilderEventListenerList.remove(listener);
    }

    protected void fireCustomExpressionBuilderEvent(CustomExpressionBuilderEvent evt) {
        Iterator<CustomExpressionBuilderEventListener> listeners = this.customExpressionBuilderEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().customExpressionBuilderEventOccurred(evt);
        }
    }

    public void addCustomizeDatasourceFieldListEventListener(CustomizeDatasourceFieldListEventListener listener) {
        this.customizeDatasourceFieldListEventListenerList.add(listener);
    }

    public void removeCustomizeDatasourceFieldListEventListener(CustomizeDatasourceFieldListEventListener listener) {
        this.customizeDatasourceFieldListEventListenerList.remove(listener);
    }

    protected void fireCustomizeDatasourceFieldListEvent(CustomizeDatasourceFieldListEvent evt) {
        Iterator<CustomizeDatasourceFieldListEventListener> listeners = this.customizeDatasourceFieldListEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().customizeDatasourceFieldListEventOccurred(evt);
        }
    }

    public void addLinkDeletingEventListener(LinkDeletingEventListener listener) {
        this.linkDeletingEventListenerList.add(listener);
    }

    public void removeLinkDeletingEventListener(LinkDeletingEventListener listener) {
        this.linkDeletingEventListenerList.remove(listener);
    }

    protected void fireLinkDeletingEvent(LinkDeletingEvent evt) {
        Iterator<LinkDeletingEventListener> listeners = this.linkDeletingEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().linkDeletingEventOccurred(evt);
        }
    }

    public void addLinkCreatedEventListener(LinkCreatedEventListener listener) {
        this.linkCreatedEventListenerList.add(listener);
    }

    public void removeLinkCreatedEventListener(LinkCreatedEventListener listener) {
        this.linkCreatedEventListenerList.remove(listener);
    }

    protected void fireLinkCreatedEvent(LinkCreatedEvent evt) {
        Iterator<LinkCreatedEventListener> listeners = this.linkCreatedEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().linkCreatedEventOccurred(evt);
        }
    }

    public void addLinkDragOverEventListener(LinkDragOverEventListener listener) {
        this.linkDragOverEventListenerList.add(listener);
    }

    public void removeLinkDragOverEventListener(LinkDragOverEventListener listener) {
        this.linkDragOverEventListenerList.remove(listener);
    }

    protected void fireLinkDragOverEvent(LinkDragOverEvent evt) {
        Iterator<LinkDragOverEventListener> listeners = this.linkDragOverEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().linkDragOverEventOccurred(evt);
        }
    }

    public void addLinkCreatingEventListener(LinkCreatingEventListener listener) {
        this.linkCreatingEventListenerList.add(listener);
    }

    public void removeLinkCreatingEventListener(LinkCreatingEventListener listener) {
        this.linkCreatingEventListenerList.remove(listener);
    }

    protected void fireLinkCreatingEvent(LinkCreatingEvent evt) {
        Iterator<LinkCreatingEventListener> listeners = this.linkCreatingEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().linkCreatingEventOccurred(evt);
        }
    }

    public void addLinkChangingEventListener(LinkChangingEventListener listener) {
        this.linkChangingEventListenerList.add(listener);
    }

    public void removeLinkChangingEventListener(LinkChangingEventListener listener) {
        this.linkChangingEventListenerList.remove(listener);
    }

    protected void fireLinkChangingEvent(LinkChangingEvent evt) {
        Iterator<LinkChangingEventListener> listeners = this.linkChangingEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().linkChangingEventOccurred(evt);
        }
    }

    public void addLinkChangedEventListener(LinkChangedEventListener listener) {
        this.linkChangedEventListenerList.add(listener);
    }

    public void removeLinkChangedEventListener(LinkChangedEventListener listener) {
        this.linkChangedEventListenerList.remove(listener);
    }

    protected void fireLinkChangedEvent(LinkChangedEvent evt) {
        Iterator<LinkChangedEventListener> listeners = this.linkChangedEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().linkChangedEventOccurred(evt);
        }
    }

    public void addBeforeDatasourceFieldDragEventListener(BeforeDatasourceFieldDragEventListener listener) {
        this.beforeDatasourceFieldDragEventListenerList.add(listener);
    }

    public void removeBeforeDatasourceFieldDragEventListener(BeforeDatasourceFieldDragEventListener listener) {
        this.beforeDatasourceFieldDragEventListenerList.remove(listener);
    }

    protected void fireBeforeDatasourceFieldDragEvent(BeforeDatasourceFieldDragEvent evt) {
        Iterator<BeforeDatasourceFieldDragEventListener> listeners = this.beforeDatasourceFieldDragEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().beforeDatasourceFieldDragEventOccurred(evt);
        }
    }

    public void addGridCellValueChangingEventListener(GridCellValueChangingEventListener listener) {
        this.gridCellValueChangingEventListenerList.add(listener);
    }

    public void removeGridCellValueChangingEventListener(GridCellValueChangingEventListener listener) {
        this.gridCellValueChangingEventListenerList.remove(listener);
    }

    protected void fireGridCellValueChangingEvent(GridCellValueChangingEvent evt) {
        Iterator<GridCellValueChangingEventListener> listeners = this.gridCellValueChangingEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().gridCellValueChangingEventOccurred(evt);
        }
    }

    public void addGridCellValueChangedEventListener(GridCellValueChangedEventListener listener) {
        this.gridCellValueChangedEventListenerList.add(listener);
    }

    public void removeGridCellValueChangedEventListener(GridCellValueChangedEventListener listener) {
        this.gridCellValueChangedEventListenerList.remove(listener);
    }

    protected void fireGridCellValueChangedEvent(GridCellValueChangedEvent evt) {
        Iterator<GridCellValueChangedEventListener> listeners = this.gridCellValueChangedEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().gridCellValueChangedEventOccurred(evt);
        }
    }

    public void addCustomizeDatasourceCaptionEventListener(CustomizeDatasourceCaptionEventListener listener) {
        this.customizeDatasourceCaptionEventListenerList.add(listener);
    }

    public void removeCustomizeDatasourceCaptionEventListener(CustomizeDatasourceCaptionEventListener listener) {
        this.customizeDatasourceCaptionEventListenerList.remove(listener);
    }

    protected void fireCustomizeDatasourceCaptionEvent(CustomizeDatasourceCaptionEvent evt) {
        Iterator<CustomizeDatasourceCaptionEventListener> listeners = this.customizeDatasourceCaptionEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().customizeDatasourceCaptionEventOccurred(evt);
        }
    }

    public void addBeforePropertiesDialogEventListener(BeforePropertiesDialogEventListener listener) {
        this.beforePropertiesDialogEventListenerList.add(listener);
    }

    public void removeBeforePropertiesDialogEventListener(BeforePropertiesDialogEventListener listener) {
        this.beforePropertiesDialogEventListenerList.remove(listener);
    }

    protected void fireBeforePropertiesDialogEvent(BeforePropertiesDialogEvent evt) {
        Iterator<BeforePropertiesDialogEventListener> listeners = this.beforePropertiesDialogEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().beforePropertiesDialogEventOccurred(evt);
        }
    }

    public void addAfterPropertiesDialogEventListener(AfterPropertiesDialogEventListener listener) {
        this.afterPropertiesDialogEventListenerList.add(listener);
    }

    public void removeAfterPropertiesDialogEventListener(AfterPropertiesDialogEventListener listener) {
        this.afterPropertiesDialogEventListenerList.remove(listener);
    }

    protected void fireAfterPropertiesDialogEvent(AfterPropertiesDialogEvent evt) {
        Iterator<AfterPropertiesDialogEventListener> listeners = this.afterPropertiesDialogEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().afterPropertiesDialogEventOccurred(evt);
        }
    }

    public void addDatasourceFieldAddingEventListener(DatasourceFieldAddingEventListener listener) {
        this.datasourceFieldAddingEventListenerList.add(listener);
    }

    public void removeDatasourceFieldAddingEventListener(DatasourceFieldAddingEventListener listener) {
        this.datasourceFieldAddingEventListenerList.remove(listener);
    }

    protected void fireDatasourceFieldAddingEvent(DatasourceFieldAddingEvent evt) {
        Iterator<DatasourceFieldAddingEventListener> listeners = this.datasourceFieldAddingEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().datasourceFieldAddingEventOccurred(evt);
        }
    }

    public void addDatasourceFieldAddedEventListener(DatasourceFieldAddedEventListener listener) {
        this.datasourceFieldAddedEventListenerList.add(listener);
    }

    public void removeDatasourceFieldAddedEventListener(DatasourceFieldAddedEventListener listener) {
        this.datasourceFieldAddedEventListenerList.remove(listener);
    }

    protected void fireDatasourceFieldAddedEvent(DatasourceFieldAddedEvent evt) {
        Iterator<DatasourceFieldAddedEventListener> listeners = this.datasourceFieldAddedEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().datasourceFieldAddedEventOccurred(evt);
        }
    }

    public void addDatasourceFieldRemovingEventListener(DatasourceFieldRemovingEventListener listener) {
        this.datasourceFieldRemovingEventListenerList.add(listener);
    }

    public void removeDatasourceFieldRemovingEventListener(DatasourceFieldRemovingEventListener listener) {
        this.datasourceFieldRemovingEventListenerList.remove(listener);
    }

    protected void fireDatasourceFieldRemovingEvent(DatasourceFieldRemovingEvent evt) {
        Iterator<DatasourceFieldRemovingEventListener> listeners = this.datasourceFieldRemovingEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().datasourceFieldRemovingEventOccurred(evt);
        }
    }

    public void addDatasourceFieldRemovedEventListener(DatasourceFieldRemovedEventListener listener) {
        this.datasourceFieldRemovedEventListenerList.add(listener);
    }

    public void removeDatasourceFieldRemovedEventListener(DatasourceFieldRemovedEventListener listener) {
        this.datasourceFieldRemovedEventListenerList.remove(listener);
    }

    protected void fireDatasourceFieldRemovedEvent(DatasourceFieldRemovedEvent evt) {
        Iterator<DatasourceFieldRemovedEventListener> listeners = this.datasourceFieldRemovedEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().datasourceFieldRemovedEventOccurred(evt);
        }
    }

    public void addGetDiagramObjectWidthEventListener(GetDiagramObjectWidthEventListener listener) {
        this.getDiagramObjectWidthEventListenerList.add(listener);
    }

    public void removeGetDiagramObjectWidthEventListener(GetDiagramObjectWidthEventListener listener) {
        this.getDiagramObjectWidthEventListenerList.remove(listener);
    }

    protected void fireGetDiagramObjectWidthEvent(GetDiagramObjectWidthEvent evt) {
        Iterator<GetDiagramObjectWidthEventListener> listeners = this.getDiagramObjectWidthEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().getDiagramObjectWidthEventOccurred(evt);
        }
    }

    public void addUserMessageEventListener(UserMessageEventListener listener) {
        this.userMessageEventListenerList.add(listener);
    }

    public void removeUserMessageEventListener(UserMessageEventListener listener) {
        this.userMessageEventListenerList.remove(listener);
    }

    protected void fireUserMessageEvent(UserMessageId messageId) {
        String msg;
        switch (messageId) {
            case ColumnNameAlreadyUsed: {
                msg = Helpers.localizer.getString("strColumnNameAlreadyUsed", Constants.strColumnNameAlreadyUsed);
                break;
            }
            case DeletingAliasCausesConflict: {
                msg = Helpers.localizer.getString("strDeletingAliasCausesConflict", Constants.strDeletingAliasCausesConflict);
                break;
            }
            case SelectingExpressionCausesConflict: {
                msg = Helpers.localizer.getString("strSelectingExpressionCausesConflict", Constants.strSelectingExpressionCausesConflict);
                break;
            }
            default: {
                throw new QueryBuilderException("Unknown user message ID.");
            }
        }
        UserMessageEvent evt = new UserMessageEvent(this, messageId, msg);
        Iterator<UserMessageEventListener> listeners = this.userMessageEventListenerList.iterator();
        if (listeners.hasNext()) {
            while (listeners.hasNext()) {
                listeners.next().userMessageEventOccurred(evt);
            }
        } else {
            JOptionPane.showMessageDialog(this, msg);
        }
    }

    public void addGetProcedureParametersEventListener(GetProcedureParametersEventListener listener) {
        this.getProcedureParametersEventListenerList.add(listener);
    }

    public void removeGetProcedureParametersEventListener(GetProcedureParametersEventListener listener) {
        this.getProcedureParametersEventListenerList.remove(listener);
    }

    protected void fireGetProcedureParametersEvent(GetProcedureParametersEvent evt) {
        Iterator<GetProcedureParametersEventListener> listeners = this.getProcedureParametersEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().getProcedureParametersEventOccurred(evt);
        }
    }

    public void addComponentCreatedEventListener(ComponentCreatedEventListener listener) {
        this.componentCreatedEventListenerList.add(listener);
    }

    public void removeComponentCreatedEventListener(ComponentCreatedEventListener listener) {
        this.componentCreatedEventListenerList.remove(listener);
    }

    protected void fireComponentCreatedEvent(ComponentCreatedEvent evt) {
        Iterator<ComponentCreatedEventListener> listeners = this.componentCreatedEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().componentCreatedEventOccurred(evt);
        }
    }

    public void addComponentDestroyingEventListener(ComponentDestroyingEventListener listener) {
        this.componentDestroyingEventListenerList.add(listener);
    }

    public void removeComponentDestroyingEventListener(ComponentDestroyingEventListener listener) {
        this.componentDestroyingEventListenerList.remove(listener);
    }

    protected void fireComponentDestroyingEvent(ComponentDestroyingEvent evt) {
        Iterator<ComponentDestroyingEventListener> listeners = this.componentDestroyingEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().componentDestroyingEventOccurred(evt);
        }
    }

    @Override
    public void syntaxProviderChangedEventOccurred(SyntaxProviderChangedEvent event) {
        if (this.getSyntaxProvider() == null) {
            this.clear();
        } else {
            this.readSyntaxProviderCaps();
            this.sqlUpdated();
        }
    }

    @Override
    public void metadataObjectVisibleEventOccurred(MetadataObjectVisibleEvent event) {
        if (event.metadataObject instanceof MetadataTable) {
            FilterTableEvent e = new FilterTableEvent(this, event.metadataObject.getFullName().getQualifiedName());
            this.fireFilterTableEvent(e);
            event.visible = e.visible;
        } else if (event.metadataObject instanceof MetadataView) {
            FilterViewEvent e = new FilterViewEvent(this, event.metadataObject.getFullName().getQualifiedName());
            this.fireFilterViewEvent(e);
            event.visible = e.visible;
        } else if (event.metadataObject instanceof MetadataProcedure) {
            FilterProcedureEvent e = new FilterProcedureEvent(this, event.metadataObject.getFullName().getQualifiedName());
            this.fireFilterProcedureEvent(e);
            event.visible = e.visible;
        } else if (event.metadataObject instanceof MetadataSynonym) {
            FilterSynonymEvent e = new FilterSynonymEvent(this, event.metadataObject.getFullName().getQualifiedName());
            this.fireFilterSynonymEvent(e);
            event.visible = e.visible;
        }
    }

    private void refreshDatasourcesMetadataInDatasourceGroup(DatasourceGroup group) throws QueryBuilderException {
        if (group == null) {
            return;
        }
        for (int i = 0; i < group.getCount(); ++i) {
            if (group.get(i) instanceof DataSource) {
                ((DataSource)group.get(i)).refreshMetadata();
                continue;
            }
            if (!(group.get(i) instanceof DatasourceGroup)) continue;
            this.refreshDatasourcesMetadataInDatasourceGroup((DatasourceGroup)group.get(i));
        }
    }

    private void refreshDatasourcesMetadataInUnionGroup(UnionGroup group) throws QueryBuilderException {
        for (int i = 0; i < group.getCount(); ++i) {
            if (group.get(i) instanceof UnionGroup) {
                this.refreshDatasourcesMetadataInUnionGroup((UnionGroup)group.get(i));
                continue;
            }
            if (!(group.get(i) instanceof UnionSubQuery)) continue;
            this.refreshDatasourcesMetadataInDatasourceGroup(((UnionSubQuery)group.get(i)).getFromClause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDatasourcesMetadata(SubQuery subQuery) throws QueryBuilderException {
        this.beginUpdate();
        try {
            this.refreshDatasourcesMetadataInUnionGroup(subQuery);
            for (int i = 0; i < subQuery.getSubQueryCount(); ++i) {
                this.refreshDatasourcesMetadata(subQuery.getSubQueries().get(i));
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void refreshDatasourcesMetadata() {
        for (SubQuery subQuery : this.subQueries) {
            this.refreshDatasourcesMetadata(subQuery);
        }
    }

    public void beginUpdate() {
        ++this.updating;
        this.query.beginUpdate();
    }

    public void endUpdate() {
        --this.updating;
        if (this.updating < 0) {
            throw new RuntimeException("Using of endUpdate() without prior beginUpdate() is detected.");
        }
        this.query.endUpdate();
        if (!this.isDisposing() && !this.isUpdating()) {
            if (this.activeSubQueryChanged) {
                this.fireActiveSubQueryChangedEvent(new ActiveSubQueryChangedEvent(this));
            } else if (this.activeUnionSubQueryChanged) {
                this.fireActiveUnionSubQueryChangedEvent(new ActiveUnionSubQueryChangedEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshMetadata() throws QueryBuilderException {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.getMetadataContainer().beginUpdate();
            try {
                if (this.getSyntaxProvider() == null) {
                    throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
                }
                if (this.getMetadataProvider() == null) {
                    throw new QueryBuilderException(Helpers.localizer.getString("strNoMetadataProvider", "No metadata provider."));
                }
                this.getMetadataContainer().clear();
                this.getMetadataContainer().loadMetadataByFilter(this.getMetadataFilter(), null);
                this.refreshDatasourcesMetadata();
            }
            finally {
                this.getMetadataContainer().endUpdate();
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public boolean isNameOfTable(SQLDatabaseObject name) {
        return this.metadataContainer.findTableByFullName(name) != null;
    }

    public boolean isNameOfView(SQLDatabaseObject name) {
        return this.metadataContainer.findViewByFullName(name) != null;
    }

    public boolean isNameOfProcedure(SQLDatabaseObject name) {
        return this.metadataContainer.findProcedureByFullName(name) != null;
    }

    public void getDatabaseList(SQLQualifiedNameList databaseList) throws QueryBuilderException {
        databaseList.clear();
        if (!this.isOfflineMode()) {
            this.sqlContext.getDatabaseList(databaseList);
        }
    }

    public void getDatabaseList(List<String> databaseList) throws QueryBuilderException {
        SQLQualifiedNameList qnl = new SQLQualifiedNameList(this.sqlContext);
        this.sqlContext.getDatabaseList(qnl);
        databaseList.clear();
        if (qnl.getCount() > 0) {
            for (int i = 0; i < qnl.getCount(); ++i) {
                SQLQualifiedName qn = qnl.get(i);
                databaseList.add(qn.getQualifiedName());
            }
        }
    }

    public void loadMetadata(SQLQualifiedName database) throws QueryBuilderException {
        this.metadataContainer.loadMetadataByFilter(this.metadataFilter, database);
        this.refreshDatasourcesMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMetadata(String database) throws QueryBuilderException {
        SQLQualifiedName db = this.sqlContext.parseQualifiedNameQuoteIfNeed(database);
        try {
            this.metadataContainer.loadMetadataByFilter(this.metadataFilter, db);
            this.refreshDatasourcesMetadata();
        }
        finally {
            db.dispose();
        }
    }

    public void loadMetadataByFilter(MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        this.metadataContainer.loadMetadataByFilter(metadataFilter, database);
        this.refreshDatasourcesMetadata();
    }

    public void loadMetadataByMask(String objectMask, String schemaMask, SQLQualifiedName database) throws QueryBuilderException {
        this.metadataContainer.loadMetadataByMask(objectMask, schemaMask, database);
        this.refreshDatasourcesMetadata();
    }

    public void loadMetadataByMask(String objectMask, String schemaMask, String database) throws QueryBuilderException {
        this.metadataContainer.loadMetadataByMask(objectMask, schemaMask, database);
        this.refreshDatasourcesMetadata();
    }

    public void clearMetadataByMask(String objectMask, String schemaMask, SQLQualifiedName database) throws QueryBuilderException {
        this.metadataContainer.clearMetadataByMask(objectMask, schemaMask, database);
        this.refreshDatasourcesMetadata();
    }

    public void getTableNames(List names, boolean system) {
        names.clear();
        for (int i = 0; i < this.metadataContainer.getCount(); ++i) {
            MetadataObject mo = this.metadataContainer.get(i);
            if (!mo.isVisible() || (system || mo.isSystem()) && (!system || !mo.isSystem()) || !(mo instanceof MetadataTable)) continue;
            names.add(new TextAndObject(mo.getFullName().getQualifiedNameWithoutQuotes(), mo.getFullName()));
        }
    }

    public void getViewNames(List names, boolean system) {
        names.clear();
        for (int i = 0; i < this.metadataContainer.getCount(); ++i) {
            MetadataObject mo = this.metadataContainer.get(i);
            if (!mo.isVisible() || (system || mo.isSystem()) && (!system || !mo.isSystem()) || !(mo instanceof MetadataView)) continue;
            names.add(new TextAndObject(mo.getFullName().getQualifiedNameWithoutQuotes(), mo.getFullName()));
        }
    }

    public void getProcedureNames(List names, boolean system) {
        names.clear();
        for (int i = 0; i < this.metadataContainer.getCount(); ++i) {
            MetadataObject mo = this.metadataContainer.get(i);
            if (!mo.isVisible() || (system || mo.isSystem()) && (!system || !mo.isSystem()) || !(mo instanceof MetadataProcedure)) continue;
            names.add(new TextAndObject(mo.getFullName().getQualifiedNameWithoutQuotes(), mo.getFullName()));
        }
    }

    public static boolean editMetadataContainer(Window parent, MetadataContainer metadataContainer, boolean forceSaveResults, MetadataFilter metadataFilter) {
        assert (metadataContainer != null);
        MetadataContainerEditorDialog dlg = new MetadataContainerEditorDialog(parent, metadataContainer, false);
        if (metadataFilter != null) {
            dlg.setMetadataFilter(metadataFilter);
        }
        return dlg.showDialog();
    }

    public static boolean loadMetadataContainer(Window parent, MetadataContainer metadataContainer, MetadataFilter metadataFilter) {
        MetadataContainerLoadDialog dlg = new MetadataContainerLoadDialog(parent, metadataContainer, false);
        if (metadataFilter != null) {
            dlg.setMetadataFilter(metadataFilter);
        }
        return dlg.showDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fetchMetadataToFile(Window parent) {
        BaseSQLContext tmpSQLContext = new BaseSQLContext(null);
        MetadataContainer tmpMetadataContainer = new MetadataContainer(null, tmpSQLContext);
        try {
            tmpSQLContext.setMetadataContainer(tmpMetadataContainer);
            MetadataContainerLoadDialog dlg = new MetadataContainerLoadDialog(parent, tmpMetadataContainer, true);
            if (dlg.showDialog()) {
                String string = dlg.getXMLFileName();
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            tmpMetadataContainer.dispose();
            tmpSQLContext.dispose();
        }
    }

    public void showQueryBuilderPropertiesDialog(Window parent, String title, EnumSet<QueryBuilderProperties> flags, BaseSQLBuilder builder) {
        QueryBuilderPropertiesDialog dlg = new QueryBuilderPropertiesDialog(parent, this, title, flags, builder);
        dlg.showDialog();
    }

    private void setSleepMode(boolean value) {
        if (value != this.sleepMode) {
            if (value) {
                this.sleepModeOn();
            } else {
                this.sleepModeOff();
            }
        }
    }

    private void sleepModeOn() {
        this.sleepMode = true;
        this.fireSleepModeChangedEvent(new SleepModeChangedEvent(this));
    }

    private void sleepModeOff() {
        this.sleepMode = false;
        this.sleepModeText = "";
        this.fireSleepModeChangedEvent(new SleepModeChangedEvent(this));
    }

    private boolean isSelectStatement(String sql) throws QueryBuilderException {
        boolean result = false;
        if (this.getSyntaxProvider() != null) {
            BaseScanner s = this.getSyntaxProvider().createScanner();
            s.init(sql);
            if (s.getCount() > 0) {
                int i;
                for (i = 0; i < s.getCount() && (s.getToken((int)i).comment || s.getToken((int)i).val.equals("(")); ++i) {
                }
                String val = s.getToken((int)i).val.toUpperCase();
                if (val.equals("SELECT")) {
                    result = true;
                } else if (val.equals("WITH")) {
                    result = true;
                    for (i = 0; i < s.getCount(); ++i) {
                        val = s.getToken((int)i).val.toUpperCase();
                        if (!val.equals("INSERT") && !val.equals("UPDATE")) continue;
                        result = false;
                        break;
                    }
                } else {
                    result = false;
                }
            } else {
                result = false;
            }
        } else {
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        return result;
    }

    public void createControls() {
        if (this.controlsCreated) {
            return;
        }
        this.controlsCreated = true;
        this.query.createControls();
        this.tabs.setSelectedComponent(this.activeSubquery.getQueryPage());
    }

    public void destroyControls() {
        if (!this.controlsCreated) {
            return;
        }
        this.controlsCreated = false;
        this.query.destroyControls();
    }

    void doUpdateControlParams() {
        if (!this.isControlsCreated()) {
            return;
        }
        if (this.queryStructureTreeOptions.isTreeVisible()) {
            this.queryStructureSplitPane.setLeftComponent(this.queryStructureScrollPane);
            this.queryStructureSplitPane.setDividerSize(5);
            if (this.treeFont != null) {
                // empty if block
            }
            this.queryStructureTree.setFont(this.treeFont);
            this.updateQueryStructureTree();
        } else {
            this.queryStructureSplitPane.setLeftComponent(null);
            this.queryStructureSplitPane.setDividerSize(0);
            this.queryStructureSplitPane.setDividerLocation(1.0);
        }
        if (this.metadataTreeOptions.isTreeVisible()) {
            this.metadataSplitPane.setRightComponent(this.metadataScrollPane);
            this.metadataSplitPane.setDividerSize(5);
            if (this.treeFont != null) {
                // empty if block
            }
            this.metadataTree.setFont(this.treeFont);
            this.metadataTree.setEditable(this.metadataTreeOptions.isEnableEditing());
            this.metadataTree.reloadNodes(false);
        } else {
            this.metadataSplitPane.setRightComponent(null);
            this.metadataSplitPane.setDividerSize(0);
            this.metadataSplitPane.setDividerLocation(0.0);
        }
        if (this.isControlsCreated() && this.query.isControlsCreated()) {
            this.query.doUpdateContolParams();
        }
    }

    public void updateQueryStructureTree() {
        this.queryStructureTree.updateTree();
    }

    public void repaintDiagramPane() {
        if (this.activeSubquery != null && this.activeSubquery.getActiveUnionSubquery() != null && this.activeSubquery.getActiveUnionSubquery().isControlsCreated()) {
            this.activeSubquery.getActiveUnionSubquery().getUnionPage().getDiagramPane().repaint();
        }
    }

    boolean isResultQueryASTGenerated() {
        return this.resultQueryAST != null;
    }

    void generateResultQueryAST() throws QueryBuilderException {
        ArrayList lCTE = new ArrayList();
        ArrayList lFromObj = new ArrayList();
        this.resultQueryAST = (SQLSelectStatement)this.query.getResultAST();
        this.resultQueryAST.restoreColumnPrefixRecursive(true);
        this.resultQueryAST.prepareAndFixupRecursive(lCTE, lFromObj, true);
        if (this.parameters == null) {
            this.parameters = new ParameterList(this);
        }
        this.parameters.reloadParameterListFromAST(this.resultQueryAST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTreePosition(ControlOwner ownerObject) {
        block6: {
            if (this.queryStructureTreeOptions.isTreeVisible()) {
                this.queryStructureTree.beginUpdate();
                try {
                    CustomTreeNode n = this.queryStructureTree.findTreePosition(ownerObject, ((CustomTreeNode)this.queryStructureTree.getModel().getRoot()).children());
                    if (n == null) break block6;
                    TreePath nodePath = new TreePath(n.getPath());
                    if (this.queryStructureTree.isVisible(nodePath)) {
                        this.queryStructureTree.setSelectionPath(nodePath);
                        break block6;
                    }
                    for (CustomTreeNode parent = (CustomTreeNode)n.getParent(); parent != null; parent = (CustomTreeNode)parent.getParent()) {
                        TreePath parentPath = new TreePath(parent.getPath());
                        if (!this.queryStructureTree.isVisible(parentPath)) continue;
                        this.queryStructureTree.setSelectionPath(parentPath);
                        break;
                    }
                }
                finally {
                    this.queryStructureTree.endUpdate();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SQLSelectStatement parseSQL(String sql) throws QueryBuilderException {
        AstNodeBase result = null;
        ArrayList lCTE = new ArrayList();
        ArrayList lFromObj = new ArrayList();
        if (this.getSyntaxProvider() == null) throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        try {
            if (!Str.IsNullOrEmpty(sql) && !sql.trim().isEmpty() && (result = this.sqlContext.parseSelect(sql)) != null && ((SQLSelectStatement)result).orderBy != null && ((SQLSubQueryExpressions)result).getCount() == 1 && ((SQLSubQueryExpressions)result).get(0) instanceof SQLSubQuerySelectExpression && ((SQLSubQuerySelectExpression)((SQLSubQueryExpressions)result).get((int)0)).orderBy == null) {
                ((SQLSubQuerySelectExpression)((SQLSubQueryExpressions)result).get((int)0)).orderBy = ((SQLSelectStatement)result).orderBy;
                ((SQLSelectStatement)result).orderBy = null;
            }
            if (result == null) {
                SQLSubQuerySelectExpression usq = new SQLSubQuerySelectExpression(this.sqlContext);
                usq.selectItems = new SQLSelectItems(this.sqlContext);
                usq.selectItems.add(new SQLSelectItemAllColumns(this.sqlContext));
                if (this.sqlContext.getSyntaxProvider().isFromClauseMandatory()) {
                    usq.from = new SQLFromClause(this.sqlContext);
                }
                result = new SQLSelectStatement(this.sqlContext);
                ((SQLSubQueryExpressions)result).add(usq);
            }
            result.prepareAndFixupRecursive(lCTE, lFromObj);
            if (!this.getParsingErrorOnUnknownObjects()) return result;
            ArrayList lASTObjects = new ArrayList();
            result.getMyChildrenRecursive(new Wrapper<List>(lASTObjects));
            for (int i = 0; i < lASTObjects.size(); ++i) {
                if (!(lASTObjects.get(i) instanceof SQLFromObject) || ((SQLFromObject)lASTObjects.get((int)i)).fromObj == null || ((SQLFromObject)lASTObjects.get(i)).getMetadataObject() != null || ((SQLFromObject)lASTObjects.get(i)).getCTEObject() != null) continue;
                String tmpObjectName = ((SQLFromObject)lASTObjects.get((int)i)).fromObj.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
                throw new ParsingException(Helpers.localizer.getString("strBadSelectStatement", "Invalid SELECT statement."), tmpObjectName);
            }
            return result;
        }
        catch (ParsingException e) {
            result = null;
            if (this.sqlErrorEventListenerList.size() <= 0) throw new QueryBuilderException("Failed to parse SQL query.\n" + e.getMessage(), e);
            this.fireSqlErrorEvent(new SqlErrorEvent(this, sql, e.getMessage(), e.errorTokenValue, e.errorPos));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSqlInternal() throws QueryBuilderException {
        if (this.tmpSQL != null) {
            this.beginUpdate();
            try {
                this.clearInternal();
                this.query.loadFromAST(this.tmpSQL);
                this.tmpSQL = null;
                if (this.getParent() != null) {
                    this.query.requestAlignUnionNavbar();
                }
            }
            finally {
                this.endUpdate();
            }
        }
        this.updateVisibleSubQueries();
    }

    protected void clearInternal() {
        this.query.clear();
        this.resetUniqueQueryNameCounter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.beginUpdate();
        try {
            this.clearInternal();
            try {
                this.query.add();
            }
            catch (Exception ex) {
                QueryBuilder.log(ex);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    void sqlUpdated() {
        QueryAwakeEvent e = new QueryAwakeEvent(this);
        if (this.isSleepMode() && !this.sleepModeSettingText) {
            this.fireQueryAwakeEvent(e);
        }
        if (!e.abort) {
            if (!this.sleepModeSettingText) {
                this.setSleepMode(false);
            }
            this.setResultQueryASTInvalid();
            if (!this.isDisposing()) {
                if (this.queryStructureTree != null) {
                    this.updateQueryStructureTree();
                }
                this.fireSQLUpdatedEvent(new SQLUpdatedEvent(this));
            }
        } else if (this.sleepMode && this.isDisplayable()) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        QueryBuilder.this.silentClearSQL();
                    }
                });
            }
            catch (QueryBuilderException ex) {
                QueryBuilder.log(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void silentClearSQL() {
        this.sleepModeSettingText = true;
        try {
            this.beginUpdate();
            try {
                this.clear();
            }
            finally {
                this.endUpdate();
            }
        }
        finally {
            this.sleepModeSettingText = false;
        }
    }

    private void setResultQueryASTInvalid() {
        if (this.resultQueryAST != null) {
            this.resultQueryAST.dispose();
        }
        if (this.statistics != null) {
            this.statistics.setStatisticsInvalid();
        }
        if (this.parameters != null) {
            this.parameters.setParametersInvalid();
        }
        this.resultQueryAST = null;
    }

    protected void readSyntaxProviderCaps() {
        if (!this.isDisposing()) {
            this.clear();
        }
    }

    IdentQuotation getQuoteAllIdentifiersInternal() {
        if (this.quoteAllIdentifiers) {
            return IdentQuotation.All;
        }
        return IdentQuotation.IfNeed;
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    void popupMenuPopup(JPopupMenu popupMenu, JComponent component, ControlOwner owner, Point where) {
        this.fireValidatePopupMenuEvent(new ValidatePopupMenuEvent(component, owner, popupMenu));
        if (popupMenu != null && popupMenu.getComponentCount() > 0) {
            popupMenu.show(component, where.x, where.y);
        }
    }

    private AddObjectDialog createAddObjectDialog() {
        AddObjectDialog result = new AddObjectDialog(SwingUtilities.getWindowAncestor(this), this, this.metadataContainer);
        this.addObjectDialogOptions.addUpdatedEventListener(result);
        return result;
    }

    public void showAddObjectDialog() {
        if (this.addObjectDialog == null) {
            this.addObjectDialog = this.createAddObjectDialog();
        }
        this.addObjectDialog.showDialog();
        this.sqlUpdated();
    }

    @Override
    public void updatedEventOccurred(UpdatedEvent event) {
        if (this.statistics != null) {
            this.statistics.setStatisticsInvalid();
        }
    }

    public static void showAboutDialog(Window parent) {
        AboutDialog about = new AboutDialog(parent);
        about.setVisible(true);
    }

    public LinkOptions getLinkOptions() {
        return this.linkOptions;
    }

    public void setLinkOptions(LinkOptions linkOptions) {
        if (this.linkOptions != linkOptions) {
            this.linkOptions = linkOptions;
        }
    }

    public void addSQLUpdatedEventListener(SQLUpdatedEventListener listener) {
        this.updatedEventListenerList.add(listener);
    }

    public void removeSQLUpdatedEventListener(SQLUpdatedEventListener listener) {
        this.updatedEventListenerList.remove(listener);
    }

    protected void fireSQLUpdatedEvent(SQLUpdatedEvent evt) {
        Iterator<SQLUpdatedEventListener> listeners = this.updatedEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().sqlUpdatedEventOccurred(evt);
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.queryStructureSplitPane.setDividerLocation(this.queryStructureTreeOptions.getTreeWidth() + this.queryStructureSplitPane.getInsets().left);
        this.metadataSplitPane.setDividerLocation(this.metadataSplitPane.getWidth() - this.metadataSplitPane.getInsets().right - this.metadataSplitPane.getDividerSize() - this.metadataTreeOptions.getTreeWidth());
        this.metadataSplitPane.validate();
        this.queryStructureSplitPane.validate();
    }

    public SkipKeywordMode getOuterKeywordInLinks() {
        return this.sqlContext.getSQLBuilderExpression().getOuterKeywordInLinks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOuterKeywordInLinks(SkipKeywordMode value) {
        this.sqlContext.beginUpdate();
        try {
            this.sqlContext.getSQLBuilderExpression().setOuterKeywordInLinks(value);
            this.sqlContext.getSQLBuilderExpressionQuoted().setOuterKeywordInLinks(value);
            this.sqlContext.getSQLBuilderExpressionNonQuoted().setOuterKeywordInLinks(value);
            this.sqlContext.getSQLBuilderMetadata().setOuterKeywordInLinks(value);
            this.sqlContext.getSQLBuilderExpressionForServer().setOuterKeywordInLinks(value);
            this.sqlContext.getSQLBuilderExpressionForServerWithoutQuotes().setOuterKeywordInLinks(value);
        }
        finally {
            this.sqlContext.endUpdate();
        }
    }

    public SkipKeywordMode getInnerKeywordInLinks() {
        return this.sqlContext.getSQLBuilderExpression().getInnerKeywordInLinks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInnerKeywordInLinks(SkipKeywordMode value) {
        this.sqlContext.beginUpdate();
        try {
            this.sqlContext.getSQLBuilderExpression().setInnerKeywordInLinks(value);
            this.sqlContext.getSQLBuilderExpressionQuoted().setInnerKeywordInLinks(value);
            this.sqlContext.getSQLBuilderExpressionNonQuoted().setInnerKeywordInLinks(value);
            this.sqlContext.getSQLBuilderMetadata().setInnerKeywordInLinks(value);
            this.sqlContext.getSQLBuilderExpressionForServer().setInnerKeywordInLinks(value);
            this.sqlContext.getSQLBuilderExpressionForServerWithoutQuotes().setInnerKeywordInLinks(value);
        }
        finally {
            this.sqlContext.endUpdate();
        }
    }

    public SkipKeywordMode getAsKeywordInExpressionAlias() {
        return this.sqlContext.getSQLBuilderExpression().getAsKeywordInExpressionAlias();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsKeywordInExpressionAlias(SkipKeywordMode value) {
        this.sqlContext.beginUpdate();
        try {
            this.sqlContext.getSQLBuilderExpression().setAsKeywordInExpressionAlias(value);
            this.sqlContext.getSQLBuilderExpressionQuoted().setAsKeywordInExpressionAlias(value);
            this.sqlContext.getSQLBuilderExpressionNonQuoted().setAsKeywordInExpressionAlias(value);
            this.sqlContext.getSQLBuilderMetadata().setAsKeywordInExpressionAlias(value);
            this.sqlContext.getSQLBuilderExpressionForServer().setAsKeywordInExpressionAlias(value);
            this.sqlContext.getSQLBuilderExpressionForServerWithoutQuotes().setAsKeywordInExpressionAlias(value);
        }
        finally {
            this.sqlContext.endUpdate();
        }
    }

    public SkipKeywordMode getAsKeywordInObjectAlias() {
        return this.sqlContext.getSQLBuilderExpression().getAsKeywordInObjectAlias();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsKeywordInObjectAlias(SkipKeywordMode value) {
        this.sqlContext.beginUpdate();
        try {
            this.sqlContext.getSQLBuilderExpression().setAsKeywordInObjectAlias(value);
            this.sqlContext.getSQLBuilderExpressionQuoted().setAsKeywordInObjectAlias(value);
            this.sqlContext.getSQLBuilderExpressionNonQuoted().setAsKeywordInObjectAlias(value);
            this.sqlContext.getSQLBuilderMetadata().setAsKeywordInObjectAlias(value);
            this.sqlContext.getSQLBuilderExpressionForServer().setAsKeywordInObjectAlias(value);
            this.sqlContext.getSQLBuilderExpressionForServerWithoutQuotes().setAsKeywordInObjectAlias(value);
        }
        finally {
            this.sqlContext.endUpdate();
        }
    }

    public boolean isLoadJoinsFromWhereClause() {
        return this.loadJoinsFromWhereClause;
    }

    public void setLoadJoinsFromWhereClause(boolean value) {
        this.loadJoinsFromWhereClause = value;
    }

    public void setTabsVisible(boolean value) {
        this.tabs.setTabsVisible(value);
    }

    public boolean isTabsVisible() {
        return this.tabs.isTabsVisible();
    }

    public DropTarget getCustomDiagramPaneDropTarget() {
        return this.customDiagramPaneDropTarget;
    }

    public void setCustomDiagramPaneDropTarget(DropTarget dropTraget) {
        this.customDiagramPaneDropTarget = dropTraget;
        this.doUpdateControlParams();
    }

    public DropTarget getCustomCriteriaListDropTarget() {
        return this.customCriteriaListDropTarget;
    }

    public void setCustomCriteriaListDropTarget(DropTarget dropTraget) {
        this.customCriteriaListDropTarget = dropTraget;
        this.doUpdateControlParams();
    }

    public static void main(String[] args) {
    }

    protected static void log(Throwable thrown) {
        QueryBuilder.log(thrown, Level.SEVERE);
    }

    protected static void log(Throwable thrown, Level level) {
        String msg = thrown.getMessage() + " - " + thrown.getStackTrace()[0].toString();
        LOGGER.log(level, msg, thrown);
    }

    private void resetUniqueQueryNameCounter() {
        this.uniqueQueryNameCounter = 1;
    }

    private int getUniqueQueryNameCounter() {
        int result = this.uniqueQueryNameCounter++;
        return result;
    }

    private String getUniqueQueryNameCounterStr() {
        return String.valueOf(this.getUniqueQueryNameCounter());
    }

    private boolean isUniqueQueryNameInUnionGroup(UnionGroup unionGroup, AstTokenIdentifier name) {
        for (int i = 0; i < unionGroup.getCount(); ++i) {
            QueryBase item = unionGroup.get(i);
            if (!(item instanceof UnionGroup ? !this.isUniqueQueryNameInUnionGroup((UnionGroup)item, name) : item instanceof UnionSubQuery && !this.isUniqueQueryNameInUnionSubQuery((UnionSubQuery)item, name))) continue;
            return false;
        }
        return true;
    }

    private boolean isUniqueQueryNameInUnionSubQuery(UnionSubQuery unionSubQuery, AstTokenIdentifier name) {
        return unionSubQuery.isUniqueAlias(name);
    }

    public boolean isUniqueQueryName(AstTokenIdentifier name) {
        for (int i = 0; i < this.subQueries.getCount(); ++i) {
            SubQuery subQuery = this.subQueries.get(i);
            if (this.isUniqueQueryNameInUnionGroup(subQuery, name)) continue;
            return false;
        }
        return true;
    }

    public AstTokenIdentifier createUniqueQueryName() {
        AstTokenIdentifier result = new AstTokenIdentifier(this.sqlContext);
        result.setToken("Query" + this.getUniqueQueryNameCounterStr());
        while (!this.isUniqueQueryName(result)) {
            result.setToken("Query" + this.getUniqueQueryNameCounterStr());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createUniqueQueryNameStr() {
        AstTokenIdentifier unique = this.createUniqueQueryName();
        try {
            String string = unique.getToken();
            return string;
        }
        finally {
            unique.dispose();
        }
    }

    public List<SubQuery> getSubQueryList() {
        return this.subQueries.getList();
    }

    public List<UnionSubQuery> getUnionSubQueryList() {
        ArrayList<UnionSubQuery> result = new ArrayList<UnionSubQuery>(this.subQueries.getCount());
        for (int i = 0; i < this.subQueries.getCount(); ++i) {
            this.subQueries.get(i).gatherUnionSubQueries(result);
        }
        return result;
    }

    public QueryPart getFilterTabsByActiveQueryPart() {
        return this.filterTabsByActiveQueryPart;
    }

    public void setFilterTabsByActiveQueryPart(QueryPart value) {
        if (this.filterTabsByActiveQueryPart != value) {
            this.filterTabsByActiveQueryPart = value;
            this.updateVisibleSubQueries();
        }
    }

    void registerSubQuery(SubQuery subQuery) {
        this.subQueries.registerSubQuery(subQuery);
    }

    void unregisterSubQuery(SubQuery subQuery) {
        this.subQueries.unregisterSubQuery(subQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateVisibleSubQueries() {
        if (!this.isControlsCreated()) {
            return;
        }
        if (this.getFilterTabsByActiveQueryPart() == QueryPart.Query) {
            for (int i = 0; i < this.subQueries.getCount(); ++i) {
                SubQuery subQuery = this.subQueries.get(i);
                if (!subQuery.canCreateControls() || subQuery.isControlsCreated()) continue;
                subQuery.createControls();
                this.tabs.setComponentZOrder(subQuery.getQueryPage(), i);
            }
        } else {
            List<SubQuery> parentSubQueries = this.getParentSubQueries(this.activeSubquery.getActiveUnionSubquery());
            ArrayList<SubQuery> childSubQueries = new ArrayList<SubQuery>();
            ArrayList<SubQuery> subQueriesToHide = new ArrayList<SubQuery>();
            try {
                int i;
                SubQuery subQuery2;
                switch (this.getFilterTabsByActiveQueryPart()) {
                    case SubQuery: {
                        this.collectChildSubQueries(childSubQueries, this.activeSubquery);
                        break;
                    }
                    case UnionSubQuery: {
                        this.collectChildSubQueries(childSubQueries, this.activeSubquery.getActiveUnionSubquery());
                    }
                }
                for (SubQuery subQuery2 : this.subQueries) {
                    if (subQuery2 == this.activeSubquery || parentSubQueries.indexOf(subQuery2) != -1 || childSubQueries.indexOf(subQuery2) != -1) continue;
                    subQueriesToHide.add(subQuery2);
                }
                for (i = 0; i < parentSubQueries.size(); ++i) {
                    subQuery2 = parentSubQueries.get(i);
                    if (subQuery2.canCreateControls() && !subQuery2.isControlsCreated()) {
                        subQuery2.createControls();
                    }
                    if (!subQuery2.isControlsCreated()) continue;
                    this.tabs.setPageIndex(subQuery2.getQueryPage(), i);
                    if (i != parentSubQueries.size() - 1) continue;
                    this.tabs.setSelectedIndex(i);
                }
                for (i = 0; i < childSubQueries.size(); ++i) {
                    subQuery2 = (SubQuery)childSubQueries.get(i);
                    if (subQuery2.canCreateControls() && !subQuery2.isControlsCreated()) {
                        subQuery2.createControls();
                    }
                    if (!subQuery2.isControlsCreated()) continue;
                    this.tabs.setPageIndex(subQuery2.getQueryPage(), parentSubQueries.size() + i);
                }
                for (SubQuery subQuery2 : subQueriesToHide) {
                    if (!subQuery2.isControlsCreated()) continue;
                    subQuery2.destroyControls();
                }
            }
            finally {
                parentSubQueries.clear();
                childSubQueries.clear();
                subQueriesToHide.clear();
            }
        }
    }

    List<SubQuery> getParentSubQueries(UnionSubQuery unionSubQuery) {
        ArrayList<SubQuery> result = new ArrayList<SubQuery>();
        for (SubQuery subQuery = unionSubQuery.getRootQuery(); subQuery != null; subQuery = subQuery.getOwnerSubQuery()) {
            result.add(0, subQuery);
        }
        return result;
    }

    void collectChildSubQueries(List<SubQuery> list, ControlOwner root) {
        SubQuery cte;
        for (ControlOwner child : root.children) {
            if (child instanceof SubQuery && list.indexOf((SubQuery)child) == -1) {
                list.add((SubQuery)child);
            }
            this.collectChildSubQueries(list, child);
        }
        if (root instanceof DataSourceObject && (cte = ((DataSourceObject)root).getSubQueryCTE()) != null && list.indexOf(cte) == -1) {
            list.add(cte);
        }
    }

    protected void reloadStatistics() {
        this.resultQueryAST.prepareCalcStatisticsRecursive();
        while (this.resultQueryAST.calcStatisticsRecursive() != 0) {
        }
        if (this.statistics == null) {
            this.statistics = new QueryStatistics(this, this.sqlContext);
        }
        this.statistics.reloadStatistics(this.resultQueryAST);
    }
}

