/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataBase;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataProcedure;
import com.adbs.ast.MetadataRelation;
import com.adbs.ast.MetadataSynonym;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.MetadataView;
import com.adbs.querybuilder.CustomTreeCellRenderer;
import com.adbs.querybuilder.CustomTreeNode;
import com.adbs.querybuilder.MetadataContainerLoadDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.Document;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class MetadataContainerEditorDialog
extends JDialog
implements DocumentListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    boolean dialogResult = false;
    private MetadataContainer editedMetadataContainer;
    private BaseSQLContext temporarySQLContext;
    private MetadataContainer temporaryMetadataContainer;
    private MetadataObject metadataObject;
    private MetadataField metadataField;
    private MetadataFilter metadataFilter;
    private boolean loading;
    private boolean forceSaveResults;
    private CustomTreeNode root = null;
    private DefaultTreeModel model = null;
    private Icon folderIcon = Helpers.createImageIcon("images/folder.png");
    private Icon itemIcon = Helpers.createImageIcon("images/item.png");
    private Icon databaseIcon = Helpers.createImageIcon("images/database.png");
    private Icon schemaIcon = Helpers.createImageIcon("images/schema.png");
    private Icon tableIcon = Helpers.createImageIcon("images/table.png");
    private Icon viewIcon = Helpers.createImageIcon("images/view.png");
    private Icon procedureIcon = Helpers.createImageIcon("images/procedure.png");
    private Icon synonymIcon = Helpers.createImageIcon("images/synonym.png");
    private Icon fieldsIcon = Helpers.createImageIcon("images/fields.png");
    private JButton bCancel;
    private JButton bDelete;
    private JButton bLoad;
    private JButton bLoadFromXML;
    private JButton bOK;
    private JButton bSaveToXML;
    private JToggleButton bShowProcedures;
    private JToggleButton bShowSynonyms;
    private JToggleButton bShowSystemObjects;
    private JToggleButton bShowTables;
    private JToggleButton bShowUserObjects;
    private JToggleButton bShowViews;
    private JCheckBox cbSystemObject;
    private JCheckBox cbVisibleObject;
    private JTextField eFieldAltName;
    private JTextField eFieldDescription;
    private JTextArea eFieldLongDescription;
    private JTextField eFieldName;
    private JTextField eFieldType;
    private JTextField eObjectAltName;
    private JTextField eObjectDatabase;
    private JTextField eObjectDescription;
    private JTextArea eObjectLongDescription;
    private JTextField eObjectName;
    private JTextField eObjectSchema;
    private JTextField eObjectType;
    private JPanel gObjectName;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSplitPane jSplitPane1;
    private JLabel lDescription;
    private JLabel lLongDescription;
    private JLabel lObjectDatabase;
    private JLabel lObjectName;
    private JLabel lObjectSchema;
    private JLabel lObjectType;
    private JLabel lblFieldAltName;
    private JLabel lblFieldDescription;
    private JLabel lblFieldLongDescription;
    private JLabel lblFieldName;
    private JLabel lblFieldType;
    private JLabel lblObjectAltName;
    private JTree metadataTree;
    private JPanel pnlBottom;
    private JPanel pnlFieldProperties;
    private JPanel pnlNoProperties;
    private JPanel pnlObjectProperties;
    private JPanel pnlProperties;
    private JPanel pnlTop;

    public MetadataContainerEditorDialog(Window parent, MetadataContainer metadataContainer, boolean forceSaveResults) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.metadataFilter = new MetadataFilter();
        this.editedMetadataContainer = metadataContainer;
        this.forceSaveResults = forceSaveResults;
        this.temporarySQLContext = new BaseSQLContext(null);
        this.temporarySQLContext.assign(this.editedMetadataContainer.getSQLContext());
        this.temporaryMetadataContainer = new MetadataContainer(null, this.temporarySQLContext);
        this.temporarySQLContext.setMetadataContainer(this.temporaryMetadataContainer);
        this.temporaryMetadataContainer.assign(metadataContainer);
        Helpers.localizer.localizeDialog(this);
        this.root = new CustomTreeNode(Helpers.localizer.getString("strMetadataContainer", "Metadata Container"));
        this.model = new DefaultTreeModel(this.root);
        this.root.removeAllChildren();
        this.metadataTree.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 1));
        this.metadataTree.setCellRenderer(new CustomTreeCellRenderer());
        this.metadataTree.setModel(this.model);
        this.metadataTree.expandPath(new TreePath(this.root.getPath()));
        this.loadMetadataTree();
        this.updateButtonsState();
        this.updatePropertiesPanel();
        if (forceSaveResults) {
            this.bCancel.setVisible(false);
            this.bOK.setLocation(this.bCancel.getX(), this.bOK.getY());
        }
        this.setLocationRelativeTo(parent);
        this.getRootPane().setDefaultButton(this.bOK);
        AbstractAction escape = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetadataContainerEditorDialog.this.setVisible(false);
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE");
        this.rootPane.getActionMap().put("ESCAPE", escape);
        this.metadataTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MetadataContainerEditorDialog.this.updatePropertiesPanel();
                MetadataContainerEditorDialog.this.updateButtonsState();
            }
        });
        this.bShowUserObjects.addActionListener(this);
        this.bShowSystemObjects.addActionListener(this);
        this.bShowTables.addActionListener(this);
        this.bShowViews.addActionListener(this);
        this.bShowProcedures.addActionListener(this);
        this.bShowSynonyms.addActionListener(this);
        this.cbVisibleObject.addActionListener(this);
        this.cbSystemObject.addActionListener(this);
        this.metadataTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!(e.getKeyCode() != 127 || e.isAltDown() || e.isControlDown() || e.isShiftDown())) {
                    MetadataContainerEditorDialog.this.deleteSelectedMetadataItem();
                }
                super.keyPressed(e);
            }
        });
        this.eObjectAltName.getDocument().addDocumentListener(this);
        this.eObjectDescription.getDocument().addDocumentListener(this);
        this.eObjectLongDescription.getDocument().addDocumentListener(this);
        this.eFieldAltName.getDocument().addDocumentListener(this);
        this.eFieldLongDescription.getDocument().addDocumentListener(this);
        this.eFieldDescription.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.pnlTop = new JPanel();
        this.jLabel1 = new JLabel();
        this.bShowUserObjects = new JToggleButton();
        this.bShowSystemObjects = new JToggleButton();
        this.bShowTables = new JToggleButton();
        this.bShowViews = new JToggleButton();
        this.bShowProcedures = new JToggleButton();
        this.bShowSynonyms = new JToggleButton();
        this.bLoad = new JButton();
        this.bDelete = new JButton();
        this.pnlBottom = new JPanel();
        this.bCancel = new JButton();
        this.bOK = new JButton();
        this.bLoadFromXML = new JButton();
        this.bSaveToXML = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.metadataTree = new JTree();
        this.pnlProperties = new JPanel();
        this.pnlNoProperties = new JPanel();
        this.jLabel4 = new JLabel();
        this.pnlObjectProperties = new JPanel();
        this.eObjectType = new JTextField();
        this.lObjectType = new JLabel();
        this.gObjectName = new JPanel();
        this.eObjectDatabase = new JTextField();
        this.lObjectDatabase = new JLabel();
        this.eObjectSchema = new JTextField();
        this.lObjectSchema = new JLabel();
        this.eObjectName = new JTextField();
        this.lObjectName = new JLabel();
        this.cbSystemObject = new JCheckBox();
        this.cbVisibleObject = new JCheckBox();
        this.lblObjectAltName = new JLabel();
        this.eObjectAltName = new JTextField();
        this.eObjectDescription = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.eObjectLongDescription = new JTextArea();
        this.lDescription = new JLabel();
        this.lLongDescription = new JLabel();
        this.pnlFieldProperties = new JPanel();
        this.lblFieldName = new JLabel();
        this.eFieldName = new JTextField();
        this.lblFieldType = new JLabel();
        this.eFieldType = new JTextField();
        this.lblFieldAltName = new JLabel();
        this.eFieldAltName = new JTextField();
        this.lblFieldDescription = new JLabel();
        this.eFieldDescription = new JTextField();
        this.lblFieldLongDescription = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.eFieldLongDescription = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setTitle("Metadata Container Editor");
        this.setFont(new Font("Dialog", 0, 11));
        this.setIconImage(null);
        this.setModal(true);
        this.setName("MetadataContainerEditorDialog");
        this.jLabel1.setFont(this.getFont());
        this.jLabel1.setText("Filter:");
        this.jLabel1.setName("label1");
        this.bShowUserObjects.setFont(this.getFont());
        this.bShowUserObjects.setSelected(true);
        this.bShowUserObjects.setText("U");
        this.bShowUserObjects.setToolTipText("Show user objects");
        this.bShowUserObjects.setMargin(new Insets(2, 5, 2, 5));
        this.bShowSystemObjects.setFont(this.getFont());
        this.bShowSystemObjects.setSelected(true);
        this.bShowSystemObjects.setText("S");
        this.bShowSystemObjects.setToolTipText("Show system objects");
        this.bShowSystemObjects.setMargin(new Insets(2, 5, 2, 5));
        this.bShowTables.setFont(this.getFont());
        this.bShowTables.setSelected(true);
        this.bShowTables.setText("T");
        this.bShowTables.setToolTipText("Show tables");
        this.bShowTables.setMargin(new Insets(2, 5, 2, 5));
        this.bShowViews.setFont(this.getFont());
        this.bShowViews.setSelected(true);
        this.bShowViews.setText("V");
        this.bShowViews.setToolTipText("Show views");
        this.bShowViews.setMargin(new Insets(2, 5, 2, 5));
        this.bShowProcedures.setFont(this.getFont());
        this.bShowProcedures.setSelected(true);
        this.bShowProcedures.setText("P");
        this.bShowProcedures.setToolTipText("Show procedures");
        this.bShowProcedures.setMargin(new Insets(2, 5, 2, 5));
        this.bShowSynonyms.setFont(this.getFont());
        this.bShowSynonyms.setSelected(true);
        this.bShowSynonyms.setText("S");
        this.bShowSynonyms.setToolTipText("Show synonyms");
        this.bShowSynonyms.setMargin(new Insets(2, 5, 2, 5));
        this.bLoad.setFont(this.getFont());
        this.bLoad.setIcon(new ImageIcon(this.getClass().getResource("/com/adbs/querybuilder/images/plus.png")));
        this.bLoad.setText("Load");
        this.bLoad.setEnabled(false);
        this.bLoad.setMargin(new Insets(2, 10, 2, 10));
        this.bLoad.setName("bLoad");
        this.bLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetadataContainerEditorDialog.this.bLoadActionPerformed(evt);
            }
        });
        this.bDelete.setFont(this.getFont());
        this.bDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/adbs/querybuilder/images/minus.png")));
        this.bDelete.setMargin(new Insets(2, 2, 2, 2));
        this.bDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetadataContainerEditorDialog.this.bDeleteActionPerformed(evt);
            }
        });
        GroupLayout pnlTopLayout = new GroupLayout(this.pnlTop);
        this.pnlTop.setLayout(pnlTopLayout);
        pnlTopLayout.setHorizontalGroup(pnlTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTopLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bShowUserObjects).addGap(1, 1, 1).addComponent(this.bShowSystemObjects).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bShowTables).addGap(0, 0, 0).addComponent(this.bShowViews).addGap(0, 0, 0).addComponent(this.bShowProcedures).addGap(0, 0, 0).addComponent(this.bShowSynonyms).addGap(30, 30, 30).addComponent(this.bLoad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDelete).addContainerGap(270, Short.MAX_VALUE)));
        pnlTopLayout.setVerticalGroup(pnlTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTopLayout.createSequentialGroup().addContainerGap().addGroup(pnlTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bDelete).addGroup(pnlTopLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.bShowUserObjects).addComponent(this.bShowSystemObjects).addComponent(this.bShowTables).addComponent(this.bShowViews).addComponent(this.bShowProcedures).addComponent(this.bShowSynonyms).addComponent(this.bLoad))).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.pnlTop, "First");
        this.bCancel.setFont(this.getFont());
        this.bCancel.setText("Cancel");
        this.bCancel.setName("bCancel");
        this.bCancel.setPreferredSize(new Dimension(75, 23));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetadataContainerEditorDialog.this.bCancelActionPerformed(evt);
            }
        });
        this.bOK.setFont(this.getFont());
        this.bOK.setText("OK");
        this.bOK.setName("bOk");
        this.bOK.setPreferredSize(new Dimension(75, 23));
        this.bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetadataContainerEditorDialog.this.bOKActionPerformed(evt);
            }
        });
        this.bLoadFromXML.setFont(this.getFont());
        this.bLoadFromXML.setText("Load Metadata from XML file...");
        this.bLoadFromXML.setName("bLoadFromXML");
        this.bLoadFromXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetadataContainerEditorDialog.this.bLoadFromXMLActionPerformed(evt);
            }
        });
        this.bSaveToXML.setFont(this.getFont());
        this.bSaveToXML.setText("Save Metadata to XML file...");
        this.bSaveToXML.setName("bSaveToXML");
        this.bSaveToXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetadataContainerEditorDialog.this.bSaveToXMLActionPerformed(evt);
            }
        });
        GroupLayout pnlBottomLayout = new GroupLayout(this.pnlBottom);
        this.pnlBottom.setLayout(pnlBottomLayout);
        pnlBottomLayout.setHorizontalGroup(pnlBottomLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlBottomLayout.createSequentialGroup().addContainerGap().addComponent(this.bLoadFromXML).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bSaveToXML).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 66, Short.MAX_VALUE).addComponent(this.bOK, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bCancel, -2, 90, -2).addContainerGap()));
        pnlBottomLayout.setVerticalGroup(pnlBottomLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlBottomLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(pnlBottomLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bCancel, -2, -1, -2).addComponent(this.bOK, -2, -1, -2).addComponent(this.bLoadFromXML).addComponent(this.bSaveToXML)).addContainerGap()));
        this.getContentPane().add((Component)this.pnlBottom, "Last");
        this.jSplitPane1.setBorder(BorderFactory.createEmptyBorder(1, 12, 1, 12));
        this.jSplitPane1.setDividerLocation(310);
        this.jSplitPane1.setResizeWeight(0.5);
        this.metadataTree.setFont(this.getFont());
        this.jScrollPane1.setViewportView(this.metadataTree);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.pnlProperties.setLayout(new CardLayout());
        this.pnlNoProperties.setLayout(new BorderLayout());
        this.jLabel4.setFont(this.getFont());
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("No properties for this node");
        this.jLabel4.setHorizontalTextPosition(0);
        this.pnlNoProperties.add((Component)this.jLabel4, "Center");
        this.pnlProperties.add((Component)this.pnlNoProperties, "pnlNoProperties");
        this.pnlObjectProperties.setPreferredSize(new Dimension(300, 400));
        this.eObjectType.setEditable(false);
        this.eObjectType.setFont(this.getFont());
        this.lObjectType.setFont(this.getFont());
        this.lObjectType.setText("Object Type:");
        this.lObjectType.setName("lObjectType");
        this.lObjectType.setRequestFocusEnabled(false);
        this.gObjectName.setBorder(BorderFactory.createTitledBorder("Object Name"));
        this.gObjectName.setFont(this.getFont());
        this.gObjectName.setName("gObjectName");
        this.eObjectDatabase.setEditable(false);
        this.eObjectDatabase.setFont(this.getFont());
        this.lObjectDatabase.setFont(this.getFont());
        this.lObjectDatabase.setHorizontalAlignment(4);
        this.lObjectDatabase.setLabelFor(this.eObjectDatabase);
        this.lObjectDatabase.setText("Database:");
        this.lObjectDatabase.setName("lObjectDatabase");
        this.eObjectSchema.setEditable(false);
        this.eObjectSchema.setFont(this.getFont());
        this.lObjectSchema.setFont(this.getFont());
        this.lObjectSchema.setHorizontalAlignment(4);
        this.lObjectSchema.setText("Schema:");
        this.lObjectSchema.setName("lObjectSchema");
        this.eObjectName.setEditable(false);
        this.eObjectName.setFont(this.getFont());
        this.lObjectName.setFont(this.getFont());
        this.lObjectName.setHorizontalAlignment(4);
        this.lObjectName.setText("Name:");
        this.lObjectName.setName("lObjectName");
        GroupLayout gObjectNameLayout = new GroupLayout(this.gObjectName);
        this.gObjectName.setLayout(gObjectNameLayout);
        gObjectNameLayout.setHorizontalGroup(gObjectNameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gObjectNameLayout.createSequentialGroup().addContainerGap().addGroup(gObjectNameLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lObjectName, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.lObjectSchema, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.lObjectDatabase, GroupLayout.Alignment.TRAILING, -1, 103, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(gObjectNameLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.eObjectName, -1, 132, Short.MAX_VALUE).addComponent(this.eObjectSchema, -1, 132, Short.MAX_VALUE).addComponent(this.eObjectDatabase, GroupLayout.Alignment.LEADING, -1, 132, Short.MAX_VALUE)).addContainerGap()));
        gObjectNameLayout.setVerticalGroup(gObjectNameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gObjectNameLayout.createSequentialGroup().addGroup(gObjectNameLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.eObjectDatabase, -2, -1, -2).addComponent(this.lObjectDatabase)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gObjectNameLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.eObjectSchema, -2, -1, -2).addComponent(this.lObjectSchema)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gObjectNameLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.eObjectName, -2, -1, -2).addComponent(this.lObjectName)).addContainerGap(-1, Short.MAX_VALUE)));
        this.cbSystemObject.setFont(this.cbSystemObject.getFont());
        this.cbSystemObject.setText("System");
        this.cbSystemObject.setName("checkSystem");
        this.cbVisibleObject.setFont(this.cbVisibleObject.getFont());
        this.cbVisibleObject.setText("Visible");
        this.cbVisibleObject.setName("checkVisible");
        this.lblObjectAltName.setText("Alternative Name:");
        this.lblObjectAltName.setName("lAltName");
        this.eObjectAltName.setFont(this.getFont());
        this.eObjectDescription.setFont(this.getFont());
        this.eObjectLongDescription.setColumns(20);
        this.eObjectLongDescription.setFont(this.getFont());
        this.eObjectLongDescription.setLineWrap(true);
        this.eObjectLongDescription.setRows(5);
        this.eObjectLongDescription.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.eObjectLongDescription);
        this.lDescription.setText("Description:");
        this.lDescription.setName("lDescription");
        this.lLongDescription.setText("Long Description:");
        this.lLongDescription.setName("lLongDescription");
        GroupLayout pnlObjectPropertiesLayout = new GroupLayout(this.pnlObjectProperties);
        this.pnlObjectProperties.setLayout(pnlObjectPropertiesLayout);
        pnlObjectPropertiesLayout.setHorizontalGroup(pnlObjectPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlObjectPropertiesLayout.createSequentialGroup().addContainerGap().addGroup(pnlObjectPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gObjectName, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(pnlObjectPropertiesLayout.createSequentialGroup().addComponent(this.lObjectType, -2, 112, -2).addGap(18, 18, 18).addComponent(this.eObjectType, -1, 147, Short.MAX_VALUE)).addComponent(this.eObjectAltName, GroupLayout.Alignment.TRAILING, -1, 277, Short.MAX_VALUE).addComponent(this.lblObjectAltName, -1, 277, Short.MAX_VALUE).addComponent(this.eObjectDescription, -1, 277, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 277, Short.MAX_VALUE).addComponent(this.lLongDescription, -1, 277, Short.MAX_VALUE).addComponent(this.lDescription, -1, 277, Short.MAX_VALUE).addComponent(this.cbSystemObject, -1, 277, Short.MAX_VALUE).addComponent(this.cbVisibleObject, -1, 277, Short.MAX_VALUE)).addContainerGap()));
        pnlObjectPropertiesLayout.setVerticalGroup(pnlObjectPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlObjectPropertiesLayout.createSequentialGroup().addContainerGap().addGroup(pnlObjectPropertiesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lObjectType).addComponent(this.eObjectType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gObjectName, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSystemObject).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbVisibleObject).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblObjectAltName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.eObjectAltName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lDescription).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.eObjectDescription, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lLongDescription).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, -1, -2).addGap(123, 123, 123)));
        this.pnlProperties.add((Component)this.pnlObjectProperties, "pnlObjectProperties");
        this.lblFieldName.setFont(this.getFont());
        this.lblFieldName.setText("Field Name:");
        this.lblFieldName.setName("lFieldName");
        this.eFieldName.setEditable(false);
        this.eFieldName.setFont(this.getFont());
        this.lblFieldType.setFont(this.getFont());
        this.lblFieldType.setText("Field Type:");
        this.lblFieldType.setName("lFieldType");
        this.eFieldType.setEditable(false);
        this.eFieldType.setFont(this.getFont());
        this.lblFieldAltName.setFont(this.getFont());
        this.lblFieldAltName.setText("Alternative Name:");
        this.lblFieldAltName.setName("lFieldAltName");
        this.eFieldAltName.setFont(this.getFont());
        this.lblFieldDescription.setFont(this.getFont());
        this.lblFieldDescription.setText("Description:");
        this.lblFieldDescription.setName("lFieldDescription");
        this.eFieldDescription.setFont(this.getFont());
        this.lblFieldLongDescription.setFont(this.getFont());
        this.lblFieldLongDescription.setText("Long Description:");
        this.lblFieldLongDescription.setName("lFieldLongDescription");
        this.eFieldLongDescription.setColumns(20);
        this.eFieldLongDescription.setFont(this.getFont());
        this.eFieldLongDescription.setLineWrap(true);
        this.eFieldLongDescription.setRows(5);
        this.eFieldLongDescription.setWrapStyleWord(true);
        this.jScrollPane3.setViewportView(this.eFieldLongDescription);
        GroupLayout pnlFieldPropertiesLayout = new GroupLayout(this.pnlFieldProperties);
        this.pnlFieldProperties.setLayout(pnlFieldPropertiesLayout);
        pnlFieldPropertiesLayout.setHorizontalGroup(pnlFieldPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlFieldPropertiesLayout.createSequentialGroup().addContainerGap().addGroup(pnlFieldPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlFieldPropertiesLayout.createSequentialGroup().addComponent(this.lblFieldName, -1, 196, Short.MAX_VALUE).addGap(91, 91, 91)).addGroup(pnlFieldPropertiesLayout.createSequentialGroup().addComponent(this.lblFieldType, -1, 193, Short.MAX_VALUE).addGap(94, 94, 94)).addGroup(pnlFieldPropertiesLayout.createSequentialGroup().addComponent(this.lblFieldAltName, -1, 227, Short.MAX_VALUE).addGap(60, 60, 60)).addGroup(pnlFieldPropertiesLayout.createSequentialGroup().addComponent(this.lblFieldDescription, -1, 197, Short.MAX_VALUE).addGap(90, 90, 90)).addGroup(pnlFieldPropertiesLayout.createSequentialGroup().addComponent(this.lblFieldLongDescription, -1, 223, Short.MAX_VALUE).addGap(64, 64, 64)).addGroup(GroupLayout.Alignment.TRAILING, pnlFieldPropertiesLayout.createSequentialGroup().addGroup(pnlFieldPropertiesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane3, GroupLayout.Alignment.LEADING, -1, 277, Short.MAX_VALUE).addComponent(this.eFieldDescription, GroupLayout.Alignment.LEADING, -1, 277, Short.MAX_VALUE).addComponent(this.eFieldAltName, GroupLayout.Alignment.LEADING, -1, 277, Short.MAX_VALUE).addComponent(this.eFieldType, GroupLayout.Alignment.LEADING, -1, 277, Short.MAX_VALUE).addComponent(this.eFieldName, -1, 277, Short.MAX_VALUE)).addContainerGap()))));
        pnlFieldPropertiesLayout.setVerticalGroup(pnlFieldPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlFieldPropertiesLayout.createSequentialGroup().addContainerGap().addComponent(this.lblFieldName, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.eFieldName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblFieldType, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.eFieldType, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblFieldAltName, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.eFieldAltName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblFieldDescription, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.eFieldDescription, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblFieldLongDescription, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, 90, -2).addGap(206, 206, 206)));
        this.pnlProperties.add((Component)this.pnlFieldProperties, "pnlFieldProperties");
        this.jSplitPane1.setRightComponent(this.pnlProperties);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.pack();
    }

    private void bOKActionPerformed(ActionEvent evt) {
        this.editedMetadataContainer.assign(this.temporaryMetadataContainer);
        this.dialogResult = true;
        this.setVisible(false);
    }

    private void bLoadActionPerformed(ActionEvent evt) {
        MetadataContainerLoadDialog f = new MetadataContainerLoadDialog((Window)this, this.temporaryMetadataContainer, false);
        f.setMetadataFilter(this.metadataFilter);
        f.showDialog();
        this.loadMetadataTree();
        this.updateButtonsState();
    }

    private void bDeleteActionPerformed(ActionEvent evt) {
        this.deleteSelectedMetadataItem();
    }

    private void bSaveToXMLActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogType(1);
        fileChooser.setDialogTitle("Select XML file to save metadata to");
        fileChooser.setFileFilter(new FileNameExtensionFilter("XML files", "xml"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showSaveDialog(this) == 0) {
            String path = fileChooser.getSelectedFile().getPath();
            if (Helpers.getFileExtension(fileChooser.getSelectedFile().getName()) == null) {
                path = path + ".xml";
            }
            this.temporaryMetadataContainer.saveToXMLFile(path);
        }
    }

    private void bLoadFromXMLActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogType(0);
        fileChooser.setDialogTitle("Select XML file to load metadata from");
        fileChooser.setFileFilter(new FileNameExtensionFilter("XML files", "xml"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog(this) == 0) {
            try {
                this.temporaryMetadataContainer.loadFromXMLFile(fileChooser.getSelectedFile().getPath());
            }
            catch (QueryBuilderException ex) {
                JOptionPane.showMessageDialog(this, "Failed to load metadata from XML file.\r\n" + ex.getMessage());
            }
            this.loadMetadataTree();
        }
    }

    private void bCancelActionPerformed(ActionEvent evt) {
        this.dialogResult = false;
        this.setVisible(false);
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.dialogResult;
    }

    public MetadataContainer getEditedMetadataContainer() {
        return this.editedMetadataContainer;
    }

    public BaseSQLContext getTemporarySQLContext() {
        return this.temporarySQLContext;
    }

    public MetadataContainer getTemporaryMetadataContainer() {
        return this.temporaryMetadataContainer;
    }

    public MetadataObject getMetadataObject() {
        return this.metadataObject;
    }

    public void setMetadataObject(MetadataObject value) {
        this.metadataObject = value;
        this.loadObjectProps();
    }

    public MetadataField getMetadataField() {
        return this.metadataField;
    }

    public void setMetadataField(MetadataField value) {
        this.metadataField = value;
        this.loadFieldProps();
    }

    public MetadataFilter getMetadataFilter() {
        return this.metadataFilter;
    }

    public void setMetadataFilter(MetadataFilter metadataFilter) {
        if (this.metadataFilter != metadataFilter) {
            this.metadataFilter = metadataFilter;
        }
    }

    private CustomTreeNode findNamedNode(CustomTreeNode where, String name, Icon icon) {
        for (CustomTreeNode n = where != null && where.getChildCount() > 0 ? (CustomTreeNode)where.getFirstChild() : this.root; n != null; n = (CustomTreeNode)n.getNextNode()) {
            if (!n.toString().equals(name)) continue;
            return n;
        }
        CustomTreeNode result = new CustomTreeNode(name, null, icon);
        where.add(result);
        return result;
    }

    private void loadMetadataTree() {
        TreePath selectedPath = this.metadataTree.getSelectionPath();
        MetadataBase oldSelected = selectedPath != null ? (MetadataBase)((CustomTreeNode)selectedPath.getLastPathComponent()).tag : null;
        this.root.removeAllChildren();
        CustomTreeNode n = this.root;
        n.tag = this.temporaryMetadataContainer;
        n.icon = this.folderIcon;
        for (int i = 0; i < this.temporaryMetadataContainer.getCount(); ++i) {
            MetadataObject o = this.temporaryMetadataContainer.get(i);
            if ((o.isSystem() || !this.bShowUserObjects.isSelected()) && (!o.isSystem() || !this.bShowSystemObjects.isSelected())) continue;
            if (o instanceof MetadataTable && this.bShowTables.isSelected()) {
                this.loadObject(n, o, oldSelected);
                continue;
            }
            if (o instanceof MetadataView && this.bShowViews.isSelected()) {
                this.loadObject(n, o, oldSelected);
                continue;
            }
            if (o instanceof MetadataProcedure && this.bShowProcedures.isSelected()) {
                this.loadObject(n, o, oldSelected);
                continue;
            }
            if (!(o instanceof MetadataSynonym) || !this.bShowSynonyms.isSelected()) continue;
            this.loadObject(n, o, oldSelected);
        }
        this.model.reload();
        this.expandTree();
        if (oldSelected == null) {
            this.metadataTree.setSelectionPath(new TreePath(n.getPath()));
        }
    }

    private void expandTree() {
        this.metadataTree.expandPath(new TreePath(this.root.getPath()));
        for (int i = 0; i < this.metadataTree.getRowCount(); ++i) {
            Object obj = ((CustomTreeNode)this.metadataTree.getPathForRow((int)i).getLastPathComponent()).tag;
            if (obj != null && !(obj instanceof MetadataContainer)) continue;
            this.metadataTree.expandRow(i);
        }
    }

    private CustomTreeNode loadField(CustomTreeNode parent, MetadataField obj, MetadataBase selectedObject) {
        CustomTreeNode n = new CustomTreeNode(obj.getNameStrNotQuoted(), obj, this.itemIcon);
        parent.add(n);
        if (selectedObject == obj) {
            this.metadataTree.setSelectionPath(new TreePath(n.getPath()));
        }
        return n;
    }

    private CustomTreeNode loadRelation(CustomTreeNode parent, MetadataRelation obj, MetadataBase selectedObject) {
        CustomTreeNode n = new CustomTreeNode(obj.getChildTableStrNotQuoted(), obj, this.itemIcon);
        parent.add(n);
        if (selectedObject == obj) {
            this.metadataTree.setSelectionPath(new TreePath(n.getPath()));
        }
        return n;
    }

    private CustomTreeNode loadObject(CustomTreeNode parent, MetadataObject obj, MetadataBase selectedObject) {
        int i;
        AstTokenIdentifier emptySchemaName;
        String dbname = obj.getDatabase().getCount() != 0 ? obj.getDatabaseStrNotQuoted() : Helpers.localizer.getString("strMetadataTreeCurrentDatabase", "(current database)");
        if (!Str.IsNullOrEmpty(obj.getDBLinkStr())) {
            dbname = dbname + "@" + obj.getDBLinkStr();
        }
        CustomTreeNode db = parent = this.findNamedNode(parent, dbname, this.databaseIcon);
        CustomTreeNode schema = !Str.IsNullOrEmpty(obj.getSchemaStrNotQuoted()) ? (parent = this.findNamedNode(parent, obj.getSchemaStrNotQuoted(), this.schemaIcon)) : (this.temporarySQLContext.getSyntaxProvider() != null && this.temporarySQLContext.getSyntaxProvider().isSupportSchemas() ? ((emptySchemaName = this.temporarySQLContext.getSyntaxProvider().getEmptySchemaName(this.temporarySQLContext)) != null ? (parent = this.findNamedNode(parent, emptySchemaName.getToken(), this.schemaIcon)) : parent) : parent);
        CustomTreeNode result = new CustomTreeNode(obj.getNameStrNotQuoted(), obj);
        parent.add(result);
        if (selectedObject == obj) {
            this.metadataTree.setSelectionPath(new TreePath(result.getPath()));
        }
        result.icon = obj instanceof MetadataTable ? this.tableIcon : (obj instanceof MetadataView ? this.viewIcon : (obj instanceof MetadataProcedure ? this.procedureIcon : (obj instanceof MetadataSynonym ? this.synonymIcon : this.tableIcon)));
        CustomTreeNode f = new CustomTreeNode(Helpers.localizer.getString("strFields", "Fields"), obj.getFields(), this.fieldsIcon);
        result.add(f);
        if (selectedObject == obj.getFields()) {
            this.metadataTree.setSelectionPath(new TreePath(f.getPath()));
        }
        for (i = 0; i < obj.getFields().getCount(); ++i) {
            this.loadField(f, obj.getFields().get(i), selectedObject);
        }
        if (obj.getRelations().getCount() > 0) {
            CustomTreeNode r = new CustomTreeNode(Helpers.localizer.getString("strRelations", "Relations"), obj.getFields(), this.fieldsIcon);
            result.add(r);
            if (selectedObject == obj.getRelations()) {
                this.metadataTree.setSelectionPath(new TreePath(r.getPath()));
            }
            for (i = 0; i < obj.getRelations().getCount(); ++i) {
                this.loadRelation(r, obj.getRelations().get(i), selectedObject);
            }
        }
        return result;
    }

    private void switchPanel(String cardName) {
        ((CardLayout)this.pnlProperties.getLayout()).show(this.pnlProperties, cardName);
    }

    private void showObjectProps(MetadataObject obj) {
        this.setMetadataObject(obj);
        this.switchPanel("pnlObjectProperties");
    }

    private void showFieldProps(MetadataField metadataField) {
        this.setMetadataField(metadataField);
        this.switchPanel("pnlFieldProperties");
    }

    private void updatePropertiesPanel() {
        if (this.metadataTree.getSelectionPath() != null) {
            Object obj = ((CustomTreeNode)this.metadataTree.getSelectionPath().getLastPathComponent()).tag;
            if (obj != null) {
                if (obj instanceof MetadataObject) {
                    this.showObjectProps((MetadataObject)obj);
                } else if (obj instanceof MetadataField) {
                    this.showFieldProps((MetadataField)obj);
                } else {
                    this.switchPanel("pnlNoProperties");
                }
            } else {
                this.switchPanel("pnlNoProperties");
            }
        } else {
            this.switchPanel("pnlNoProperties");
        }
    }

    private void updateButtonsState() {
        this.bDelete.setEnabled(this.metadataTree.getSelectionPath() != null && this.temporaryMetadataContainer.isLoaded());
    }

    private boolean deleteNodeObject(Object o) {
        if (o instanceof MetadataObject) {
            this.temporaryMetadataContainer.remove((MetadataObject)o);
            return true;
        }
        return false;
    }

    private boolean deleteNodeAndChildren(CustomTreeNode node) {
        boolean result;
        if (node.tag != null) {
            result = this.deleteNodeObject(node.tag);
            if (result) {
                node.removeFromParent();
            }
        } else {
            result = false;
        }
        if (!result) {
            CustomTreeNode tNode = (CustomTreeNode)(node.getChildCount() > 0 ? node.getFirstChild() : null);
            while (tNode != null) {
                CustomTreeNode tNext = (CustomTreeNode)tNode.getNextNode();
                this.deleteNodeAndChildren(tNode);
                tNode = tNext;
            }
            if (node.tag == null && node.getChildCount() == 0) {
                node.removeFromParent();
            }
        }
        return result;
    }

    private void deleteSelectedMetadataItem() {
        if (this.metadataTree.getSelectionPath() != null) {
            CustomTreeNode n = (CustomTreeNode)this.metadataTree.getSelectionPath().getLastPathComponent();
            if (n == this.root) {
                if (JOptionPane.showConfirmDialog(this, Helpers.localizer.getString("strClearMetadataContainer", "Clear Metadata Container?"), Helpers.localizer.getString("strConfirmation", "Confirmation"), 0) == 0) {
                    this.temporaryMetadataContainer.clear();
                    this.loadMetadataTree();
                    this.updateButtonsState();
                }
            } else {
                CustomTreeNode parent = (CustomTreeNode)n.getParent();
                if (parent == null) {
                    parent = this.root;
                }
                if (this.deleteNodeAndChildren(n)) {
                    this.model.reload();
                    this.expandTree();
                    this.metadataTree.setSelectionPath(new TreePath(parent.getPath()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadObjectProps() {
        if (!this.loading) {
            this.loading = true;
            try {
                if (this.metadataObject instanceof MetadataTable) {
                    this.eObjectType.setText(Helpers.localizer.getString("strObjectTypeTable", "Table"));
                } else if (this.metadataObject instanceof MetadataView) {
                    this.eObjectType.setText(Helpers.localizer.getString("strObjectTypeView", "View"));
                } else if (this.metadataObject instanceof MetadataProcedure) {
                    this.eObjectType.setText(Helpers.localizer.getString("strObjectTypeProcedure", "Procedure"));
                } else if (this.metadataObject instanceof MetadataSynonym) {
                    this.eObjectType.setText(Helpers.localizer.getString("strObjectTypeSynonym", "Synonym"));
                } else {
                    this.eObjectType.setText(Helpers.localizer.getString("strObjectTypeUnknown", "Unknown"));
                }
                this.eObjectDatabase.setText(this.metadataObject.getDatabaseStrNotQuoted());
                this.eObjectSchema.setText(this.metadataObject.getSchemaStrNotQuoted());
                this.eObjectName.setText(this.metadataObject.getNameStrNotQuoted());
                this.cbSystemObject.setSelected(this.metadataObject.isSystem());
                this.cbVisibleObject.setSelected(this.metadataObject.isVisible());
                this.eObjectAltName.setText(this.metadataObject.getAltName());
                this.eObjectDescription.setText(this.metadataObject.getShortDescription());
                this.eObjectLongDescription.setText(this.metadataObject.getLongDescription());
            }
            finally {
                this.loading = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveObjectProps() {
        if (!this.loading) {
            try {
                this.loading = true;
                this.metadataObject.setSystem(this.cbSystemObject.isSelected());
                this.metadataObject.setVisible(this.cbVisibleObject.isSelected());
                this.metadataObject.setAltName(this.eObjectAltName.getText());
                this.metadataObject.setShortDescription(this.eObjectDescription.getText());
                this.metadataObject.setLongDescription(this.eObjectLongDescription.getText());
            }
            finally {
                this.loading = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFieldProps() {
        if (!this.loading) {
            this.loading = true;
            try {
                this.eFieldName.setText(this.metadataField.getNameStrNotQuoted());
                if (this.metadataField.getFieldTypeName() != null && this.metadataField.getFieldTypeName().length() > 0) {
                    this.eFieldType.setText(this.metadataField.getFieldTypeName());
                } else {
                    this.eFieldType.setText(Helpers.typeToString(this.metadataField.getFieldType()));
                }
                this.eFieldAltName.setText(this.metadataField.getAltName());
                this.eFieldDescription.setText(this.metadataField.getShortDescription());
                this.eFieldLongDescription.setText(this.metadataField.getLongDescription());
            }
            finally {
                this.loading = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFieldProps() {
        if (!this.loading) {
            this.loading = true;
            try {
                this.metadataField.setAltName(this.eFieldAltName.getText());
                this.metadataField.setShortDescription(this.eFieldDescription.getText());
                this.metadataField.setLongDescription(this.eFieldLongDescription.getText());
            }
            finally {
                this.loading = false;
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.OnTextFieldChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.OnTextFieldChanged(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.OnTextFieldChanged(e);
    }

    private void OnTextFieldChanged(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.eObjectAltName.getDocument() || doc == this.eObjectLongDescription.getDocument() || doc == this.eObjectDescription.getDocument()) {
            this.saveObjectProps();
        } else if (doc == this.eFieldAltName.getDocument() || doc == this.eFieldLongDescription.getDocument() || doc == this.eFieldDescription.getDocument()) {
            this.saveFieldProps();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.bShowUserObjects || source == this.bShowSystemObjects || source == this.bShowTables || source == this.bShowViews || source == this.bShowProcedures || source == this.bShowSynonyms) {
            this.loadMetadataTree();
            this.updateButtonsState();
        } else if (source == this.cbSystemObject || source == this.cbVisibleObject) {
            this.saveObjectProps();
        }
    }
}

