/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.UpdatablePersistent;
import com.adbs.querybuilder.FieldListBaseColumnOptions;
import com.adbs.querybuilder.FieldTypeCase;
import java.awt.Color;
import java.awt.SystemColor;

public class FieldListTypeColumnOptions
extends FieldListBaseColumnOptions {
    private int fontStyle = 0;
    private Color color = SystemColor.textInactiveText;
    private FieldTypeCase typeCase = FieldTypeCase.Lowercase;

    public FieldListTypeColumnOptions(UpdatablePersistent parent) {
        super(parent);
        this.setDrawOrder(2);
        this.setMargin(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Object source) {
        this.beginUpdate();
        try {
            super.assign(source);
            if (source instanceof FieldListTypeColumnOptions) {
                this.setFontStyle(((FieldListTypeColumnOptions)source).getFontStyle());
                this.setColor(((FieldListTypeColumnOptions)source).getColor());
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int fontStyle) {
        if (this.fontStyle != fontStyle) {
            this.fontStyle = fontStyle;
            this.notifyUpdated();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (this.color != color) {
            this.color = color;
            this.notifyUpdated();
        }
    }

    public FieldTypeCase getCase() {
        return this.typeCase;
    }

    public void setCase(FieldTypeCase value) {
        if (this.typeCase != value) {
            this.typeCase = value;
            this.notifyUpdated();
        }
    }
}

