/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstAliasExpressionsList;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.SQLAliasExpression;
import com.adbs.ast.SQLFromQuery;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.UpdatedEvent;
import com.adbs.ast.UpdatedEventListener;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DatasourceGroup;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.SubQuery;
import com.adbs.querybuilder.SubSelectStatementProxy;
import com.adbs.utils.Helpers;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class DataSourceQuery
extends DataSource
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private ArrayList<String> columnAliases = new ArrayList();
    private SubQuery fQuery;
    private UpdatedEventListener subqueryFieldsChanged = new UpdatedEventListener(){

        @Override
        public void updatedEventOccurred(UpdatedEvent event) {
            DataSourceQuery.this.reloadFieldsFromUnderlyingSubquery();
        }
    };

    public DataSourceQuery(DatasourceGroup owner, DatasourceGroup updateParent, QueryBuilder queryBuilder) {
        super(owner, updateParent, queryBuilder);
    }

    @Override
    public void dispose() {
        this.getQuery2().getFields().removeUpdatedEventListener(this.subqueryFieldsChanged);
        super.dispose();
    }

    public SubQuery getQuery2() {
        return this.fQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFromAST(SQLFromSource fs) {
        boolean result;
        this.beginUpdate();
        try {
            result = super.loadFromAST(fs);
            this.fQuery = ((SubSelectStatementProxy)((SQLFromQuery)fs).subQuery).subQuery;
            this.fQuery.getFields().addUpdatedEventListener(this.subqueryFieldsChanged);
            this.subqueryFieldsChanged.updatedEventOccurred(new UpdatedEvent(this));
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        QueryBuilder qb = this.getQueryBuilder();
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(Helpers.localizer.getString("strSwitchToDerivedTable", "Switch to derived table"));
        item.setActionCommand("switch to derived table");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem(Helpers.localizer.getString("strRemove", "Remove"));
        item.setActionCommand("remove");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem(Helpers.localizer.getString("strStrAftofitHeight", "Autofit object height"));
        item.setActionCommand("autofit height");
        item.addActionListener(this);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(Helpers.localizer.getString("strEdit", "Properties"));
        item.setActionCommand("edit");
        item.addActionListener(this);
        menu.add(item);
        return menu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("switch to derived table")) {
            this.switchToSubqueryTab();
        } else if (action.equals("remove")) {
            this.dispose();
        } else if (action.equals("autofit height")) {
            if (this.getDSControl() != null) {
                this.getDSControl().setOptimalHeight();
            }
        } else if (action.equals("edit")) {
            this.editProps(SwingUtilities.getWindowAncestor(this.getQueryBuilder()));
        }
    }

    public void switchToSubqueryTab() {
        this.queryBuilder.setActiveSubquery(this.getQuery2());
    }

    @Override
    protected boolean isDeletedFieldsCleaned() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadFieldsFromUnderlyingSubquery() {
        MetadataFieldList fields = this.getFields();
        fields.beginUpdate();
        try {
            fields.assign(this.getQuery2().getFields());
            AstAliasExpressionsList colNames = this.getFromSource().columnNamesList;
            if (colNames != null) {
                for (int i = 0; i < fields.getCount(); ++i) {
                    MetadataField f = fields.get(i);
                    if (i < colNames.getCount()) {
                        f.setNameAlias(colNames.get(i));
                        continue;
                    }
                    SQLAliasExpression a = new SQLAliasExpression(this.sqlContext);
                    assert (f.getName().get(0) != null);
                    a.alias = f.getName().get(0).clone(this.sqlContext);
                    colNames.add(a);
                }
                colNames.setCount(fields.getCount());
            }
            this.doCustomizeDatasourceFieldsList();
        }
        finally {
            fields.endUpdate();
        }
        if (this.getDSControl() != null) {
            this.getDSControl().tuneSize();
        }
    }

    @Override
    public void refreshMetadata() {
        this.reloadFieldsFromUnderlyingSubquery();
    }
}

