/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstToken;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLDatabaseObject;
import com.adbs.ast.SQLFromObject;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.UpdatedEvent;
import com.adbs.ast.UpdatedEventListener;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DatasourceGroup;
import com.adbs.querybuilder.DestroyingEventListener;
import com.adbs.querybuilder.Query;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.SubQuery;
import com.adbs.querybuilder.SubSelectStatementProxy;
import com.adbs.utils.Constants;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class DataSourceObject
extends DataSource {
    private SubQuery subQueryCTE;
    private UpdatedEventListener subqueryFieldsChanged = new UpdatedEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updatedEventOccurred(UpdatedEvent event) {
            assert (DataSourceObject.this.subQueryCTE != null);
            DataSourceObject.this.getFields().beginUpdate();
            try {
                DataSourceObject.this.getFields().assign(((DataSourceObject)DataSourceObject.this).subQueryCTE.getWithClauseItem().fieldList);
                DataSourceObject.this.doCustomizeDatasourceFieldsList();
            }
            finally {
                DataSourceObject.this.getFields().endUpdate();
            }
            if (DataSourceObject.this.getDSControl() != null) {
                DataSourceObject.this.getDSControl().tuneSize();
            }
        }
    };
    private DestroyingEventListener subqueryDeleting = new DestroyingEventListener(){

        @Override
        public void destroyingEventOccurred(EventObject event) {
            DataSourceObject.this.dispose();
        }
    };

    public DataSourceObject(DatasourceGroup owner, DatasourceGroup updateParent, QueryBuilder queryBuilder) {
        super(owner, updateParent, queryBuilder);
    }

    public SQLDatabaseObject getDatabaseObject() {
        if (this.astFromSource != null) {
            return ((SQLFromObject)this.astFromSource).fromObj;
        }
        return null;
    }

    public SubQuery getSubQueryCTE() {
        return this.subQueryCTE;
    }

    @Override
    public SQLFromObject getDatasourceAST() {
        SQLFromSource fs = super.getDatasourceAST();
        if (fs != null) {
            return (SQLFromObject)fs;
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.getDatasourceAST().getCTEObject() != null) {
            assert (this.subQueryCTE != null);
            this.subQueryCTE.getWithClauseItem().fieldList.removeUpdatedEventListener(this.subqueryFieldsChanged);
            this.subQueryCTE.removeDestroyingEventListener(this.subqueryDeleting);
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getDataSourceName() {
        SQLDatabaseObject dbo = this.getDatabaseObject();
        if (dbo != null) {
            BaseSQLContext context = this.getSQLContext();
            MetadataObject mo = this.astFromSource.getMetadataObject();
            if (!Str.IsNullOrEmpty(this.getAlias())) {
                return this.getAlias() + " (" + this.astFromSource.getSimpleExpression(context.getSQLBuilderExpression()) + ")";
            }
            if (mo != null) {
                if (this.getQueryBuilder().isUseAltNames() && !Str.IsNullOrEmpty(mo.getAltName())) {
                    return this.astFromSource.getSimpleExpression(context.getSQLBuilderExpression());
                }
                String result = mo.getNameStrNotQuoted();
                SQLQualifiedName qn = mo.getNameAsObject(true, true, false, context.getSQLBuilderExpression().getObjectPrefixSkipping());
                if (!Helpers.isQualifiedNameEmpty(qn)) {
                    result = result + " (" + qn.getQualifiedNameWithoutQuotes() + ")";
                }
                qn.dispose();
                return result;
            }
            SQLQualifiedName qn = new SQLQualifiedName(dbo.getSQLContext());
            try {
                qn.assign(dbo);
                if (qn.getCount() > 1) {
                    AstToken n = qn.extractName();
                    String string = n.getToken() + " (" + qn.getQualifiedNameWithoutQuotes() + ")";
                    return string;
                }
                String string = qn.getQualifiedNameWithoutQuotes();
                return string;
            }
            finally {
                qn.dispose();
            }
        }
        return super.getDataSourceName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFromAST(SQLFromSource fs) {
        boolean result;
        assert (fs instanceof SQLFromObject);
        this.beginUpdate();
        try {
            result = super.loadFromAST(fs);
            assert (super.getDatasourceAST() != null);
            assert (super.getDatasourceAST() instanceof SQLFromObject);
            if (this.getDatasourceAST().getCTEObject() != null) {
                assert (this.getDatasourceAST().getCTEObject().subQuery != null);
                assert (this.getDatasourceAST().getCTEObject().subQuery instanceof SubSelectStatementProxy);
                SubSelectStatementProxy proxy = (SubSelectStatementProxy)this.getDatasourceAST().getCTEObject().subQuery;
                this.subQueryCTE = proxy.subQuery;
                this.subQueryCTE.getWithClauseItem().fieldList.addUpdatedEventListener(this.subqueryFieldsChanged);
                this.subQueryCTE.addDestroyingEventListener(this.subqueryDeleting);
            } else {
                this.subQueryCTE = null;
            }
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    @Override
    protected boolean isDeletedFieldsCleaned() {
        return this.subQueryCTE != null;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(Helpers.localizer.getString("strCheckAll", Constants.strCheckAll));
        item.setActionCommand("check all");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem(Helpers.localizer.getString("strUncheckAll", Constants.strUncheckAll));
        item.setActionCommand("uncheck all");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem(Helpers.localizer.getString("strRemove", "Remove"));
        item.setActionCommand("remove");
        item.addActionListener(this);
        menu.add(item);
        if (this.getSubQueryCTE() != null) {
            item = new JMenuItem(Helpers.localizer.getString("strDeleteCTE", Constants.strDeleteCTE));
            item.setActionCommand("delete cte");
            item.addActionListener(this);
            menu.add(item);
        }
        item = new JMenuItem(Helpers.localizer.getString("strStrAftofitHeight", "Autofit object height"));
        item.setActionCommand("auto fit height");
        item.addActionListener(this);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(Helpers.localizer.getString("strEdit", "Properties"));
        item.setActionCommand("edit");
        item.setFont(item.getFont().deriveFont(1));
        item.addActionListener(this);
        menu.add(item);
        return menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("delete cte") && JOptionPane.showConfirmDialog(this.getDSControl(), Helpers.localizer.getString("strConfirmCTERemoving", Constants.strConfirmCTERemoving), Helpers.localizer.getString("strConfirmation", "Confirmation"), 0) == 0) {
            Query q = this.queryBuilder.getQuery();
            q.beginUpdate();
            try {
                q.getASTSubQuery().withClause.remove(this.subQueryCTE.withClauseItem);
                q.notifySQLUpdatedRecursive();
            }
            finally {
                q.endUpdate();
            }
        }
        super.actionPerformed(e);
    }

    @Override
    public String getObjectNameInQuery() {
        if (this.subQueryCTE != null) {
            return this.subQueryCTE.getSubQueryCTEItemAST().name.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
        }
        return super.getObjectNameInQuery();
    }
}

