/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataQualifiedNameList;
import com.adbs.ast.MetadataRelation;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.UpdatedEvent;
import com.adbs.ast.UpdatedEventListener;
import com.adbs.querybuilder.BeforeDatasourceFieldDragEvent;
import com.adbs.querybuilder.CheckListItem;
import com.adbs.querybuilder.CriteriaItem;
import com.adbs.querybuilder.CriteriaList;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourceControl;
import com.adbs.querybuilder.DatasourceFieldAddedEvent;
import com.adbs.querybuilder.DatasourceFieldAddingEvent;
import com.adbs.querybuilder.DatasourceFieldRemovedEvent;
import com.adbs.querybuilder.DatasourceFieldRemovingEvent;
import com.adbs.querybuilder.DiagramPane;
import com.adbs.querybuilder.FieldListOptions;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkCreatedEvent;
import com.adbs.querybuilder.LinkCreatingEvent;
import com.adbs.querybuilder.LinkDragOverEvent;
import com.adbs.querybuilder.LinkManipulations;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class DataSourceFieldList
extends JList
implements UpdatedEventListener {
    private static final long serialVersionUID = 1L;
    private DataSourceControl dataSourceControl;
    private FieldListOptions options;
    private DefaultListModel model = new DefaultListModel();
    private int updating = 0;

    public DataSourceFieldList(DataSourceControl parent, FieldListOptions options) {
        this.dataSourceControl = parent;
        this.options = options;
        this.setOpaque(false);
        this.setModel(this.model);
        this.setCellRenderer(new CheckListCellRenderer());
        this.setSelectionMode(0);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 0x40000000, new CustomDragGestureListener());
        this.setDropTarget(new DropTarget(this, new CustomDropTargetListener()));
        options.addUpdatedEventListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                DataSourceFieldList.this.onMouseClicked(e);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                DataSourceFieldList.this.onKeyPressed(e);
            }
        });
        Font f = this.dataSourceControl.getDataSource().queryBuilder.getDiagramObjectFont();
        if (f != null) {
            this.setFont(f);
        }
    }

    public DataSourceControl getDataSourceControl() {
        return this.dataSourceControl;
    }

    @Override
    public void updatedEventOccurred(UpdatedEvent event) {
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public int getFieldsCount() {
        return this.model.size();
    }

    public CheckListItem get(int index) {
        return (CheckListItem)this.model.get(index);
    }

    public boolean getChecked(int index) {
        CheckListItem item = (CheckListItem)this.model.get(index);
        return item.checked;
    }

    public void setChecked(int index, boolean checked) {
        CheckListItem item = (CheckListItem)this.model.get(index);
        item.checked = checked;
        if (this.updating == 0) {
            this.repaint();
        }
    }

    public void beginUpdate() {
        ++this.updating;
    }

    public void endUpdate() {
        --this.updating;
        if (this.updating == 0) {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toggleItem(int x) {
        DataSource ds = this.dataSourceControl.getDataSource();
        CriteriaList cl = ds.getQuery().getCriteriaList();
        cl.beginUpdate();
        try {
            SQLQualifiedName qn;
            MetadataField mf;
            if (x == 0 && ds.getQueryBuilder().getSyntaxProvider().isSupportAllTableFieldsSelection() && !ds.getQueryBuilder().getFieldListOptions().isHideAsteriskItem()) {
                mf = null;
                qn = null;
            } else {
                mf = this.get((int)x).field;
                qn = mf.getName();
            }
            if (!this.getChecked(x)) {
                DatasourceFieldAddingEvent evt1 = new DatasourceFieldAddingEvent(ds.getQueryBuilder(), ds.getQuery(), ds, mf);
                ds.getQueryBuilder().fireDatasourceFieldAddingEvent(evt1);
                if (evt1.abort) {
                    return;
                }
                CriteriaItem ci = cl.findField(ds, qn);
                if (ci == null) {
                    ci = cl.addField(ds, qn);
                }
                ci.setSelectedUI(true);
                DatasourceFieldAddedEvent evt2 = new DatasourceFieldAddedEvent(ds.getQueryBuilder(), ds.getQuery(), ds, mf, ci);
                ds.getQueryBuilder().fireDatasourceFieldAddedEvent(evt2);
            } else {
                DatasourceFieldRemovingEvent evt1 = new DatasourceFieldRemovingEvent(ds.getQueryBuilder(), ds.getQuery(), ds, mf);
                ds.getQueryBuilder().fireDatasourceFieldRemovingEvent(evt1);
                if (evt1.abort) {
                    return;
                }
                cl.removeFields(ds, qn);
                DatasourceFieldRemovedEvent evt2 = new DatasourceFieldRemovedEvent(ds.getQueryBuilder(), ds.getQuery(), ds, mf);
                ds.getQueryBuilder().fireDatasourceFieldRemovedEvent(evt2);
            }
        }
        finally {
            cl.endUpdate();
        }
    }

    protected void onMouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            int x;
            if (e.getClickCount() == 1) {
                int x2 = this.locationToIndex(e.getPoint());
                if (x2 != -1) {
                    Rectangle r = this.getCellBounds(x2, x2);
                    boolean _do = false;
                    this.dataSourceControl.getDataSource().getQueryBuilder().updateTreePosition(this.dataSourceControl.getDataSource());
                    if (e.getPoint().x <= r.x + r.height + 4) {
                        _do = true;
                    }
                    if (_do) {
                        this.toggleItem(x2);
                    }
                }
            } else if (e.getClickCount() == 2 && (x = this.getSelectedIndex()) != -1) {
                Rectangle r = this.getCellBounds(x, x);
                if (e.getPoint().x > r.x + r.height + 4) {
                    DataSource ds = this.getDataSourceControl().getDataSource();
                    MetadataField mf = ((CheckListItem)this.getSelectedValue()).field;
                    DatasourceFieldAddingEvent evtBefore = new DatasourceFieldAddingEvent(ds.getQueryBuilder(), ds.getQuery(), ds, mf);
                    ds.getQueryBuilder().fireDatasourceFieldAddingEvent(evtBefore);
                    if (evtBefore.abort) {
                        return;
                    }
                    CriteriaItem ci = mf == null ? ds.getQuery().getCriteriaList().addField(ds, (SQLQualifiedName)null) : ds.getQuery().getCriteriaList().addField(ds, mf.getName());
                    DatasourceFieldAddedEvent evtAfter = new DatasourceFieldAddedEvent(ds.getQueryBuilder(), ds.getQuery(), ds, mf, ci);
                    ds.getQueryBuilder().fireDatasourceFieldAddedEvent(evtAfter);
                }
            }
        } else if (e.getButton() == 3) {
            DataSource ds = this.getDataSourceControl().getDataSource();
            ds.getQueryBuilder().popupMenuPopup(ds.getPopupMenu(), this, ds, e.getPoint());
        }
    }

    protected void onKeyPressed(KeyEvent e) {
        int x;
        if (e.getKeyCode() == 32 && (x = this.getSelectedIndex()) != -1) {
            this.toggleItem(x);
            if (x + 1 < this.model.getSize()) {
                this.setSelectedIndex(x + 1);
            }
        }
    }

    private class CustomDropTargetListener
    extends DropTargetAdapter {
        private CustomDropTargetListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dragOver(DropTargetDragEvent event) {
            DataSourceFieldList sourceList = null;
            Transferable transferable = event.getTransferable();
            CheckListItem sourceItem = null;
            if (transferable.isDataFlavorSupported(CheckListItem.CHECK_LIST_ITEM_FLAVOR)) {
                try {
                    sourceItem = (CheckListItem)transferable.getTransferData(CheckListItem.CHECK_LIST_ITEM_FLAVOR);
                    sourceList = sourceItem.list;
                }
                catch (Exception ex) {
                    Logger.getLogger(DataSourceFieldList.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (sourceList != null && sourceList.getDataSourceControl().getDiagramPane() == DataSourceFieldList.this.dataSourceControl.getDiagramPane()) {
                if (sourceList != DataSourceFieldList.this) {
                    int i = DataSourceFieldList.this.locationToIndex(event.getLocation());
                    if (i != -1) {
                        MetadataField fromField = sourceItem.field;
                        DataSource fromDatasource = sourceList.dataSourceControl.getDataSource();
                        MetadataField toField = DataSourceFieldList.this.get((int)i).field;
                        DataSource toDatasource = DataSourceFieldList.this.dataSourceControl.getDataSource();
                        if (fromDatasource != toDatasource && fromField != null && toField != null) {
                            boolean accept;
                            MetadataRelation relation;
                            MetadataObject fromObject = fromDatasource.getMetadataObject();
                            MetadataObject toObject = toDatasource.getMetadataObject();
                            if (fromObject != null && toObject != null) {
                                MetadataQualifiedNameList fromFieldsList = new MetadataQualifiedNameList(null, DataSourceFieldList.this.dataSourceControl.getDataSource().getSQLContext());
                                try {
                                    fromFieldsList.add(fromField.getName());
                                    MetadataQualifiedNameList toFieldsList = new MetadataQualifiedNameList(null, DataSourceFieldList.this.dataSourceControl.getDataSource().getSQLContext());
                                    try {
                                        toFieldsList.add(toField.getName());
                                        i = fromObject.getRelations().findRelation(fromFieldsList, toObject.getSchema(), toObject.getName(), toFieldsList, toObject.getDatabase());
                                        if (i != -1) {
                                            relation = fromObject.getRelations().get(i);
                                        }
                                        i = toObject.getRelations().findRelation(toFieldsList, fromObject.getSchema(), fromObject.getName(), fromFieldsList, fromObject.getDatabase());
                                        if (i != -1) {
                                            relation = toObject.getRelations().get(i);
                                        }
                                        relation = null;
                                    }
                                    finally {
                                        toFieldsList.dispose();
                                    }
                                }
                                finally {
                                    fromFieldsList.dispose();
                                }
                            } else {
                                relation = null;
                            }
                            boolean bl = accept = DataSourceFieldList.this.dataSourceControl.getDataSource().getQuery().findLink(fromDatasource, fromField.getName(), toDatasource, toField.getName()) == null && DataSourceFieldList.this.dataSourceControl.getDataSource().getQuery().findLink(toDatasource, toField.getName(), fromDatasource, fromField.getName()) == null;
                            if (accept) {
                                boolean bl2 = accept = DataSourceFieldList.this.dataSourceControl.getDataSource().getQueryBuilder().getLinkOptions().getLinkManipulations() == LinkManipulations.Allow || DataSourceFieldList.this.dataSourceControl.getDataSource().getQueryBuilder().getLinkOptions().getLinkManipulations() == LinkManipulations.AllowRelationsOnly && relation != null;
                            }
                            if (accept && DataSourceFieldList.this.dataSourceControl.getDataSource().getQueryBuilder().getLinkOptions().isLinkCompatibleTypesOnly()) {
                                boolean bl3 = accept = fromField.getFieldType() == toField.getFieldType();
                            }
                            if (accept) {
                                LinkDragOverEvent linkDragOverEvent = new LinkDragOverEvent(DataSourceFieldList.this.dataSourceControl.getDataSource().getQueryBuilder(), DataSourceFieldList.this.dataSourceControl.getDataSource().getQuery(), fromDatasource, fromField, toDatasource, toField, relation);
                                DataSourceFieldList.this.dataSourceControl.getDataSource().getQueryBuilder().fireLinkDragOverEvent(linkDragOverEvent);
                                if (linkDragOverEvent.abort) {
                                    accept = false;
                                }
                            }
                            if (!accept) {
                                event.rejectDrag();
                            } else {
                                event.acceptDrag(0x40000000);
                            }
                        } else {
                            event.rejectDrag();
                        }
                    } else {
                        event.rejectDrag();
                    }
                } else {
                    event.rejectDrag();
                }
            } else {
                event.rejectDrag();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent event) {
            int i;
            event.acceptDrop(0x40000000);
            DataSourceFieldList sourceList = null;
            CheckListItem sourceItem = null;
            Transferable transferable = event.getTransferable();
            DiagramPane diagramPane = DataSourceFieldList.this.dataSourceControl.getDiagramPane();
            if (transferable.isDataFlavorSupported(CheckListItem.CHECK_LIST_ITEM_FLAVOR)) {
                try {
                    sourceItem = (CheckListItem)transferable.getTransferData(CheckListItem.CHECK_LIST_ITEM_FLAVOR);
                    sourceList = sourceItem.list;
                }
                catch (Exception ex) {
                    Logger.getLogger(DataSourceFieldList.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (sourceList != null && sourceList.getDataSourceControl().getDiagramPane() == diagramPane && sourceList != DataSourceFieldList.this && (i = DataSourceFieldList.this.locationToIndex(event.getLocation())) != -1) {
                MetadataField fromField = sourceItem.field;
                DataSource fromDatasource = sourceList.dataSourceControl.getDataSource();
                MetadataField toField = DataSourceFieldList.this.get((int)i).field;
                DataSource toDatasource = DataSourceFieldList.this.dataSourceControl.getDataSource();
                if (fromDatasource != toDatasource && fromField != null && toField != null) {
                    boolean accept;
                    MetadataRelation relation;
                    MetadataObject fromObject = fromDatasource.getMetadataObject();
                    MetadataObject toObject = toDatasource.getMetadataObject();
                    if (fromObject != null && toObject != null) {
                        MetadataQualifiedNameList fromFieldsList = new MetadataQualifiedNameList(null, DataSourceFieldList.this.dataSourceControl.getDataSource().getSQLContext());
                        try {
                            fromFieldsList.add(fromField.getName());
                            MetadataQualifiedNameList toFieldsList = new MetadataQualifiedNameList(null, DataSourceFieldList.this.dataSourceControl.getDataSource().getSQLContext());
                            try {
                                toFieldsList.add(toField.getName());
                                i = fromObject.getRelations().findRelation(fromFieldsList, toObject.getSchema(), toObject.getName(), toFieldsList, toObject.getDatabase());
                                if (i != -1) {
                                    relation = fromObject.getRelations().get(i);
                                }
                                i = toObject.getRelations().findRelation(toFieldsList, fromObject.getSchema(), fromObject.getName(), fromFieldsList, fromObject.getDatabase());
                                if (i != -1) {
                                    relation = toObject.getRelations().get(i);
                                }
                                relation = null;
                            }
                            finally {
                                toFieldsList.dispose();
                            }
                        }
                        finally {
                            fromFieldsList.dispose();
                        }
                    } else {
                        relation = null;
                    }
                    boolean bl = accept = DataSourceFieldList.this.dataSourceControl.getDataSource().getQuery().findLink(fromDatasource, fromField.getName(), toDatasource, toField.getName()) == null && DataSourceFieldList.this.dataSourceControl.getDataSource().getQuery().findLink(toDatasource, toField.getName(), fromDatasource, fromField.getName()) == null;
                    if (accept) {
                        boolean bl2 = accept = DataSourceFieldList.this.dataSourceControl.getDataSource().getQueryBuilder().getLinkOptions().getLinkManipulations() == LinkManipulations.Allow || DataSourceFieldList.this.dataSourceControl.getDataSource().getQueryBuilder().getLinkOptions().getLinkManipulations() == LinkManipulations.AllowRelationsOnly && relation != null;
                    }
                    if (accept && DataSourceFieldList.this.dataSourceControl.getDataSource().getQueryBuilder().getLinkOptions().isLinkCompatibleTypesOnly()) {
                        boolean bl3 = accept = fromField.getFieldType() == toField.getFieldType();
                    }
                    if (accept) {
                        LinkCreatingEvent linkCreatingEvent = new LinkCreatingEvent(DataSourceFieldList.this.dataSourceControl.getDataSource().getQueryBuilder(), DataSourceFieldList.this.dataSourceControl.getDataSource().getQuery(), fromDatasource, fromField, toDatasource, toField, relation);
                        DataSourceFieldList.this.dataSourceControl.getDataSource().getQueryBuilder().fireLinkCreatingEvent(linkCreatingEvent);
                        if (!linkCreatingEvent.abort) {
                            Link link = DataSourceFieldList.this.dataSourceControl.getDataSource().getQuery().addLink(fromDatasource, fromField.getName(), toDatasource, toField.getName());
                            LinkCreatedEvent linkCreatedEvent = new LinkCreatedEvent(DataSourceFieldList.this.dataSourceControl.getDataSource().getQueryBuilder(), link);
                            DataSourceFieldList.this.dataSourceControl.getDataSource().getQueryBuilder().fireLinkCreatedEvent(linkCreatedEvent);
                            diagramPane.doLayout();
                            diagramPane.repaint();
                        }
                    }
                }
            }
        }
    }

    private class CustomDragGestureListener
    implements DragGestureListener {
        private CustomDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            DataSourceFieldList list = (DataSourceFieldList)dge.getComponent();
            CheckListItem item = (CheckListItem)list.getSelectedValue();
            if (item.field != null) {
                BeforeDatasourceFieldDragEvent beforeDatasourceFieldDragEvent = new BeforeDatasourceFieldDragEvent(DataSourceFieldList.this.dataSourceControl.getDataSource().getQueryBuilder(), DataSourceFieldList.this.dataSourceControl.getDataSource().getQuery(), DataSourceFieldList.this.dataSourceControl.getDataSource(), item.field);
                DataSourceFieldList.this.dataSourceControl.getDataSource().getQueryBuilder().fireBeforeDatasourceFieldDragEvent(beforeDatasourceFieldDragEvent);
                if (!beforeDatasourceFieldDragEvent.abort) {
                    item.list = list;
                    dge.startDrag(null, item);
                }
            }
        }
    }

    private class CheckListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        private Color listForeground;
        private Color listBackground;
        private Color listSelectionForeground;
        private Color listSelectionBackground;
        private JCheckBox check;
        private DefaultListCellRenderer label;

        public CheckListCellRenderer() {
            UIDefaults uid = UIManager.getLookAndFeel().getDefaults();
            this.listForeground = uid.getColor("List.foreground");
            this.listBackground = uid.getColor("List.background");
            this.listSelectionForeground = uid.getColor("List.selectionForeground");
            this.listSelectionBackground = uid.getColor("List.selectionBackground");
            this.setLayout(new BorderLayout());
            this.check = new JCheckBox();
            this.label = new DefaultListCellRenderer();
            Dimension psz = this.check.getPreferredSize();
            psz.height -= 4;
            this.check.setPreferredSize(psz);
            this.add((Component)this.check, "West");
            this.add((Component)this.label, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.label.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (isSelected) {
                this.label.setForeground(this.listSelectionForeground);
                this.label.setBackground(this.listSelectionBackground);
            } else {
                this.label.setForeground(this.listForeground);
                this.label.setBackground(this.listBackground);
            }
            this.check.setBackground(this.listBackground);
            this.check.setSelected(((CheckListItem)value).checked);
            return this;
        }
    }
}

