/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.querybuilder.CheckListItem;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourceFieldList;
import com.adbs.querybuilder.DataSourceQuery;
import com.adbs.querybuilder.DiagramObjectDeletingEvent;
import com.adbs.querybuilder.DiagramPane;
import com.adbs.querybuilder.GetDiagramObjectWidthEvent;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.utils.Str;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class DataSourceControl
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private boolean isDisposing = false;
    private DataSource dataSource;
    private DiagramPane diagramPane;
    private DataSourceFieldList fieldList;
    private JScrollPane scrollPane;

    public DataSourceControl(DataSource owner) {
        this.dataSource = owner;
        this.setResizable(true);
        this.setClosable(true);
        this.setFrameIcon(null);
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.fieldList = new DataSourceFieldList(this, this.dataSource.getQueryBuilder().getFieldListOptions());
        this.scrollPane = new JScrollPane(this.fieldList, 20, 31);
        UIDefaults uid = UIManager.getLookAndFeel().getDefaults();
        this.scrollPane.getViewport().setBackground(uid.getColor("List.background"));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.setMinimumSize(new Dimension(50, 30));
        this.setPreferredSize(new Dimension(this.dataSource.getQueryBuilder().getDefaultDiagramObjectWidth(), this.dataSource.getQueryBuilder().getMaxDiagramObjectHeight()));
        this.pack();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                DataSourceControl.this.revalidate();
                if (DataSourceControl.this.getParent() != null) {
                    DataSourceControl jcomp = DataSourceControl.this;
                    Point location = jcomp.getLocation();
                    location.x = Math.max(0, location.x);
                    location.y = Math.max(0, location.y);
                    if (!location.equals(jcomp.getLocation())) {
                        jcomp.setLocation(location);
                    }
                    int titleHeight = Math.max(1, ((JComponent)jcomp).getRootPane().getY());
                    Rectangle titlePaneRect = new Rectangle(jcomp.getX(), jcomp.getY(), jcomp.getWidth(), titleHeight);
                    DataSourceControl.this.getDiagramPane().scrollRectToVisible(titlePaneRect);
                    DataSourceControl.this.getParent().repaint();
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                DataSourceControl.this.revalidate();
                if (DataSourceControl.this.getParent() != null) {
                    DataSourceControl.this.getParent().repaint();
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                DataSourceControl.this.revalidate();
                if (DataSourceControl.this.getParent() != null) {
                    DataSourceControl.this.getParent().repaint();
                }
            }
        });
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                DataSourceControl.this.onInternalFrameClosing(e);
            }
        });
        this.scrollPane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DataSourceControl.this.revalidate();
                DataSourceControl.this.getParent().repaint();
            }
        });
        if (System.getProperty("os.name").startsWith("Mac")) {
            this.attachMouseListener(this);
        } else {
            for (Component c : this.getComponents()) {
                if (!(c instanceof BasicInternalFrameTitlePane)) continue;
                String baseName = this.getDataSource().getDataSourceName() + ".";
                for (Component titlePaneComponent : ((BasicInternalFrameTitlePane)c).getComponents()) {
                    JButton b;
                    if (!(titlePaneComponent instanceof JButton) || !Str.IsNullOrEmpty((b = (JButton)titlePaneComponent).getName())) continue;
                    b.setName(baseName + b.getToolTipText());
                }
                this.attachMouseListener(c);
                break;
            }
        }
    }

    private void attachMouseListener(Component c) {
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3 && e.getClickCount() == 1) {
                    DataSourceControl.this.dataSource.getQueryBuilder().popupMenuPopup(DataSourceControl.this.dataSource.getPopupMenu(), DataSourceControl.this, DataSourceControl.this.dataSource, e.getPoint());
                } else if (e.getButton() == 1 && e.getClickCount() == 2) {
                    if (DataSourceControl.this.dataSource instanceof DataSourceQuery) {
                        DataSourceControl.this.dataSource.getQueryBuilder().setActiveSubquery(((DataSourceQuery)DataSourceControl.this.dataSource).getQuery2());
                    } else {
                        DataSourceControl.this.dataSource.editProps(SwingUtilities.getWindowAncestor(DataSourceControl.this));
                    }
                }
                super.mouseClicked(e);
                DataSourceControl.this.dataSource.getQueryBuilder().updateTreePosition(DataSourceControl.this.dataSource);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        this.isDisposing = true;
        if (this.isFocusOwner()) {
            this.diagramPane.transferFocus();
        }
        QueryBuilder qb = this.dataSource.getQueryBuilder();
        qb.getQuery().beginUpdate();
        try {
            this.dataSource.dispose();
            this.dataSource = null;
        }
        finally {
            qb.getQuery().endUpdate();
        }
        if (!qb.isDisposing() && this.diagramPane != null) {
            if (this.diagramPane.getFocusedControl() == this) {
                this.diagramPane.setFocusedControl(null);
            }
            this.diagramPane.repaint();
        }
    }

    public boolean isDisposing() {
        return this.isDisposing;
    }

    public DiagramPane getDiagramPane() {
        return this.diagramPane;
    }

    void setDiagramPane(DiagramPane value) {
        this.diagramPane = value;
    }

    public DataSourceFieldList getFieldList() {
        return this.fieldList;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    void setDataSource(DataSource value) {
        this.dataSource = value;
    }

    public int setOptimalHeight() {
        if (this.isDisposing || this.dataSource.getQueryBuilder().isDisposing()) {
            return 0;
        }
        int itemsHeight = this.fieldList.getHeight();
        if (this.fieldList.getModel().getSize() > 0) {
            itemsHeight = this.fieldList.getCellBounds((int)0, (int)(this.fieldList.getModel().getSize() - 1)).height;
        }
        int frameHeight = this.getHeight();
        int clientHeight = this.getRootPane().getHeight();
        int bordersHeight = frameHeight - clientHeight;
        int maxHeight = this.dataSource.getQueryBuilder().getMaxDiagramObjectHeight();
        clientHeight = maxHeight == -1 ? itemsHeight : (itemsHeight < maxHeight ? itemsHeight : maxHeight);
        this.setSize(this.getWidth(), clientHeight + bordersHeight + 4);
        return this.getHeight();
    }

    public void tuneSize() {
        this.doLayout();
        this.setOptimalHeight();
        this.setSize(this.calculateWidth(), this.getHeight());
    }

    private int calculateWidth() {
        GetDiagramObjectWidthEvent evt = new GetDiagramObjectWidthEvent(this.dataSource);
        evt.width = this.dataSource.getQueryBuilder().getDefaultDiagramObjectWidth();
        this.dataSource.getQueryBuilder().fireGetDiagramObjectWidthEvent(evt);
        return evt.width;
    }

    public Rectangle calcFieldRect(SQLQualifiedName field, boolean withWindowFrame) {
        Rectangle result;
        if (this.isDisposing || this.dataSource.getQueryBuilder().isDisposing()) {
            return new Rectangle(0, 0, 0, 0);
        }
        int x = -1;
        if (field != null) {
            for (int iField = 0; iField < this.fieldList.getFieldsCount(); ++iField) {
                MetadataField mf = this.fieldList.get((int)iField).field;
                if (mf == null || !this.dataSource.getSQLContext().isQualifiedNamesEqual(field, mf.getName()) && (field.getCount() != 1 || Str.IsNullOrEmpty(mf.getAltName()) || !(field.get(0) instanceof AstTokenIdentifier) || field.get(0).getToken().compareToIgnoreCase(mf.getAltName()) != 0)) continue;
                x = iField;
                break;
            }
        }
        if (x != -1) {
            Rectangle viewportBounds = this.getRootPane().getBounds();
            Rectangle cellBounds = this.fieldList.getCellBounds(x, x);
            cellBounds = SwingUtilities.convertRectangle(this.fieldList, cellBounds, this);
            cellBounds.width = this.fieldList.getRootPane().getWidth();
            if (cellBounds.y < viewportBounds.y) {
                cellBounds.y = viewportBounds.y - cellBounds.height / 2;
            }
            if (cellBounds.y > viewportBounds.y + viewportBounds.height) {
                cellBounds.y = viewportBounds.y + viewportBounds.height - cellBounds.height / 2;
            }
            result = cellBounds;
        } else {
            Rectangle rp = this.getRootPane().getBounds();
            result = new Rectangle(rp.x, 0, rp.width, rp.y);
        }
        if (withWindowFrame) {
            int borderWidth = this.getRootPane().getX();
            result.x -= borderWidth + 1;
            result.width += borderWidth * 2 + 2;
        }
        return result;
    }

    public Rectangle calcFieldRect(SQLQualifiedName field) {
        return this.calcFieldRect(field, true);
    }

    public void requestAlign() {
        this.revalidate();
    }

    private String getFieldNameStr(MetadataField field) {
        if (!Str.IsNullOrEmpty(field.getAltName()) && this.dataSource.getQueryBuilder().isUseAltNames()) {
            return field.getAltName();
        }
        return field.getName().getQualifiedNameWithoutQuotes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadFieldList(BaseSQLContext sqlContext, MetadataFieldList metadataFields) {
        if (this.isDisposing || this.dataSource.getQueryBuilder().isDisposing()) {
            return;
        }
        this.fieldList.beginUpdate();
        try {
            DefaultListModel content = (DefaultListModel)this.fieldList.getModel();
            content.clear();
            if (!this.dataSource.getQueryBuilder().getFieldListOptions().isHideAsteriskItem() && sqlContext.getSyntaxProvider() != null && sqlContext.getSyntaxProvider().isSupportAllTableFieldsSelection()) {
                content.addElement(new CheckListItem("*", null, false));
            }
            for (int i = 0; i < metadataFields.getCount(); ++i) {
                content.addElement(new CheckListItem(this.getFieldNameStr(metadataFields.get(i)), metadataFields.get(i), false));
            }
        }
        finally {
            this.fieldList.endUpdate();
        }
        this.requestAlign();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateChecksOnFields(List checkedFields) {
        this.fieldList.beginUpdate();
        try {
            for (int i = 0; i < this.fieldList.getFieldsCount(); ++i) {
                this.fieldList.setChecked(i, checkedFields.indexOf(this.fieldList.get((int)i).field) != -1);
            }
        }
        finally {
            this.fieldList.endUpdate();
        }
    }

    private void onInternalFrameClosing(InternalFrameEvent e) {
        DiagramObjectDeletingEvent evt = new DiagramObjectDeletingEvent(this.dataSource.getQuery(), this.dataSource);
        this.dataSource.getQueryBuilder().fireDiagramObjectDeletingEvent(evt);
        if (evt.abort) {
            this.setDefaultCloseOperation(0);
        } else {
            this.setDefaultCloseOperation(2);
        }
    }

    static {
        UIDefaults uIDefaults = UIManager.getLookAndFeel().getDefaults();
    }
}

