/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstNodeBase;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.MetadataCollectionItemBase;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLAliasObjectAlias;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLFromFunction;
import com.adbs.ast.SQLFromObject;
import com.adbs.ast.SQLFromQuery;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLObjectColumn;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SyntaxProviderChangedEvent;
import com.adbs.ast.UpdatedEvent;
import com.adbs.ast.UpdatedEventListener;
import com.adbs.querybuilder.ControlOwner;
import com.adbs.querybuilder.CriteriaItem;
import com.adbs.querybuilder.CriteriaList;
import com.adbs.querybuilder.CustomizeDatasourceFieldListEvent;
import com.adbs.querybuilder.DataSourceBase;
import com.adbs.querybuilder.DataSourceControl;
import com.adbs.querybuilder.DataSourceType;
import com.adbs.querybuilder.DatasourceFieldAddedEvent;
import com.adbs.querybuilder.DatasourceFieldAddingEvent;
import com.adbs.querybuilder.DatasourceFieldRemovedEvent;
import com.adbs.querybuilder.DatasourceFieldRemovingEvent;
import com.adbs.querybuilder.DatasourceGroup;
import com.adbs.querybuilder.DiagramObjectDeletingEvent;
import com.adbs.querybuilder.DiagramPane;
import com.adbs.querybuilder.FieldListOptions;
import com.adbs.querybuilder.FieldListSortType;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.SubQuery;
import com.adbs.utils.Constants;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataSource
extends DataSourceBase
implements ActionListener,
UpdatedEventListener {
    private static final long serialVersionUID = 1L;
    private DataSourceType datasourceType;
    private String caption;
    private ArrayList checkedFields = new ArrayList();
    private MetadataFieldList oldFieldList;
    private int left;
    private int top;
    private int width;
    private int height;

    public DataSource(DatasourceGroup owner, DatasourceGroup updateParent, QueryBuilder queryBuilder) {
        super(owner, updateParent, queryBuilder);
        this.sqlContext.addSyntaxProviderChangedEventListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.setDisposing(true);
        this.sqlContext.removeSyntaxProviderChangedEventListener(this);
        if (!this.query.isDisposing()) {
            if (this.getQuery() != null && this.getGroup() != null) {
                this.getQuery().beginUpdate();
                try {
                    this.getGroup().notifyReorderNeeded();
                    this.getQuery().notifyDatasourceDestroying(this);
                    try {
                        this.setGroup(null);
                    }
                    catch (QueryBuilderException ex) {
                        Logger.getLogger(DataSource.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                finally {
                    this.getQuery().endUpdate();
                }
            }
            this.astFromSource.getFieldList().removeUpdatedEventListener(this);
            if (this.oldFieldList != null) {
                this.oldFieldList.dispose();
                this.oldFieldList = null;
            }
        }
        super.dispose();
    }

    public DataSourceType getDatasourceType() {
        return this.datasourceType;
    }

    public String getAlias() {
        if (this.astFromSource == null || this.astFromSource.alias == null || this.astFromSource.alias.alias == null) {
            return "";
        }
        return this.astFromSource.alias.alias.getToken();
    }

    public void setAlias(String value) {
        if (!this.getAlias().equals(value)) {
            assert (this.astFromSource != null);
            if (this.astFromSource.alias != null) {
                if (!Str.IsNullOrEmpty(value)) {
                    this.astFromSource.alias.alias.setToken(value);
                    this.astFromSource.alias.alias.setCaseSensitive(false);
                } else {
                    this.astFromSource.alias = null;
                }
            } else if (!Str.IsNullOrEmpty(value)) {
                this.astFromSource.alias = new SQLAliasObjectAlias(this.getSQLContext());
                this.astFromSource.alias.alias = new AstTokenIdentifier(this.getSQLContext(), value, false);
            }
            this.getQuery().notifySQLUpdatedRecursive();
        }
    }

    public SQLAliasObjectAlias getAliasAST() {
        if (this.astFromSource == null) {
            return null;
        }
        return this.astFromSource.alias;
    }

    public String getCaption() {
        return this.caption;
    }

    public MetadataFieldList getFields() {
        if (this.astFromSource != null && this.astFromSource.getFieldList() != null) {
            return this.astFromSource.getFieldList();
        }
        return null;
    }

    public SQLFromSource getDatasourceAST() {
        return this.astFromSource;
    }

    public MetadataObject getMetadataObject() {
        return this.astFromSource.getMetadataObject();
    }

    public String getNameInQuery() {
        SQLAliasObjectAlias astAlias = this.getAliasAST();
        if (astAlias != null) {
            return astAlias.alias.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
        }
        return this.getObjectNameInQuery();
    }

    public DataSourceControl getDSControl() {
        if (this.controls.size() >= 1) {
            return (DataSourceControl)this.controls.get(0);
        }
        return null;
    }

    public int getLeft() {
        DataSourceControl c = this.getDSControl();
        if (c != null) {
            this.left = ((Component)c).getX();
        }
        return this.left;
    }

    public void setLeft(int value) {
        DataSourceControl c = this.getDSControl();
        if (c != null) {
            c.setLocation(value, ((Component)c).getY());
            this.left = ((Component)c).getX();
        } else {
            this.left = value;
        }
    }

    public int getTop() {
        DataSourceControl c = this.getDSControl();
        if (c != null) {
            this.top = ((Component)c).getY();
        }
        return this.top;
    }

    public void setTop(int value) {
        DataSourceControl c = this.getDSControl();
        if (c != null) {
            c.setLocation(((Component)c).getX(), value);
            this.top = ((Component)c).getY();
        } else {
            this.top = value;
        }
    }

    public int getWidth() {
        DataSourceControl c = this.getDSControl();
        if (c != null) {
            this.width = ((Component)c).getWidth();
        }
        return this.width;
    }

    public void setWidth(int value) {
        DataSourceControl c = this.getDSControl();
        if (c != null) {
            c.setSize(value, ((Component)c).getHeight());
            this.width = ((Component)c).getWidth();
        } else {
            this.width = value;
        }
    }

    public int getHeight() {
        DataSourceControl c = this.getDSControl();
        if (c != null) {
            this.height = ((Component)c).getHeight();
        }
        return this.height;
    }

    public void setHeight(int value) {
        DataSourceControl c = this.getDSControl();
        if (c != null) {
            c.setSize(((Component)c).getWidth(), value);
            this.height = ((Component)c).getHeight();
        } else {
            this.height = value;
        }
    }

    public Icon getIcon() {
        switch (this.datasourceType) {
            case View: {
                return this.getQueryBuilder().getAddObjectDialogOptions().getViewsIcon();
            }
            case StoredProc: {
                return this.getQueryBuilder().getAddObjectDialogOptions().getProceduresIcon();
            }
            case SubQuery: {
                return this.getQueryBuilder().getAddObjectDialogOptions().getQueriesIcon();
            }
        }
        return this.getQueryBuilder().getAddObjectDialogOptions().getTablesIcon();
    }

    @Override
    public void syntaxProviderChangedEventOccurred(SyntaxProviderChangedEvent event) {
        super.syntaxProviderChangedEventOccurred(event);
        try {
            this.refreshMetadata();
        }
        catch (QueryBuilderException ex) {
            Logger.getLogger(DataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.getDSControl() != null) {
            this.getDSControl().setOptimalHeight();
        }
    }

    @Override
    protected void doAfterUpdated() {
        super.doAfterUpdated();
        if (!this.isDisposing()) {
            this.updateCaption();
        }
    }

    @Override
    public int getControlsCount() {
        return 1;
    }

    @Override
    protected Component createControlInternal(int i) {
        if (i == 0) {
            DataSourceControl c = new DataSourceControl(this);
            DiagramPane dp = this.getQuery().getUnionPage().getDiagramPane();
            c.setDiagramPane(dp);
            dp.add(c);
            dp.setComponentZOrder(c, 0);
            c.setVisible(true);
            return c;
        }
        return null;
    }

    @Override
    protected void saveControlParams(int i) {
        super.saveControlParams(i);
        DataSourceControl c = this.getDSControl();
        this.left = ((Component)c).getX();
        this.top = ((Component)c).getY();
        this.width = ((Component)c).getWidth();
        this.height = ((Component)c).getHeight();
    }

    @Override
    protected void restoreControlParams(int i) {
        DataSourceControl c = this.getDSControl();
        c.getFieldList().setBackground(this.getQueryBuilder().getDiagramObjectColor());
        c.getFieldList().setFont(this.getQueryBuilder().getDiagramObjectFont());
        if (this.astFromSource != null) {
            c.reloadFieldList(this.getSQLContext(), this.astFromSource.getFieldList());
        }
        if (this.width == 0 && this.height == 0 && this.top == 0 && this.left == 0) {
            this.updateCaption();
            c.tuneSize();
            this.width = c.getWidth();
            this.height = c.getHeight();
            Point tl = this.getQuery().getDiagramPane().findEmptyPlace(c);
            c.setLocation(tl);
        } else {
            c.setLocation(this.left, this.top);
            if (this.width == 0 || this.height == 0) {
                c.tuneSize();
                this.width = c.getWidth();
                this.height = c.getHeight();
            } else {
                c.setSize(this.width, this.height);
            }
        }
        this.updateChecks();
    }

    @Override
    protected void updateContolParams(int i) {
        super.updateContolParams(i);
        if (i == 0) {
            DataSourceControl c = this.getDSControl();
            c.getFieldList().setBackground(this.getQueryBuilder().getDiagramObjectColor());
            c.getFieldList().setFont(this.getQueryBuilder().getDiagramObjectFont());
            this.updateCaption();
        }
    }

    protected void updateDatasourceType() {
        try {
            if (this.astFromSource != null) {
                if (this.astFromSource instanceof SQLFromObject) {
                    SQLFromObject fo = (SQLFromObject)this.astFromSource;
                    this.datasourceType = this.getQueryBuilder().isNameOfTable(fo.fromObj) ? DataSourceType.Table : (this.getQueryBuilder().isNameOfView(fo.fromObj) ? DataSourceType.View : (this.getQueryBuilder().isNameOfProcedure(fo.fromObj) ? DataSourceType.StoredProc : DataSourceType.Other));
                } else {
                    this.datasourceType = this.astFromSource instanceof SQLFromQuery ? DataSourceType.SubQuery : (this.astFromSource instanceof SQLFromFunction && this.getQueryBuilder().isNameOfProcedure(((SQLFromFunction)this.astFromSource).name) ? DataSourceType.Function : DataSourceType.Other);
                }
            } else {
                this.datasourceType = DataSourceType.Other;
            }
        }
        catch (Exception ex) {
            this.datasourceType = DataSourceType.Table;
        }
    }

    protected void updateCaption() {
        String c = this.getDataSourceName();
        int i = this.checkedFields.size();
        if (this.getQueryBuilder().isTableChecksCountInCaption() && i > 0) {
            c = this.checkedFields.indexOf(null) != -1 ? (i - 1 > 0 ? "(*" + String.valueOf(i - 1) + ") " + c : "(*) " + c) : "(" + String.valueOf(i) + ") " + c;
        }
        this.setCaption(c);
    }

    @Override
    protected String getDataSourceName() {
        if (!Str.IsNullOrEmpty(this.getAlias())) {
            return this.getAlias();
        }
        return super.getDataSourceName();
    }

    @Override
    public void saveLayout(Document document, Element unionSubQuery, SQLBuilder sqlBuilder) {
        Element ds = document.createElement("DataSource");
        unionSubQuery.appendChild(ds);
        ds.setAttribute("SQL", this.getResultSQL(sqlBuilder));
        ds.setAttribute("X", String.valueOf(this.getLeft()));
        ds.setAttribute("Y", String.valueOf(this.getTop()));
        ds.setAttribute("Height", String.valueOf(this.getHeight()));
        ds.setAttribute("Width", String.valueOf(this.getWidth()));
    }

    @Override
    public void loadLayout(Element unionSubQuery, SQLBuilder sqlBuilder) {
        Element ds = Helpers.findChildByNameAndAttribute("DataSource", "SQL", this.getResultSQL(sqlBuilder), unionSubQuery);
        if (ds != null) {
            this.setLeft(Integer.parseInt(ds.getAttribute("X")));
            this.setTop(Integer.parseInt(ds.getAttribute("Y")));
            this.setWidth(Integer.parseInt(ds.getAttribute("Width")));
            this.setHeight(Integer.parseInt(ds.getAttribute("Height")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshMetadata() throws QueryBuilderException {
        ArrayList lCTE = new ArrayList();
        ArrayList lFromObj = new ArrayList();
        if (this.astFromSource != null && this.getQueryBuilder() != null && !this.getQueryBuilder().isDisposing()) {
            if (this.getSQLContext().getSyntaxProvider() != null) {
                this.getFields().beginUpdate();
                try {
                    this.astFromSource.restoreColumnPrefixRecursive(true);
                    this.gatherPrepareAndFixupContext(lCTE, lFromObj, false);
                    this.astFromSource.prepareAndFixupRecursive(lCTE, lFromObj);
                    this.doCustomizeDatasourceFieldsList();
                }
                finally {
                    this.getFields().endUpdate();
                }
            }
            if (this.getDSControl() != null) {
                this.getDSControl().reloadFieldList(this.getSQLContext(), this.getFields());
                this.updateChecks();
            }
        }
    }

    private void setCheckInternal(boolean value, MetadataField field) {
        if (value) {
            this.checkedFields.add(field);
        }
    }

    @Override
    public void updateChecks() {
        if (this.astFromSource != null) {
            CriteriaItem ci;
            int i;
            boolean check;
            this.checkedFields.clear();
            if (this.sqlContext.getSyntaxProvider() != null && this.sqlContext.getSyntaxProvider().isSupportAllTableFieldsSelection()) {
                check = false;
                for (i = 0; i < this.getQuery().getCriteriaList().getCount(); ++i) {
                    ci = this.getQuery().getCriteriaList().get(i);
                    if (ci.getExpressionDatasourceAST() != this.astFromSource || ci.getExpressionColumnAST() != null) continue;
                    check = ci.isSelected();
                    break;
                }
                this.setCheckInternal(check, null);
            }
            for (i = 0; i < this.astFromSource.getFieldList().getCount(); ++i) {
                check = false;
                MetadataField field = this.astFromSource.getFieldList().get(i);
                for (int j = 0; j < this.getQuery().getCriteriaList().getCount(); ++j) {
                    ci = this.getQuery().getCriteriaList().get(j);
                    if (ci.getExpressionDatasourceAST() != this.astFromSource || ci.getExpressionColumnAST() == null || this.getSQLContext().compareQualifiedNames(ci.getExpressionColumnAST(), field.getName()) != 0) continue;
                    check = ci.isSelected();
                    break;
                }
                this.setCheckInternal(check, field);
            }
            if (this.getDSControl() != null) {
                this.getDSControl().updateChecksOnFields(this.checkedFields);
                this.updateCaption();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFromAST(SQLFromSource fs) {
        boolean result;
        this.beginUpdate();
        try {
            result = super.loadFromAST(fs);
            this.doCustomizeDatasourceFieldsList();
            this.astFromSource.getFieldList().addUpdatedEventListener(this);
            this.loadSubQueries(this.astFromSource);
            this.updateDatasourceType();
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    public Rectangle calcFieldRect(SQLQualifiedName field) {
        if (this.getDSControl() != null) {
            return this.getDSControl().calcFieldRect(field);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(Helpers.localizer.getString("strCheckAll", Constants.strCheckAll));
        item.setActionCommand("check all");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem(Helpers.localizer.getString("strUncheckAll", Constants.strUncheckAll));
        item.setActionCommand("uncheck all");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem(Helpers.localizer.getString("strRemove", "Remove"));
        item.setActionCommand("remove");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem(Helpers.localizer.getString("strStrAftofitHeight", "Autofit object height"));
        item.setActionCommand("auto fit height");
        item.addActionListener(this);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(Helpers.localizer.getString("strEdit", "Properties"));
        item.setActionCommand("edit");
        item.setFont(item.getFont().deriveFont(1));
        item.addActionListener(this);
        menu.add(item);
        return menu;
    }

    @Override
    public void getDatasources(List list) {
        list.add(this);
    }

    private void setCaption(String value) {
        this.caption = value;
        if (this.getDSControl() != null) {
            this.getDSControl().setTitle(this.caption);
        }
    }

    private void movePrimaryKeysToBegin() {
        int pos = 0;
        MetadataFieldList fields = this.getFields();
        for (int i = 0; i < fields.getCount(); ++i) {
            MetadataField f = fields.get(i);
            if (!f.isPrimaryKey()) continue;
            fields.move(i, pos);
            ++pos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("check all")) {
            CriteriaList criteriaList = this.query.getCriteriaList();
            MetadataFieldList fields = this.getFields();
            criteriaList.beginUpdate();
            try {
                for (int i = 0; i < this.getFields().getCount(); ++i) {
                    MetadataField field = fields.get(i);
                    CriteriaItem criteriaItem = criteriaList.findField(this, field.getName());
                    if (criteriaItem == null) {
                        DatasourceFieldAddingEvent event = new DatasourceFieldAddingEvent(this.queryBuilder, this.query, this, field);
                        if (!event.abort) {
                            criteriaItem = criteriaList.addField(this, field.getName());
                            this.queryBuilder.fireDatasourceFieldAddedEvent(new DatasourceFieldAddedEvent(this.queryBuilder, this.query, this, field, criteriaItem));
                        }
                    }
                    if (criteriaItem == null) continue;
                    criteriaItem.setSelected(true);
                }
            }
            finally {
                criteriaList.endUpdate();
            }
        } else if (action.equals("uncheck all")) {
            CriteriaList criteriaList = this.query.getCriteriaList();
            MetadataFieldList fields = this.getFields();
            criteriaList.beginUpdate();
            try {
                for (int i = 0; i < fields.getCount(); ++i) {
                    MetadataField field = fields.get(i);
                    DatasourceFieldRemovingEvent event = new DatasourceFieldRemovingEvent(this.queryBuilder, this.query, this, field);
                    this.queryBuilder.fireDatasourceFieldRemovingEvent(event);
                    if (event.abort) continue;
                    criteriaList.removeFields(this, field.getName());
                    this.queryBuilder.fireDatasourceFieldRemovedEvent(new DatasourceFieldRemovedEvent(this.queryBuilder, this.query, this, field));
                }
            }
            finally {
                criteriaList.endUpdate();
            }
        } else if (action.equals("remove")) {
            DiagramObjectDeletingEvent evt = new DiagramObjectDeletingEvent(this.getQuery(), this);
            this.getQueryBuilder().fireDiagramObjectDeletingEvent(evt);
            if (evt.abort) {
                return;
            }
            this.dispose();
        } else if (action.equals("auto fit height")) {
            if (this.getDSControl() != null) {
                this.getDSControl().tuneSize();
            }
        } else if (action.equals("edit")) {
            this.editProps(SwingUtilities.getWindowAncestor(this.getQueryBuilder()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatedEventOccurred(UpdatedEvent event) {
        if (!this.getQueryBuilder().isDisposing()) {
            DataSourceControl dsControl = this.getDSControl();
            if (dsControl != null) {
                dsControl.reloadFieldList(this.getSQLContext(), this.getFields());
                dsControl.setOptimalHeight();
            } else {
                this.height = 0;
            }
            this.updateChecks();
            this.beginUpdate();
            try {
                if (this.isDeletedFieldsCleaned()) {
                    this.cleanDeletedFields();
                }
                this.notifySQLUpdated();
            }
            finally {
                this.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCustomizeDatasourceFieldsList() {
        MetadataFieldList fields = this.getFields();
        FieldListOptions o = this.getQueryBuilder().getFieldListOptions();
        FieldListSortType sortType = o.getSortType();
        fields.beginUpdate();
        try {
            if (o != null) {
                if (sortType == FieldListSortType.Name) {
                    this.getFields().sort(new SortMetadataFieldsByNameComparator());
                } else if (sortType == FieldListSortType.Description) {
                    this.getFields().sort(new SortMetadataFieldsByDescriptionComparator());
                } else if (sortType == FieldListSortType.None && this.getMetadataObject() != null && this.getMetadataObject().getFields().getCount() > 0) {
                    fields.sort(new SortMetadataFieldsByOriginalOrderComparator(this.getMetadataObject().getFields()));
                }
                if (o.isKeyFieldsFirst()) {
                    this.movePrimaryKeysToBegin();
                }
            }
            this.getQueryBuilder().fireCustomizeDatasourceFieldListEvent(new CustomizeDatasourceFieldListEvent(this.getQueryBuilder(), this, this.getFields()));
        }
        finally {
            fields.endUpdate();
        }
    }

    public boolean isFieldSelected(MetadataField field) {
        return this.checkedFields.indexOf(field) != -1;
    }

    private boolean isExpressionReferenceToFields(AstNodeBase expression, MetadataFieldList fields) {
        boolean result = false;
        ArrayList referencedColumns = new ArrayList();
        expression.getReferencedColumnsRecursive(referencedColumns);
        for (int i = 0; i < referencedColumns.size(); ++i) {
            SQLObjectColumn column = (SQLObjectColumn)referencedColumns.get(i);
            boolean bl = result = column.datasource == this.astFromSource && fields.findFieldByName(column) != -1;
            if (result) break;
        }
        return result;
    }

    private void cleanDeletedFields() {
        if (this.oldFieldList != null) {
            for (int i = this.oldFieldList.getCount() - 1; i >= 0; --i) {
                MetadataField field = this.oldFieldList.get(i);
                if (this.getFields().findFieldByName(field.getName()) == -1) continue;
                this.oldFieldList.delete(i);
            }
            if (this.oldFieldList.getCount() > 0) {
                CriteriaList cl = this.query.getCriteriaList();
                for (int i = cl.getCount() - 1; i >= 0; --i) {
                    CriteriaItem ci = cl.get(i);
                    if (ci.getExpression() == null) continue;
                    if (this.isExpressionReferenceToFields(ci.getExpression(), this.oldFieldList)) {
                        ci.dispose();
                        continue;
                    }
                    for (int j = 0; j < ci.getConditionCount(); ++j) {
                        SQLExpressionItem condition = ci.getASTCondition(j);
                        if (condition == null || !this.isExpressionReferenceToFields(condition, this.oldFieldList)) continue;
                        ci.setConditionString(j, "");
                    }
                }
            }
        }
        if (this.oldFieldList == null) {
            this.oldFieldList = new MetadataFieldList(null, this.sqlContext);
        }
        this.oldFieldList.clear();
        this.oldFieldList.assign(this.getFields());
    }

    protected boolean isDeletedFieldsCleaned() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObjectNameInQuery() {
        MetadataObject metadataObject = this.getMetadataObject();
        if (metadataObject != null) {
            if (this.sqlContext.getSQLBuilderExpression().isUseAltNames() && !Str.IsNullOrEmpty(metadataObject.getAltName())) {
                AstTokenIdentifier id = new AstTokenIdentifier(this.sqlContext, metadataObject.getAltName());
                try {
                    String string = id.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
                    return string;
                }
                finally {
                    id.dispose();
                }
            }
            SQLQualifiedName qn = metadataObject.getNameAsObject(true, true, true, this.sqlContext.getSQLBuilderExpression().getObjectPrefixSkipping());
            try {
                String string = qn.getQualifiedName();
                return string;
            }
            finally {
                qn.dispose();
            }
        }
        return "";
    }

    private void loadDatasourceGroup(List<DataSource> dataSourceList, DatasourceGroup fromGroup, int fromIndex) {
        for (int i = 0; i < fromIndex; ++i) {
            DataSourceBase ds = fromGroup.get(i);
            if (ds instanceof DatasourceGroup) {
                this.loadDatasourceGroup(dataSourceList, (DatasourceGroup)ds, ((DatasourceGroup)ds).getCount() - 1);
                continue;
            }
            dataSourceList.add((DataSource)ds);
        }
    }

    @Override
    public void collectVisibleDataSources(List<DataSource> dataSourceList) {
        ControlOwner newBase;
        dataSourceList.add(this);
        DataSourceBase currentDatasource = this;
        DatasourceGroup currentGroup = currentDatasource.getGroup();
        while (currentGroup != null) {
            int groupIndex = currentGroup.indexOf(currentDatasource);
            this.loadDatasourceGroup(dataSourceList, currentGroup, groupIndex - 1);
            currentDatasource = currentGroup;
            currentGroup = currentDatasource.getGroup();
        }
        for (newBase = this; newBase != null && !(newBase instanceof SubQuery); newBase = newBase.getOwner()) {
        }
        if (newBase != null) {
            newBase = newBase.getOwner();
        }
        if (newBase != null) {
            if (newBase instanceof DataSource) {
                newBase.collectVisibleDataSources(dataSourceList);
                dataSourceList.remove((DataSource)newBase);
            } else {
                newBase.collectVisibleDataSources(dataSourceList);
            }
        }
    }

    private class SortMetadataFieldsByOriginalOrderComparator
    implements Comparator<MetadataCollectionItemBase> {
        private final MetadataFieldList fields;

        private SortMetadataFieldsByOriginalOrderComparator(MetadataFieldList fields) {
            this.fields = fields;
        }

        @Override
        public int compare(MetadataCollectionItemBase item1, MetadataCollectionItemBase item2) {
            MetadataField f1 = (MetadataField)item1;
            MetadataField f2 = (MetadataField)item2;
            return this.fields.findFieldByName(f1.getName()) - this.fields.findFieldByName(f2.getName());
        }
    }

    private class SortMetadataFieldsByDescriptionComparator
    implements Comparator<MetadataCollectionItemBase> {
        private SortMetadataFieldsByDescriptionComparator() {
        }

        @Override
        public int compare(MetadataCollectionItemBase qn1, MetadataCollectionItemBase qn2) {
            String s2;
            MetadataField f1 = (MetadataField)qn1;
            MetadataField f2 = (MetadataField)qn2;
            String s1 = f1.getShortDescription();
            int result = s1.compareToIgnoreCase(s2 = f2.getShortDescription());
            if (result == 0) {
                s1 = f1.getAltName();
                if (Str.IsNullOrEmpty(s1)) {
                    s1 = f1.getNameStrNotQuoted();
                }
                if (Str.IsNullOrEmpty(s2 = f2.getAltName())) {
                    s2 = f2.getNameStrNotQuoted();
                }
                result = s1.compareToIgnoreCase(s2);
            }
            return result;
        }
    }

    private class SortMetadataFieldsByNameComparator
    implements Comparator<MetadataCollectionItemBase> {
        private SortMetadataFieldsByNameComparator() {
        }

        @Override
        public int compare(MetadataCollectionItemBase qn1, MetadataCollectionItemBase qn2) {
            String s2;
            MetadataField f1 = (MetadataField)qn1;
            MetadataField f2 = (MetadataField)qn2;
            String s1 = f1.getAltName();
            if (Str.IsNullOrEmpty(s1)) {
                s1 = f1.getNameStrNotQuoted();
            }
            if (Str.IsNullOrEmpty(s2 = f2.getAltName())) {
                s2 = f2.getNameStrNotQuoted();
            }
            return s1.compareToIgnoreCase(s2);
        }
    }
}

