/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstIdentifierList;
import com.adbs.ast.AstNode;
import com.adbs.ast.AstToken;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.SQLExpressionAnd;
import com.adbs.ast.SQLExpressionBrackets;
import com.adbs.ast.SQLExpressionColumn;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLExpressionLogicalCollection;
import com.adbs.ast.SQLExpressionOr;
import com.adbs.ast.SQLGroupByList;
import com.adbs.ast.SQLOrderByClause;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLSelectItem;
import com.adbs.ast.SQLSelectItemAllColumns;
import com.adbs.ast.SQLSelectItemExpression;
import com.adbs.ast.SQLSelectItems;
import com.adbs.querybuilder.ConditionType;
import com.adbs.querybuilder.ControlOwner;
import com.adbs.querybuilder.CriteriaItem;
import com.adbs.querybuilder.CriteriaListControl;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import com.adbs.utils.Wrapper;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;

public class CriteriaList
extends ControlOwner {
    private static final long serialVersionUID = 1L;
    private UnionSubQuery unionSubQuery;
    public final ArrayList<CriteriaItem> orderByItems = new ArrayList();
    public final ArrayList<CriteriaItem> items = new ArrayList();
    private boolean isListLoading;
    protected SQLSelectItems astCriteriaList;
    protected SQLGroupByList astGroupBy;
    protected SQLOrderByClause astOrderBy;

    public CriteriaList(UnionSubQuery owner, QueryBuilder queryBuilder) {
        super(owner, owner, queryBuilder);
        this.unionSubQuery = owner;
        this.addEmptyRow();
    }

    @Override
    public void dispose() {
        if (this.astOrderBy != null) {
            this.astOrderBy.dispose();
            this.astOrderBy = null;
        }
        if (this.astCriteriaList != null) {
            this.astCriteriaList.dispose();
            this.astCriteriaList = null;
        }
        if (this.astGroupBy != null) {
            this.astGroupBy.dispose();
            this.astGroupBy = null;
        }
        super.dispose();
    }

    public boolean isListLoading() {
        return this.isListLoading;
    }

    public UnionSubQuery getUnionSubQuery() {
        return this.unionSubQuery;
    }

    public CriteriaListControl getCriteriaListControl() {
        if (this.controls.size() >= 1) {
            return (CriteriaListControl)this.controls.get(0);
        }
        return null;
    }

    JScrollPane getCriteriaListControlScrollPane() {
        if (this.controls.size() >= 1) {
            Container parent;
            for (parent = ((Component)this.controls.get(0)).getParent(); parent != null && !(parent instanceof JScrollPane); parent = parent.getParent()) {
            }
            return (JScrollPane)parent;
        }
        return null;
    }

    public CriteriaItem get(int index) {
        return this.items.get(index);
    }

    public int getCount() {
        return this.items.size();
    }

    public SQLGroupByList getGroupByAST() {
        return this.astGroupBy;
    }

    public int getOrderByItemsCount() {
        return this.orderByItems.size();
    }

    @Override
    public int getControlsCount() {
        return 1;
    }

    @Override
    protected Component createControlInternal(int i) {
        if (i == 0) {
            CriteriaListControl c = new CriteriaListControl(this);
            c.buildGUI();
            this.controls.set(i, c);
            return c;
        }
        return null;
    }

    @Override
    protected void restoreControlParams(int i) {
        if (i == 0) {
            this.fillList();
        }
    }

    @Override
    protected void updateContolParams(int i) {
        super.updateContolParams(i);
        if (i == 0) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillList() {
        if (this.getCriteriaListControl() != null) {
            this.isListLoading = true;
            try {
                this.getCriteriaListControl().fillList();
            }
            finally {
                this.isListLoading = false;
            }
        }
    }

    @Override
    protected void doAfterUpdated() {
        if (!this.isDisposing()) {
            if (this.getCount() == 0 || this.items.get((int)(this.getCount() - 1)).astExpression != null) {
                this.addEmptyRow();
            }
            while (this.getCount() > 1 && this.items.get((int)(this.getCount() - 2)).astExpression == null) {
                this.removeLastRow();
            }
            this.fillList();
            this.unionSubQuery.getFromClause().updateChecks();
        }
        super.doAfterUpdated();
    }

    protected CriteriaItem findOrAddCriteriaItem(SQLExpressionItem ei, EnumSet<ConditionType> compatibleTypes, ConditionType addType, boolean doFixup) {
        return this.findOrAddCriteriaItemFrom(0, ei, compatibleTypes, addType, doFixup);
    }

    protected int findSelectItemFrom(int fromIndex, SQLExpressionItem expression, EnumSet<ConditionType> compatibleTypes) {
        for (int i = fromIndex; i < this.getCount(); ++i) {
            if (!compatibleTypes.contains((Object)this.items.get(i).getConditionType()) || !this.items.get(i).isEqualExpression(expression)) continue;
            return i;
        }
        return -1;
    }

    protected int addSelectItem(SQLExpressionItem expression, ConditionType type, boolean doFixup) {
        CriteriaItem ci;
        int result = -1;
        for (int i = 0; i < this.getCount(); ++i) {
            if (this.items.get((int)i).astExpression != null) continue;
            result = i;
            break;
        }
        if (result == -1) {
            ci = this.addEmptyRow();
            result = this.indexOf(ci);
        }
        ci = this.items.get(result);
        ci.loadFromAST(expression, doFixup);
        ci.conditionType = type;
        return result;
    }

    protected CriteriaItem findOrAddCriteriaItemFrom(int fromIndex, SQLExpressionItem expression, EnumSet<ConditionType> compatibleTypes, ConditionType type, boolean doFixup) {
        CriteriaItem result;
        int i = this.findSelectItemFrom(fromIndex, expression, compatibleTypes);
        if (i == -1) {
            i = this.addSelectItem(expression, type, doFixup);
            result = this.items.get(i);
            if (type != ConditionType.None) {
                result.setConditionType(type);
            }
        } else {
            result = this.items.get(i);
            if (result.getConditionType() == ConditionType.None && type != ConditionType.None) {
                result.setConditionType(type);
            }
        }
        return result;
    }

    private CriteriaItem addEmptyRow() {
        CriteriaItem result = new CriteriaItem(this, this.getQueryBuilder());
        this.items.add(result);
        result.setGrouping(false);
        result.setConditionType(ConditionType.Where);
        if (this.isControlsCreated() && result.canCreateControls()) {
            result.createControls();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CriteriaItem insertEmptyRow(int index) {
        CriteriaItem result = null;
        this.beginUpdate();
        try {
            result = this.addEmptyRow();
            this.moveRow(this.items.indexOf(result), index);
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    protected void removeLastRow() {
        this.items.remove(this.items.size() - 1);
    }

    @Override
    protected void getASTChildren(List l) {
        super.getASTChildren(l);
        if (this.astCriteriaList != null) {
            l.add(this.astCriteriaList);
        }
        if (this.astGroupBy != null) {
            l.add(this.astGroupBy);
        }
    }

    @Override
    protected AstNode createResultAST() {
        AstNode result = this.astCriteriaList.clone(this.getSQLContext());
        for (int i = 0; i < this.getCount(); ++i) {
            if (!this.items.get(i).isSelected() || this.items.get((int)i).astExpression == null) continue;
            ((SQLSelectItems)result).add((SQLSelectItem)this.items.get(i).getResultAST());
        }
        if (((SQLSelectItems)result).getCount() == 0) {
            ((SQLSelectItems)result).add(new SQLSelectItemAllColumns(this.getSQLContext()));
        }
        return result;
    }

    public CriteriaItem addASTExpression(SQLSelectItem expression) throws QueryBuilderException {
        CriteriaItem result = this.addEmptyRow();
        result.loadFromAST(expression, true);
        return result;
    }

    public CriteriaItem insertASTExpression(int index, SQLSelectItem expression) throws QueryBuilderException {
        CriteriaItem result = this.insertEmptyRow(index);
        result.loadFromAST(expression, true);
        return result;
    }

    public int indexOf(CriteriaItem item) {
        return this.items.indexOf(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.beginUpdate();
        try {
            for (int i = this.getCount() - 1; i >= 0; --i) {
                this.items.get(i).clear();
            }
            this.notifySQLUpdated();
        }
        finally {
            this.endUpdate();
        }
    }

    public void moveRow(int oldIndex, int newIndex) {
        Helpers.listMove(this.items, oldIndex, newIndex);
        this.notifySQLUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCriteriaListFromAST(SQLSelectItems sl) {
        if (this.astCriteriaList != null) {
            this.astCriteriaList.dispose();
        }
        this.beginUpdate();
        try {
            int i;
            if (sl == null) {
                sl = new SQLSelectItems(this.getSQLContext());
            }
            this.astCriteriaList = sl;
            if (sl.getCount() != 1 || !(sl.get(0) instanceof SQLSelectItemAllColumns) && (!(sl.get(0) instanceof SQLSelectItemExpression) || ((SQLSelectItemExpression)sl.get((int)0)).expression != null)) {
                for (i = 0; i < sl.getCount(); ++i) {
                    while (i >= this.getCount()) {
                        this.addEmptyRow();
                    }
                    CriteriaItem ci = this.items.get(i);
                    ci.setConditionType(ConditionType.None);
                    ci.loadFromAST(sl.get(i), true);
                    ci.setSelected(true);
                }
            }
            for (i = sl.getCount() - 1; i >= 0; --i) {
                sl.delete(i);
            }
            this.notifySQLUpdated();
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGroupByListFromAST(SQLGroupByList gl) {
        this.beginUpdate();
        try {
            if (gl != null) {
                if (this.sqlContext.getSyntaxProvider().isSupportGroupByStar() && gl.groupByStar) {
                    for (CriteriaItem ci : this.items) {
                        if (!ci.isSelected() || ci.isAggregatedExpression()) continue;
                        ci.setGrouping(true);
                    }
                } else {
                    int i;
                    for (i = 0; i < gl.getCount(); ++i) {
                        CriteriaItem ci = this.findOrAddCriteriaItem(gl.get(i), Helpers.conditionsHavingCompatible, ConditionType.Having, true);
                        ci.setGrouping(true);
                    }
                    for (i = gl.getCount() - 1; i >= 0; --i) {
                        gl.delete(i);
                    }
                }
            }
            if (this.astGroupBy != null) {
                this.astGroupBy.dispose();
            }
            this.astGroupBy = gl != null ? gl : new SQLGroupByList(this.sqlContext);
            this.notifySQLUpdated();
        }
        finally {
            this.endUpdate();
        }
    }

    public void loadOrderByListFromAST(SQLOrderByClause ob) {
        this.loadOrderByListFromAST(ob, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadOrderByListFromAST(SQLOrderByClause ob, boolean doFixup) throws QueryBuilderException {
        this.beginUpdate();
        try {
            if (ob != null) {
                int i;
                for (i = 0; i < ob.getCount(); ++i) {
                    CriteriaItem ci = null;
                    if (ob.get((int)i).expression instanceof SQLExpressionColumn) {
                        SQLExpressionColumn ec = (SQLExpressionColumn)ob.get((int)i).expression;
                        if (ec.column != null && ec.column.getCount() == 1) {
                            AstToken id = ec.column.get(0);
                            for (int j = 0; j < this.getCount(); ++j) {
                                CriteriaItem tempCi = this.items.get(j);
                                if (!tempCi.isCanSort()) continue;
                                AstIdentifierList occupiedNames = tempCi.getOccupiedColumnNames();
                                try {
                                    if (this.orderByItems.indexOf(tempCi) != -1 || occupiedNames.findByToken(id) == -1) continue;
                                    ci = tempCi;
                                    break;
                                }
                                finally {
                                    occupiedNames.dispose();
                                }
                            }
                        }
                    }
                    if (ci == null) {
                        ci = this.findOrAddCriteriaItem(ob.get((int)i).expression, Helpers.conditionsAll, ConditionType.None, doFixup);
                    }
                    this.orderByItems.add(ci);
                    ci.loadOrderByItemFromAST(ob.get(i));
                }
                for (i = ob.getCount() - 1; i >= 0; --i) {
                    ob.extract(i);
                }
            }
            if (this.astOrderBy != null) {
                this.astOrderBy.dispose();
            }
            this.astOrderBy = ob != null ? ob : new SQLOrderByClause(this.sqlContext);
            this.notifySQLUpdated();
        }
        finally {
            this.endUpdate();
        }
    }

    private void load(ConditionType group, int conditionIndex, SQLExpressionItem expression, SQLExpressionItem condition) {
        EnumSet<ConditionType> cts = null;
        if (group == ConditionType.Where) {
            cts = Helpers.conditionsWhereCompatible;
        } else if (group == ConditionType.Having) {
            cts = Helpers.conditionsHavingCompatible;
        }
        int i = -1;
        do {
            if ((i = this.findSelectItemFrom(i + 1, expression, cts)) == -1 || this.items.get(i).getASTCondition(conditionIndex) != null) continue;
            if (this.items.get(i).getConditionType() != ConditionType.None) break;
            this.items.get(i).setConditionType(group);
            break;
        } while (i != -1);
        if (i == -1) {
            i = this.addSelectItem(expression, group, true);
        }
        if (i != -1) {
            this.items.get(i).addCondition(conditionIndex, condition);
        }
    }

    private void loadConditionItem(ConditionType group, int i, SQLExpressionItem e) {
        Wrapper<SQLExpressionItem> ei = new Wrapper<SQLExpressionItem>(Helpers.expressionExtractFromBrackets(e));
        if (ei.value != e) {
            e.dispose();
            e = (SQLExpressionItem)ei.value;
        }
        e = e.findExpressionItem(ei);
        this.load(group, i, (SQLExpressionItem)ei.value, e);
    }

    private void loadConditionGroup(ConditionType group, int index, SQLExpressionItem e) {
        SQLExpressionItem ei = Helpers.expressionRemoveBrackets(e);
        if (e != ei) {
            e.dispose();
        }
        if (ei != null) {
            if (ei instanceof SQLExpressionAnd) {
                while (((SQLExpressionAnd)ei).getCount() > 0) {
                    SQLExpressionItem ei2 = ((SQLExpressionAnd)ei).extract(0);
                    this.loadConditionItem(group, index, ei2);
                }
                ei.dispose();
            } else {
                this.loadConditionItem(group, index, ei);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConditionFromAST(SQLExpressionItem w, ConditionType group) {
        this.beginUpdate();
        try {
            SQLExpressionItem ei = Helpers.prepareLogicalExpressionForLoading(w);
            if (ei != null) {
                if (ei instanceof SQLExpressionOr) {
                    int i = 0;
                    while (((SQLExpressionOr)ei).getCount() > 0) {
                        SQLExpressionItem ei2 = ((SQLExpressionOr)ei).extract(0);
                        this.loadConditionGroup(group, i, ei2);
                        ++i;
                    }
                    ei.dispose();
                } else if (ei instanceof SQLExpressionAnd) {
                    this.loadConditionGroup(group, 0, ei);
                } else {
                    this.loadConditionItem(group, 0, ei);
                }
            }
            this.notifySQLUpdated();
        }
        finally {
            this.endUpdate();
        }
    }

    private void getSelectItemsWithConditionsOfTypeInColumn(int columnIndex, EnumSet<ConditionType> conditionTypes, List result) {
        result.clear();
        for (int i = 0; i < this.getCount(); ++i) {
            CriteriaItem item = this.items.get(i);
            if (!conditionTypes.contains((Object)item.conditionType) || item.getConditionCount() <= columnIndex || item.getASTCondition(columnIndex) == null) continue;
            result.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLExpressionItem getConditionTree(EnumSet<ConditionType> conditionTypes) {
        SQLExpressionItem result;
        int maxConds = 0;
        maxConds = this.getMaxConditionCountInternal(conditionTypes);
        if (maxConds > 0) {
            SQLExpressionLogicalCollection sc;
            int i;
            ArrayList<SQLExpressionLogicalCollection> mainOr = new ArrayList<SQLExpressionLogicalCollection>();
            ArrayList<SQLExpressionItem> mainAnd = new ArrayList<SQLExpressionItem>();
            ArrayList list = new ArrayList();
            for (i = 0; i < maxConds; ++i) {
                int j;
                this.getSelectItemsWithConditionsOfTypeInColumn(i, conditionTypes, list);
                if (list.size() <= 0) continue;
                mainAnd.clear();
                for (j = 0; j < list.size(); ++j) {
                    CriteriaItem ci = (CriteriaItem)list.get(j);
                    SQLExpressionItem main = ci.getASTCondition(i);
                    if ((main = main.clone(this.getSQLContext())) instanceof SQLExpressionOr) {
                        SQLExpressionBrackets tmp = new SQLExpressionBrackets(this.getSQLContext());
                        tmp.lExpression = main;
                        main = tmp;
                    }
                    SQLExpressionItem expr = ci.getExpression();
                    try {
                        main.restoreLExpression(expr);
                    }
                    finally {
                        expr.dispose();
                    }
                    mainAnd.add(main);
                }
                sc = new SQLExpressionAnd(this.getSQLContext());
                for (j = 0; j < mainAnd.size(); ++j) {
                    sc.add((SQLExpressionItem)mainAnd.get(j));
                }
                mainOr.add(sc);
            }
            sc = new SQLExpressionOr(this.getSQLContext());
            for (i = 0; i < mainOr.size(); ++i) {
                sc.add((SQLExpressionItem)mainOr.get(i));
            }
            result = sc;
            if (result != null) {
                result = Helpers.transformExpression(result);
            }
        } else {
            result = null;
        }
        return result;
    }

    public SQLGroupByList getGroupByTree() {
        boolean flagGroupByHaveItems = false;
        boolean flagGroupByStar = true;
        SQLGroupByList result = this.astGroupBy != null ? (SQLGroupByList)this.astGroupBy.clone(this.sqlContext) : new SQLGroupByList(this.sqlContext);
        if (this.sqlContext.getSyntaxProvider() != null && this.sqlContext.getSyntaxProvider().isSupportGroupByStar()) {
            for (CriteriaItem ci : this.items) {
                boolean bl = flagGroupByHaveItems = flagGroupByHaveItems || ci.isGrouping();
                if (ci.isSelected()) {
                    flagGroupByStar = flagGroupByStar && (ci.isGrouping() || ci.isAggregatedExpression());
                } else {
                    boolean bl2 = flagGroupByStar = flagGroupByStar && !ci.isGrouping();
                }
                if (flagGroupByStar) continue;
                break;
            }
            result.groupByStar = flagGroupByHaveItems && flagGroupByStar;
        } else {
            flagGroupByStar = false;
        }
        if (!flagGroupByStar) {
            for (CriteriaItem ci : this.items) {
                if (!ci.isGrouping()) continue;
                result.add(ci.getGroupByItem());
            }
        }
        if (result.getCount() == 0 && !result.groupByStar) {
            result.dispose();
            result = null;
        }
        return result;
    }

    public SQLOrderByClause getOrderByClause() {
        SQLOrderByClause result;
        if (this.orderByItems.size() > 0) {
            result = this.astOrderBy != null ? (SQLOrderByClause)this.astOrderBy.clone(this.sqlContext) : new SQLOrderByClause(this.sqlContext);
            for (int i = 0; i < this.orderByItems.size(); ++i) {
                result.add(this.orderByItems.get(i).getOrderByItem());
            }
        } else {
            result = null;
        }
        return result;
    }

    public CriteriaItem findField(DataSource datasource, SQLQualifiedName fieldName) {
        CriteriaItem result = null;
        for (int i = 0; i < this.getCount(); ++i) {
            CriteriaItem si = this.get(i);
            if (si.getExpressionDatasourceAST() != datasource.astFromSource || (fieldName != null || si.getExpressionColumnAST() != null) && (fieldName == null || si.getExpressionColumnAST() == null || this.getQueryBuilder().getSQLContext().compareQualifiedNames(si.getExpressionColumnAST(), fieldName) != 0)) continue;
            result = si;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CriteriaItem insertField(int index, DataSource datasource, SQLQualifiedName fieldName) {
        CriteriaItem result = null;
        this.beginUpdate();
        try {
            result = this.insertEmptyRow(index);
            result.setFieldExpression(datasource, fieldName);
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    public CriteriaItem addField(DataSource datasource, String fieldName) {
        CriteriaItem result = null;
        SQLQualifiedName field = this.getSQLContext().parseQualifiedNameQuoteIfNeed(fieldName);
        if (field == null) {
            throw new QueryBuilderException(Helpers.localizer.getString("strBadFieldName", "Invalid field name: \"%1$s\""));
        }
        result = this.addField(datasource, field);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CriteriaItem addField(DataSource datasource, SQLQualifiedName fieldName) {
        CriteriaItem result;
        if (this.getCount() == 0) {
            result = this.addEmptyRow();
        } else {
            result = this.get(this.getCount() - 1);
            if (!Str.IsNullOrEmpty(result.getExpressionString())) {
                result = this.addEmptyRow();
            }
        }
        this.beginUpdate();
        try {
            result.setFieldExpression(datasource, fieldName);
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CriteriaItem insertExpression(int index, String expression) throws QueryBuilderException {
        CriteriaItem result = null;
        this.beginUpdate();
        try {
            result = this.insertEmptyRow(index);
            result.setExpressionString(expression);
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CriteriaItem addExpression(String expression) throws QueryBuilderException {
        CriteriaItem result;
        if (this.getCount() == 0) {
            result = this.addEmptyRow();
        } else {
            result = this.items.get(this.getCount() - 1);
            if (!Str.IsNullOrEmpty(result.getExpressionString())) {
                result = this.addEmptyRow();
            }
        }
        this.beginUpdate();
        try {
            result.setExpressionString(expression);
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFields(DataSource datasource, SQLQualifiedName fieldName) {
        this.beginUpdate();
        try {
            int i;
            ArrayList<CriteriaItem> l = new ArrayList<CriteriaItem>();
            for (i = 0; i < this.getCount(); ++i) {
                CriteriaItem ci = this.items.get(i);
                if (ci.getExpressionDatasourceAST() != datasource.astFromSource || (fieldName != null || ci.getExpressionColumnAST() != null) && (fieldName == null || ci.getExpressionColumnAST() == null || this.getQueryBuilder().getSQLContext().compareQualifiedNames(ci.getExpressionColumnAST(), fieldName) != 0)) continue;
                try {
                    ci.setSelected(false);
                    if (!ci.isExpressionOnly()) continue;
                    l.add(ci);
                    ci.clear();
                    continue;
                }
                catch (QueryBuilderException ex) {
                    Logger.getLogger(CriteriaList.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (l.size() != 0) {
                int last = this.getCount() - 1;
                for (i = this.getCount() - 1; i >= 0; --i) {
                    if (this.items.get((int)i).astExpression == null) continue;
                    last = i;
                    break;
                }
                for (i = 0; i < l.size(); ++i) {
                    int cur = this.items.indexOf(l.get(i));
                    if (cur >= last) continue;
                    Helpers.listMove(this.items, cur, last);
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    void languageChanged() {
        if (this.controls.size() >= 1) {
            ((CriteriaListControl)this.controls.get(0)).updateHeaders();
        }
        super.languageChanged();
    }

    public void startConditionsLoading() {
        for (int i = 0; i < this.getCount(); ++i) {
            this.items.get(i).startConditionsLoading();
        }
    }

    public void finalizeLoading() {
        for (int i = 0; i < this.getCount(); ++i) {
            this.items.get(i).finalizeLoading();
        }
    }

    public int getMaxConditionCount() {
        return this.getMaxConditionCountInternal(Helpers.conditionsAll);
    }

    private int getMaxConditionCountInternal(EnumSet<ConditionType> conditionTypes) {
        int result = 0;
        for (int i = 0; i < this.getCount(); ++i) {
            if (!conditionTypes.contains((Object)this.items.get((int)i).conditionType) || this.items.get(i).getConditionCount() <= result) continue;
            this.items.get(i).shrinkConditionList();
            int j = this.items.get(i).getConditionCount();
            if (j <= result) continue;
            result = j;
        }
        return result;
    }

    public boolean isAliasAssigned(AstTokenIdentifier alias) {
        for (int i = 0; i < this.getCount(); ++i) {
            CriteriaItem criteriaItem = this.get(i);
            if (criteriaItem.astAlias == null || this.sqlContext.compareTokens(alias, criteriaItem.astAlias.alias) != 0) continue;
            return true;
        }
        return false;
    }

    public AstTokenIdentifier createUniqueAlias(String prefix) {
        AstTokenIdentifier result = new AstTokenIdentifier(this.sqlContext);
        for (int i = 0; i < 0x7FFFFFFE; ++i) {
            result.setToken(prefix + (i > 0 ? String.valueOf(i) : ""));
            if (this.isUniqueColumnName(result) && !this.isAliasAssigned(result)) break;
        }
        return result;
    }

    public boolean isUniqueColumnName(AstTokenIdentifier alias) {
        return this.isUniqueColumnName(alias, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUniqueColumnName(AstTokenIdentifier alias, CriteriaItem forCriteriaItem) {
        for (int i = 0; i < this.getCount(); ++i) {
            CriteriaItem criteriaItem = this.items.get(i);
            if (!criteriaItem.isSelected() || criteriaItem == forCriteriaItem) continue;
            AstIdentifierList occupiedNames = criteriaItem.getOccupiedColumnNames();
            try {
                if (occupiedNames == null || occupiedNames.findByIdToken(alias) == -1) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                if (occupiedNames != null) {
                    occupiedNames.dispose();
                }
            }
        }
        return true;
    }

    public boolean isQueryWithGrouping() {
        for (int i = 0; i < this.getCount(); ++i) {
            if (!this.get(i).isGrouping()) continue;
            return true;
        }
        return false;
    }
}

