/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.metadata;

import com.adbs.ast.BaseSQLContext;
import com.adbs.metadata.MetadataFieldsFetcherFromResultSet;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;

public class MetadataFieldsFetcherFromQuery
extends MetadataFieldsFetcherFromResultSet {
    private String query;

    public MetadataFieldsFetcherFromQuery(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public void dispose() {
        this.destroyResultSet();
        super.dispose();
    }

    @Override
    protected void init() throws QueryBuilderException {
        if (!this.isResultSetCreated()) {
            this.createResultSet();
        }
        super.init();
    }

    @Override
    protected void close() {
        this.destroyResultSet();
        super.close();
    }

    public void createResultSet() throws QueryBuilderException {
        if (!this.sqlContext.getMetadataProvider().canExecSQL()) {
            throw new QueryBuilderException(Helpers.localizer.getString("strMetadataProviderCantExecSQL", "Used metadata provider cannot execute SQL queries."));
        }
        this.resultSet.setResultSet(this.sqlContext.getMetadataProvider().execSQL(this.query, false));
    }

    public void destroyResultSet() {
        this.resultSet.close();
    }

    public boolean isResultSetCreated() {
        return this.resultSet.getResultSet() != null;
    }
}

