/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstFieldList;
import com.adbs.ast.AstNodeWithList;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLExpressionBrackets;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLFromClause;
import com.adbs.ast.SQLFromGroup;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLGroupByList;
import com.adbs.ast.SQLOrderByClause;
import com.adbs.ast.SQLSelectItem;
import com.adbs.ast.SQLSelectItemAllColumns;
import com.adbs.ast.SQLSelectItemAllTableColumns;
import com.adbs.ast.SQLSelectItemExpression;
import com.adbs.ast.SQLSelectItems;
import com.adbs.ast.SQLSubQueryExpression;
import com.adbs.ast.SQLSubQuerySelectMode;
import com.adbs.utils.Helpers;
import com.adbs.utils.Wrapper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLSubQuerySelectExpression
extends SQLSubQueryExpression {
    public MetadataFieldList fieldList;
    public SQLSubQuerySelectMode selectMode;
    public SQLSelectItems selectItems;
    public SQLFromClause from;
    public SQLExpressionItem where;
    public SQLGroupByList groupBy;
    public SQLExpressionItem having;
    public SQLOrderByClause orderBy;

    public SQLSubQuerySelectExpression(BaseSQLContext sqlContext) {
        super(sqlContext);
        this.fieldList = new MetadataFieldList(null, sqlContext);
    }

    @Override
    public void dispose() {
        this.fieldList.dispose();
        super.dispose();
    }

    @Override
    protected void getASTFields(AstFieldList l) {
        super.getASTFields(l);
        try {
            l.add(SQLSubQuerySelectExpression.class.getField("selectMode"));
            l.add(SQLSubQuerySelectExpression.class.getField("selectItems"));
            l.add(SQLSubQuerySelectExpression.class.getField("from"));
            l.add(SQLSubQuerySelectExpression.class.getField("where"));
            l.add(SQLSubQuerySelectExpression.class.getField("groupBy"));
            l.add(SQLSubQuerySelectExpression.class.getField("having"));
            l.add(SQLSubQuerySelectExpression.class.getField("orderBy"));
        }
        catch (Exception ex) {
            Logger.getLogger(SQLSubQuerySelectExpression.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private int addSelectExpressionColumn(SQLSelectItemExpression selectItem, Wrapper<Integer> fieldNumber) {
        Wrapper<Integer> wrapper;
        MetadataField f;
        if (selectItem.alias != null) {
            f = this.fieldList.get((Integer)fieldNumber.value);
            wrapper = fieldNumber;
            Object e = wrapper.value;
            wrapper.value = (Integer)wrapper.value + 1;
            Integer n = wrapper.value;
        } else if (selectItem.expression != null) {
            SQLExpressionItem ei = selectItem.expression;
            if ((ei = Helpers.expressionRemoveBrackets(ei)) != null && ei instanceof SQLExpressionBrackets) {
                f = this.fieldList.get((Integer)fieldNumber.value);
                wrapper = fieldNumber;
                Object e = wrapper.value;
                wrapper.value = (Integer)wrapper.value + 1;
                Integer n = wrapper.value;
            } else {
                f = null;
            }
        } else {
            f = null;
        }
        int result = 0;
        if (f != null) {
            f.prepareStatsCollections();
            result += f.getUsedDatabaseObjects().addObjects(selectItem.getUsedDatabaseObjects());
            result += f.getUsedDatabaseObjectColumns().addColumns(selectItem.getUsedDatabaseObjectColumns());
        }
        return result;
    }

    private int addAllColumnsOfFromItem(SQLSelectItem selectItem, Wrapper<Integer> fieldNumber, SQLFromSource fs) {
        int result = 0;
        for (int i = 0; i < fs.getFieldList().getCount(); ++i) {
            MetadataField sf = fs.getFieldList().get(i);
            if (!sf.isVirtualCalculatedField()) continue;
            MetadataField df = this.fieldList.get((Integer)fieldNumber.value);
            df.prepareStatsCollections();
            Wrapper<Integer> wrapper = fieldNumber;
            Object e = wrapper.value;
            wrapper.value = (Integer)wrapper.value + 1;
            Integer n = wrapper.value;
            result += df.getUsedDatabaseObjects().addObjects(sf.getUsedDatabaseObjects());
            result += df.getUsedDatabaseObjectColumns().addColumns(sf.getUsedDatabaseObjectColumns());
            result += selectItem.getUsedDatabaseObjects().addObjects(sf.getUsedDatabaseObjects());
            result += selectItem.getUsedDatabaseObjectColumns().addColumns(sf.getUsedDatabaseObjectColumns());
        }
        return result;
    }

    private int addAllColumnsOfFromGroup(SQLSelectItem selectItem, Wrapper<Integer> fieldNumber, SQLFromGroup fi) {
        int result = 0;
        for (int i = 0; i < fi.getCount(); ++i) {
            SQLFromSource fs = fi.get(i);
            if (fs instanceof SQLFromGroup) {
                result += this.addAllColumnsOfFromGroup(selectItem, fieldNumber, (SQLFromGroup)fs);
                continue;
            }
            result += this.addAllColumnsOfFromItem(selectItem, fieldNumber, fs);
        }
        return result;
    }

    @Override
    protected int calcStatistics() {
        int result = 0;
        Wrapper<Integer> fieldNum = new Wrapper<Integer>(0);
        if (this.selectItems != null) {
            for (int i = 0; i < this.selectItems.getCount(); ++i) {
                SQLSelectItem si = this.selectItems.get(i);
                if (si instanceof SQLSelectItemExpression) {
                    result += this.addSelectExpressionColumn((SQLSelectItemExpression)si, fieldNum);
                    continue;
                }
                if (si instanceof SQLSelectItemAllTableColumns && this.from != null && ((SQLSelectItemAllTableColumns)si).databaseObject != null && ((SQLSelectItemAllTableColumns)si).databaseObject.datasource != null) {
                    result += this.addAllColumnsOfFromItem(si, fieldNum, ((SQLSelectItemAllTableColumns)si).databaseObject.datasource);
                    continue;
                }
                if (!(si instanceof SQLSelectItemAllColumns) || this.from == null) continue;
                result += this.addAllColumnsOfFromGroup(si, fieldNum, this.from);
            }
        }
        return result += super.calcStatistics();
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        this.buildSelectList(builder, format);
        this.buildFromClause(builder, format);
        this.buildWhereClause(builder, format);
        this.buildGroupByClause(builder, format);
        this.buildHavingClause(builder, format);
        this.buildOrderByClause(builder, format);
    }

    public void buildSelectList(SQLBuilder builder, SQLBuilderSelectFormat format) {
        builder.writeKeyword("Select");
        builder.addIndent(format.getIndentInPart());
        this.buildSelectMode(builder, format);
        if (format.getNewLineAfterPartKeywords()) {
            builder.newLine();
        }
        this.buildSelectListItems(builder, format);
        builder.endIndent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildSelectListItems(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.selectItems != null && this.selectItems.getCount() > 0) {
            if (!format.getNewLineAfterPartKeywords()) {
                builder.space();
            }
            AstNodeWithList separator = new AstNodeWithList(this.sqlContext);
            try {
                if (format.getSelectListFormat().getNewLineBeforeComma()) {
                    separator.addNewLine();
                }
                separator.addSymbol(",");
                if (format.getSelectListFormat().getNewLineAfterItem()) {
                    separator.addNewLine();
                } else {
                    separator.addSpace();
                }
                this.selectItems.buildList(builder, format, separator);
            }
            finally {
                separator.dispose();
            }
        }
    }

    public void buildFromClause(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.from != null) {
            builder.newLineOrSpace(format.getMainPartsFromNewLine(), 0);
            builder.writeKeyword("From");
            builder.addIndent(format.getIndentInPart());
            builder.newLineOrSpace(format.getNewLineAfterPartKeywords());
            this.from.buildSQL(builder, format);
            builder.endIndent();
        }
    }

    public void buildWhereClause(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.where != null) {
            builder.newLineOrSpace(format.getMainPartsFromNewLine(), 0);
            builder.writeKeyword("Where");
            builder.addIndent(format.getIndentInPart());
            builder.newLineOrSpace(format.getNewLineAfterPartKeywords());
            this.where.buildSQLCosmetic(builder, format, format.getWhereFormat(), 0);
            builder.endIndent();
        }
    }

    public void buildGroupByClause(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.groupBy != null) {
            builder.newLineOrSpace(format.getMainPartsFromNewLine(), 1);
            this.groupBy.buildGroupByKeywords(builder, format);
            builder.addIndent(format.getIndentInPart());
            builder.newLineOrSpace(format.getNewLineAfterPartKeywords());
            this.groupBy.buildSQL(builder, format);
            builder.endIndent();
        }
    }

    public void buildHavingClause(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.having != null) {
            builder.newLineOrSpace(format.getMainPartsFromNewLine(), 1);
            builder.writeKeyword("Having");
            builder.addIndent(format.getIndentInPart());
            builder.newLineOrSpace(format.getNewLineAfterPartKeywords());
            this.having.buildSQLCosmetic(builder, format, format.getHavingFormat(), 0);
            builder.endIndent();
        }
    }

    public void buildOrderByClause(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.orderBy != null) {
            builder.newLineOrSpace(format.getMainPartsFromNewLine(), 1);
            this.orderBy.buildOrderByKeywords(builder, format);
            builder.addIndent(format.getIndentInPart());
            builder.newLineOrSpace(format.getNewLineAfterPartKeywords());
            this.orderBy.buildOrderByList(builder, format, format.getOrderByFormat());
            builder.endIndent();
        }
    }

    private void addAllColumnsOfFromSource(SQLFromSource fs) {
        for (int i = 0; i < fs.getFieldList().getCount(); ++i) {
            MetadataField fi = this.fieldList.add();
            fi.assign(fs.getFieldList().get(i));
        }
    }

    private void addAllColumnsOfFromItem(SQLFromGroup fi) {
        for (int i = 0; i < fi.getCount(); ++i) {
            SQLFromSource fs = fi.get(i);
            if (fs instanceof SQLFromGroup) {
                this.addAllColumnsOfFromItem((SQLFromGroup)fs);
                continue;
            }
            this.addAllColumnsOfFromSource(fs);
        }
    }

    public void buildSelectMode(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.selectMode != null) {
            builder.space();
            this.selectMode.buildSQL(builder, format);
        }
    }
}

