/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.IdentQuotation;
import com.adbs.ast.MetadataField;
import com.adbs.ast.SQLAliasObjectAlias;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLFromFunction;
import com.adbs.ast.SQLFromObject;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLWithClauseItem;
import com.adbs.utils.Str;
import java.util.ArrayList;
import java.util.List;

public class SQLObjectColumn
extends SQLQualifiedName {
    public SQLFromSource datasource;
    public boolean outerJoin;
    private MetadataField metadataField;

    public SQLObjectColumn(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    @Override
    public void dispose() {
        this.setMetadataField(null);
        this.datasource = null;
        super.dispose();
    }

    public MetadataField getMetadataField() {
        return this.metadataField;
    }

    public void setMetadataField(MetadataField value) {
        if (this.metadataField != value) {
            if (value != null) {
                if (this.metadataField == null) {
                    this.metadataField = new MetadataField(null, this.sqlContext);
                }
                this.metadataField.assign(value);
            } else if (this.metadataField != null) {
                this.metadataField.dispose();
                this.metadataField = null;
            }
        }
    }

    @Override
    protected int calcStatistics() {
        int result = super.calcStatistics();
        if (this.datasource != null) {
            if (this.datasource instanceof SQLFromObject) {
                if (((SQLFromObject)this.datasource).getCTEObject() == null) {
                    result = ((SQLFromObject)this.datasource).getMetadataObject() != null ? (result += this.getUsedDatabaseObjects().addObjectIfNotExists(((SQLFromObject)this.datasource).getMetadataObject(), ((SQLFromObject)this.datasource).getMetadataObject().getFullName(), ((SQLFromObject)this.datasource).alias)) : (result += this.getUsedDatabaseObjects().addObjectIfNotExists(null, ((SQLFromObject)this.datasource).fromObj, ((SQLFromObject)this.datasource).alias));
                } else {
                    SQLWithClauseItem cte = ((SQLFromObject)this.datasource).getCTEObject();
                    result += this.getUsedDatabaseObjects().addObjects(cte.getUsedDatabaseObjects());
                }
            } else if (this.datasource instanceof SQLFromFunction) {
                result += this.getUsedDatabaseObjects().addObjectIfNotExists(null, ((SQLFromFunction)this.datasource).name, ((SQLFromFunction)this.datasource).alias);
            }
        }
        if (this.datasource != null) {
            int i = this.datasource.getFieldList().findFieldByName(this);
            if (i != -1) {
                MetadataField f = this.datasource.getFieldList().get(i);
                result += this.getUsedDatabaseObjects().addObjects(f.getUsedDatabaseObjects());
                result += this.getUsedDatabaseObjectColumns().addColumns(f.getUsedDatabaseObjectColumns());
            } else {
                SQLQualifiedName objName = new SQLQualifiedName(this.sqlContext);
                if (this.datasource instanceof SQLFromObject) {
                    objName.assign(((SQLFromObject)this.datasource).fromObj);
                } else if (this.datasource instanceof SQLFromFunction) {
                    objName.assign(((SQLFromFunction)this.datasource).name);
                }
                SQLQualifiedName fieldName = new SQLQualifiedName(this.sqlContext);
                fieldName.assign(this);
                result += this.getUsedDatabaseObjectColumns().addColumnIfNotExists(null, objName, null, fieldName);
                fieldName.dispose();
                objName.dispose();
            }
        }
        return result;
    }

    @Override
    protected void restoreColumnPrefix() {
        if (this.datasource != null) {
            if (this.datasource.alias != null) {
                this.addPrefix(this.datasource.alias.alias.clone(this.sqlContext));
            } else if (this.datasource instanceof SQLFromObject) {
                for (int i = 0; i < ((SQLFromObject)this.datasource).fromObj.getCount(); ++i) {
                    this.addPrefix(((SQLFromObject)this.datasource).fromObj.get(i).clone(this.sqlContext));
                }
                assert (this.dbLink == null);
                if (((SQLFromObject)this.datasource).fromObj.dbLink != null) {
                    this.dbLink = ((SQLFromObject)this.datasource).fromObj.dbLink.clone(this.sqlContext);
                }
            }
        }
        this.datasource = null;
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof SQLObjectColumn) {
            this.datasource = ((SQLObjectColumn)source).datasource;
            this.outerJoin = ((SQLObjectColumn)source).outerJoin;
            this.setMetadataField(((SQLObjectColumn)source).getMetadataField());
        }
    }

    @Override
    public void getReferencedColumns(List l) {
        super.getReferencedColumns(l);
        if (l.indexOf(this) == -1) {
            l.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.datasource != null) {
            if (this.getMetadataField() != null && builder.isExpandVirtualFields() && this.getMetadataField().isVirtualCalculatedField()) {
                SQLExpressionItem ei = this.getMetadataField().getExpressionAST().clone(this.sqlContext);
                try {
                    ArrayList lCTE = new ArrayList();
                    ArrayList<SQLFromSource> lFromObj = new ArrayList<SQLFromSource>();
                    lFromObj.add(this.datasource);
                    SQLAliasObjectAlias aliasBackup = this.datasource.alias;
                    try {
                        this.datasource.alias = null;
                        ei.prepareAndFixupRecursive(lCTE, lFromObj);
                    }
                    finally {
                        this.datasource.alias = aliasBackup;
                    }
                    ei.buildSQL(builder, format);
                }
                finally {
                    ei.dispose();
                }
            }
            if (this.datasource.buildColumnPrefix(builder, format)) {
                builder.writeSymbol(".");
            }
            this.buildQualifiedNameNames(builder, format);
            this.datasource.buildColumnSuffix(builder, format);
        } else {
            super.buildSQLDirect(builder, format);
        }
        if (this.outerJoin) {
            builder.writeSymbol("(+)");
        }
    }

    @Override
    public void getReferencedDatasources(List l) {
        super.getReferencedDatasources(l);
        if (this.datasource != null && l.indexOf(this.datasource) == -1) {
            l.add(this.datasource);
        }
    }

    @Override
    public void buildQualifiedNameNames(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.datasource != null && this.getCount() > 0) {
            if (this.getMetadataField() != null && builder.isUseAltNames() && !Str.IsNullOrEmpty(this.getMetadataField().getAltName())) {
                String altName = this.getMetadataField().getAltName();
                if (builder.getQuoteIdentifiers() == IdentQuotation.None || this.sqlContext.isValidIdent(altName) && builder.getQuoteIdentifiers() != IdentQuotation.All) {
                    builder.writeIdentifier(altName);
                } else {
                    builder.writeIdentifier(this.sqlContext.getSyntaxProvider().getQuoteBegin() + altName + this.sqlContext.getSyntaxProvider().getQuoteEnd());
                }
            } else {
                super.buildQualifiedNameNames(builder, format);
            }
        } else {
            super.buildQualifiedNameNames(builder, format);
        }
    }

    @Override
    public void getAllTokensToCompare(List list) {
        if (this.datasource != null) {
            if (this.datasource.alias != null) {
                list.add(this.datasource.alias.alias);
            } else if (this.datasource instanceof SQLFromObject) {
                ((SQLFromObject)this.datasource).fromObj.getAllTokensToCompare(list);
            }
        }
        super.getAllTokensToCompare(list);
    }

    @Override
    protected boolean replaceReferencesToDatasource(SQLFromSource fsFrom, SQLFromSource fsTo) {
        boolean result;
        boolean bl = result = this.datasource == fsFrom;
        if (result) {
            this.datasource = fsTo;
        }
        return result;
    }
}

