/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstNode;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderFromClauseFormat;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLFromSource;
import java.util.ArrayList;
import java.util.List;

public class SQLFromGroup
extends SQLFromSource {
    public final ArrayList<SQLFromSource> items = new ArrayList();

    public SQLFromGroup(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    public int getCount() {
        return this.items.size();
    }

    public SQLFromSource get(int index) {
        return this.items.get(index);
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof SQLFromGroup) {
            this.clear();
            for (int i = 0; i < ((SQLFromGroup)source).getCount(); ++i) {
                this.add(((SQLFromGroup)source).get(i).clone(this.sqlContext));
            }
        }
    }

    @Override
    public void getMyChildren(List l) {
        super.getMyChildren(l);
        int index = this.findFirstChildIndexForClass(SQLFromGroup.class);
        for (int i = this.getCount() - 1; i >= 0; --i) {
            l.add(index, this.get(i));
        }
    }

    private void buildItem(SQLBuilder builder, SQLBuilderSelectFormat format, SQLFromSource item) {
        if (item instanceof SQLFromGroup) {
            builder.writeSymbol("(");
            item.buildSQL(builder, format);
            builder.writeSymbol(")");
        } else {
            item.buildSQL(builder, format);
        }
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        for (int i = 0; i < this.getCount(); ++i) {
            SQLBuilderFromClauseFormat fromClauseFormat = format.getFromClauseFormat();
            if (i > 0) {
                if (this.items.get((int)i).joinKind != null) {
                    builder.newLineOrSpace(fromClauseFormat.getNewLineAfterDatasource());
                } else if (fromClauseFormat.getNewLineBeforeComma()) {
                    builder.newLine();
                }
                this.items.get(i).buildJoinOperator(builder, format);
                if (this.items.get((int)i).joinKind == null) {
                    builder.newLineOrSpace(!fromClauseFormat.getNewLineBeforeComma() && (fromClauseFormat.getNewLineAfterJoin() || fromClauseFormat.getNewLineAfterDatasource()));
                } else {
                    builder.newLineOrSpace(fromClauseFormat.getNewLineAfterJoin());
                }
            }
            this.buildItem(builder, format, this.items.get(i));
            if (this.items.get((int)i).joinOn == null) continue;
            builder.addIndent(format.getIndentInPart());
            builder.newLineOrSpace(fromClauseFormat.getNewLineBeforeJoinExpression());
            builder.writeKeyword("On");
            builder.space();
            this.items.get((int)i).joinOn.buildSQLCosmetic(builder, format, fromClauseFormat.getJoinConditionFormat(), 0);
            builder.endIndent();
        }
    }

    @Override
    public void buildExpression(SQLBuilder builder, SQLBuilderSelectFormat format) {
        this.buildSQL(builder, format);
    }

    public int add(SQLFromSource joined) {
        this.items.add(joined);
        return this.items.size() - 1;
    }

    public int indexOf(SQLFromSource fs) {
        return this.items.indexOf(fs);
    }

    public void delete(int index) {
        SQLFromSource n = this.get(index);
        this.items.remove(index);
        if (n != null) {
            ((AstNode)n).dispose();
        }
    }

    public SQLFromSource extract(SQLFromSource item) {
        int x = this.items.indexOf(item);
        if (x != -1) {
            this.items.remove(x);
            return item;
        }
        return null;
    }

    public SQLFromSource extract(int index) {
        if (index >= 0 && index < this.items.size()) {
            SQLFromSource item = this.items.get(index);
            this.items.remove(index);
            return item;
        }
        return null;
    }

    public void clear() {
        for (int i = 0; i < this.getCount(); ++i) {
            this.get(i).dispose();
        }
        this.items.clear();
    }

    @Override
    public void calcFieldList(List cteList, List fromSourcesList, boolean calcFieldUsageStats) {
        this.getFieldList().clear();
    }
}

