/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstFieldList;
import com.adbs.ast.AstNodeWithList;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLQualifiedName;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLExpressionFunction
extends SQLExpressionItem {
    public SQLQualifiedName name;
    public AstNodeWithList params;

    public SQLExpressionFunction(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    @Override
    protected void getASTFields(AstFieldList l) {
        super.getASTFields(l);
        try {
            l.add(SQLExpressionFunction.class.getField("name"));
            l.add(SQLExpressionFunction.class.getField("params"));
        }
        catch (Exception ex) {
            Logger.getLogger(SQLExpressionFunction.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildBuiltinFunctionName(SQLBuilder builder, SQLBuilderSelectFormat format, SQLQualifiedName name) {
        SQLQualifiedName qn = name.clone(this.sqlContext);
        try {
            this.sqlContext.builtinFunctionNormalize(qn);
            qn.buildSQL(builder, format);
        }
        finally {
            qn.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.name != null) {
            if (this.sqlContext.isNameOfBuiltinFunction(this.name)) {
                this.buildBuiltinFunctionName(builder, format, this.name);
            } else {
                this.name.buildSQL(builder, format);
            }
        }
        builder.writeSymbol("(");
        if (this.params != null) {
            AstNodeWithList separator = new AstNodeWithList(this.sqlContext);
            try {
                separator.addSymbol(",");
                separator.addSpace();
                this.params.buildList(builder, format, separator);
            }
            finally {
                separator.dispose();
            }
        }
        builder.writeSymbol(")");
    }
}

