/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstToken;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.ObjectPrefixSkipping;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLFromFunction;
import com.adbs.ast.SQLFromObject;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLWithClauseItem;
import com.adbs.utils.Helpers;
import java.util.List;

public class SQLDatabaseObject
extends SQLQualifiedName {
    public SQLFromSource datasource;

    public SQLDatabaseObject(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof SQLDatabaseObject) {
            this.datasource = ((SQLDatabaseObject)source).datasource;
        }
    }

    @Override
    public void getReferencedDatasources(List l) {
        super.getReferencedDatasources(l);
        if (this.datasource != null && l.indexOf(this.datasource) == -1) {
            l.add(this.datasource);
        }
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.datasource != null) {
            ((SQLFromObject)this.datasource).buildColumnPrefix(builder, format);
            ((SQLFromObject)this.datasource).buildColumnSuffix(builder, format);
        } else {
            super.buildSQLDirect(builder, format);
        }
    }

    @Override
    protected int calcStatistics() {
        int result = super.calcStatistics();
        if (this.datasource != null) {
            if (this.datasource instanceof SQLFromObject) {
                if (((SQLFromObject)this.datasource).getCTEObject() == null) {
                    result = ((SQLFromObject)this.datasource).getMetadataObject() != null ? (result += this.getUsedDatabaseObjects().addObjectIfNotExists(((SQLFromObject)this.datasource).getMetadataObject(), ((SQLFromObject)this.datasource).getMetadataObject().getFullName(), ((SQLFromObject)this.datasource).alias)) : (result += this.getUsedDatabaseObjects().addObjectIfNotExists(null, ((SQLFromObject)this.datasource).fromObj, ((SQLFromObject)this.datasource).alias));
                } else {
                    SQLWithClauseItem cte = ((SQLFromObject)this.datasource).getCTEObject();
                    result += this.getUsedDatabaseObjects().addObjects(cte.getUsedDatabaseObjects());
                }
            } else if (this.datasource instanceof SQLFromFunction) {
                result += this.getUsedDatabaseObjects().addObjectIfNotExists(null, ((SQLFromFunction)this.datasource).name, ((SQLFromFunction)this.datasource).alias);
            }
        }
        return result;
    }

    private void buildDatabaseName(SQLBuilder builder, SQLBuilderSelectFormat format, SQLQualifiedName database) {
        database.buildQualifiedNameNames(builder, format);
        builder.writeSymbol(".");
    }

    private void buildSchemaName(SQLBuilder builder, SQLBuilderSelectFormat format, AstToken schema) {
        schema.buildSQL(builder, format);
        builder.writeSymbol(this.sqlContext.getSyntaxProvider().getObjectNameSeparator());
    }

    @Override
    protected void restoreColumnPrefix() {
        if (!(this.datasource == null || this.datasource instanceof SQLFromObject && ((SQLFromObject)this.datasource).fromObj == this || this.datasource instanceof SQLFromFunction && ((SQLFromFunction)this.datasource).name == this)) {
            if (this.datasource.alias != null) {
                this.addPrefix(this.datasource.alias.alias.clone(this.sqlContext));
            } else if (this.datasource instanceof SQLFromObject) {
                for (int i = 0; i < ((SQLFromObject)this.datasource).fromObj.getCount(); ++i) {
                    this.addPrefix(((SQLFromObject)this.datasource).fromObj.get(i).clone(this.sqlContext));
                }
                assert (this.dbLink == null);
                if (((SQLFromObject)this.datasource).fromObj.dbLink != null) {
                    this.dbLink = ((SQLFromObject)this.datasource).fromObj.dbLink.clone(this.sqlContext);
                }
            }
        }
        this.datasource = null;
    }

    @Override
    public void buildQualifiedNameNames(SQLBuilder builder, SQLBuilderSelectFormat format) {
        assert (this.sqlContext.getSyntaxProvider() != null);
        if (this.datasource != null) {
            this.datasource.buildColumnPrefix(builder, format);
        } else {
            this.buildQualifiedNameNamesFull(builder, format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void buildQualifiedNameNamesFull(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.sqlContext.getMetadataContainer() != null && this.datasource != null && this.datasource.getMetadataObject() != null) {
            MetadataObject mo = this.datasource.getMetadataObject();
            SQLQualifiedName qn = mo.getNameAsObject(true, true, true, builder.getObjectPrefixSkipping());
            try {
                AstToken name = qn.extractName();
                try {
                    if (!Helpers.isQualifiedNameEmpty(qn)) {
                        if (qn.getCount() > 0) {
                            qn.buildQualifiedNameNames(builder, format);
                            builder.writeSymbol(this.sqlContext.getSyntaxProvider().getObjectNameSeparator());
                        }
                        name.buildSQL(builder, format);
                        if (qn.dbLink == null) return;
                        qn.buildQualifiedNameDBLink(builder, format);
                        return;
                    }
                    name.buildSQL(builder, format);
                    return;
                }
                finally {
                    name.dispose();
                }
            }
            finally {
                qn.dispose();
            }
        }
        if (this.sqlContext.getMetadataContainer() != null && this.sqlContext.getSyntaxProvider() != null && (this.sqlContext.getSyntaxProvider().isSupportSchemas() && this.sqlContext.getSyntaxProvider().isSupportDatabases() && this.getCount() >= 3 || !this.sqlContext.getSyntaxProvider().isSupportSchemas() && this.sqlContext.getSyntaxProvider().isSupportDatabases() && this.getCount() >= 2 || this.sqlContext.getSyntaxProvider().isSupportSchemas() && !this.sqlContext.getSyntaxProvider().isSupportDatabases() && this.getCount() >= 2)) {
            SQLQualifiedName db = new SQLQualifiedName(this.sqlContext);
            try {
                db.assign(this);
                AstToken name = db.extractName();
                try {
                    AstToken schema = this.sqlContext.getSyntaxProvider().isSupportSchemas() ? db.extractName() : null;
                    try {
                        boolean defdb = false;
                        if (db.getCount() > 0) {
                            if (builder.getObjectPrefixSkipping() == ObjectPrefixSkipping.SkipAll || builder.getObjectPrefixSkipping() == ObjectPrefixSkipping.SkipDatabase) {
                                if (Helpers.isQualifiedNameEmpty(this.sqlContext.getMetadataContainer().getDefaultDatabaseName()) || !this.sqlContext.isQualifiedNamesEqual(db, this.sqlContext.getMetadataContainer().getDefaultDatabaseName())) {
                                    this.buildDatabaseName(builder, format, db);
                                } else {
                                    defdb = true;
                                }
                            } else {
                                this.buildDatabaseName(builder, format, db);
                            }
                        } else {
                            boolean bl = defdb = !this.sqlContext.getSyntaxProvider().isSupportDatabases();
                        }
                        if (schema != null) {
                            if (builder.getObjectPrefixSkipping() == ObjectPrefixSkipping.SkipAll) {
                                if (!defdb || this.sqlContext.getMetadataContainer().getDefaultSchemaNames().getCount() == 0 || !this.sqlContext.getMetadataContainer().getDefaultSchemaNames().containsSameId((AstTokenIdentifier)schema)) {
                                    this.buildSchemaName(builder, format, schema);
                                }
                            } else {
                                this.buildSchemaName(builder, format, schema);
                            }
                        }
                    }
                    finally {
                        if (schema != null) {
                            schema.dispose();
                        }
                    }
                    name.buildSQL(builder, format);
                    return;
                }
                finally {
                    if (name != null) {
                        name.dispose();
                    }
                }
            }
            finally {
                if (db != null) {
                    db.dispose();
                }
            }
        }
        for (int i = this.getCount() - 1; i >= 0; --i) {
            this.get(i).buildSQL(builder, format);
            if (i <= 0) continue;
            if (i > 1) {
                builder.writeSymbol(".");
                continue;
            }
            builder.writeSymbol(this.sqlContext.getSyntaxProvider().getObjectNameSeparator());
        }
    }

    @Override
    public void getAllTokensToCompare(List list) {
        if (this.datasource == null || this.datasource instanceof SQLFromObject && ((SQLFromObject)this.datasource).fromObj == this || this.datasource instanceof SQLFromFunction && ((SQLFromFunction)this.datasource).name == this) {
            super.getAllTokensToCompare(list);
        } else if (this.datasource.alias != null) {
            list.add(this.datasource.alias.alias);
        } else if (this.datasource instanceof SQLFromObject) {
            ((SQLFromObject)this.datasource).fromObj.getAllTokensToCompare(list);
        }
    }

    @Override
    protected boolean replaceReferencesToDatasource(SQLFromSource fsFrom, SQLFromSource fsTo) {
        boolean result;
        boolean bl = result = this.datasource == fsFrom;
        if (result) {
            this.datasource = fsTo;
        }
        return result;
    }
}

