/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderElement;
import com.adbs.ast.SQLBuilderElementType;
import com.adbs.ast.UpdatablePersistent;
import com.adbs.utils.Str;
import java.util.ArrayList;

public class SQLBuilderPiped
extends SQLBuilder {
    private ArrayList buf = new ArrayList();
    private boolean dynamicIndents = false;
    private boolean dynamicRightMargin = false;

    public SQLBuilderPiped(UpdatablePersistent parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Object source) {
        if (source instanceof SQLBuilderPiped) {
            this.beginUpdate();
            try {
                super.assign(source);
                this.setDynamicIndents(((SQLBuilderPiped)source).getDynamicIndents());
                this.setDynamicRightMargin(((SQLBuilderPiped)source).getDynamicRightMargin());
            }
            finally {
                this.endUpdate();
            }
        } else {
            super.assign(source);
        }
    }

    protected SQLBuilderElement addNewStringNode(String str, String stringToWrite) {
        SQLBuilderElement result = new SQLBuilderElement();
        result.elementType = SQLBuilderElementType.String;
        result.val = str;
        result.width = this.calcWeight(str);
        result.valToWrite = !Str.IsNullOrEmpty(stringToWrite) ? stringToWrite : str;
        this.buf.add(result);
        return result;
    }

    private double calcCRScore(SQLBuilderElement e, double currentWidth, double rightMargin) {
        double c = rightMargin - currentWidth;
        if (c < 10.0) {
            c = 10.0 + c / 10.0;
        }
        return 100.0 - (double)e.newLineIndex * c;
    }

    protected void writeBuffer() {
        while (this.buf.size() > 0) {
            SQLBuilderElement element;
            SQLBuilderElement bestCrElement = null;
            double bestCrScore = 0.0;
            double currentWidth = 0.0;
            int i = 0;
            while (i < this.buf.size()) {
                element = (SQLBuilderElement)this.buf.get(i);
                if (!(element.elementType != SQLBuilderElementType.Space && element.elementType != SQLBuilderElementType.NewLinePoint || element.elementType == SQLBuilderElementType.Space && element.newLineIndex == -1)) {
                    double currentCrScore = this.dynamicRightMargin ? this.calcCRScore(element, currentWidth, this.rightWeight) : this.calcCRScore(element, this.getCurrentIndent() + currentWidth, this.rightWeight);
                    if (bestCrElement == null || bestCrScore <= currentCrScore) {
                        bestCrElement = element;
                        bestCrScore = currentCrScore;
                    }
                }
                double elementWidth = element.width;
                if (this.dynamicRightMargin) {
                    if (!(currentWidth + elementWidth <= this.rightWeight)) break;
                    currentWidth += elementWidth;
                    ++i;
                    continue;
                }
                if (!(this.getCurrentIndent() + currentWidth + elementWidth <= this.rightWeight)) break;
                currentWidth += elementWidth;
                ++i;
            }
            if (i == this.buf.size()) {
                bestCrElement = null;
            }
            currentWidth = this.getCurrentIndent();
            while (this.buf.size() > 0 && (bestCrElement == null || this.buf.get(0) != bestCrElement)) {
                element = (SQLBuilderElement)this.buf.get(0);
                switch (element.elementType) {
                    case String: {
                        this.writeStringToResult(element.valToWrite);
                        currentWidth += element.width;
                        break;
                    }
                    case Space: {
                        this.writeStringToResult(element.valToWrite);
                        currentWidth += element.width;
                        break;
                    }
                    case AddIndent: {
                        if (!this.dynamicIndents) {
                            this.doAddIndent(element.addIndent);
                            break;
                        }
                        if (element.addIndent > 0.0) {
                            double additionalIndent = currentWidth - this.getCurrentIndent();
                            if (this.buf.size() > 1) {
                                int nextElemIndex;
                                for (nextElemIndex = 0; nextElemIndex < this.buf.size() && (((SQLBuilderElement)this.buf.get((int)nextElemIndex)).elementType == SQLBuilderElementType.NewLinePoint || ((SQLBuilderElement)this.buf.get((int)nextElemIndex)).elementType == SQLBuilderElementType.AddIndent || ((SQLBuilderElement)this.buf.get((int)nextElemIndex)).elementType == SQLBuilderElementType.EndIndent); ++nextElemIndex) {
                                }
                                if (nextElemIndex < this.buf.size() && ((SQLBuilderElement)this.buf.get((int)nextElemIndex)).elementType == SQLBuilderElementType.Space) {
                                    additionalIndent += 1.0;
                                }
                            }
                            this.doAddIndent(additionalIndent);
                            break;
                        }
                        this.doAddIndent(element.addIndent);
                        break;
                    }
                    case EndIndent: {
                        this.doEndIndent();
                    }
                }
                this.buf.remove(0);
            }
            if (bestCrElement == null) continue;
            this.buf.remove(0);
            this.writeStringToResult(this.newLine);
            this.writeIndent();
        }
    }

    @Override
    protected void beginBuildInternal() {
        super.beginBuildInternal();
        this.buf.clear();
    }

    @Override
    protected void endBuildInternal() {
        this.writeBuffer();
        super.endBuildInternal();
    }

    @Override
    protected void spaceInternal(int newLineIndex) {
        SQLBuilderElement e = new SQLBuilderElement();
        e.elementType = SQLBuilderElementType.Space;
        e.newLineIndex = newLineIndex;
        e.width = this.calcWeight(" ");
        e.valToWrite = " ";
        this.buf.add(e);
    }

    @Override
    protected void newLineInternal() {
        this.writeBuffer();
        this.writeStringToResult(this.newLine);
    }

    @Override
    protected void goodNewLinePosInternal(int newLineIndex) {
        SQLBuilderElement e = new SQLBuilderElement();
        e.elementType = SQLBuilderElementType.NewLinePoint;
        e.newLineIndex = newLineIndex;
        e.width = 0.0;
        this.buf.add(e);
    }

    @Override
    protected void writeKeywordInternal(String keyword) {
        this.addNewStringNode(keyword, "");
    }

    @Override
    protected void writeBuiltinInternal(String builtin) {
        this.addNewStringNode(builtin, "");
    }

    @Override
    protected void writeIdentifierInternal(String identifier) {
        this.addNewStringNode(identifier, "");
    }

    @Override
    protected void writeSymbolInternal(String symbol) {
        this.addNewStringNode(symbol, "");
    }

    @Override
    protected void writeNumberInternal(String number) {
        this.addNewStringNode(number, "");
    }

    @Override
    protected void writeStringInternal(String str) {
        this.addNewStringNode(str, "");
    }

    @Override
    protected void writeCommentInternal(String comment) {
        this.addNewStringNode(comment, "");
    }

    @Override
    public void addIndent(double indent) {
        SQLBuilderElement e = new SQLBuilderElement();
        e.elementType = SQLBuilderElementType.AddIndent;
        e.addIndent = indent;
        e.width = 0.0;
        this.buf.add(e);
    }

    @Override
    public void endIndent() {
        SQLBuilderElement e = new SQLBuilderElement();
        e.elementType = SQLBuilderElementType.EndIndent;
        e.width = 0.0;
        this.buf.add(e);
    }

    public boolean getDynamicIndents() {
        return this.dynamicIndents;
    }

    public void setDynamicIndents(boolean value) {
        if (this.dynamicIndents != value) {
            this.dynamicIndents = value;
            this.notifyUpdated();
        }
    }

    public boolean getDynamicRightMargin() {
        return this.dynamicRightMargin;
    }

    public void setDynamicRightMargin(boolean value) {
        if (this.dynamicRightMargin != value) {
            this.dynamicRightMargin = value;
            this.notifyUpdated();
        }
    }
}

