/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstNode;
import com.adbs.ast.BuildSQLForNodeEvent;
import com.adbs.ast.BuildSQLForNodeEventListener;
import com.adbs.ast.IdentQuotation;
import com.adbs.ast.KeywordFormat;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.ObjectPrefixSkipping;
import com.adbs.ast.SQLBuilderFromClauseFormat;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SkipKeywordMode;
import com.adbs.ast.UpdatablePersistent;
import java.util.ArrayList;
import java.util.Iterator;

public class SQLBuilder
extends UpdatablePersistent {
    private MetadataContainer metadataContainer;
    private boolean newLineWasWritten;
    private boolean spaceWritten;
    private int spaceNewLineIndex;
    private int rightMargin = 80;
    private SQLBuilderSelectFormat subFmt;
    private SQLBuilderSelectFormat mainFmt;
    protected String newLine = "\r\n";
    private ArrayList<Double> indents = new ArrayList();
    private int indentIndex = -1;
    private KeywordFormat keywordFormat = KeywordFormat.FirstUpper;
    private SQLBuilderSelectFormat derFmt;
    private SQLBuilderSelectFormat cteFmt;
    private IdentQuotation quoteIdentifiers = IdentQuotation.IfNeed;
    private ObjectPrefixSkipping objectPrefixSkipping = ObjectPrefixSkipping.SkipAll;
    private boolean useAltNames = true;
    private boolean expandVirtualFields = false;
    private boolean expandVirtualObjects = false;
    private StringBuilder resultExpression = new StringBuilder();
    protected double rightWeight = 80.0;
    private SkipKeywordMode outerKeywordInLinks = SkipKeywordMode.DontCare;
    private SkipKeywordMode innerKeywordInLinks = SkipKeywordMode.DontCare;
    private boolean parenthesizeANDGroups = true;
    private boolean parenthesizeSingleCriterion = false;
    private SkipKeywordMode asKeywordInExpressionAlias = SkipKeywordMode.DontCare;
    private SkipKeywordMode asKeywordInObjectAlias = SkipKeywordMode.DontCare;
    protected ArrayList<BuildSQLForNodeEventListener> beginBuildSQLForNodeEventListenerList = new ArrayList();
    protected ArrayList<BuildSQLForNodeEventListener> endBuildSQLForNodeEventListenerList = new ArrayList();

    public SQLBuilder(UpdatablePersistent parent) {
        super(parent);
        this.mainFmt = new SQLBuilderSelectFormat(this);
        this.subFmt = new SQLBuilderSelectFormat(this);
        this.subFmt.setMainPartsFromNewLine(false);
        SQLBuilderFromClauseFormat fromClauseFormat = this.subFmt.getFromClauseFormat();
        fromClauseFormat.setNewLineAfterDatasource(false);
        fromClauseFormat.setNewLineAfterJoin(false);
        fromClauseFormat.setNewLineBeforeJoinExpression(false);
        fromClauseFormat.setNewLineBeforeComma(false);
        this.derFmt = new SQLBuilderSelectFormat(this);
        this.cteFmt = new SQLBuilderSelectFormat(this);
    }

    @Override
    public void dispose() {
        this.cteFmt.dispose();
        this.derFmt.dispose();
        this.subFmt.dispose();
        this.mainFmt.dispose();
        super.dispose();
    }

    public MetadataContainer getMetadataContainer() {
        return this.metadataContainer;
    }

    public void setMetadataContainer(MetadataContainer value) {
        if (this.metadataContainer != value) {
            this.metadataContainer = value;
            this.notifyUpdated();
        }
    }

    public String getResult() {
        return this.resultExpression.toString();
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(int value) {
        if (this.rightMargin != value) {
            this.rightMargin = value;
            this.rightWeight = this.rightMargin > 0 ? (double)this.rightMargin : 2.147483647E9;
            this.notifyUpdated();
        }
    }

    public KeywordFormat getKeywordFormat() {
        return this.keywordFormat;
    }

    public void setKeywordFormat(KeywordFormat value) {
        if (this.keywordFormat != value) {
            this.keywordFormat = value;
            this.notifyUpdated();
        }
    }

    public IdentQuotation getQuoteIdentifiers() {
        return this.quoteIdentifiers;
    }

    public void setQuoteIdentifiers(IdentQuotation value) {
        if (this.quoteIdentifiers != value) {
            this.quoteIdentifiers = value;
            this.notifyUpdated();
        }
    }

    public SQLBuilderSelectFormat getMainQueryFormat() {
        return this.mainFmt;
    }

    public void setMainQueryFormat(SQLBuilderSelectFormat value) {
        this.mainFmt.assign(value);
    }

    public SQLBuilderSelectFormat getExpressionsSubQueryFormat() {
        return this.subFmt;
    }

    public void setExpressionsSubQueryFormat(SQLBuilderSelectFormat value) {
        this.subFmt.assign(value);
    }

    public SQLBuilderSelectFormat getFromSubQueryFormat() {
        return this.derFmt;
    }

    public void setFromSubQueryFormat(SQLBuilderSelectFormat value) {
        this.derFmt.assign(value);
    }

    public SQLBuilderSelectFormat getCTESubQueryFormat() {
        return this.cteFmt;
    }

    public void setCTESubQueryFormat(SQLBuilderSelectFormat value) {
        this.cteFmt.assign(value);
    }

    public ObjectPrefixSkipping getObjectPrefixSkipping() {
        return this.objectPrefixSkipping;
    }

    public void setObjectPrefixSkipping(ObjectPrefixSkipping value) {
        if (this.objectPrefixSkipping != value) {
            this.objectPrefixSkipping = value;
            this.notifyUpdated();
        }
    }

    public boolean isUseAltNames() {
        return this.useAltNames;
    }

    public void setUseAltNames(boolean value) {
        if (this.useAltNames != value) {
            this.useAltNames = value;
            this.notifyUpdated();
        }
    }

    public SkipKeywordMode getOuterKeywordInLinks() {
        return this.outerKeywordInLinks;
    }

    public void setOuterKeywordInLinks(SkipKeywordMode value) {
        if (this.outerKeywordInLinks != value) {
            this.outerKeywordInLinks = value;
            this.notifyUpdated();
        }
    }

    public SkipKeywordMode getInnerKeywordInLinks() {
        return this.innerKeywordInLinks;
    }

    public void setInnerKeywordInLinks(SkipKeywordMode value) {
        if (this.innerKeywordInLinks != value) {
            this.innerKeywordInLinks = value;
            this.notifyUpdated();
        }
    }

    public boolean isParenthesizeANDGroups() {
        return this.parenthesizeANDGroups;
    }

    public void setParenthesizeANDGroups(boolean value) {
        if (value != this.parenthesizeANDGroups) {
            this.parenthesizeANDGroups = value;
            this.notifyUpdated();
        }
    }

    public boolean isParenthesizeSingleCriterion() {
        return this.parenthesizeSingleCriterion;
    }

    public void setParenthesizeSingleCriterion(boolean value) {
        if (value != this.parenthesizeSingleCriterion) {
            this.parenthesizeSingleCriterion = value;
            this.notifyUpdated();
        }
    }

    protected void writeStringToResult(String s) {
        this.resultExpression.append(s);
    }

    protected void checkSpaceWritten() {
        if (this.spaceWritten) {
            this.spaceWritten = false;
            this.spaceInternal(this.spaceNewLineIndex);
        }
    }

    protected double getCurrentIndent() {
        if (this.indentIndex == -1) {
            return 0.0;
        }
        return this.indents.get(this.indentIndex);
    }

    protected double calcWeight(String elVal) {
        return elVal.length();
    }

    protected void writeIndent() {
        StringBuilder sb = new StringBuilder();
        double ind = this.getCurrentIndent();
        if (ind > 0.0) {
            double spw = this.calcWeight(" ");
            int spc = (int)Math.ceil(ind / spw);
            sb.setLength(spc);
            for (int i = 0; i < spc; ++i) {
                sb.setCharAt(i, ' ');
            }
            this.writeStringToResult(sb.toString());
        }
    }

    protected void doAddIndent(double indent) {
        ++this.indentIndex;
        if (this.indents.size() < this.indentIndex + 1) {
            for (int i = 0; i < 10; ++i) {
                this.indents.add(0.0);
            }
        }
        if (this.indentIndex > 0) {
            this.indents.set(this.indentIndex, this.indents.get(this.indentIndex - 1) + indent);
        } else {
            this.indents.set(this.indentIndex, indent);
        }
    }

    protected void doEndIndent() {
        this.indents.set(this.indentIndex, 0.0);
        --this.indentIndex;
    }

    protected void beginBuildInternal() {
        this.resultExpression.setLength(0);
    }

    protected void endBuildInternal() {
    }

    protected void spaceInternal(int newLineIndex) {
        this.writeSymbol(" ");
    }

    protected void newLineInternal() {
        this.writeSymbol(this.newLine);
    }

    protected void goodNewLinePosInternal(int newLineIndex) {
    }

    protected void writeKeywordInternal(String keyword) {
        this.writeStringToResult(keyword);
    }

    protected void writeIdentifierInternal(String identifier) {
        this.writeStringToResult(identifier);
    }

    protected void writeBuiltinInternal(String builtin) {
        this.writeStringToResult(builtin);
    }

    protected void writeSymbolInternal(String symbol) {
        this.writeStringToResult(symbol);
    }

    protected void writeNumberInternal(String number) {
        this.writeStringToResult(number);
    }

    protected void writeStringInternal(String str) {
        this.writeStringToResult(str);
    }

    protected void writeCommentInternal(String comment) {
        this.writeStringToResult(comment);
    }

    public void beginBuild() {
        this.beginBuildInternal();
        this.indentIndex = -1;
        this.writeIndent();
        this.newLineWasWritten = true;
        this.spaceWritten = false;
        this.spaceNewLineIndex = Integer.MAX_VALUE;
    }

    public void endBuild() {
        this.endBuildInternal();
    }

    public void space(int newLineIndex) {
        if (!this.spaceWritten) {
            this.spaceWritten = true;
            this.spaceNewLineIndex = newLineIndex;
        } else if (newLineIndex < this.spaceNewLineIndex) {
            this.spaceNewLineIndex = newLineIndex;
        }
    }

    public void space() {
        this.space(3);
    }

    public void addIndent(double indent) {
        this.doAddIndent(indent);
    }

    public void endIndent() {
        this.doEndIndent();
    }

    public void newLine() {
        if (!this.newLineWasWritten) {
            this.newLineInternal();
            this.writeIndent();
        }
        this.newLineWasWritten = true;
        this.spaceWritten = false;
    }

    public void newLineOrSpace(boolean newLine, int newLineIndex) {
        if (newLine) {
            this.newLine();
        } else {
            this.space(newLineIndex);
        }
    }

    public void newLineOrSpace(boolean newLine) {
        this.newLineOrSpace(newLine, 1);
    }

    public void goodNewLinePos(int newLineIndex) {
        this.goodNewLinePosInternal(newLineIndex);
    }

    public void writeKeyword(String keyword) {
        this.checkSpaceWritten();
        switch (this.keywordFormat) {
            case UpperCase: {
                this.writeKeywordInternal(keyword.toUpperCase());
                break;
            }
            case LowerCase: {
                this.writeKeywordInternal(keyword.toLowerCase());
                break;
            }
            default: {
                this.writeKeywordInternal(keyword);
            }
        }
        this.newLineWasWritten = false;
    }

    public void writeBuiltin(String builtin) {
        this.checkSpaceWritten();
        this.writeBuiltinInternal(builtin);
        this.newLineWasWritten = false;
    }

    public void writeKeywordAndSpace(String keyword, int newLineIndex) {
        this.writeKeyword(keyword);
        this.space(newLineIndex);
    }

    public void writeKeywordAndSpace(String keyword) {
        this.writeKeywordAndSpace(keyword, 3);
    }

    public void writeIdentifier(String identifier) {
        this.checkSpaceWritten();
        this.writeIdentifierInternal(identifier);
        this.newLineWasWritten = false;
    }

    public void writeSymbol(String symbol) {
        this.checkSpaceWritten();
        this.writeSymbolInternal(symbol);
        this.newLineWasWritten = false;
    }

    public void writeNumber(String number) {
        this.checkSpaceWritten();
        this.writeNumberInternal(number);
        this.newLineWasWritten = false;
    }

    public void writeString(String str) {
        this.checkSpaceWritten();
        this.writeStringInternal(str);
        this.newLineWasWritten = false;
    }

    public void writeComment(String comment) {
        this.checkSpaceWritten();
        this.writeCommentInternal(comment);
        this.newLineWasWritten = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Object source) {
        if (source instanceof SQLBuilder) {
            this.beginUpdate();
            try {
                SQLBuilder srcBuilder = (SQLBuilder)source;
                this.setRightMargin(srcBuilder.getRightMargin());
                this.setKeywordFormat(srcBuilder.getKeywordFormat());
                this.setQuoteIdentifiers(srcBuilder.getQuoteIdentifiers());
                this.setMainQueryFormat(srcBuilder.getMainQueryFormat());
                this.setExpressionsSubQueryFormat(srcBuilder.getExpressionsSubQueryFormat());
                this.setFromSubQueryFormat(srcBuilder.getFromSubQueryFormat());
                this.setCTESubQueryFormat(srcBuilder.getCTESubQueryFormat());
                this.setObjectPrefixSkipping(srcBuilder.getObjectPrefixSkipping());
                this.setUseAltNames(srcBuilder.isUseAltNames());
                this.setExpandVirtualFields(srcBuilder.isExpandVirtualFields());
                this.setExpandVirtualObjects(srcBuilder.isExpandVirtualObjects());
                this.setParenthesizeANDGroups(srcBuilder.isParenthesizeANDGroups());
                this.setParenthesizeSingleCriterion(srcBuilder.isParenthesizeSingleCriterion());
            }
            finally {
                this.endUpdate();
            }
        } else {
            super.assign(source);
        }
    }

    public SkipKeywordMode getAsKeywordInExpressionAlias() {
        return this.asKeywordInExpressionAlias;
    }

    public void setAsKeywordInExpressionAlias(SkipKeywordMode asKeywordInExpressionAlias) {
        if (this.asKeywordInExpressionAlias != asKeywordInExpressionAlias) {
            this.asKeywordInExpressionAlias = asKeywordInExpressionAlias;
            this.notifyUpdated();
        }
    }

    public SkipKeywordMode getAsKeywordInObjectAlias() {
        return this.asKeywordInObjectAlias;
    }

    public void setAsKeywordInObjectAlias(SkipKeywordMode asKeywordInObjectAlias) {
        if (this.asKeywordInObjectAlias != asKeywordInObjectAlias) {
            this.asKeywordInObjectAlias = asKeywordInObjectAlias;
            this.notifyUpdated();
        }
    }

    public boolean isExpandVirtualFields() {
        return this.expandVirtualFields;
    }

    public void setExpandVirtualFields(boolean value) {
        if (this.expandVirtualFields != value) {
            this.expandVirtualFields = value;
            this.notifyUpdated();
        }
    }

    public boolean isExpandVirtualObjects() {
        return this.expandVirtualObjects;
    }

    public void setExpandVirtualObjects(boolean value) {
        if (this.expandVirtualObjects != value) {
            this.expandVirtualObjects = value;
            this.notifyUpdated();
        }
    }

    public void addBeginBuildSQLForNodeEventListener(BuildSQLForNodeEventListener listener) {
        this.beginBuildSQLForNodeEventListenerList.add(listener);
    }

    public void removeBeginBuildSQLForNodeEventListener(BuildSQLForNodeEventListener listener) {
        this.beginBuildSQLForNodeEventListenerList.remove(listener);
    }

    protected void fireBeginBuildSQLForNodeEvent(AstNode node) {
        Iterator<BuildSQLForNodeEventListener> listeners = this.beginBuildSQLForNodeEventListenerList.iterator();
        BuildSQLForNodeEvent evt = new BuildSQLForNodeEvent(this, node);
        while (listeners.hasNext()) {
            listeners.next().buildSQLForNodeEventOccurred(evt);
        }
    }

    public void addEndBuildSQLForNodeEventListener(BuildSQLForNodeEventListener listener) {
        this.endBuildSQLForNodeEventListenerList.add(listener);
    }

    public void removeEndBuildSQLForNodeEventListener(BuildSQLForNodeEventListener listener) {
        this.endBuildSQLForNodeEventListenerList.remove(listener);
    }

    protected void fireEndBuildSQLForNodeEvent(AstNode node) {
        Iterator<BuildSQLForNodeEventListener> listeners = this.endBuildSQLForNodeEventListenerList.iterator();
        BuildSQLForNodeEvent evt = new BuildSQLForNodeEvent(this, node);
        while (listeners.hasNext()) {
            listeners.next().buildSQLForNodeEventOccurred(evt);
        }
    }
}

