/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstNode;
import com.adbs.ast.AstToken;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataBase;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataFilterItem;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataObjectHash;
import com.adbs.ast.MetadataObjectVisibleEvent;
import com.adbs.ast.MetadataObjectVisibleEventListener;
import com.adbs.ast.MetadataProcedure;
import com.adbs.ast.MetadataQualifiedNameList;
import com.adbs.ast.MetadataSynonym;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.MetadataView;
import com.adbs.ast.ParsingException;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SortByNameComparator;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;

public class MetadataContainer
extends MetadataBase {
    private Vector<MetadataObject> items = new Vector();
    MetadataObjectHash namesHash;
    private boolean offlineMode = false;
    private boolean loaded;
    private boolean objectsUpdated;
    private SQLQualifiedName defaultDatabaseName;
    private SQLIdentifiersCollection defaultSchemaNames;
    private MetadataQualifiedNameList customAggregateFunctions;
    protected ArrayList<MetadataObjectVisibleEventListener> metadataObjectVisibleEventListenerList = new ArrayList();

    public MetadataContainer(MetadataBase parent, BaseSQLContext sqlContext) {
        super(parent, sqlContext);
        this.namesHash = new MetadataObjectHash(1024);
        this.defaultDatabaseName = new SQLQualifiedName(sqlContext);
        this.defaultSchemaNames = new SQLIdentifiersCollection(sqlContext);
        this.customAggregateFunctions = new MetadataQualifiedNameList(this, sqlContext);
    }

    @Override
    public void dispose() {
        this.clear();
        this.defaultDatabaseName.dispose();
        this.defaultSchemaNames.dispose();
        this.customAggregateFunctions.dispose();
        super.dispose();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean getObjectsUpdated() {
        return this.objectsUpdated;
    }

    public boolean isOfflineMode() {
        return this.offlineMode;
    }

    public void setOfflineMode(boolean value) {
        if (this.offlineMode != value) {
            this.offlineMode = value;
        }
    }

    public String getXML() {
        String result = "";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.newDocument();
            doc.appendChild(this.getXMLNode(doc, "metadata"));
            DOMSource src = new DOMSource(doc.getDocumentElement());
            StringWriter sw = new StringWriter();
            TransformerFactory tranFact = TransformerFactory.newInstance();
            Transformer transformer = tranFact.newTransformer();
            StreamResult dest = new StreamResult(sw);
            transformer.transform(src, dest);
            result = sw.toString();
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    public void setXML(String value) throws QueryBuilderException {
        this.loadFromXML(value);
    }

    public MetadataObject get(int index) {
        return this.items.get(index);
    }

    public int getCount() {
        return this.items.size();
    }

    public int getCapacity() {
        return this.items.capacity();
    }

    public void setCapacity(int value) {
        this.items.ensureCapacity(value);
    }

    public SQLQualifiedName getDefaultDatabaseName() {
        return this.defaultDatabaseName;
    }

    public void setDefaultDatabaseName(SQLQualifiedName value) {
        if (this.defaultDatabaseName != value) {
            if (value != null) {
                this.defaultDatabaseName.assign(value);
            } else {
                this.defaultDatabaseName.clear();
            }
        }
    }

    public String getDefaultDatabaseNameStr() {
        return this.defaultDatabaseName.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
    }

    public void setDefaultDatabaseNameStr(String value) throws QueryBuilderException {
        this.defaultDatabaseName.setQualifiedName(value);
    }

    public SQLIdentifiersCollection getDefaultSchemaNames() {
        return this.defaultSchemaNames;
    }

    public void setDefaultSchemaNames(SQLIdentifiersCollection value) {
        if (this.defaultSchemaNames != value) {
            this.defaultSchemaNames.assign(value);
        }
    }

    public String getDefaultSchemaNamesStr() {
        String result = "";
        for (int i = 0; i < this.defaultSchemaNames.getCount(); ++i) {
            result = !Str.IsNullOrEmpty(result) ? result + ";" + this.defaultSchemaNames.get(i).getSimpleSQL(this.sqlContext.getSQLBuilderExpression()) : this.defaultSchemaNames.get(i).getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
        }
        return result;
    }

    public void setDefaultSchemaNamesStr(String value) {
        if (!this.getDefaultSchemaNamesStr().equals(value)) {
            ArrayList<String> identifiers = new ArrayList<String>();
            boolean unclosedQuotation = false;
            String[] ss = value.split(";");
            for (int i = 0; i < ss.length; ++i) {
                if (!unclosedQuotation) {
                    if (ss[i].indexOf(this.sqlContext.getSyntaxProvider().getQuoteBegin()) != -1) {
                        unclosedQuotation = true;
                        if (ss[i].indexOf(this.sqlContext.getSyntaxProvider().getQuoteEnd()) != -1) {
                            unclosedQuotation = false;
                        }
                    }
                    identifiers.add(ss[i]);
                    continue;
                }
                int x = identifiers.size() - 1;
                identifiers.set(x, ((String)identifiers.get(x)).concat(";" + ss[i]));
                if (ss[i].indexOf(this.sqlContext.getSyntaxProvider().getQuoteEnd()) == -1) continue;
                unclosedQuotation = false;
            }
            for (String s : identifiers) {
                this.defaultSchemaNames.addIdentifier(s.trim());
            }
        }
    }

    private void parseObjectNames(String schema, String name, String database, ParsedNames parsedNames) {
        parsedNames.parsedSchema = !Str.IsNullOrEmpty(schema) ? this.sqlContext.parseIdentifierQuoteIfNeed(schema) : new AstTokenIdentifier(this.sqlContext, "");
        parsedNames.parsedName = !Str.IsNullOrEmpty(name) ? this.sqlContext.parseIdentifierQuoteIfNeed(name) : new AstTokenIdentifier(this.sqlContext, "");
        parsedNames.parsedDatabase = !Str.IsNullOrEmpty(database) ? this.sqlContext.parseQualifiedNameQuoteIfNeed(database) : new SQLQualifiedName(this.sqlContext);
    }

    private void checkSyntaxProvider() throws QueryBuilderException {
        if (this.sqlContext.getSyntaxProvider() == null) {
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
    }

    private void checkMetadataProvider() throws QueryBuilderException {
        if (this.sqlContext.getMetadataProvider() == null) {
            throw new QueryBuilderException(Helpers.localizer.getString("strNoMetadataProvider", "No metadata provider."));
        }
    }

    public MetadataObject addObject(AstTokenIdentifier schema, AstTokenIdentifier name, Class objectClass, boolean system, SQLQualifiedName database) {
        this.loaded = true;
        MetadataObject result = null;
        try {
            Constructor c = objectClass.getConstructor(MetadataBase.class, BaseSQLContext.class);
            result = (MetadataObject)c.newInstance(this, this.sqlContext);
            result.setSchema(schema);
            result.setName(name);
            result.setDatabase(database);
            result.setSystem(system);
            this.add(result);
        }
        catch (Exception ex) {
            Logger.getLogger(MetadataContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public MetadataObject addObject(SQLQualifiedName fullName, Class objectClass, boolean system) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataObject addObject(String fullName, Class objectClass, boolean system) {
        assert (!Str.IsNullOrEmpty(fullName)) : "MetadataContainer.addObject(): fullName must be non-empty string";
        SQLQualifiedName qn = this.sqlContext.parseQualifiedNameQuoteIfNeed(fullName);
        try {
            MetadataObject metadataObject = this.addObject(qn, objectClass, system);
            return metadataObject;
        }
        finally {
            if (qn != null) {
                qn.dispose();
            }
        }
    }

    MetadataObject findByNameAndClass(AstTokenIdentifier name, AstTokenIdentifier schema, SQLQualifiedName database, Class objectClass) {
        return this.namesHash.findByNameAndClass(name, schema, database, objectClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MetadataObject findByFullNameAndClass(SQLQualifiedName name, Class objectClass) {
        AstNode nm = null;
        AstNode sch = null;
        assert (!Helpers.isQualifiedNameEmpty(name));
        SQLQualifiedNameList nameList = new SQLQualifiedNameList(this.sqlContext);
        SQLQualifiedName db = new SQLQualifiedName(this.sqlContext);
        try {
            SQLQualifiedName qn;
            db.assign(name);
            if (db.getCount() <= 0 || !(db.get(0) instanceof AstTokenIdentifier)) {
                MetadataObject metadataObject = null;
                return metadataObject;
            }
            nm = (AstTokenIdentifier)db.extractName();
            sch = this.sqlContext.getSyntaxProvider().isSupportSchemas() && db.getCount() > 0 && db.get(0) instanceof AstTokenIdentifier ? (AstTokenIdentifier)db.extractName() : null;
            if (db.getCount() == 1 && db.get(0).isEmpty()) {
                db.clear();
            }
            if (Helpers.isQualifiedNameEmpty(db) && this.sqlContext.getSyntaxProvider().isSupportDatabases() && !Helpers.isQualifiedNameEmpty(this.defaultDatabaseName)) {
                db.assign(this.defaultDatabaseName);
            }
            nameList.add(name.clone(this.sqlContext));
            if (this.sqlContext.getSyntaxProvider().isSupportSchemas()) {
                if (sch == null || ((AstToken)sch).isEmpty()) {
                    for (int i = 0; i < this.defaultSchemaNames.getCount(); ++i) {
                        qn = db.clone(this.sqlContext);
                        qn.addName(this.defaultSchemaNames.get(i).clone(this.sqlContext));
                        qn.addName(((AstTokenIdentifier)nm).clone(this.sqlContext));
                        nameList.add(qn);
                    }
                } else {
                    qn = db.clone(this.sqlContext);
                    qn.addName(((AstTokenIdentifier)sch).clone(this.sqlContext));
                    qn.addName(((AstTokenIdentifier)nm).clone(this.sqlContext));
                    nameList.add(qn);
                }
            } else {
                qn = db.clone(this.sqlContext);
                qn.addName(((AstTokenIdentifier)nm).clone(this.sqlContext));
                nameList.add(qn);
            }
            for (int j = 0; j < nameList.getCount(); ++j) {
                MetadataObject mo = this.namesHash.findByFullNameAndClass(nameList.get(j), objectClass);
                if (mo == null) continue;
                MetadataObject metadataObject = mo;
                return metadataObject;
            }
        }
        finally {
            if (nm != null) {
                nm.dispose();
            }
            if (sch != null) {
                sch.dispose();
            }
            nameList.dispose();
            db.dispose();
        }
        return null;
    }

    protected MetadataObject findByAltNameAndClass(String altName, Class objectClass) {
        return this.namesHash.findByAltNameAndClass(altName, objectClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Element getXMLNode(Document doc, String nodeName) {
        Element result;
        this.beginUpdate();
        try {
            result = doc.createElement(nodeName);
            if (result != null) {
                result.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                result.setAttribute("xsi:noNamespaceSchemaLocation", "http://www.activequerybuilder.com/schemas/metadata.xsd");
                if (!Helpers.isQualifiedNameEmpty(this.defaultDatabaseName)) {
                    result.appendChild(this.defaultDatabaseName.getXMLNode(doc, "default_database", "item"));
                }
                if (this.defaultSchemaNames.getCount() != 0) {
                    result.appendChild(this.defaultSchemaNames.getXMLNode(doc, "default_schemas", "item"));
                }
                if (this.customAggregateFunctions.getCount() > 0) {
                    result.appendChild(this.customAggregateFunctions.getXMLNode(doc, "custom_aggregate_functions", "custom_aggregate_function"));
                }
                for (int i = 0; i < this.getCount(); ++i) {
                    MetadataObject tItem = this.get(i);
                    Element iItem = tItem.getXMLNode(doc, tItem.getXMLItemName());
                    if (iItem == null) continue;
                    result.appendChild(iItem);
                }
            }
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromXMLNode(Node node) throws QueryBuilderException {
        if (node.getNodeName().equals("metadata")) {
            this.beginUpdate();
            try {
                Node child = Helpers.findChildElByName("default_database", node);
                if (child != null) {
                    this.defaultDatabaseName.loadFromXMLNode(child, "item");
                }
                if ((child = Helpers.findChildElByName("default_schemas", node)) != null) {
                    this.defaultSchemaNames.loadFromXMLNode(child, "item");
                }
                if ((child = Helpers.findChildElByName("custom_aggregate_functions", node)) != null) {
                    this.customAggregateFunctions.loadFromXMLNode(child, "custom_aggregate_function");
                }
                int cap = this.getCount() + node.getChildNodes().getLength();
                if (this.getCapacity() < cap) {
                    this.setCapacity(cap);
                }
                for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                    Class objectClass;
                    child = node.getChildNodes().item(i);
                    if (child == null || (objectClass = child.getNodeName().equals("table") ? MetadataTable.class : (child.getNodeName().equals("view") ? MetadataView.class : (child.getNodeName().equals("procedure") ? MetadataProcedure.class : (child.getNodeName().equals("synonym") ? MetadataSynonym.class : null)))) == null) continue;
                    try {
                        Constructor c = objectClass.getConstructor(MetadataBase.class, BaseSQLContext.class);
                        MetadataObject obj = (MetadataObject)c.newInstance(this, this.sqlContext);
                        this.add(obj);
                        obj.loadFromXMLNode(child);
                        continue;
                    }
                    catch (Exception ex) {
                        Logger.getLogger(MetadataContainer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            finally {
                this.endUpdate();
            }
        } else {
            throw new QueryBuilderException(String.format(Helpers.localizer.getString("strErrorBadXMLTagNotFound", "Bad XML file: tag %1$s not found."), "metadata"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Object source) {
        this.beginUpdate();
        try {
            super.assign(source);
            if (source instanceof MetadataContainer) {
                this.clear();
                this.setCapacity(((MetadataContainer)source).getCount());
                for (int i = 0; i < ((MetadataContainer)source).getCount(); ++i) {
                    this.add((MetadataObject)((MetadataContainer)source).get(i).clone(this, this.sqlContext));
                }
                this.notifyUpdated();
            }
            this.rebuildNamesHash();
            if (source instanceof MetadataContainer) {
                this.loaded = ((MetadataContainer)source).isLoaded();
                this.defaultDatabaseName.assign(((MetadataContainer)source).getDefaultDatabaseName());
                this.defaultSchemaNames.assign(((MetadataContainer)source).getDefaultSchemaNames());
                this.setObjectsUpdated();
                this.notifyUpdated();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFields() throws QueryBuilderException {
        this.beginUpdate();
        try {
            for (int i = 0; i < this.getCount(); ++i) {
                if (this.get(i).getFields().isLoaded()) continue;
                this.get(i).loadFields();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public int add(MetadataObject item) {
        assert (item != null);
        assert (item.getParent() == this);
        this.items.add(item);
        this.notify(item, ListNotification.Added);
        this.notifyUpdated();
        return this.items.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.beginUpdate();
        try {
            this.loaded = false;
            this.defaultDatabaseName.clear();
            this.defaultSchemaNames.clear();
            for (int i = this.getCount() - 1; i >= 0; --i) {
                this.notify(this.get(i), ListNotification.Deleted);
            }
            this.items.clear();
            this.notifyUpdated();
        }
        finally {
            this.endUpdate();
        }
    }

    public MetadataObject extract(MetadataObject item) {
        assert (this.indexOf(item) != -1);
        MetadataObject result = item;
        this.notify(item, ListNotification.Extracted);
        this.items.remove(item);
        this.notifyUpdated();
        return result;
    }

    public int indexOf(MetadataObject item) {
        return this.items.indexOf(item);
    }

    public void insert(int index, MetadataObject item) {
        this.items.add(index, item);
        this.notify(item, ListNotification.Added);
        this.notifyUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(int currentIndex, int newIndex) {
        this.beginUpdate();
        try {
            Helpers.listMove(this.items, currentIndex, newIndex);
            this.setObjectsUpdated();
            this.notifyUpdated();
        }
        finally {
            this.endUpdate();
        }
    }

    public int remove(MetadataObject item) {
        int x = this.indexOf(item);
        assert (x != -1);
        this.items.remove(item);
        this.notify(item, ListNotification.Deleted);
        this.notifyUpdated();
        return x;
    }

    public MetadataTable addTable(AstTokenIdentifier schema, AstTokenIdentifier name, boolean system, SQLQualifiedName database) {
        return (MetadataTable)this.addObject(schema, name, MetadataTable.class, system, database);
    }

    public MetadataView addView(AstTokenIdentifier schema, AstTokenIdentifier name, boolean system, SQLQualifiedName database) {
        return (MetadataView)this.addObject(schema, name, MetadataView.class, system, database);
    }

    public MetadataProcedure addProcedure(AstTokenIdentifier schema, AstTokenIdentifier name, boolean system, SQLQualifiedName database) {
        return (MetadataProcedure)this.addObject(schema, name, MetadataProcedure.class, system, database);
    }

    public MetadataTable addTable(String schema, String name, boolean system, String database) {
        ParsedNames parsedNames = new ParsedNames();
        this.parseObjectNames(schema, name, database, parsedNames);
        return this.addTable(parsedNames.parsedSchema, parsedNames.parsedName, system, parsedNames.parsedDatabase);
    }

    public MetadataTable addTable(String fullName, boolean system) {
        return (MetadataTable)this.addObject(fullName, MetadataTable.class, system);
    }

    public MetadataTable addTable(SQLQualifiedName fullName, boolean system) {
        return (MetadataTable)this.addObject(fullName, MetadataTable.class, system);
    }

    public MetadataView addView(String schema, String name, boolean system, String database) {
        ParsedNames parsedNames = new ParsedNames();
        this.parseObjectNames(schema, name, database, parsedNames);
        return this.addView(parsedNames.parsedSchema, parsedNames.parsedName, system, parsedNames.parsedDatabase);
    }

    public MetadataView addView(String fullName, boolean system) {
        return (MetadataView)this.addObject(fullName, MetadataView.class, system);
    }

    public MetadataView addView(SQLQualifiedName fullName, boolean system) {
        return (MetadataView)this.addObject(fullName, MetadataView.class, system);
    }

    public MetadataProcedure addProcedure(String schema, String name, boolean system, String database) {
        ParsedNames parsedNames = new ParsedNames();
        this.parseObjectNames(schema, name, database, parsedNames);
        return this.addProcedure(parsedNames.parsedSchema, parsedNames.parsedName, system, parsedNames.parsedDatabase);
    }

    public MetadataProcedure addProcedure(String fullName, boolean system) {
        return (MetadataProcedure)this.addObject(fullName, MetadataProcedure.class, system);
    }

    public MetadataProcedure addProcedure(SQLQualifiedName fullName, boolean system) {
        return (MetadataProcedure)this.addObject(fullName, MetadataProcedure.class, system);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataSynonym addSynonym(String fullName, String synonymOfObject, boolean system) {
        assert (!Str.IsNullOrEmpty(fullName)) : "MetadataContainer.addSynonym(): fullName must be non-empty string";
        SQLQualifiedName name = this.sqlContext.parseQualifiedNameQuoteIfNeed(fullName);
        try {
            if (!Str.IsNullOrEmpty(synonymOfObject)) {
                SQLQualifiedName referenced = this.sqlContext.parseQualifiedNameQuoteIfNeed(synonymOfObject);
                try {
                    MetadataSynonym metadataSynonym = this.addSynonym(name, referenced, system);
                    return metadataSynonym;
                }
                finally {
                    if (referenced != null) {
                        referenced.dispose();
                    }
                }
            }
            MetadataSynonym metadataSynonym = this.addSynonym(name, null, system);
            return metadataSynonym;
        }
        finally {
            if (name != null) {
                name.dispose();
            }
        }
    }

    public MetadataSynonym addSynonym(SQLQualifiedName fullName, SQLQualifiedName synonymOfObject, boolean system) {
        MetadataSynonym result = (MetadataSynonym)this.addObject(fullName, MetadataSynonym.class, system);
        if (!Helpers.isQualifiedNameEmpty(synonymOfObject)) {
            result.setReferencedFullName(synonymOfObject);
        }
        return result;
    }

    public MetadataObject findObjectByName(AstTokenIdentifier name, AstTokenIdentifier schema, SQLQualifiedName database) {
        return this.findByNameAndClass(name, schema, database, MetadataObject.class);
    }

    public MetadataObject findObjectByName(String name, String schema, String database) {
        ParsedNames parsedNames = new ParsedNames();
        try {
            this.parseObjectNames(schema, name, database, parsedNames);
        }
        catch (Exception ex) {
            // empty catch block
        }
        MetadataObject result = parsedNames.parsedName != null ? this.findByNameAndClass(parsedNames.parsedName, parsedNames.parsedSchema, parsedNames.parsedDatabase, MetadataObject.class) : null;
        return result;
    }

    public MetadataTable findTableByName(AstTokenIdentifier name, AstTokenIdentifier schema, SQLQualifiedName database) {
        return (MetadataTable)this.findByNameAndClass(name, schema, database, MetadataTable.class);
    }

    public MetadataTable findTableByName(String name, String schema, String database) {
        ParsedNames parsedNames = new ParsedNames();
        try {
            this.parseObjectNames(schema, name, database, parsedNames);
        }
        catch (Exception ex) {
            // empty catch block
        }
        MetadataTable result = parsedNames.parsedName != null ? (MetadataTable)this.findByNameAndClass(parsedNames.parsedName, parsedNames.parsedSchema, parsedNames.parsedDatabase, MetadataTable.class) : null;
        return result;
    }

    public MetadataView findViewByName(AstTokenIdentifier name, AstTokenIdentifier schema, SQLQualifiedName database) {
        return (MetadataView)this.findByNameAndClass(name, schema, database, MetadataView.class);
    }

    public MetadataView findViewByName(String name, String schema, String database) {
        ParsedNames parsedNames = new ParsedNames();
        try {
            this.parseObjectNames(schema, name, database, parsedNames);
        }
        catch (Exception ex) {
            // empty catch block
        }
        MetadataView result = parsedNames.parsedName != null ? (MetadataView)this.findByNameAndClass(parsedNames.parsedName, parsedNames.parsedSchema, parsedNames.parsedDatabase, MetadataView.class) : null;
        return result;
    }

    public MetadataProcedure findProcedureByName(AstTokenIdentifier name, AstTokenIdentifier schema, SQLQualifiedName database) {
        return (MetadataProcedure)this.findByNameAndClass(name, schema, database, MetadataProcedure.class);
    }

    public MetadataProcedure findProcedureByName(String name, String schema, String database) {
        ParsedNames parsedNames = new ParsedNames();
        try {
            this.parseObjectNames(schema, name, database, parsedNames);
        }
        catch (Exception ex) {
            Logger.getLogger(MetadataContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        MetadataProcedure result = parsedNames.parsedName != null ? (MetadataProcedure)this.findByNameAndClass(parsedNames.parsedName, parsedNames.parsedSchema, parsedNames.parsedDatabase, MetadataProcedure.class) : null;
        return result;
    }

    public MetadataObject findObjectByFullName(SQLQualifiedName name) {
        return this.findByFullNameAndClass(name, MetadataObject.class);
    }

    public MetadataObject findObjectByFullName(String name) {
        MetadataObject result;
        SQLQualifiedName parsedName = null;
        if (!Str.IsNullOrEmpty(name)) {
            try {
                parsedName = this.sqlContext.parseQualifiedNameQuoteIfNeed(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = parsedName != null ? this.findByFullNameAndClass(parsedName, MetadataObject.class) : null;
        } else {
            result = null;
        }
        return result;
    }

    public MetadataTable findTableByFullName(SQLQualifiedName name) {
        return (MetadataTable)this.findByFullNameAndClass(name, MetadataTable.class);
    }

    public MetadataTable findTableByFullName(String name) {
        MetadataTable result;
        SQLQualifiedName parsedName = null;
        if (!Str.IsNullOrEmpty(name)) {
            try {
                parsedName = this.sqlContext.parseQualifiedNameQuoteIfNeed(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = parsedName != null ? (MetadataTable)this.findByFullNameAndClass(parsedName, MetadataTable.class) : null;
        } else {
            result = null;
        }
        return result;
    }

    public MetadataView findViewByFullName(SQLQualifiedName name) {
        return (MetadataView)this.findByFullNameAndClass(name, MetadataView.class);
    }

    public MetadataView findViewByFullName(String name) {
        MetadataView result;
        SQLQualifiedName parsedName = null;
        if (!Str.IsNullOrEmpty(name)) {
            try {
                parsedName = this.sqlContext.parseQualifiedNameQuoteIfNeed(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = parsedName != null ? (MetadataView)this.findByFullNameAndClass(parsedName, MetadataView.class) : null;
        } else {
            result = null;
        }
        return result;
    }

    public MetadataProcedure findProcedureByFullName(SQLQualifiedName name) {
        return (MetadataProcedure)this.findByFullNameAndClass(name, MetadataProcedure.class);
    }

    public MetadataProcedure findProcedureByFullName(String name) {
        MetadataProcedure result;
        SQLQualifiedName parsedName = null;
        if (!Str.IsNullOrEmpty(name)) {
            try {
                parsedName = this.sqlContext.parseQualifiedNameQuoteIfNeed(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = parsedName != null ? (MetadataProcedure)this.findByFullNameAndClass(parsedName, MetadataProcedure.class) : null;
        } else {
            result = null;
        }
        return result;
    }

    public MetadataSynonym findSynonymByFullName(SQLQualifiedName name) {
        return (MetadataSynonym)this.findByFullNameAndClass(name, MetadataSynonym.class);
    }

    public MetadataSynonym findSynonymByFullName(String name) {
        MetadataSynonym result;
        SQLQualifiedName parsedName = null;
        if (!Str.IsNullOrEmpty(name)) {
            try {
                parsedName = this.sqlContext.parseQualifiedNameQuoteIfNeed(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = parsedName != null ? (MetadataSynonym)this.findByFullNameAndClass(parsedName, MetadataSynonym.class) : null;
        } else {
            result = null;
        }
        return result;
    }

    public MetadataSynonym findSynonymByName(String name, String schema, String database) {
        ParsedNames parsedNames = new ParsedNames();
        try {
            this.parseObjectNames(schema, name, database, parsedNames);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MetadataSynonym result = parsedNames.parsedName != null ? (MetadataSynonym)this.findByNameAndClass(parsedNames.parsedName, parsedNames.parsedSchema, parsedNames.parsedDatabase, MetadataSynonym.class) : null;
        return result;
    }

    public MetadataObject findObjectByAltName(String altName) {
        return this.findByAltNameAndClass(altName, MetadataObject.class);
    }

    public MetadataTable findTableByAltName(String altName) {
        return (MetadataTable)this.findByAltNameAndClass(altName, MetadataTable.class);
    }

    public MetadataView findViewByAltName(String altName) {
        return (MetadataView)this.findByAltNameAndClass(altName, MetadataView.class);
    }

    public MetadataProcedure findProcedureByAltName(String altName) {
        return (MetadataProcedure)this.findByAltNameAndClass(altName, MetadataProcedure.class);
    }

    public MetadataSynonym findSynonymByAltName(String altName) {
        return (MetadataSynonym)this.findByAltNameAndClass(altName, MetadataSynonym.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMetadataByFilter(MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        this.loaded = true;
        this.checkSyntaxProvider();
        this.checkMetadataProvider();
        this.beginUpdate();
        try {
            if (this.sqlContext.getSyntaxProvider().isSupportDatabases() && Helpers.isQualifiedNameEmpty(this.defaultDatabaseName)) {
                SQLQualifiedName db = this.sqlContext.getSyntaxProvider().getDefaultDatabaseName(this.sqlContext);
                try {
                    this.defaultDatabaseName.assign(db);
                }
                finally {
                    db.dispose();
                }
            }
            if (this.sqlContext.getSyntaxProvider().isSupportSchemas() && this.defaultSchemaNames.getCount() == 0) {
                this.sqlContext.getSyntaxProvider().getDefaultSchemaNames(this.sqlContext, this.defaultSchemaNames);
            }
            this.sqlContext.loadMetadataObjects(this, metadataFilter, database);
            this.sqlContext.loadMetadataRelations(this, metadataFilter, database);
            this.sqlContext.loadMetadataCustomAggregateNames(this, database);
        }
        finally {
            this.endUpdate();
        }
    }

    public void loadMetadataByMask(String objectMask, String schemaMask, SQLQualifiedName database, boolean caseSensitive) throws QueryBuilderException {
        this.loaded = true;
        MetadataFilter filter = new MetadataFilter();
        MetadataFilterItem fi = filter.add();
        fi.setObjectMask(objectMask);
        fi.setObjectMaskCaseSensitive(caseSensitive);
        fi.setSchemaMask(schemaMask);
        fi.setSchemaMaskCaseSensitive(caseSensitive);
        this.loadMetadataByFilter(filter, database);
    }

    public void loadMetadataByMask(String objectMask, String schemaMask, SQLQualifiedName database) {
        this.loadMetadataByMask(objectMask, schemaMask, database, true);
    }

    public void loadMetadataByMask(String objectMask, String schemaMask, String database, boolean caseSensitive) throws QueryBuilderException {
        SQLQualifiedName qn;
        this.checkSyntaxProvider();
        if (!Str.IsNullOrEmpty(database)) {
            try {
                qn = this.sqlContext.parseQualifiedNameQuoteIfNeed(database);
            }
            catch (ParsingException ex) {
                throw new QueryBuilderException("MetadataContainer.loadMetadataByMask(): Failed to parse qualified name.\n" + ex.getMessage(), ex);
            }
        } else {
            qn = null;
        }
        this.loadMetadataByMask(objectMask, schemaMask, qn, caseSensitive);
    }

    public void loadMetadataByMask(String objectMask, String schemaMask, String database) {
        this.loadMetadataByMask(objectMask, schemaMask, database, true);
    }

    public void clearMetadataByMask(String objectMask, String schemaMask, SQLQualifiedName database, boolean caseSensitive) {
        MetadataFilter filter = new MetadataFilter();
        MetadataFilterItem fi = filter.add();
        fi.setObjectMask(objectMask);
        fi.setObjectMaskCaseSensitive(caseSensitive);
        fi.setSchemaMask(schemaMask);
        fi.setSchemaMaskCaseSensitive(caseSensitive);
        for (int i = this.getCount() - 1; i >= 0; --i) {
            MetadataObject mo = this.get(i);
            if ((mo.getDatabase().getCount() != 0 || database != null && database.getCount() != 0) && !this.sqlContext.isQualifiedNamesEqual(mo.getDatabase(), database) || !filter.filterMetadataObject(mo)) continue;
            this.delete(i);
        }
    }

    public void clearMetadataByMask(String objectMask, String schemaMask, SQLQualifiedName database) {
        this.clearMetadataByMask(objectMask, schemaMask, database, true);
    }

    public void clearMetadataByMask(String objectMask, String schemaMask, String database, boolean caseSensitive) throws QueryBuilderException {
        SQLQualifiedName qn;
        this.checkSyntaxProvider();
        if (!Str.IsNullOrEmpty(database)) {
            try {
                qn = this.sqlContext.parseQualifiedNameQuoteIfNeed(database);
            }
            catch (ParsingException ex) {
                throw new QueryBuilderException("MetadataContainer.clearMetadataByMask(): Failed to parse qualified name.\n" + ex.getMessage(), ex);
            }
        } else {
            qn = null;
        }
        this.clearMetadataByMask(objectMask, schemaMask, qn, caseSensitive);
    }

    public void clearMetadataByMask(String objectMask, String schemaMask, String database) {
        this.clearMetadataByMask(objectMask, schemaMask, database, true);
    }

    public void sortByNames() {
        assert (this.sqlContext.getSyntaxProvider() != null);
        this.sortItems(new SortByNameComparator());
    }

    protected void sortItems(Comparator<MetadataObject> comparator) {
        Collections.sort(this.items, comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromXML(String xml) throws QueryBuilderException {
        this.beginUpdate();
        try {
            this.clear();
            this.addFromXML(xml);
        }
        finally {
            this.endUpdate();
        }
    }

    public void addFromXML(String xml) throws QueryBuilderException {
        this.beginUpdate();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            StringReader sr = new StringReader(xml);
            Document doc = parser.parse(new InputSource(sr));
            if (doc.getDocumentElement() != null) {
                this.loadFromXMLNode(doc.getDocumentElement());
            }
        }
        catch (Exception ex) {
            throw new QueryBuilderException(String.format(Helpers.localizer.getString("strErrorBadXML", "Error parsing XML:\n%1$s"), ex.getMessage()), ex);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromXMLFile(String fileName) throws QueryBuilderException {
        this.beginUpdate();
        try {
            this.clear();
            this.addFromXMLFile(fileName);
        }
        finally {
            this.endUpdate();
        }
    }

    public void addFromXMLFile(String fileName) throws QueryBuilderException {
        this.beginUpdate();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.parse(fileName);
            if (doc.getDocumentElement() != null) {
                this.loadFromXMLNode(doc.getDocumentElement());
            }
        }
        catch (IOException e) {
            throw new QueryBuilderException(String.format(Helpers.localizer.getString("strErrorXMLFileNotFound", "The specified file was not found:\n%1$s."), e.getMessage()), e);
        }
        catch (Exception e) {
            throw new QueryBuilderException(String.format(Helpers.localizer.getString("strErrorBadXML", "Error parsing XML:\n%1$s"), e.getMessage()), e);
        }
        finally {
            this.endUpdate();
        }
    }

    public void saveToXMLFile(String fileName) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.newDocument();
            ProcessingInstruction pi = doc.createProcessingInstruction("xml", "version=\"1.0\" encoding=\"UTF-8\"");
            doc.appendChild(pi);
            doc.appendChild(this.getXMLNode(doc, "metadata"));
            DOMSource src = new DOMSource(doc.getDocumentElement());
            FileWriter fw = new FileWriter(fileName);
            TransformerFactory tranFact = TransformerFactory.newInstance();
            Transformer transformer = tranFact.newTransformer();
            StreamResult dest = new StreamResult(fw);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(src, dest);
            fw.flush();
            fw.close();
        }
        catch (Exception ex) {
            Logger.getLogger(MetadataContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void loadFieldsForQuery(String query, MetadataFieldList fieldList) throws QueryBuilderException {
        if (!this.isOfflineMode()) {
            this.sqlContext.loadFieldsForQuery(query, fieldList);
        }
    }

    protected void setObjectsUpdated() {
        this.objectsUpdated = true;
    }

    protected void clearObjectsUpdated() {
        this.objectsUpdated = false;
    }

    @Override
    protected void doUpdated() {
        super.doUpdated();
        this.clearObjectsUpdated();
    }

    public boolean isMetadataObjectVisible(MetadataObject metadataObject) {
        MetadataObjectVisibleEvent event = new MetadataObjectVisibleEvent(this, metadataObject);
        this.fireMetadataObjectVisibleEvent(event);
        return event.visible;
    }

    private void rebuildNamesHash() {
        this.namesHash.clear();
        for (int i = 0; i < this.getCount(); ++i) {
            this.namesHash.addByName(this.get(i));
            this.namesHash.addByAltName(this.get(i));
        }
    }

    protected void notify(MetadataBase item, ListNotification action) {
        switch (action) {
            case Added: {
                this.loaded = true;
                this.namesHash.reHashByName((MetadataObject)item);
                this.namesHash.reHashByAltName((MetadataObject)item);
                break;
            }
            case Extracted: {
                this.namesHash.removeByName((MetadataObject)item);
                this.namesHash.removeByAltName((MetadataObject)item);
                break;
            }
            case Deleted: {
                this.namesHash.removeByName((MetadataObject)item);
                this.namesHash.removeByAltName((MetadataObject)item);
                item.dispose();
            }
        }
        this.setObjectsUpdated();
    }

    public void delete(int index) {
        this.notify(this.get(index), ListNotification.Deleted);
        this.items.remove(index);
        this.notifyUpdated();
    }

    public void addMetadataObjectVisibleEventListener(MetadataObjectVisibleEventListener listener) {
        this.metadataObjectVisibleEventListenerList.add(listener);
    }

    public void removeMetadataObjectVisibleEventListener(MetadataObjectVisibleEventListener listener) {
        this.metadataObjectVisibleEventListenerList.remove(listener);
    }

    protected void fireMetadataObjectVisibleEvent(MetadataObjectVisibleEvent evt) {
        Iterator<MetadataObjectVisibleEventListener> listeners = this.metadataObjectVisibleEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().metadataObjectVisibleEventOccurred(evt);
        }
    }

    public MetadataQualifiedNameList getCustomAggregateFunctions() {
        return this.customAggregateFunctions;
    }

    public void setCustomAggregateFunctions(MetadataQualifiedNameList value) {
        if (this.customAggregateFunctions != value) {
            if (value != null) {
                this.customAggregateFunctions.assign(value);
            } else {
                this.customAggregateFunctions.clear();
            }
        }
    }

    public static enum ListNotification {
        Added,
        Extracted,
        Deleted;

    }

    public class ParsedNames {
        public AstTokenIdentifier parsedSchema;
        public AstTokenIdentifier parsedName;
        public SQLQualifiedName parsedDatabase;
    }
}

