/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.Buffer;
import com.adbs.ast.StartTable;
import com.adbs.ast.Token;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public abstract class BaseScanner {
    private final List<Token> tokens = new ArrayList<Token>();
    protected Buffer buffer;
    protected int ch;
    protected char valCh;
    protected int pos;
    protected int line;
    protected int lineStart;
    protected int oldEols;
    protected BitSet ignore;
    protected boolean allowComments = true;
    protected boolean allowSpaces = true;
    protected StartTable start = new StartTable();

    public BaseScanner() {
        this.ignore = new BitSet(65535);
        this.ignore.set(32, true);
        this.initInternal();
    }

    public int getCount() {
        return this.tokens.size();
    }

    public boolean getAllowComments() {
        return this.allowComments;
    }

    public void setAllowComments(boolean value) {
        this.allowComments = value;
    }

    public boolean getAllowSpaces() {
        return this.allowSpaces;
    }

    public void setAllowSpaces(boolean value) {
        this.allowSpaces = value;
    }

    public void init(String s) {
        Token node;
        this.buffer = new Buffer();
        this.buffer.fill(s);
        this.pos = -1;
        this.line = 1;
        this.lineStart = 0;
        this.oldEols = 0;
        this.nextCh();
        this.tokens.clear();
        do {
            node = this.nextToken();
            this.tokens.add(node);
        } while (node.kind != 0);
        node.val = "EOF";
        this.buffer = null;
    }

    public Token getToken(int i) {
        if (i >= 0 && i < this.tokens.size()) {
            return this.tokens.get(i);
        }
        return this.tokens.get(this.tokens.size() - 1);
    }

    protected void nextCh() {
        if (this.oldEols > 0) {
            this.ch = 13;
            --this.oldEols;
        } else {
            this.ch = this.buffer.read();
            ++this.pos;
            if (this.ch == 10 && this.buffer.peek() != 13) {
                this.ch = 13;
            }
            if (this.ch == 13) {
                if (this.buffer.peek() == 10) {
                    this.buffer.read();
                    ++this.pos;
                }
                ++this.line;
                this.lineStart = this.pos + 1;
            }
        }
        this.valCh = (char)this.ch;
        if (this.ch != -1) {
            this.ch = Character.toLowerCase((char)this.ch);
        }
    }

    public abstract void checkLiteral(Token var1);

    public abstract Token nextToken();

    public abstract void initInternal();
}

