/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstNode;
import com.adbs.ast.AstToken;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseParser;
import com.adbs.ast.BaseScanner;
import com.adbs.ast.IdentQuotation;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataProcedure;
import com.adbs.ast.MetadataQualifiedNameList;
import com.adbs.ast.MetadataSynonym;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.MetadataView;
import com.adbs.ast.ParsingException;
import com.adbs.ast.SQLAliasObjectAlias;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderFast;
import com.adbs.ast.SQLDatabaseObject;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLFromObject;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSelectItem;
import com.adbs.ast.SQLSelectStatement;
import com.adbs.ast.SQLSubSelectStatement;
import com.adbs.ast.SyntaxProviderChangedEvent;
import com.adbs.ast.SyntaxProviderChangedEventListener;
import com.adbs.ast.Token;
import com.adbs.ast.UpdatablePersistent;
import com.adbs.ast.WayPoint;
import com.adbs.ast.WayPointList;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class BaseSQLContext
extends UpdatablePersistent
implements BaseSyntaxProvider.DestroyedEventListener,
BaseSyntaxProvider.ChangedEventListener {
    private static final long serialVersionUID = 1L;
    private BaseScanner identifiersScanner;
    private BaseParser identifiersParser;
    private BaseScanner qualifiedNamesScanner;
    private BaseParser qualifiedNamesParser;
    private final ReentrantLock lock = new ReentrantLock();
    private BaseSyntaxProvider syntaxProvider = null;
    private BaseMetadataProvider metadataProvider = null;
    private MetadataContainer metadataContainer = null;
    private SQLBuilder sqlBuilderExpression;
    private SQLBuilder sqlBuilderExpressionQuoted;
    private SQLBuilder sqlBuilderExpressionNonQuoted;
    private SQLBuilder sqlBuilderExpressionForServer;
    private SQLBuilder sqlBuilderExpressionForServerWithoutQuotes;
    private SQLBuilder sqlBuilderMetadata;
    private SQLQualifiedNameList builtinFunctionsCache;
    private SQLQualifiedNameList prefixed1ParamAggregateNames;
    private SQLQualifiedNameList oneParamAggregateNames;
    private SQLQualifiedNameList starAggregateNames;
    private boolean syntaxProviderChangedFlag = false;
    private HashMap<AstNode, Integer> astNodes = new HashMap();
    protected List<SyntaxProviderChangedEventListener> syntaxProviderChangedEventListenerList = new ArrayList<SyntaxProviderChangedEventListener>();
    BaseMetadataProvider.AfterConnectEventListener afterConnectEventListener = new BaseMetadataProvider.AfterConnectEventListener(){

        @Override
        public void afterConnectEventOccurred(BaseMetadataProvider.AfterConnectEvent event) {
            if (BaseSQLContext.this.syntaxProvider != null) {
                BaseSQLContext.this.syntaxProvider.resetCachedDefaultDatabaseName();
            }
        }
    };

    public BaseSQLContext(UpdatablePersistent parent) {
        super(parent);
        this.sqlBuilderExpression = new SQLBuilderFast(this);
        this.sqlBuilderExpressionQuoted = new SQLBuilderFast(this);
        this.sqlBuilderExpressionQuoted.setQuoteIdentifiers(IdentQuotation.All);
        this.sqlBuilderExpressionNonQuoted = new SQLBuilderFast(this);
        this.sqlBuilderExpressionNonQuoted.setQuoteIdentifiers(IdentQuotation.None);
        this.sqlBuilderExpressionForServer = new SQLBuilderFast(this);
        this.sqlBuilderExpressionForServer.setUseAltNames(false);
        this.sqlBuilderExpressionForServerWithoutQuotes = new SQLBuilderFast(this);
        this.sqlBuilderExpressionForServerWithoutQuotes.setUseAltNames(false);
        this.sqlBuilderExpressionForServerWithoutQuotes.setQuoteIdentifiers(IdentQuotation.None);
        this.sqlBuilderMetadata = new SQLBuilderFast(this);
        this.sqlBuilderMetadata.setQuoteIdentifiers(IdentQuotation.None);
    }

    @Override
    public void dispose() {
        if (this.syntaxProvider != null) {
            this.syntaxProvider.removeDestroyedEventListener(this);
            this.syntaxProvider.removeChangedEventListener(this);
        }
        if (this.metadataProvider != null) {
            this.metadataProvider.removeAfterConnectEventListener(this.afterConnectEventListener);
        }
        this.sqlBuilderMetadata.dispose();
        this.sqlBuilderExpressionForServerWithoutQuotes.dispose();
        this.sqlBuilderExpressionForServer.dispose();
        this.sqlBuilderExpressionNonQuoted.dispose();
        this.sqlBuilderExpressionQuoted.dispose();
        this.sqlBuilderExpression.dispose();
        this.invalidateBuiltinFunctionNamesCache();
        this.invalidateAggregateNamesCache();
        super.dispose();
    }

    public void registerAstNode(AstNode node) {
        this.astNodes.put(node, 0);
    }

    public void unregisterAstNode(AstNode node) {
        this.astNodes.remove(node);
    }

    public SQLSelectStatement parseSelect(String sql) throws ParsingException, QueryBuilderException {
        if (this.syntaxProvider != null) {
            BaseScanner s = this.syntaxProvider.createScanner();
            s.init(sql);
            BaseParser p = this.syntaxProvider.createParser(s, this);
            WayPoint w = new WayPoint(null, 0);
            WayPointList l = new WayPointList();
            try {
                l.add(w);
                p.parseSelectWayCalc(l);
                p.expect(l, 0);
                if (l.size() != 0) {
                    WayPoint way = p.selectBestWay(l);
                    p.unrollWay(way);
                    p.getWayNode();
                    SQLSelectStatement sQLSelectStatement = p.parseSelect();
                    return sQLSelectStatement;
                }
                Token t = p.getBadToken() != -1 ? s.getToken(p.getBadToken()) : null;
                throw new ParsingException(Helpers.localizer.getString("strBadSelectStatement", "Invalid SELECT statement."), t);
            }
            finally {
                l.clear();
            }
        }
        throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLSubSelectStatement parseSubQuery(String sql) {
        SQLSubSelectStatement result;
        block5: {
            if (this.syntaxProvider != null) {
                BaseScanner s = this.syntaxProvider.createScanner();
                s.init(sql);
                BaseParser p = this.syntaxProvider.createParser(s, this);
                WayPoint w = new WayPoint(null, 0);
                WayPointList l = new WayPointList();
                try {
                    l.add(w);
                    p.parseSubQueryWayCalc(l);
                    p.expect(l, 0);
                    if (l.size() != 0) {
                        p.unrollWay((WayPoint)l.get(0));
                        p.getWayNode();
                        result = p.parseSubQuery();
                        break block5;
                    }
                    Object result2 = null;
                    Token t = p.getBadToken() != -1 ? s.getToken(p.getBadToken()) : null;
                    throw new ParsingException(Helpers.localizer.getString("strBadSelectStatement", "Invalid SELECT statement."), t);
                }
                finally {
                    l.clear();
                }
            }
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AstTokenIdentifier parseIdentifier(String identifier) throws ParsingException {
        AstTokenIdentifier result;
        if (this.syntaxProvider != null) {
            if (!Str.IsNullOrEmpty(identifier)) {
                BaseScanner s = this.getIdentifiersScanner();
                this.lock.lock();
                try {
                    s.init(identifier);
                    BaseParser p = this.getIdentifiersParser();
                    WayPoint w = new WayPoint(null, 0);
                    WayPointList l = new WayPointList();
                    try {
                        l.add(w);
                        p.parseIdentifierWayCalc(l);
                        p.expect(l, 0);
                        if (l.size() != 0) {
                            p.unrollWay((WayPoint)l.get(0));
                            p.getWayNode();
                            result = p.parseIdentifier();
                        }
                        result = null;
                    }
                    finally {
                        l.clear();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            } else {
                result = null;
            }
        } else {
            result = new AstTokenIdentifier(this, identifier, false);
        }
        return result;
    }

    public AstTokenIdentifier parseIdentifierQuoteIfNeed(String identifier) throws ParsingException {
        AstTokenIdentifier result = this.parseIdentifier(identifier);
        if (result == null) {
            result = this.parseIdentifier(this.syntaxProvider.getQuoteBegin() + identifier + this.syntaxProvider.getQuoteEnd());
        }
        if (result == null) {
            result = this.parseIdentifier(Helpers.createQuotedIdentifier(identifier, this.syntaxProvider.getQuoteBegin(), this.syntaxProvider.getQuoteEnd()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLQualifiedName parseQualifiedName(String qualifiedName) throws ParsingException {
        SQLQualifiedName result;
        if (this.syntaxProvider != null) {
            if (!Str.IsNullOrEmpty(qualifiedName)) {
                BaseScanner s = this.getQualifiedNamesScanner();
                this.lock.lock();
                try {
                    s.init(qualifiedName);
                    BaseParser p = this.getQualifiedNamesParser();
                    WayPoint w = new WayPoint(null, 0);
                    WayPointList l = new WayPointList();
                    try {
                        l.add(w);
                        p.parseObjectNameWayCalc(l);
                        p.expect(l, 0);
                        if (l.size() != 0) {
                            p.unrollWay((WayPoint)l.get(0));
                            p.getWayNode();
                            result = p.parseObjectName();
                        }
                        result = null;
                    }
                    finally {
                        l.clear();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            } else {
                result = null;
            }
        } else {
            result = new SQLQualifiedName(this);
            result.addName(qualifiedName, false);
        }
        return result;
    }

    public SQLQualifiedName parseQualifiedNameQuoteIfNeed(String qualifiedName) throws ParsingException {
        SQLQualifiedName result = this.parseQualifiedName(qualifiedName);
        if (result == null) {
            result = this.parseQualifiedName(this.syntaxProvider.getQuoteBegin() + qualifiedName + this.syntaxProvider.getQuoteEnd());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLDatabaseObject parseObjectName(String objectName) throws ParsingException {
        SQLDatabaseObject result;
        if (this.syntaxProvider != null) {
            BaseScanner s = this.syntaxProvider.createScanner();
            s.init(objectName);
            BaseParser p = this.syntaxProvider.createParser(s, this);
            WayPoint w = new WayPoint(null, 0);
            WayPointList l = new WayPointList();
            try {
                l.add(w);
                p.parseObjectNameWayCalc(l);
                p.expect(l, 0);
                if (l.size() != 0) {
                    p.unrollWay((WayPoint)l.get(0));
                    p.getWayNode();
                    result = p.parseObjectName();
                }
                result = null;
            }
            finally {
                l.clear();
            }
        } else {
            result = new SQLDatabaseObject(this);
            result.addName(objectName, false);
        }
        return result;
    }

    public SQLDatabaseObject parseObjectNameQuoteIfNeed(String objectName) throws ParsingException {
        if (!Str.IsNullOrEmpty(objectName)) {
            SQLDatabaseObject result = this.parseObjectName(objectName);
            if (result == null) {
                result = this.parseObjectName(this.syntaxProvider.getQuoteBegin() + objectName + this.syntaxProvider.getQuoteEnd());
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLExpressionItem parseExpression(String sql) throws ParsingException, QueryBuilderException {
        SQLExpressionItem result;
        block5: {
            if (this.syntaxProvider != null) {
                BaseScanner s = this.syntaxProvider.createScanner();
                s.init(sql);
                BaseParser p = this.syntaxProvider.createParser(s, this);
                WayPoint w = new WayPoint(null, 0);
                WayPointList l = new WayPointList();
                try {
                    l.add(w);
                    p.parseExpressionWayCalc(l);
                    p.expect(l, 0);
                    if (l.size() != 0) {
                        p.unrollWay((WayPoint)l.get(0));
                        p.getWayNode();
                        result = p.parseExpression();
                        break block5;
                    }
                    Object result2 = null;
                    Token t = p.getBadToken() != -1 ? s.getToken(p.getBadToken()) : null;
                    throw new ParsingException("Bad expression", t);
                }
                finally {
                    l.clear();
                }
            }
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLSelectItem parseSelectItem(String sql) throws QueryBuilderException, ParsingException {
        SQLSelectItem result = null;
        if (this.syntaxProvider != null) {
            BaseScanner s = this.syntaxProvider.createScanner();
            s.init(sql);
            BaseParser p = this.syntaxProvider.createParser(s, this);
            WayPoint w = new WayPoint(null, 0);
            WayPointList l = new WayPointList();
            try {
                l.add(w);
                p.parseSelectItemWayCalc(l);
                p.expect(l, 0);
                if (l.size() != 0) {
                    p.unrollWay((WayPoint)l.get(0));
                    p.getWayNode();
                    result = p.parseSelectItem();
                }
                result = null;
            }
            finally {
                l.clear();
            }
        } else {
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        return result;
    }

    public SQLExpressionItem parseLogicalExpression(String sql) {
        return this.parseLogicalExpression(sql, true, false);
    }

    public SQLExpressionItem parseLogicalExpression(String sql, boolean strict) {
        return this.parseLogicalExpression(sql, strict, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLExpressionItem parseLogicalExpression(String sql, boolean strict, boolean allowBooleanConstants) throws ParsingException, QueryBuilderException {
        SQLExpressionItem result = null;
        if (this.syntaxProvider != null) {
            BaseScanner s = this.syntaxProvider.createScanner();
            s.init(sql);
            BaseParser p = this.syntaxProvider.createParser(s, this);
            p.setStrictLogicalExpressions(strict);
            p.setAllowBooleanConstants(allowBooleanConstants);
            WayPoint w = new WayPoint(null, 0);
            WayPointList l = new WayPointList();
            try {
                l.add(w);
                p.parseLogicalExpressionWayCalc(l);
                p.expect(l, 0);
                if (l.size() != 0) {
                    p.unrollWay((WayPoint)l.get(0));
                    p.getWayNode();
                    result = p.parseLogicalExpression();
                }
                result = null;
            }
            finally {
                l.clear();
            }
        } else {
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLFromSource parseDatasource(String datasourceExpression) throws ParsingException, QueryBuilderException {
        SQLFromSource result;
        block5: {
            if (this.syntaxProvider != null) {
                BaseScanner s = this.syntaxProvider.createScanner();
                s.init(datasourceExpression);
                BaseParser p = this.syntaxProvider.createParser(s, this);
                WayPoint w = new WayPoint(null, 0);
                WayPointList l = new WayPointList();
                try {
                    l.add(w);
                    p.parseFromSourceWayCalc(l);
                    p.expect(l, 0);
                    if (l.size() != 0) {
                        p.unrollWay((WayPoint)l.get(0));
                        p.getWayNode();
                        result = p.parseFromSource();
                        break block5;
                    }
                    Object result2 = null;
                    Token t = p.getBadToken() != -1 ? s.getToken(p.getBadToken()) : null;
                    throw new ParsingException(Helpers.localizer.getString("strBadFromObjectExpression", "Invalid FROM object expression"), t);
                }
                finally {
                    l.clear();
                }
            }
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        return result;
    }

    public SQLFromObject createSQLFromObject(String objectName, String alias) throws ParsingException, QueryBuilderException {
        SQLFromObject result;
        SQLDatabaseObject qn = this.parseObjectNameQuoteIfNeed(objectName);
        if (qn != null) {
            result = new SQLFromObject(this);
            result.fromObj = qn;
            result.fromObj.datasource = result;
            if (!Str.IsNullOrEmpty(alias)) {
                result.alias = new SQLAliasObjectAlias(this);
                result.alias.alias = this.parseIdentifierQuoteIfNeed(alias);
            }
        } else {
            throw new QueryBuilderException(Helpers.localizer.getString("strBadObjectName", "Invalid object name"));
        }
        return result;
    }

    public SQLFromObject createSQLFromObject(SQLQualifiedName objectName, AstTokenIdentifier alias) {
        assert (objectName != null);
        SQLFromObject result = new SQLFromObject(this);
        result.fromObj = new SQLDatabaseObject(this);
        if (objectName != null) {
            result.fromObj.assign(objectName);
        }
        result.fromObj.datasource = result;
        if (alias != null) {
            result.alias = new SQLAliasObjectAlias(this);
            result.alias.alias = alias.clone(this);
        }
        return result;
    }

    public SQLFromObject createSQLFromObject(MetadataObject metadataObject, AstTokenIdentifier alias) {
        assert (metadataObject != null);
        SQLFromObject result = new SQLFromObject(this);
        result.fromObj = new SQLDatabaseObject(this);
        result.fromObj.assign(metadataObject.getFullName());
        result.fromObj.datasource = result;
        result.setMetadataObject(metadataObject);
        if (alias != null) {
            result.alias = new SQLAliasObjectAlias(this);
            result.alias.alias = alias.clone(this);
        }
        return result;
    }

    public void getDatabaseList(SQLQualifiedNameList databaseList) throws QueryBuilderException {
        if (this.syntaxProvider == null) {
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        this.syntaxProvider.getDatabaseList(this, databaseList);
    }

    public void loadMetadataObjects(MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.syntaxProvider == null) {
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        this.syntaxProvider.loadMetadataObjects(this, metadataContainer, metadataFilter, database);
    }

    public void loadMetadataRelations(MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.syntaxProvider == null) {
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        this.syntaxProvider.loadMetadataRelations(this, metadataContainer, metadataFilter, database);
    }

    public void loadMetadataForTable(MetadataTable metadataTable) throws QueryBuilderException {
        if (this.syntaxProvider == null) {
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        this.syntaxProvider.loadMetadataForTable(this, metadataTable);
    }

    public void loadMetadataForView(MetadataView metadataView) throws QueryBuilderException {
        if (this.syntaxProvider == null) {
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        this.syntaxProvider.loadMetadataForView(this, metadataView);
    }

    public void loadMetadataForProcedure(MetadataProcedure metadataProcedure) throws QueryBuilderException {
        if (this.syntaxProvider == null) {
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        this.syntaxProvider.loadMetadataForProcedure(this, metadataProcedure);
    }

    public void loadMetadataForSynonym(MetadataSynonym metadataSynonym) throws QueryBuilderException {
        if (this.syntaxProvider == null) {
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        this.syntaxProvider.loadMetadataForSynonym(this, metadataSynonym);
    }

    public void loadFieldsForQuery(String query, MetadataFieldList fieldList) throws QueryBuilderException {
        if (this.syntaxProvider == null) {
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        this.syntaxProvider.loadFieldsForQuery(this, query, fieldList);
    }

    public boolean isNameOfPrefixedAggregate(SQLQualifiedName name) {
        if (this.prefixed1ParamAggregateNames == null) {
            this.fillAggregateNamesCache();
        }
        return this.prefixed1ParamAggregateNames.findByName(name) != -1;
    }

    public boolean isNameOfAggregate(SQLQualifiedName name) {
        if (this.oneParamAggregateNames == null) {
            this.fillAggregateNamesCache();
        }
        return this.oneParamAggregateNames.findByName(name) != -1;
    }

    public boolean isNameOfStarAggregate(SQLQualifiedName name) {
        if (this.starAggregateNames == null) {
            this.fillAggregateNamesCache();
        }
        return this.starAggregateNames.findByName(name) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregateNormalize(SQLQualifiedName name) {
        int i;
        assert (this.syntaxProvider != null);
        if (this.starAggregateNames == null) {
            this.fillAggregateNamesCache();
        }
        if ((i = this.prefixed1ParamAggregateNames.findByName(name)) != -1) {
            name.assign(this.prefixed1ParamAggregateNames.get(i));
            return;
        }
        i = this.oneParamAggregateNames.findByName(name);
        if (i != -1) {
            name.assign(this.oneParamAggregateNames.get(i));
            return;
        }
        i = this.starAggregateNames.findByName(name);
        if (i != -1) {
            name.assign(this.starAggregateNames.get(i));
            return;
        }
        MetadataQualifiedNameList customAggregateFunctions = this.metadataContainer.getCustomAggregateFunctions();
        if (customAggregateFunctions.getCount() > 0) {
            SQLQualifiedNameList namesList = Helpers.generatePossibleFullNamesList(name);
            try {
                for (i = 0; i < namesList.getCount(); ++i) {
                    int j = customAggregateFunctions.findByName(namesList.get(i));
                    if (j == -1) continue;
                    name.assign(customAggregateFunctions.get(j));
                }
            }
            finally {
                namesList.dispose();
            }
        }
    }

    public boolean isNameOfBuiltinFunction(SQLQualifiedName name) {
        if (this.builtinFunctionsCache == null) {
            this.fillBuiltinFunctionNamesCache();
        }
        return this.builtinFunctionsCache.findByName(name) != -1;
    }

    public void builtinFunctionNormalize(SQLQualifiedName name) {
        int i;
        assert (this.syntaxProvider != null);
        if (this.builtinFunctionsCache == null) {
            this.fillBuiltinFunctionNamesCache();
        }
        if ((i = this.builtinFunctionsCache.findByName(name)) != -1) {
            name.assign(this.builtinFunctionsCache.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidIdent(String ident) {
        if (!Str.IsNullOrEmpty(ident) && !ident.startsWith(this.syntaxProvider.getQuoteBegin())) {
            BaseScanner s = this.getIdentifiersScanner();
            this.lock.lock();
            try {
                boolean bl;
                s.setAllowComments(false);
                s.setAllowSpaces(false);
                s.init(ident);
                BaseParser p = this.getIdentifiersParser();
                WayPoint w = new WayPoint(null, 0);
                WayPointList l = new WayPointList();
                try {
                    l.add(w);
                    p.parseIdentifierWayCalc(l);
                    p.expect(l, 0);
                    bl = l.size() != 0;
                }
                catch (Throwable throwable) {
                    l.clear();
                    throw throwable;
                }
                l.clear();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableExists(String tableName) {
        ResultSet resultSet = null;
        if (this.metadataProvider.canExecSQL()) {
            try {
                resultSet = this.metadataProvider.execSQL("select 1 as dummy_value from " + tableName + " where 0<>0", false);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception ignore) {
                }
                finally {
                    resultSet = null;
                }
            }
        }
        return false;
    }

    private String calcIdString(AstTokenIdentifier id) {
        if (this.syntaxProvider != null) {
            if (this.syntaxProvider.isIdentifiersCaseSensitive()) {
                if (id.getCaseSensitive()) {
                    return id.getToken();
                }
                if (this.syntaxProvider.isNonQuotedIdentifiersToUpperCase()) {
                    return id.getToken().toUpperCase();
                }
                return id.getToken().toLowerCase();
            }
            return id.getToken().toUpperCase();
        }
        if (!id.getCaseSensitive()) {
            return id.getToken().toUpperCase();
        }
        return id.getToken();
    }

    public int compareIdentifiers(AstTokenIdentifier id1, AstTokenIdentifier id2) {
        assert (id1 != null);
        assert (id2 != null);
        String s1 = this.calcIdString(id1);
        String s2 = this.calcIdString(id2);
        return s1.compareTo(s2);
    }

    public int compareTokens(AstToken t1, AstToken t2) {
        assert (t1 != null);
        assert (t2 != null);
        if (t1 instanceof AstTokenIdentifier && t2 instanceof AstTokenIdentifier) {
            return this.compareIdentifiers((AstTokenIdentifier)t1, (AstTokenIdentifier)t2);
        }
        return t1.getToken().compareTo(t2.getToken());
    }

    public int compareQualifiedNames(SQLQualifiedName n1, SQLQualifiedName n2) {
        int result = 0;
        ArrayList l1 = new ArrayList();
        ArrayList l2 = new ArrayList();
        n1.getTokensToCompare(l1);
        n2.getTokensToCompare(l2);
        if (l1.size() < l2.size()) {
            result = -1;
        } else if (l1.size() > l2.size()) {
            result = 1;
        } else if (l1.size() == 0 && l2.size() == 0) {
            result = 0;
        } else {
            result = 0;
            for (int i = l1.size() - 1; i >= 0; --i) {
                AstToken t1 = (AstToken)l1.get(i);
                AstToken t2 = (AstToken)l2.get(i);
                assert (t1 != null);
                assert (t2 != null);
                result = this.compareTokens(t1, t2);
                if (result == 0) continue;
                return result;
            }
        }
        return result;
    }

    public int compareQualifiedNamesFull(SQLQualifiedName n1, SQLQualifiedName n2) {
        int result;
        ArrayList l1 = new ArrayList();
        ArrayList l2 = new ArrayList();
        n1.getAllTokensToCompare(l1);
        n2.getAllTokensToCompare(l2);
        if (l1.size() < l2.size()) {
            result = -1;
        } else if (l1.size() > l2.size()) {
            result = 1;
        } else if (l1.size() == 0 && l2.size() == 0) {
            result = 0;
        } else {
            result = 0;
            for (int i = l1.size() - 1; i >= 0; --i) {
                AstToken t1 = (AstToken)l1.get(i);
                AstToken t2 = (AstToken)l2.get(i);
                assert (t1 != null);
                assert (t2 != null);
                result = this.compareTokens(t1, t2);
                if (result == 0) continue;
                return result;
            }
        }
        return result;
    }

    public boolean isQualifiedNamesEqual(SQLQualifiedName name1, SQLQualifiedName name2) {
        if (name1 == name2 || name1 == null && name2 == null) {
            return true;
        }
        if (name1 == null && name2.getCount() == 0 && name2.dbLink == null || name2 == null && name1.getCount() == 0 && name1.dbLink == null) {
            return true;
        }
        if (name1 == null || name2 == null) {
            return false;
        }
        if (name1.getCount() == 0 && name2.getCount() == 0 && name1.dbLink == null && name2.dbLink == null) {
            return true;
        }
        if (name1.getCount() != name2.getCount()) {
            return false;
        }
        if (name1.dbLink == null && name2.dbLink == null) {
            return name1.get(0).getToken().compareToIgnoreCase(name2.get(0).getToken()) == 0 && this.compareQualifiedNames(name1, name2) == 0;
        }
        return this.compareQualifiedNames(name1, name2) == 0;
    }

    public boolean isQualifiedNamesFullEqual(SQLQualifiedName name1, SQLQualifiedName name2) {
        if (name1 == name2 || name1 == null && name2 == null) {
            return true;
        }
        if (name1 == null || name2 == null) {
            return false;
        }
        return this.compareQualifiedNamesFull(name1, name2) == 0;
    }

    public boolean isIdentifiersEqual(AstTokenIdentifier id1, AstTokenIdentifier id2) {
        return id1 == id2 || this.compareIdentifiers(id1, id2) == 0;
    }

    @Override
    protected void doUpdated() {
        if (this.syntaxProviderChangedFlag) {
            this.identifiersParser = null;
            this.identifiersScanner = null;
            this.qualifiedNamesParser = null;
            this.qualifiedNamesScanner = null;
            this.fireSyntaxProviderChangedEvent(new SyntaxProviderChangedEvent(this));
        }
        this.syntaxProviderChangedFlag = false;
        Set<AstNode> keys = this.astNodes.keySet();
        Iterator<AstNode> iterator = keys.iterator();
        while (iterator.hasNext()) {
            iterator.next().onSyntaxProviderChanged(this);
        }
        super.doUpdated();
    }

    private void notifySyntaxProviderChanged() {
        assert (this.isUpdating());
        this.syntaxProviderChangedFlag = true;
        this.invalidateAggregateNamesCache();
        this.invalidateBuiltinFunctionNamesCache();
        this.notifyUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Object source) {
        if (source instanceof BaseSQLContext) {
            this.beginUpdate();
            try {
                this.setSyntaxProvider(((BaseSQLContext)source).getSyntaxProvider());
                this.setMetadataProvider(((BaseSQLContext)source).getMetadataProvider());
                this.setSQLBuilderExpression(((BaseSQLContext)source).getSQLBuilderExpression());
                this.setSQLBuilderExpressionQuoted(((BaseSQLContext)source).getSQLBuilderExpressionQuoted());
                this.setSQLBuilderExpressionNonQuoted(((BaseSQLContext)source).getSQLBuilderExpressionNonQuoted());
                this.setSQLBuilderExpressionForServer(((BaseSQLContext)source).getSQLBuilderExpressionForServer());
                this.setSQLBuilderExpressionForServerWithoutQuotes(((BaseSQLContext)source).getSQLBuilderExpressionForServerWithoutQuotes());
                this.setSQLBuilderMetadata(((BaseSQLContext)source).getSQLBuilderMetadata());
            }
            finally {
                this.endUpdate();
            }
        } else {
            super.assign(source);
        }
    }

    public BaseScanner getIdentifiersScanner() {
        assert (this.getSyntaxProvider() != null);
        BaseScanner result = this.identifiersScanner != null ? this.identifiersScanner : (this.identifiersScanner = this.getSyntaxProvider().createScanner());
        return result;
    }

    public BaseParser getIdentifiersParser() {
        assert (this.getSyntaxProvider() != null);
        BaseParser result = this.identifiersParser != null ? this.identifiersParser : (this.identifiersParser = this.getSyntaxProvider().createParser(this.identifiersScanner, this));
        return result;
    }

    public BaseScanner getQualifiedNamesScanner() {
        assert (this.getSyntaxProvider() != null);
        BaseScanner result = this.qualifiedNamesScanner != null ? this.qualifiedNamesScanner : (this.qualifiedNamesScanner = this.getSyntaxProvider().createScanner());
        return result;
    }

    public BaseParser getQualifiedNamesParser() {
        assert (this.getSyntaxProvider() != null);
        BaseParser result = this.qualifiedNamesParser != null ? this.qualifiedNamesParser : (this.qualifiedNamesParser = this.getSyntaxProvider().createParser(this.getQualifiedNamesScanner(), this));
        return result;
    }

    public BaseSyntaxProvider getSyntaxProvider() {
        return this.syntaxProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyntaxProvider(BaseSyntaxProvider value) {
        if (this.syntaxProvider != value) {
            this.beginUpdate();
            try {
                if (this.syntaxProvider != null) {
                    this.syntaxProvider.removeDestroyedEventListener(this);
                    this.syntaxProvider.removeChangedEventListener(this);
                }
                this.syntaxProvider = value;
                if (this.syntaxProvider != null) {
                    this.syntaxProvider.addDestroyedEventListener(this);
                    this.syntaxProvider.addChangedEventListener(this);
                }
                this.notifySyntaxProviderChanged();
            }
            finally {
                this.endUpdate();
            }
        }
    }

    public BaseMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(BaseMetadataProvider value) {
        if (this.metadataProvider != value) {
            this.metadataProvider = value;
            if (this.metadataProvider != null) {
                this.metadataProvider.addAfterConnectEventListener(this.afterConnectEventListener);
            }
            this.notifyUpdated();
        }
    }

    public MetadataContainer getMetadataContainer() {
        return this.metadataContainer;
    }

    public void setMetadataContainer(MetadataContainer value) {
        if (this.metadataContainer != value) {
            this.metadataContainer = value;
            this.notifyUpdated();
        }
    }

    public SQLBuilder getSQLBuilderExpression() {
        return this.sqlBuilderExpression;
    }

    public void setSQLBuilderExpression(SQLBuilder value) {
        if (this.sqlBuilderExpression != value) {
            this.sqlBuilderExpression.assign(value);
            this.notifyUpdated();
        }
    }

    public SQLBuilder getSQLBuilderExpressionQuoted() {
        return this.sqlBuilderExpressionQuoted;
    }

    public void setSQLBuilderExpressionQuoted(SQLBuilder value) {
        if (this.sqlBuilderExpressionQuoted != value) {
            this.sqlBuilderExpressionQuoted.assign(value);
            this.notifyUpdated();
        }
    }

    public SQLBuilder getSQLBuilderExpressionNonQuoted() {
        return this.sqlBuilderExpressionNonQuoted;
    }

    public void setSQLBuilderExpressionNonQuoted(SQLBuilder value) {
        if (this.sqlBuilderExpressionNonQuoted != value) {
            this.sqlBuilderExpressionNonQuoted.assign(value);
            this.notifyUpdated();
        }
    }

    public SQLBuilder getSQLBuilderExpressionForServer() {
        return this.sqlBuilderExpressionForServer;
    }

    public void setSQLBuilderExpressionForServer(SQLBuilder value) {
        if (this.sqlBuilderExpressionForServer != value) {
            this.sqlBuilderExpressionForServer.assign(value);
            this.notifyUpdated();
        }
    }

    public SQLBuilder getSQLBuilderExpressionForServerWithoutQuotes() {
        return this.sqlBuilderExpressionForServerWithoutQuotes;
    }

    public void setSQLBuilderExpressionForServerWithoutQuotes(SQLBuilder value) {
        if (this.sqlBuilderExpressionForServerWithoutQuotes != value) {
            this.sqlBuilderExpressionForServerWithoutQuotes.assign(value);
            this.notifyUpdated();
        }
    }

    public SQLBuilder getSQLBuilderMetadata() {
        return this.sqlBuilderMetadata;
    }

    public void setSQLBuilderMetadata(SQLBuilder value) {
        if (this.sqlBuilderMetadata != value) {
            this.sqlBuilderMetadata.assign(value);
            this.notifyUpdated();
        }
    }

    public void addSyntaxProviderChangedEventListener(SyntaxProviderChangedEventListener listener) {
        this.syntaxProviderChangedEventListenerList.add(listener);
    }

    public void removeSyntaxProviderChangedEventListener(SyntaxProviderChangedEventListener listener) {
        this.syntaxProviderChangedEventListenerList.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSyntaxProviderChangedEvent(SyntaxProviderChangedEvent evt) {
        List<SyntaxProviderChangedEventListener> list;
        List<SyntaxProviderChangedEventListener> list2 = list = Collections.synchronizedList(new ArrayList<SyntaxProviderChangedEventListener>(this.syntaxProviderChangedEventListenerList));
        synchronized (list2) {
            ListIterator<SyntaxProviderChangedEventListener> listeners = list.listIterator();
            while (listeners.hasNext()) {
                listeners.next().syntaxProviderChangedEventOccurred(evt);
            }
        }
    }

    @Override
    public void destroyedEventOccurred(BaseSyntaxProvider.DestroyedEvent event) {
        this.setSyntaxProvider(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changedEventOccurred(BaseSyntaxProvider.ChangedEvent event) {
        this.beginUpdate();
        try {
            this.notifySyntaxProviderChanged();
        }
        finally {
            this.endUpdate();
        }
    }

    public void loadMetadataCustomAggregateNames(MetadataContainer metadataContainer, SQLQualifiedName database) {
        if (this.syntaxProvider == null) {
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        this.syntaxProvider.loadMetadataCustomAggregateNames(this, metadataContainer, database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNameOfCustomAggregate(SQLQualifiedName name) {
        assert (!Helpers.isQualifiedNameEmpty(name));
        SQLQualifiedNameList namesList = Helpers.generatePossibleFullNamesList(name);
        try {
            for (int i = 0; i < namesList.getCount(); ++i) {
                if (this.metadataContainer.getCustomAggregateFunctions().findByName(namesList.get(i)) == -1) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            namesList.dispose();
        }
        return false;
    }

    private void invalidateAggregateNamesCache() {
        if (this.prefixed1ParamAggregateNames != null) {
            this.prefixed1ParamAggregateNames.dispose();
            this.prefixed1ParamAggregateNames = null;
        }
        if (this.oneParamAggregateNames != null) {
            this.oneParamAggregateNames.dispose();
            this.oneParamAggregateNames = null;
        }
        if (this.starAggregateNames != null) {
            this.starAggregateNames.dispose();
            this.starAggregateNames = null;
        }
    }

    private void fillAggregateNamesCache() {
        this.prefixed1ParamAggregateNames = new SQLQualifiedNameList(this);
        this.syntaxProvider.getPrefixed1ParamAggregateNames(this.prefixed1ParamAggregateNames);
        this.oneParamAggregateNames = new SQLQualifiedNameList(this);
        this.syntaxProvider.get1ParamAggregateNames(this.oneParamAggregateNames);
        this.starAggregateNames = new SQLQualifiedNameList(this);
        this.syntaxProvider.getStarAggregateNames(this.starAggregateNames);
    }

    private void invalidateBuiltinFunctionNamesCache() {
        if (this.builtinFunctionsCache != null) {
            this.builtinFunctionsCache.dispose();
            this.builtinFunctionsCache = null;
        }
    }

    private void fillBuiltinFunctionNamesCache() {
        this.builtinFunctionsCache = new SQLQualifiedNameList(this);
        this.syntaxProvider.getBuiltinFunctionNames(this.builtinFunctionsCache);
    }
}

