/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstExtender;
import com.adbs.ast.AstFieldList;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AstNode
extends AstExtender {
    public AstExtender extender;

    public AstNode(BaseSQLContext sqlContext) {
        super(sqlContext);
        this.updateExtender();
        sqlContext.registerAstNode(this);
    }

    @Override
    public void dispose() {
        this.sqlContext.unregisterAstNode(this);
        super.dispose();
    }

    public AstExtender getExtender() {
        return this.extender;
    }

    public void setExtender(AstExtender extender) {
        this.extender = extender;
    }

    void onSyntaxProviderChanged(Object sender) {
        this.updateExtender();
    }

    @Override
    public AstNode clone(BaseSQLContext sqlContext) {
        return (AstNode)super.clone(sqlContext);
    }

    @Override
    protected void getASTFields(AstFieldList l) {
        super.getASTFields(l);
        try {
            l.add(AstNode.class.getField("extender"));
        }
        catch (Exception ex) {
            Logger.getLogger(AstNode.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void updateExtender() {
        Class extenderClass = this.sqlContext.getSyntaxProvider() != null ? this.sqlContext.getSyntaxProvider().findExtenderClass(this.getClass(), true) : null;
        if (extenderClass != null) {
            if (this.extender != null) {
                if (this.extender.getClass() != extenderClass) {
                    AstExtender oldExtender = this.extender;
                    try {
                        Constructor c = extenderClass.getConstructor(BaseSQLContext.class);
                        this.extender = (AstExtender)c.newInstance(this.sqlContext);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(AstNode.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.extender.assign(oldExtender);
                    oldExtender = null;
                }
            } else {
                try {
                    Constructor c = extenderClass.getConstructor(BaseSQLContext.class);
                    this.extender = (AstExtender)c.newInstance(this.sqlContext);
                }
                catch (Exception ex) {
                    Logger.getLogger(AstNode.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            this.extender = null;
        }
    }

    public boolean editPropsInternal(AstNode n, Object parameter) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildSQL(SQLBuilder builder, SQLBuilderSelectFormat format) {
        builder.fireBeginBuildSQLForNodeEvent(this);
        try {
            if (this.extender != null) {
                this.extender.buildSQLForNode(this, builder, format);
            } else {
                this.buildSQLDirect(builder, format);
            }
        }
        finally {
            builder.fireEndBuildSQLForNodeEvent(this);
        }
    }

    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSimpleSQL(SQLBuilder sqlBuilder) {
        sqlBuilder.beginBuild();
        try {
            this.buildSQL(sqlBuilder, sqlBuilder.getMainQueryFormat());
        }
        finally {
            sqlBuilder.endBuild();
        }
        return sqlBuilder.getResult();
    }

    public void editProps(Object parameter) {
        AstNode c = this.clone(this.sqlContext);
        if (this.extender != null && this.extender.editPropsForNode(c, parameter) || this.extender == null && this.editPropsInternal(c, parameter)) {
            this.assign(c);
        }
    }
}

