/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.Version;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Ide;
import oracle.ide.IdeUIManager;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserInit;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ide.webbrowser.ProxySettingsPanel;
import oracle.ideimpl.webupdate.CheckMasterListRunnable;
import oracle.ideimpl.webupdate.CheckUpdatesRunnable;
import oracle.ideimpl.webupdate.InvalidLocalBundleException;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateCenterMonitor;
import oracle.ideimpl.webupdate.UpdateHook;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.WebUpdateAddin;
import oracle.ideimpl.webupdate.parser.Problems;
import oracle.ideimpl.webupdate.wizard.UpdateCenterPanel;
import oracle.ideimpl.webupdate.wizard.UpdatePageConditions;
import oracle.ideimpl.webupdate.wizard.UpdateWizardModel;
import oracle.ideimpl.webupdate.wizard.UpdateWizardPage;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.controls.SimpleListModel;
import oracle.javatools.controls.nicelist.NiceList;
import oracle.javatools.controls.nicelist.NiceListActionEvent;
import oracle.javatools.controls.nicelist.NiceListActionListener;
import oracle.javatools.controls.nicelist.NiceListRenderer;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.javatools.dialogs.BaseMessageDialog;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.icons.OracleIcons;

final class UpdateSourcePage
extends UpdateWizardPage {
    private final JMultiLineLabel _lbHint = new JMultiLineLabel();
    private final JRadioButton _rbUpdateCenter = new JRadioButton();
    private final NiceList _lstUpdateCenters = new NiceList();
    private final JButton _btnAddCenter = new JButton();
    private final JButton _btnRemoveCenter = new JButton();
    private final JButton _btnEditCenter = new JButton();
    private final JRadioButton _rbLocalFile = new JRadioButton();
    private final JLabel _lbFileName = new JLabel();
    private final URLTextField _tfLocalFileName = new URLTextField(){

        protected URLChooser createChooser(URL url) {
            URLChooser chooser = super.createChooser(url);
            chooser.setShowJarsAsDirs(false);
            return chooser;
        }
    };
    private final JButton _btnBrowse = new JButton();
    private final JPanel _panProgress = new JPanel();
    private final JProgressBar _pbUpdates = new JProgressBar();
    private final JLabel _lbProgress = new JLabel();
    private final JLabel _lbError = new JLabel();
    private final HyperlinkButton _hlError = new HyperlinkButton();
    private final GridBagLayout _layout = new GridBagLayout();
    private SimpleListModel _listModel;
    private boolean _checkedMasterList = false;
    private boolean _firstTime = true;
    private boolean _firstTimeForAutoupdate = true;
    private transient CheckMasterListRunnable _masterListChecker = null;
    private ActionListener _errorDetailsListener;
    private transient LocalUpdateBundle _localBundle;
    private boolean _isSaved = false;

    UpdateSourcePage() {
        this.resControls();
        this.layoutControls();
        this.installListeners();
        NiceListRenderer renderer = new NiceListRenderer(){

            public String getTitle(Object center) {
                return ((UpdateCenter)center).getName();
            }

            public String getDescription(Object center) {
                return URLFileSystem.getPlatformPathName((URL)URLFactory.newURL((String)((UpdateCenter)center).getURL()));
            }

            public boolean isItemSelected(Object center) {
                return ((UpdateCenter)center).isEnabled();
            }
        };
        renderer.setGradientColor(IdeUIManager.getActiveTitleGradientLightColor(), IdeUIManager.getActiveTitleGradientDarkColor());
        this._lstUpdateCenters.setCellRenderer((ListCellRenderer)renderer);
        this._lstUpdateCenters.setFireCheckboxActionOnDoubleClick(true);
        this._lstUpdateCenters.setSelectionMode(0);
        this._tfLocalFileName.setValidateExistingFile(true);
    }

    private void resControls() {
        this._lbHint.setText(UpdateArb.getString(96));
        ResourceUtils.resButton((AbstractButton)this._rbUpdateCenter, (String)UpdateArb.getString(97));
        ResourceUtils.resButton((AbstractButton)this._btnAddCenter, (String)UpdateArb.getString(98));
        ResourceUtils.resButton((AbstractButton)this._btnEditCenter, (String)UpdateArb.getString(100));
        ResourceUtils.resButton((AbstractButton)this._btnRemoveCenter, (String)UpdateArb.getString(99));
        ResourceUtils.resButton((AbstractButton)this._rbLocalFile, (String)UpdateArb.getString(101));
        ResourceUtils.resLabel((JLabel)this._lbFileName, (Component)this._tfLocalFileName, (String)UpdateArb.getString(102));
        ResourceUtils.resButton((AbstractButton)this._btnBrowse, (String)UpdateArb.getString(103));
        this._pbUpdates.setIndeterminate(true);
        this._tfLocalFileName.setDirectoryOnly(false);
        this._tfLocalFileName.setChooserInit(new URLChooserInit(){

            public void initURLChooser(URLChooser urlChooser) {
                urlChooser.clearChooseableURLFilters();
                urlChooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
                WildcardURLFilter allFilesFilter = new WildcardURLFilter("*.zip", false, UpdateArb.getString(116));
                urlChooser.addChooseableURLFilter((URLFilter)allFilesFilter);
                urlChooser.setURLFilter((URLFilter)allFilesFilter);
            }
        });
    }

    private void layoutControls() {
        this.setLayout(this._layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = INSETS_HINT;
        this.add((Component)this._lbHint, gbc);
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets = INSETS_GAP_BELOW;
        this.add(this._rbUpdateCenter, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 24, 5, 0);
        this.add(new JScrollPane((Component)this._lstUpdateCenters), gbc);
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setOrientation(1);
        buttonBar.setAlignment(1);
        buttonBar.add((Component)this._btnAddCenter);
        buttonBar.add((Component)this._btnRemoveCenter);
        buttonBar.add((Component)this._btnEditCenter);
        gbc.gridx += 2;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 5, 5, 0);
        this.add((Component)buttonBar, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 24, 5, 0);
        this._panProgress.setLayout(new BorderLayout(5, 0));
        this._panProgress.setVisible(false);
        this.add(this._panProgress, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.gridwidth = 3;
        gbc.fill = 0;
        gbc.insets = INSETS_GAP_BELOW;
        this.add(this._rbLocalFile, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 24, 0, 12);
        this.add(this._lbFileName, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = INSETS_ZERO;
        this.add((Component)this._tfLocalFileName, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        this.add(this._btnBrowse, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._rbUpdateCenter);
        bg.add(this._rbLocalFile);
    }

    private void installListeners() {
        Listener l = new Listener();
        this._rbUpdateCenter.addActionListener(l);
        this._rbLocalFile.addActionListener(l);
        this._btnBrowse.addActionListener(l);
        this._btnAddCenter.addActionListener(l);
        this._btnEditCenter.addActionListener(l);
        this._btnRemoveCenter.addActionListener(l);
        this._tfLocalFileName.getDocument().addDocumentListener(l);
        this._lstUpdateCenters.getSelectionModel().addListSelectionListener(l);
        this._lstUpdateCenters.addListActionListener((NiceListActionListener)l);
        this._lstUpdateCenters.addKeyListener((KeyListener)l);
        this._rbUpdateCenter.setSelected(true);
        this.updateEnabledControls();
    }

    @Override
    public boolean isComplete() {
        if (this._rbUpdateCenter.isSelected()) {
            if (this._masterListChecker != null && this._masterListChecker.isRunning()) {
                return false;
            }
            for (int i = 0; i < this._lstUpdateCenters.getModel().getSize(); ++i) {
                UpdateCenter center = (UpdateCenter)this._lstUpdateCenters.getModel().getElementAt(i);
                if (!center.isEnabled()) continue;
                return true;
            }
            return false;
        }
        return this._tfLocalFileName.getText().trim().length() > 0;
    }

    @Override
    public Component getInitialFocus() {
        return this._rbUpdateCenter;
    }

    @Override
    public void pageSelected(TraversableContext context) {
        this._isSaved = false;
        if (this._firstTimeForAutoupdate && this.getModel(context).isSourceSkipped()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateSourcePage.this.getTraversableContext().getWizardCallbacks().nextPage();
                }
            });
            this._firstTimeForAutoupdate = false;
            return;
        }
        if (this._firstTime) {
            this._listModel = new SimpleListModel(this.getModel(context).getAllUpdateCenters());
            this._lstUpdateCenters.setModel((ListModel)this._listModel);
            this._firstTime = false;
        }
        if (!this._checkedMasterList) {
            this.checkMasterList(context);
            this._checkedMasterList = true;
        }
        this.defaultLocalFilename();
    }

    private void defaultLocalFilename() {
        if (this._tfLocalFileName.getText().trim().length() > 0) {
            return;
        }
        URL lastLocalBundle = WebUpdateAddin.getPreferences().getLastLocalBundleURL();
        if (lastLocalBundle == null) {
            return;
        }
        this._tfLocalFileName.setURL(lastLocalBundle);
    }

    private void storeLocalFilename() {
        if (this._tfLocalFileName.getText().trim().length() == 0) {
            return;
        }
        URL url = this._tfLocalFileName.getURL();
        if (url == null) {
            return;
        }
        WebUpdateAddin.getPreferences().setLastLocalBundleURL(url);
    }

    private void checkMasterList(final TraversableContext context) {
        this._masterListChecker = new CheckMasterListRunnable(this.getModel(context).getUpdateManager().getMasterServerURL()){

            @Override
            protected void failed(final Throwable t) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UpdateSourcePage.this._masterListChecker = null;
                        UpdateSourcePage.this.masterListUpdateError(context, t);
                        UpdateSourcePage.this.completeValueChanged();
                    }
                });
            }

            @Override
            protected void finished(final List l) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UpdateSourcePage.this._masterListChecker = null;
                        UpdateSourcePage.this.processMasterList(context, l);
                        UpdateSourcePage.this.completeValueChanged();
                    }
                });
            }
        };
        ProgressMonitor monitor = new ProgressMonitor();
        this._masterListChecker.setMonitor(monitor);
        Thread t = new Thread((Runnable)this._masterListChecker, "Update Master List Checker");
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean proxyPrompt() {
        ProxyOptions options = ProxyOptions.getProxyOptions();
        ProxySettingsPanel psp = new ProxySettingsPanel();
        psp.setProxyOptions(options);
        MessagePanel mp = new MessagePanel();
        mp.setMessageType(4);
        mp.setMessageText(UpdateArb.getString(172));
        mp.addMessageComponent((Component)psp);
        HelpUtils.setHelpID((JComponent)mp, (String)"f1_idewideupdatetimeout_html");
        JEWTDialog jd = JEWTDialog.createDialog((Component)((Object)this), (String)UpdateArb.getString(173), (int)7);
        jd.setContent((Component)mp);
        try {
            if (jd.runDialog()) {
                ProxyOptions.setProxyOptions((ProxyOptions)psp.getProxyOptions());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            jd.dispose();
        }
    }

    private void masterListUpdateError(TraversableContext context, Throwable t) {
        if (this.proxyPrompt()) {
            this.checkMasterList(context);
            return;
        }
        this._panProgress.removeAll();
        this._panProgress.add((Component)this._lbError, "West");
        this._panProgress.add((Component)this._hlError, "East");
        this._lbError.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this._lbError.setText(UpdateArb.getString(111));
        this._hlError.setText(UpdateArb.getString(112));
        if (this._errorDetailsListener != null) {
            this._hlError.removeActionListener(this._errorDetailsListener);
        }
        this._errorDetailsListener = new ErrorDetailsListener(t);
        this._hlError.addActionListener(this._errorDetailsListener);
        this._panProgress.invalidate();
        this._panProgress.validate();
        this._panProgress.setVisible(true);
    }

    private void processMasterList(TraversableContext context, List masterListCenters) {
        UpdateHook updateHook = (UpdateHook)ExtensionRegistry.getExtensionRegistry().getHook(UpdateHook.ELEMENT);
        masterListCenters.addAll(updateHook.getUpdateCenters());
        for (UpdateCenter masterServer : masterListCenters) {
            if (masterServer.getMasterId() == null) continue;
            UpdateCenter existingEntry = this.findCenterByMasterId(masterServer.getMasterId(), this.getModel(context).getAllUpdateCenters());
            if (existingEntry == null) {
                masterServer.setEnabled(masterServer.isSelectedByDefault());
                this._listModel.addElement((Object)masterServer);
                continue;
            }
            boolean different = false;
            if (!existingEntry.isEnabledChangedByUser()) {
                existingEntry.setEnabled(masterServer.isSelectedByDefault());
            }
            if (!existingEntry.getURL().equals(masterServer.getURL())) {
                existingEntry.setURL(masterServer.getURL());
                different = true;
            }
            if (!existingEntry.getName().equals(masterServer.getName())) {
                existingEntry.setName(masterServer.getName());
                different = true;
            }
            if (existingEntry.isProtected() != masterServer.isProtected()) {
                existingEntry.setProtected(masterServer.isProtected());
                different = true;
            }
            if (!different) continue;
            int index = this.getModel(context).getAllUpdateCenters().indexOf(existingEntry);
            this._listModel.changed(index);
        }
        ArrayList<UpdateCenter> serversToRemove = new ArrayList<UpdateCenter>();
        for (UpdateCenter localServer : this.getModel(context).getAllUpdateCenters()) {
            UpdateCenter masterEntry;
            if (localServer.getMasterId() == null || (masterEntry = this.findCenterByMasterId(localServer.getMasterId(), masterListCenters)) != null) continue;
            serversToRemove.add(localServer);
        }
        Iterator i = serversToRemove.iterator();
        while (i.hasNext()) {
            this._listModel.removeElement(i.next());
        }
    }

    private UpdateCenter findCenterByMasterId(String masterId, List centers) {
        for (UpdateCenter thisCenter : centers) {
            if (!masterId.equals(thisCenter.getMasterId())) continue;
            return thisCenter;
        }
        return null;
    }

    private boolean haveLicenseAgreement(UpdateBundle bundle) {
        if (bundle == null) {
            return false;
        }
        for (UpdateInfo update : bundle.getUpdates()) {
            if (update.getClickThroughURL() == null) continue;
            return true;
        }
        return false;
    }

    public Object getExitTransition() {
        try {
            this.doSave(this.getTraversableContext());
            UpdateWizardModel model = this.getModel(this.getTraversableContext());
            UpdatePageConditions state = new UpdatePageConditions(this._rbLocalFile.isSelected(), this._rbLocalFile.isSelected() && model.getLocalBundle() != null && this.haveLicenseAgreement(model.getLocalBundle().getBundle()), this._rbLocalFile.isSelected() ? model.getLocalBundle().getBundle().getUpdates() : Collections.EMPTY_SET);
            if (state.isLocal()) {
                if (state.isLicense()) {
                    this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition((Object)"sourceToLicence");
                    return "sourceToLicence";
                }
                if (state.isSingleUser()) {
                    this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition((Object)"sourceToSummary");
                    return "sourceToSummary";
                }
                this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition((Object)"sourceToDlLocation");
                return "sourceToDlLocation";
            }
            return null;
        }
        catch (TraversalException te) {
            return null;
        }
    }

    private void doSave(TraversableContext context) throws TraversalException {
        if (!this._isSaved) {
            if (!this.doValidation(context)) {
                throw new TraversalException(null);
            }
            this.save(context);
            this._isSaved = true;
        }
    }

    @Override
    public final void onExit(TraversableContext context) throws TraversalException {
        this.doSave(context);
        this.pageDeselected(context);
    }

    @Override
    public void save(TraversableContext context) {
        try {
            UpdateManager.getInstance().setUpdateCenters(this.getModel(context).getAllUpdateCenters());
        }
        catch (IOException ioe) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ioe);
        }
        if (this._rbLocalFile.isSelected()) {
            this.getModel(context).setLocalBundle(this._localBundle);
        } else {
            this.getModel(context).setLocalBundle(null);
        }
    }

    @Override
    public boolean doValidation(TraversableContext context) {
        if (context.getDirection() == 2) {
            return true;
        }
        if (this._rbLocalFile.isSelected()) {
            return this.validateLocalBundle();
        }
        return true;
    }

    private boolean validateLocalBundle() {
        this.storeLocalFilename();
        URL theURL = this._tfLocalFileName.getURL();
        if (theURL != null && "file".equals(theURL.getProtocol())) {
            File f = new File(URLFileSystem.getPlatformPathName((URL)theURL));
            try {
                this._localBundle = LocalUpdateBundle.createInstance(f);
                if (this._localBundle.getBundle().getUpdates().size() == 0) {
                    MessageDialog.error((Component)((Object)this), (Object)UpdateArb.getString(153), (String)UpdateArb.getString(152), null);
                    return false;
                }
                ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
                for (UpdateInfo update : this._localBundle.getBundle().getUpdates()) {
                    boolean result;
                    if (!this.validateUpdateDependencies(update)) {
                        return false;
                    }
                    if (update.isNew()) continue;
                    Version currentVersion = extReg.findExtension(update.getID()).getVersion();
                    Version newVersion = update.getVersion();
                    int diff = newVersion.compareTo(currentVersion);
                    if (diff == 0 && !(result = MessageDialog.confirm((Component)((Object)this), (Object)UpdateArb.format(155, newVersion.toString(), update.getName()), (String)UpdateArb.getString(154), null, (boolean)false, (String)UpdateArb.getString(156), (String)UpdateArb.getString(157)))) {
                        return false;
                    }
                    if (diff >= 0 || (result = MessageDialog.confirm((Component)((Object)this), (Object)UpdateArb.format(159, newVersion.toString(), update.getName(), currentVersion.toString()), (String)UpdateArb.getString(158), null, (boolean)true, (String)UpdateArb.getString(160), (String)UpdateArb.getString(161)))) continue;
                    return false;
                }
                return true;
            }
            catch (InvalidLocalBundleException nabe) {
                if (nabe.problems() != null) {
                    this.logLocalBundleProblems(theURL, nabe.problems());
                }
                MessageDialog.error((Component)((Object)this), (Object)nabe.getMessage(), (String)UpdateArb.getString(134), null);
                return false;
            }
        }
        MessageDialog.error((Component)((Object)this), (Object)UpdateArb.getString(135), (String)UpdateArb.getString(136), null);
        return false;
    }

    private void logLocalBundleProblems(URL url, Problems problems) {
        LogManager logManager = LogManager.getLogManager();
        LogPage msgPage = logManager.getMsgPage();
        msgPage.log((Object)UpdateArb.format(184, URLFileSystem.getPlatformPathName((URL)url), this.descriptionsAsString(problems)));
    }

    private String descriptionsAsString(Problems problems) {
        StringBuilder sb = new StringBuilder();
        for (String s : problems.descriptions()) {
            sb.append(s);
            sb.append('\n');
        }
        return sb.toString();
    }

    private boolean validateUpdateDependencies(UpdateInfo update) {
        ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
        Collection requiredIds = update.getRequiredIds();
        ArrayList<String> missingIds = new ArrayList<String>();
        for (String id : requiredIds) {
            Extension extension = extReg.findExtension(id);
            if (extension == null) {
                missingIds.add(id);
                continue;
            }
            boolean compatible = CheckUpdatesRunnable.testCompatibleVersion(update, id, extension.getVersion());
            if (compatible) continue;
            missingIds.add(id);
        }
        if (!missingIds.isEmpty()) {
            TableModel model = this.createMissingDependenciesTableModel(update, missingIds);
            NiceTable table = new NiceTable(model);
            BaseMessageDialog bmd = BaseMessageDialog.createMessageDialogImpl((Component)((Object)this), (String)UpdateArb.getString(175), (int)3);
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout(0, 5));
            p.add((Component)new JWrappedLabel(UpdateArb.getString(176)), "North");
            p.add((Component)new JScrollPane((Component)table), "Center");
            bmd.setMessage((Object)p);
            table.setAutoResizeMode(0);
            table.autoSizeColumnsToFit();
            table.autoSizeViewportToFit(new Dimension(100, 100), new Dimension(800, 400));
            bmd.runDialog();
            return false;
        }
        return true;
    }

    private TableModel createMissingDependenciesTableModel(final UpdateInfo info, final List<String> missingIds) {
        class TM
        extends AbstractTableModel
        implements NiceTableModel {
            TM() {
            }

            public int getColumnAlignment(int column) {
                return 2;
            }

            public Comparator getColumnSortComparator(int column) {
                return null;
            }

            @Override
            public int getRowCount() {
                return missingIds.size();
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                String id = (String)missingIds.get(rowIndex);
                Version max = info.getRequiredMaxVersion(id);
                Version min = info.getRequiredMinVersion(id);
                Extension installed = ExtensionRegistry.getExtensionRegistry().findExtension(id);
                switch (columnIndex) {
                    case 0: {
                        return id;
                    }
                    case 1: {
                        if (max != null && min != null) {
                            return UpdateArb.format(180, min.toString(), max.toString());
                        }
                        if (max != null) {
                            return UpdateArb.format(182, max.toString());
                        }
                        if (min != null) {
                            return UpdateArb.format(181, min.toString());
                        }
                        return "";
                    }
                    case 2: {
                        return installed != null ? installed.getVersion().toString() : UpdateArb.getString(39);
                    }
                }
                return null;
            }

            @Override
            public String getColumnName(int col) {
                switch (col) {
                    case 0: {
                        return UpdateArb.getString(177);
                    }
                    case 1: {
                        return UpdateArb.getString(178);
                    }
                    case 2: {
                        return UpdateArb.getString(179);
                    }
                }
                return "";
            }
        }
        return new TM();
    }

    private void addUpdateCenter() {
        UpdateCenter newCenter = UpdateCenterPanel.runCreateDialog((Component)((Object)this));
        if (newCenter != null) {
            newCenter.setEnabled(true);
            this._listModel.addElement((Object)newCenter);
            this._lstUpdateCenters.setSelectedIndex(this._listModel.getSize() - 1);
            this._lstUpdateCenters.ensureIndexIsVisible(this._listModel.getSize() - 1);
            this.completeValueChanged();
        }
    }

    private void removeUpdateCenter() {
        int[] sel = this._lstUpdateCenters.getSelectedIndices();
        if (sel != null && sel.length > 0) {
            int firstSel = sel[0];
            this._listModel.removeIndices(sel);
            if (this._listModel.getSize() > firstSel) {
                this._lstUpdateCenters.setSelectedIndex(firstSel);
            } else if (this._listModel.getSize() > 0) {
                this._lstUpdateCenters.setSelectedIndex(this._listModel.getSize() - 1);
            }
        }
    }

    private void editUpdateCenter() {
        UpdateCenter selected = (UpdateCenter)this._lstUpdateCenters.getSelectedValue();
        if (UpdateCenterPanel.runEditDialog((Component)((Object)this), selected)) {
            int selIdx = this._lstUpdateCenters.getSelectedIndex();
            this._listModel.changed(selIdx);
        }
    }

    private void updateEnabledControls() {
        boolean remote = this._rbUpdateCenter.isSelected();
        if (this.getTraversableContext() != null) {
            if (remote) {
                this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition((Object)"sourceToUpdates");
            } else {
                this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition((Object)"sourceToLicence");
            }
        }
        this._lstUpdateCenters.setEnabled(remote);
        this._lstUpdateCenters.setBackground(remote ? UIManager.getColor("window") : UIManager.getColor("control"));
        Object[] sel = this._lstUpdateCenters.getSelectedValues();
        this._btnAddCenter.setEnabled(remote);
        if (!remote || sel == null || sel.length == 0) {
            this._btnEditCenter.setEnabled(false);
            this._btnRemoveCenter.setEnabled(false);
        } else {
            if (sel.length == 1) {
                UpdateCenter center = (UpdateCenter)sel[0];
                this._btnEditCenter.setEnabled(!center.isFromMasterList());
            }
            boolean removeEnabled = true;
            for (int i = 0; i < sel.length; ++i) {
                UpdateCenter thisCenter = (UpdateCenter)sel[i];
                if (!thisCenter.isFromMasterList()) continue;
                removeEnabled = false;
                break;
            }
            this._btnRemoveCenter.setEnabled(removeEnabled);
        }
        this._lbFileName.setEnabled(!remote);
        this._tfLocalFileName.setEnabled(!remote);
        this._btnBrowse.setEnabled(!remote);
    }

    private void toggleCenterEnabled(int row) {
        UpdateCenter center;
        center.setEnabled(!(center = (UpdateCenter)this._lstUpdateCenters.getModel().getElementAt(row)).isEnabled());
        center.setEnabledChangedByUser(true);
        this._listModel.changed(row);
        this.completeValueChanged();
    }

    private class ErrorDetailsListener
    implements ActionListener {
        private final Throwable _throwable;

        ErrorDetailsListener(Throwable throwable) {
            this._throwable = throwable;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ExceptionDialog.showExceptionDialog((Component)((Object)UpdateSourcePage.this), (Throwable)this._throwable, (String)UpdateArb.getString(109), (String)UpdateArb.format(110, Ide.getProgramShortName()), null);
        }
    }

    private class ProgressMonitor
    implements UpdateCenterMonitor {
        private ProgressMonitor() {
        }

        @Override
        public void setMessage(final String message) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateSourcePage.this._lbProgress.setText(message);
                    UpdateSourcePage.this._panProgress.invalidate();
                    UpdateSourcePage.this._panProgress.validate();
                }
            });
        }

        @Override
        public void setMaximum(int max) {
        }

        @Override
        public void setProgress(int progress) {
        }

        @Override
        public void start() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateSourcePage.this._panProgress.add((Component)UpdateSourcePage.this._lbProgress, "West");
                    UpdateSourcePage.this._panProgress.add((Component)UpdateSourcePage.this._pbUpdates, "Center");
                    UpdateSourcePage.this._panProgress.setVisible(true);
                    UpdateSourcePage.this._panProgress.invalidate();
                    UpdateSourcePage.this._panProgress.validate();
                }
            });
        }

        @Override
        public void finish() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateSourcePage.this._panProgress.setVisible(false);
                    UpdateSourcePage.this._panProgress.invalidate();
                    UpdateSourcePage.this._panProgress.validate();
                }
            });
        }

        @Override
        public boolean isStopped() {
            return false;
        }
    }

    private class Listener
    implements DocumentListener,
    ActionListener,
    ListSelectionListener,
    KeyListener,
    NiceListActionListener {
        private Listener() {
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            UpdateSourcePage.this.completeValueChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            UpdateSourcePage.this.completeValueChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
            UpdateSourcePage.this.completeValueChanged();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src == UpdateSourcePage.this._btnAddCenter) {
                UpdateSourcePage.this.addUpdateCenter();
            } else if (src == UpdateSourcePage.this._btnRemoveCenter) {
                UpdateSourcePage.this.removeUpdateCenter();
            } else if (src == UpdateSourcePage.this._btnEditCenter) {
                UpdateSourcePage.this.editUpdateCenter();
            } else if (src == UpdateSourcePage.this._btnBrowse) {
                UpdateSourcePage.this._tfLocalFileName.actionPerformed(ae);
            }
            UpdateSourcePage.this.completeValueChanged();
            UpdateSourcePage.this.updateEnabledControls();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            UpdateSourcePage.this.updateEnabledControls();
        }

        @Override
        public void keyPressed(KeyEvent ke) {
        }

        @Override
        public void keyTyped(KeyEvent ke) {
        }

        @Override
        public void keyReleased(KeyEvent ke) {
            if (ke.getKeyCode() == 127) {
                if (UpdateSourcePage.this._btnRemoveCenter.isEnabled()) {
                    UpdateSourcePage.this.removeUpdateCenter();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }

        public void listActionPerformed(NiceListActionEvent lae) {
            if (lae.getType() == NiceListActionEvent.Type.CHECKBOX) {
                UpdateSourcePage.this.toggleCenterEnabled(lae.getRow());
            }
        }
    }
}

