/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLTextField;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateCenter;

public class UpdateCenterPanel
extends JPanel {
    private final JLabel _lbName = new JLabel();
    private final JTextField _tfName = new JTextField();
    private final JLabel _lbUrl = new JLabel();
    private final URLTextField _tfUrl = new URLTextField();
    private final JButton _btnBrowse = new JButton();
    static final String COMPLETE_PROPERTY = "isComplete";

    public UpdateCenterPanel() {
        this.resControls();
        this.layoutControls();
        this.installListeners();
    }

    private void resControls() {
        ResourceUtils.resLabel((JLabel)this._lbName, (Component)this._tfName, (String)UpdateArb.getString(104));
        ResourceUtils.resLabel((JLabel)this._lbUrl, (Component)this._tfUrl, (String)UpdateArb.getString(105));
        ResourceUtils.resButton((AbstractButton)this._btnBrowse, (String)UpdateArb.getString(106));
    }

    private void layoutControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 5, 12);
        this.add((Component)this._lbName, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._tfName, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 12);
        gbc.fill = 0;
        this.add((Component)this._lbUrl, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 2;
        this.add((Component)this._tfUrl, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this._btnBrowse, gbc);
    }

    private void installListeners() {
        DocumentListener dl = new DocumentListener(){

            protected void update() {
                boolean isComplete = UpdateCenterPanel.this.isComplete();
                UpdateCenterPanel.this.firePropertyChange(UpdateCenterPanel.COMPLETE_PROPERTY, !isComplete, isComplete);
            }

            @Override
            public void insertUpdate(DocumentEvent de) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                this.update();
            }
        };
        this._tfUrl.getDocument().addDocumentListener(dl);
        this._tfName.getDocument().addDocumentListener(dl);
        this._btnBrowse.addActionListener((ActionListener)this._tfUrl);
        this._tfUrl.setDirectoryOnly(false);
    }

    public boolean isComplete() {
        return this._tfName.getText().trim().length() > 0 && this._tfUrl.getURL() != null;
    }

    public static UpdateCenter runCreateDialog(Component parent) {
        UpdateCenter center = new UpdateCenter();
        if (UpdateCenterPanel.runEditDialog(parent, center)) {
            return center;
        }
        return null;
    }

    public static boolean runEditDialog(Component parent, UpdateCenter center) {
        UpdateCenterPanel panel = new UpdateCenterPanel();
        panel._tfName.setText(center.getName());
        panel._tfUrl.setURL(URLFactory.newURL((String)center.getURL()));
        if (UpdateCenterPanel.runDialog(parent, panel)) {
            center.setName(panel._tfName.getText().trim());
            center.setURL(panel._tfUrl.getURL().toString());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean runDialog(Component parent, final UpdateCenterPanel panel) {
        final JEWTDialog dialog = JEWTDialog.createDialog((Component)parent, (String)UpdateArb.getString(107), (int)7);
        dialog.setContent((Component)panel);
        dialog.setOKButtonEnabled(panel.isComplete());
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                dialog.setOKButtonEnabled(panel.isComplete());
            }
        };
        panel.addPropertyChangeListener(pcl);
        HelpUtils.setHelpID((JComponent)panel, (String)"f1_idewideupdatedlg_html");
        try {
            boolean bl = dialog.runDialog();
            return bl;
        }
        finally {
            panel.removePropertyChangeListener(pcl);
        }
    }

    public static void main(String[] args) {
        UpdateCenterPanel.runCreateDialog(null);
    }
}

