/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.config.Preferences;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.webupdate.PostStartupHook;
import oracle.ideimpl.webupdate.CheckForUpdatesPreferences;
import oracle.ideimpl.webupdate.Directories;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.javatools.data.PropertyStorage;

public final class WebUpdateAddin
implements Addin {
    public static final int CFU_ACTION_ID = Ide.findOrCreateCmdID((String)"CheckForUpdates");

    public void initialize() {
        UpdateManager.getInstance().setDirectories(new IdeDirectories());
        JMenu helpMenu = MenuManager.getJMenu((String)"Help");
        IdeAction action = IdeAction.find((int)CFU_ACTION_ID);
        JMenuItem item = Ide.getMenubar().createMenuItem((ToggleAction)action, 1.0f);
        Ide.getMenubar().add((Component)item, helpMenu, MenuConstants.SECTION_HELP_UPDATES);
        Ide.addIdeListener((IdeListener)new IdeListener(){

            public void mainWindowClosing(IdeEvent ie) {
            }

            public void mainWindowOpened(IdeEvent ie) {
                WebUpdateAddin.this.runInitHooks();
                WebUpdateAddin.this.checkForNewUpdates();
            }

            public void addinsLoaded(IdeEvent ie) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runInitHooks() {
        File propsFile = new File(Ide.getOracleHomeDirectory(), "installhooks.properties");
        if (propsFile.exists()) {
            InputStream is = null;
            Properties p = null;
            try {
                p = new Properties();
                is = new FileInputStream(propsFile);
                p.load(is);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
            try {
                if (p != null) {
                    this.runInitHooks(p.keySet());
                }
            }
            finally {
                if (!propsFile.delete()) {
                    propsFile.deleteOnExit();
                }
            }
        }
    }

    private final void runInitHooks(Collection initHookClassNames) {
        for (String className : initHookClassNames) {
            try {
                Class<?> clz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                PostStartupHook hook = (PostStartupHook)clz.newInstance();
                hook.install();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void checkForNewUpdates() {
        UpdateManager.getInstance().getAutomaticCheckForUpdates().check();
    }

    public static CheckForUpdatesPreferences getPreferences() {
        return CheckForUpdatesPreferences.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private static class IdeDirectories
    implements Directories {
        private String m_temp = null;

        private IdeDirectories() {
        }

        @Override
        public String getTemp() {
            if (this.m_temp == null) {
                File f = new File(Ide.getUserSettingsDirectory() + File.separator + "tmp", "update");
                this.m_temp = f.getPath();
            }
            return this.m_temp;
        }

        @Override
        public String getGlobalExtensionsHome() {
            File libDir = new File(Ide.getLibDirectory());
            return new File(libDir.getParentFile(), "extensions").getAbsolutePath();
        }

        @Override
        public String getPatchesHome() {
            return Ide.getLibDirectory() + File.separator + "patches";
        }

        @Override
        public String getUserExtensionsHome() {
            return Ide.getUserSettingsDirectory() + "extensions";
        }

        @Override
        public String getGlobalSettingsHome() {
            return Ide.getLibDirectory();
        }

        @Override
        public String getUserSettingsHome() {
            return Ide.getUserSettingsDirectory() + File.separator + "lib";
        }
    }
}

