/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.util.Version;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCenter;

public class UpdateInfo
implements Comparable {
    private UpdateBundle _bundle;
    private Type _type;
    private String _name;
    private String _description;
    private String _id;
    private Version _version;
    private String _clickThrough;
    private Map _requiredIds = new HashMap();
    private String _url;
    private String _author;
    private String _authorUrl;
    private String _preferredInstallLocation;
    private boolean _isNew = false;
    private List _requiredUpdates;
    private UpdateCenter _center;
    private String _postStartupHookClass;

    public boolean equals(Object that) {
        if (that != null && that instanceof UpdateInfo) {
            String thatID = ((UpdateInfo)that).getID();
            return this.getID() != null && thatID != null && this.getID().equals(thatID);
        }
        return false;
    }

    public int hashCode() {
        if (this.getID() == null) {
            return super.hashCode();
        }
        return this.getID().hashCode();
    }

    public void setBundle(UpdateBundle bundle) {
        this._bundle = bundle;
    }

    public UpdateBundle getBundle() {
        return this._bundle;
    }

    public String getPostStartupHookClass() {
        return this._postStartupHookClass;
    }

    public void setPostStartupHookClass(String postStartupHookClass) {
        this._postStartupHookClass = postStartupHookClass;
    }

    public String getPreferredInstallLocation() {
        return this._preferredInstallLocation;
    }

    public void setPreferredInstallLocation(String preferredInstallLocation) {
        this._preferredInstallLocation = preferredInstallLocation;
    }

    public void setSourceCenter(UpdateCenter center) {
        this._center = center;
    }

    public UpdateCenter getSourceCenter() {
        return this._center;
    }

    public boolean isNew() {
        return this._isNew;
    }

    void setNew(boolean isNew) {
        this._isNew = isNew;
    }

    void addRequiredUpdate(UpdateInfo update) {
        if (this._requiredUpdates == null) {
            this._requiredUpdates = new ArrayList();
        }
        this._requiredUpdates.add(update);
    }

    void clearRequiredUpdates() {
        if (this._requiredUpdates != null) {
            this._requiredUpdates.clear();
        }
    }

    public List getRequiredUpdates() {
        if (this._requiredUpdates == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this._requiredUpdates);
    }

    public void setAuthor(String author) {
        this._author = author;
    }

    public String getAuthor() {
        return this._author;
    }

    public void setAuthorURL(String authorUrl) {
        this._authorUrl = authorUrl;
    }

    public String getAuthorURL() {
        return this._authorUrl;
    }

    public void setDownloadURL(String url) {
        this._url = url;
    }

    public String getURL() {
        String centerUrl;
        int lastSlash;
        UpdateCenter center;
        if (this._url != null && this._url.indexOf(58) == -1 && (center = this.getSourceCenter()) != null && (lastSlash = (centerUrl = center.getURL()).lastIndexOf(47)) >= 1) {
            this._url = centerUrl.substring(0, lastSlash + 1) + this._url;
        }
        return this._url;
    }

    public void addRequiredUpdate(String id, Version minVersion, Version maxVersion) {
        this._requiredIds.put(id, new Pair<Version, Version>(minVersion, maxVersion));
    }

    public Collection getRequiredIds() {
        return this._requiredIds.keySet();
    }

    public Version getRequiredMinVersion(String id) {
        Pair versions = (Pair)this._requiredIds.get(id);
        if (versions != null) {
            return (Version)versions.getFirst();
        }
        return null;
    }

    public Version getRequiredMaxVersion(String id) {
        Pair versions = (Pair)this._requiredIds.get(id);
        if (versions != null) {
            return (Version)versions.getSecond();
        }
        return null;
    }

    public void setClickThroughURL(String url) {
        this._clickThrough = url;
    }

    public String getClickThroughURL() {
        return this._clickThrough;
    }

    public boolean hasClickThrough() {
        return this._clickThrough != null;
    }

    public void setID(String id) {
        this._id = id;
    }

    public String getID() {
        return this._id;
    }

    public void setVersion(Version version) {
        this._version = version;
    }

    public Version getVersion() {
        return this._version;
    }

    public Type getType() {
        return this._type;
    }

    public void setType(Type type) {
        this._type = type;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String toString() {
        return "UpdateInfo[ name=" + this.getName() + ", description=" + this.getDescription() + ", type=" + (Object)((Object)this.getType()) + ", version=" + this.getVersion() + "]";
    }

    public int compareTo(Object other) {
        UpdateInfo otherInfo = (UpdateInfo)other;
        return this.getName().compareTo(otherInfo.getName());
    }

    private static class Pair<A, B> {
        private final A _first;
        private final B _second;

        Pair(A first, B second) {
            this._first = first;
            this._second = second;
        }

        A getFirst() {
            return this._first;
        }

        B getSecond() {
            return this._second;
        }
    }

    public static enum Type {
        PATCH,
        MESSAGE,
        EXTENSION;

    }
}

