/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import oracle.ideimpl.webupdate.InvalidLocalBundleException;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.parser.UpdateXMLBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

class InternalUpdateGenerator {
    private static final Logger LOGGER = Logger.getLogger(InternalUpdateGenerator.class.getName());
    private static final String NONDEBUG = "nondebug";
    private static final Pattern[] SKIP_PATTERNS = new Pattern[]{Pattern.compile("^jdev.+\\.zip$"), Pattern.compile("^ExtensionSDK.zip$")};

    InternalUpdateGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File f;
        if (args.length < 1) {
            System.err.println("Usage: ");
            System.err.println("  InternalUpdateGenerator <propertiesfile>");
            System.exit(1);
        }
        if (!(f = new File(args[0])).exists()) {
            System.err.println(args[0] + " doesn't exist.");
            System.exit(1);
        }
        FileInputStream fis = null;
        Properties p = null;
        try {
            p = new Properties();
            fis = new FileInputStream(f);
            p.load(fis);
            fis.close();
            if (p.isEmpty()) {
                System.err.println(args[0] + " is empty.");
                System.exit(1);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(1);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        HashMap<String, UpdateSet> namesToUpdateSets = new HashMap<String, UpdateSet>();
        for (String string : p.keySet()) {
            int dotPos = string.indexOf(46);
            if (dotPos > 0) {
                String firstPart = string.substring(0, dotPos);
                LOGGER.info("UpdateInfo name for " + string + " is " + firstPart);
                String secondPart = string.substring(dotPos + 1);
                UpdateSet set = (UpdateSet)namesToUpdateSets.get(firstPart);
                if (set == null) {
                    set = new UpdateSet();
                    namesToUpdateSets.put(firstPart, set);
                }
                set.name = firstPart;
                if ("labelroot".equals(secondPart)) {
                    File rootFile = new File(p.getProperty(string));
                    if (!rootFile.exists()) {
                        System.err.println(rootFile + " doesn't exist.");
                        continue;
                    }
                    if (!rootFile.isDirectory()) {
                        System.err.println(rootFile + " is not a directory.");
                        continue;
                    }
                    set.baseDir = rootFile;
                    continue;
                }
                if ("relativepath".equals(secondPart)) {
                    set.relativePath = p.getProperty(string);
                    continue;
                }
                System.err.println("Unrecognized property: " + secondPart);
                continue;
            }
            LOGGER.info("Skipped because key doesn't contain a prefix: " + string);
        }
        Document doc = null;
        UpdateXMLBuilder updateXMLBuilder = new UpdateXMLBuilder();
        try {
            String displayXSLT;
            doc = updateXMLBuilder.createUpdatesDocument();
            for (UpdateSet set : namesToUpdateSets.values()) {
                if (set.baseDir != null && set.relativePath != null) {
                    InternalUpdateGenerator.processBundleDir(set.baseDir, set.relativePath, doc);
                    continue;
                }
                if (set.baseDir == null) {
                    LOGGER.warning("Skipping update set " + set.name + " baseDir is null. ");
                    continue;
                }
                if (set.relativePath != null) continue;
                LOGGER.warning("Skipping update set " + set.name + " relativePath is null. ");
            }
            String xformXSLT = p.getProperty("transformStylesheet");
            if (xformXSLT != null) {
                File sheet = new File(xformXSLT);
                if (!sheet.exists()) {
                    LOGGER.severe("Stylesheet " + sheet + " doesn't exist!");
                } else {
                    doc = InternalUpdateGenerator.xslTransform(doc, sheet);
                }
            }
            if ((displayXSLT = p.getProperty("displayStylesheet")) != null) {
                ProcessingInstruction pi = doc.createProcessingInstruction("xml-stylesheet", "href=\"" + displayXSLT + "\" type=\"text/xsl\"");
                doc.insertBefore(pi, doc.getDocumentElement());
            }
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        finally {
            if (doc != null) {
                try {
                    DocumentBuilder b = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    DOMImplementationLS ls = (DOMImplementationLS)b.getDOMImplementation().getFeature("LS", "3.0");
                    LSOutput out = ls.createLSOutput();
                    out.setByteStream(System.out);
                    LSSerializer serializer = ls.createLSSerializer();
                    serializer.setNewLine("\n");
                    serializer.write(doc, out);
                }
                catch (ParserConfigurationException pce) {
                    pce.printStackTrace();
                }
            }
        }
    }

    private static Document xslTransform(Document doc, File stylesheet) {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer transformer = factory.newTransformer(new StreamSource(new FileInputStream(stylesheet)));
            DOMSource source = new DOMSource(doc);
            DOMResult result = new DOMResult();
            transformer.transform(source, result);
            return (Document)result.getNode();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            return doc;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return doc;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return doc;
        }
    }

    private static void processBundleDir(File integDir, String relativePath, Document xmlDoc) {
        File[] buildDirs = integDir.listFiles();
        for (int i = 0; i < buildDirs.length; ++i) {
            File buildDir = buildDirs[i];
            File nonDebugDir = new File(buildDir, NONDEBUG);
            if (!nonDebugDir.exists()) {
                LOGGER.warning(nonDebugDir + " does not exist, skipping.");
                continue;
            }
            File[] zips = nonDebugDir.listFiles();
            for (int j = 0; j < zips.length; ++j) {
                File thisZip = zips[j];
                try {
                    if (!thisZip.getName().toLowerCase().endsWith(".zip") || InternalUpdateGenerator.isSkipped(thisZip)) continue;
                    InternalUpdateGenerator.processZip(thisZip, xmlDoc, relativePath);
                    continue;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    private static final boolean isSkipped(File zipFile) {
        String name = zipFile.getName();
        for (int i = 0; i < SKIP_PATTERNS.length; ++i) {
            Pattern pattern = SKIP_PATTERNS[i];
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private static final void processZip(File zipFile, Document xmlDoc, String baseUrl) throws IOException {
        try {
            LocalUpdateBundle lub = LocalUpdateBundle.createInstance(zipFile, false);
            UpdateBundle bundle = lub.getBundle();
            Set updates = bundle.getUpdates();
            File zipLabel = zipFile.getParentFile().getParentFile();
            String url = baseUrl + "/" + zipLabel.getName() + "/nondebug/" + zipFile.getName();
            if (updates.size() == 1) {
                UpdateInfo info = (UpdateInfo)updates.iterator().next();
                info.setDownloadURL(url);
            } else {
                bundle.setDownloadUrl(url);
            }
            UpdateXMLBuilder b = new UpdateXMLBuilder();
            b.appendUpdateBundle(xmlDoc, bundle);
        }
        catch (InvalidLocalBundleException nabe) {
            System.err.println("Skipped " + zipFile + ": Not a bundle. ");
        }
    }

    private static class UpdateSet {
        public String name;
        public File baseDir;
        public String relativePath;

        private UpdateSet() {
        }
    }
}

