/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.view.View;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.javatools.codeex.Base64;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.nav.ConnectionProvider;
import oracle.jdeveloper.vcs.spi.VCSApplicationSystem;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.client.SVNClient;
import oracle.jdevimpl.vcs.svn.client.SVNClientRegistry;
import oracle.jdevimpl.vcs.svn.model.SVNAuthInfo;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryWizard;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.repos.io.ObjectFactory;
import oracle.jdevimpl.vcs.svn.repos.io.SvnRepositoryType;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.security.misc.Checksum;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNUtil {
    public static ISVNClientAdapter getIDEClientAdapter() throws SVNClientException {
        return SVNUtil.getClientAdapter(SVNProfile.IDE_CLIENT_CONTEXT_ID);
    }

    public static ISVNClientAdapter getClientAdapter(Object context) throws SVNClientException {
        return SVNUtil.getClientAdapter(context, context);
    }

    public static ISVNClientAdapter getClientAdapter(Object clientContext, Object adapterContext) throws SVNClientException {
        SVNClient client = SVNClientRegistry.getInstance().getContextClient(clientContext);
        return client.getManagedAdapter(adapterContext);
    }

    public static URL getConfigDirectory() {
        SVNClient client = SVNClientRegistry.getInstance().getContextClient(SVNProfile.IDE_CLIENT_CONTEXT_ID);
        return client.getConfigUrl();
    }

    public static URL getConfigDirectory(Object clientContext) {
        SVNClient client = SVNClientRegistry.getInstance().getContextClient(clientContext);
        return client.getConfigUrl();
    }

    public static String getCompareIdentifier(URL source, SVNRevision revision) {
        String path = URLFileSystem.getPlatformPathName((URL)source);
        if (SVNRevision.HEAD.equals((Object)revision)) {
            return Resource.format("HISTORICAL_RESOURCE_IDENTIFIER_HEAD", path);
        }
        return Resource.format("HISTORICAL_RESOURCE_IDENTIFIER_RNUM", revision.toString(), path);
    }

    public static String getPath(SVNUrl url) {
        if (url == null) {
            return null;
        }
        String[] segments = url.getPathSegments();
        FastStringBuffer buff = new FastStringBuffer(segments.length * 20);
        for (int i = 0; i < segments.length; ++i) {
            buff.append(segments[i]);
            if (i + 1 >= segments.length) continue;
            buff.append('/');
        }
        return buff.toString();
    }

    public static File toFile(URL sourceUrl) {
        return new File(URLFileSystem.getPlatformPathName((URL)sourceUrl));
    }

    public static File[] toFiles(URL[] urls) {
        if (urls == null) {
            return new File[0];
        }
        File[] files = new File[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            files[i] = new File(URLFileSystem.getPlatformPathName((URL)urls[i]));
        }
        return files;
    }

    public static SVNUrl toSVNUrl(URL sourceUrl) throws MalformedURLException {
        if (sourceUrl == null) {
            return null;
        }
        if ("file".equals(sourceUrl.getProtocol())) {
            String path = URLFileSystem.getPlatformPathName((URL)sourceUrl);
            if ((path = path.replace(File.separatorChar, '/')).length() > 0 && path.charAt(0) == '/') {
                return new SVNUrl("file://" + path);
            }
            return new SVNUrl("file:///" + path);
        }
        return new SVNUrl(sourceUrl.toExternalForm());
    }

    public static URL toURL(File file) {
        if (file.isFile()) {
            return URLFactory.newFileURL((File)file);
        }
        return URLFactory.newDirURL((File)file);
    }

    public static URL[] toURLs(File[] files) {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            urls[i] = SVNUtil.toURL(files[i]);
        }
        return urls;
    }

    public static SVNNodeKind getSVNNodeKind(SVNUrl svnurl) {
        if (svnurl != null) {
            try {
                ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
                ISVNInfo info = client.getInfo(svnurl);
                if (info == null) {
                    return null;
                }
                return info.getNodeKind();
            }
            catch (SVNClientException e) {
                SVNProfile.getQualifiedLogger(SVNUtil.class.getName()).warning(e.getMessage());
            }
        }
        return null;
    }

    public static boolean isRepositoryNavigatorView(Context context) {
        if (context != null) {
            return SVNUtil.isRepositoryNavigatorView(context.getView());
        }
        return false;
    }

    public static boolean isRepositoryNavigatorView(View view) {
        return ConnectionProvider.isVersioningConnectionView((View)view);
    }

    public static SVNRemoteNode getSVNRemoteNode(Context context) {
        Node node;
        SVNRemoteNode remoteNode = null;
        if (context != null && (node = context.getNode()) != null && node instanceof SVNRemoteNode) {
            remoteNode = (SVNRemoteNode)node;
        }
        return remoteNode;
    }

    public static SVNRemoteNode[] getSVNRemoteNodes(Context context) {
        Element[] selection;
        ArrayList<Element> nodes = null;
        if (context != null && (selection = context.getSelection()) != null) {
            for (int i = 0; i < selection.length; ++i) {
                if (!(selection[i] instanceof SVNRemoteNode)) continue;
                if (nodes == null) {
                    nodes = new ArrayList<Element>(selection.length * 2);
                }
                nodes.add(selection[i]);
            }
        }
        return nodes != null ? nodes.toArray(new SVNRemoteNode[nodes.size()]) : new SVNRemoteNode[]{};
    }

    public static void setAuthInfo(ISVNClientAdapter client, SVNRepositoryInfo repos) {
        if (repos != null) {
            SVNUtil.setAuthInfo(client, repos.getAuthInfo());
        }
    }

    public static void unsetAuthInfo(ISVNClientAdapter client) {
        if (client != null) {
            client.setUsername("");
            client.setPassword("");
        }
    }

    public static void setAuthInfo(ISVNClientAdapter client, SVNAuthInfo authInfo) {
        String username;
        if (authInfo != null && (username = authInfo.getUserName()) != null && username.length() > 0) {
            client.setUsername(username);
            client.setPassword(authInfo.getPassword());
        }
    }

    public static SVNRepositoryInfo toReposInfo(SvnRepositoryType reposType) throws MalformedURLException {
        String password = reposType.getPassword();
        if (password != null && password.length() > 0) {
            try {
                password = new String(Checksum.SHA((byte[])Base64.base64Decode((String)password), null), "UTF-8");
            }
            catch (Exception e) {
                SVNProfile.getQualifiedLogger(SVNUtil.class.getName()).warning(e.getMessage());
            }
        }
        SVNAuthInfo authInfo = new SVNAuthInfo(reposType.getUserName(), password);
        SVNRepositoryInfo reposInfo = new SVNRepositoryInfo(new SVNUrl(reposType.getUrl()), reposType.getAlias(), authInfo);
        return reposInfo;
    }

    public static SvnRepositoryType toReposType(SVNRepositoryInfo reposInfo, ObjectFactory factory) {
        SvnRepositoryType reposType = factory.createSvnRepositoryType();
        reposType.setUrl(reposInfo.getURL().toString());
        reposType.setAlias(reposInfo.getAlias());
        SVNAuthInfo authInfo = reposInfo.getAuthInfo();
        if (authInfo != null) {
            reposType.setUserName(authInfo.getUserName());
            String password = authInfo.getPassword();
            if (password != null && password.length() > 0) {
                try {
                    reposType.setPassword(Base64.base64Encode((byte[])Checksum.MD5((byte[])password.getBytes("UTF-8"), null)));
                }
                catch (Exception e) {
                    SVNProfile.getQualifiedLogger(SVNUtil.class.getName()).warning(e.getMessage());
                    reposType.setPassword(null);
                }
            }
        }
        return reposType;
    }

    public static SVNRepositoryInfo getFirstAssociatedRepository(URL[] urls) throws SVNClientException {
        if (urls == null) {
            return null;
        }
        SVNRepositoryInfo repos = null;
        for (int i = 0; i < urls.length && repos == null; ++i) {
            repos = SVNUtil.getFirstAssociatedRepository(urls[i]);
        }
        return repos;
    }

    public static SVNRepositoryInfo getFirstAssociatedRepository(URL url) throws SVNClientException {
        if (url == null) {
            return null;
        }
        SVNRepositoryInfo repos = null;
        SVNUrl svnurl = SVNURLInfoCache.getInstance().getURL(url);
        svnurl = SVNUtil.canonicalizeSVNUrl(svnurl);
        repos = SVNUtil.resolveRepository(svnurl);
        return repos;
    }

    public static SVNRepositoryInfo resolveRepository(SVNUrl url) {
        return SVNUtil.resolveRepository(url, SVNRepositoryManager.getInstance().list());
    }

    public static SVNRepositoryInfo resolveRepository(SVNUrl url, Collection repositories) {
        for (SVNRepositoryInfo reposInfo : repositories) {
            if (!SVNUtil.isBaseFor(reposInfo.getURL(), url)) continue;
            return reposInfo;
        }
        return null;
    }

    public static URL resolveWorkingCopy(URL url) {
        URL parent;
        if (url == null) {
            return null;
        }
        URL shallowestAdmin = null;
        while ((parent = URLFileSystem.getParent((URL)url)) != null && !parent.equals(url)) {
            URL candidateAdminParent = URLFileSystem.isDirectory((URL)url) ? url : parent;
            URL candidateAdmin = URLFactory.newDirURL((URL)candidateAdminParent, (String)".svn");
            if (URLFileSystem.exists((URL)candidateAdmin)) {
                shallowestAdmin = candidateAdmin;
            } else if (shallowestAdmin != null || !VCSApplicationSystem.getApplicationSystem().isControlledDirectory(candidateAdminParent)) break;
            url = parent;
        }
        return shallowestAdmin != null ? URLFileSystem.getParent(shallowestAdmin) : null;
    }

    public static URL resolveControlledParent(URL url) {
        URL parent;
        URL deepestAdmin = null;
        while ((parent = URLFileSystem.getParent((URL)url)) != null && !parent.equals(url)) {
            URL candidateAdminParent = URLFileSystem.isDirectory((URL)url) ? url : parent;
            URL candidateAdmin = URLFactory.newDirURL((URL)candidateAdminParent, (String)".svn");
            if (URLFileSystem.exists((URL)candidateAdmin)) {
                deepestAdmin = candidateAdmin;
                break;
            }
            if (!VCSApplicationSystem.getApplicationSystem().isControlledDirectory(candidateAdminParent)) break;
            url = parent;
        }
        return deepestAdmin != null ? URLFileSystem.getParent(deepestAdmin) : null;
    }

    public static boolean isWorkingCopy(URL directoryUrl) {
        return URLFileSystem.isDirectory((URL)URLFactory.newDirURL((URL)directoryUrl, (String)".svn"));
    }

    public static boolean isModified(VCSStatus status, VCSProfile profile) {
        if (profile != null && "oracle.jdeveloper.subversion".equals(profile.getID())) {
            return status == profile.getStatusInstance("MODIFIED");
        }
        return false;
    }

    public static boolean isConflicted(VCSStatus status, VCSProfile profile) {
        if (profile != null && "oracle.jdeveloper.subversion".equals(profile.getID())) {
            return status == profile.getStatusInstance("CONFLICTS");
        }
        return false;
    }

    public static boolean isIgnored(VCSStatus status, VCSProfile profile) {
        if (profile != null && "oracle.jdeveloper.subversion".equals(profile.getID())) {
            return status == profile.getStatusInstance("IGNORED");
        }
        return false;
    }

    public static boolean isPropertiesModified(URL url) throws SVNClientException {
        return SVNStatusKind.MODIFIED.equals((Object)SVNStatusKind.fromInt((int)SVNURLInfoCache.getInstance().getPropStatus(url)));
    }

    public static boolean isPropertiesConflicted(URL url) throws SVNClientException {
        return SVNStatusKind.CONFLICTED.equals((Object)SVNStatusKind.fromInt((int)SVNURLInfoCache.getInstance().getPropStatus(url)));
    }

    public static boolean isTextModified(URL url) throws SVNClientException {
        return SVNStatusKind.MODIFIED.equals((Object)SVNStatusKind.fromInt((int)SVNURLInfoCache.getInstance().getTextStatus(url)));
    }

    public static boolean isTextConflicted(URL url) throws SVNClientException {
        return SVNStatusKind.CONFLICTED.equals((Object)SVNStatusKind.fromInt((int)SVNURLInfoCache.getInstance().getTextStatus(url)));
    }

    public static URL suggestCheckoutDestination(URL localBase, SVNUrl source, boolean isReposRoot, String reposAlias) {
        String lastPathSegment = source.getLastPathSegment();
        String suggestion = null;
        if (isReposRoot) {
            suggestion = reposAlias;
            if (suggestion == null || suggestion.equals("")) {
                suggestion = lastPathSegment != null && !lastPathSegment.equals("") ? lastPathSegment : source.getHost();
            }
        } else {
            suggestion = lastPathSegment;
            if ("trunk".equals(suggestion) || "branches".equals(suggestion) || "tags".equals(suggestion)) {
                String[] pathSegments = source.getPathSegments();
                suggestion = pathSegments.length > 1 ? pathSegments[pathSegments.length - 2] : source.getHost();
            }
        }
        URL dir = URLFactory.newDirURL((URL)localBase, (String)suggestion);
        int i = 0;
        while (URLFileSystem.exists((URL)dir)) {
            dir = URLFactory.newDirURL((URL)localBase, (String)(suggestion + '_' + i++));
        }
        return dir;
    }

    public static boolean ensureRepositoryConnection(Context context) {
        Collection reposInfos = SVNRepositoryManager.getInstance().list();
        if (reposInfos.size() == 0) {
            Wizard connectionWizard = WizardManager.getInstance().getWizard(SVNRepositoryWizard.class);
            return connectionWizard.invoke(context);
        }
        return true;
    }

    static boolean isBaseFor(SVNUrl root, SVNUrl url) {
        if (root == null || url == null) {
            return false;
        }
        if (root.equals((Object)url)) {
            return true;
        }
        String urlStr = url.toString();
        String rootStr = root.toString();
        if (urlStr.length() < rootStr.length()) {
            return false;
        }
        if (!rootStr.endsWith("/")) {
            rootStr = rootStr + '/';
        }
        return urlStr.indexOf(rootStr) != -1;
    }

    public static boolean isRemotelyExisiting(SVNUrl url) {
        boolean isRemoteExisiting = false;
        if (url != null) {
            try {
                ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
                ISVNInfo info = client.getInfo(url);
                return info != null;
            }
            catch (SVNClientException e) {
                SVNProfile.getQualifiedLogger(SVNUtil.class.getName()).warning(e.getMessage());
            }
        }
        return isRemoteExisiting;
    }

    public static boolean isLocked(URL url) throws SVNClientException {
        ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
        ISVNStatus status = client.getSingleStatus(SVNUtil.toFile(url));
        return status.getLockOwner() != null;
    }

    public static boolean allLocked(URL[] URLs) throws SVNClientException {
        return SVNUtil.allLocked(SVNUtil.toFiles(URLs));
    }

    public static boolean allLocked(File[] files) throws SVNClientException {
        ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
        for (int i = 0; i < files.length; ++i) {
            ISVNStatus status = client.getSingleStatus(files[i]);
            if (status.getLockOwner() != null) continue;
            return false;
        }
        return true;
    }

    public static boolean containsLocked(URL[] URLs) throws SVNClientException {
        ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
        for (int i = 0; i < URLs.length; ++i) {
            ISVNStatus status = client.getSingleStatus(SVNUtil.toFile(URLs[i]));
            if (status.getLockOwner() == null) continue;
            return true;
        }
        return false;
    }

    public static SVNUrl canonicalizeSVNUrl(SVNUrl svnurl) {
        if (svnurl == null) {
            return null;
        }
        String urlString = svnurl.toString();
        SVNUrl newurl = null;
        try {
            urlString = URLDecoder.decode(urlString, "UTF-8");
            newurl = new SVNUrl(urlString);
        }
        catch (MalformedURLException e) {
            newurl = svnurl;
        }
        catch (UnsupportedEncodingException e) {
            newurl = svnurl;
        }
        return newurl;
    }

    public static SVNUrl getCommonRootUrl(SVNUrl url0, SVNUrl url1) {
        if (!url0.getProtocol().equals(url1.getProtocol()) || !url0.getHost().equals(url1.getHost()) || url0.getPort() != url1.getPort()) {
            return null;
        }
        String baseurl = url0.getProtocol().equals("file") ? url0.getProtocol() + "://" : url0.getProtocol() + "://" + url0.getHost() + ":" + url0.getPort();
        String[] segs0 = url0.getPathSegments();
        String[] segs1 = url1.getPathSegments();
        int minLength = segs0.length >= segs1.length ? segs1.length : segs0.length;
        for (int i = 0; i < minLength && segs0[i].equals(segs1[i]); ++i) {
            baseurl = baseurl + "/" + segs0[i];
        }
        try {
            return new SVNUrl(baseurl);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static SVNUrl getCommonRootUrl(SVNUrl[] urls) {
        SVNUrl commonRoot = urls[0];
        for (int i = 0; i < urls.length; ++i) {
            if ((commonRoot = SVNUtil.getCommonRootUrl(commonRoot, urls[i])) != null) continue;
            return null;
        }
        return commonRoot;
    }
}

