/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNPropertiesPanelUI
extends JPanel {
    private static final DateFormat sDateFormat = DateFormat.getDateTimeInstance(0, 0);
    private JLabel _repositoryRootLabel;
    private JTextField _repositoryRootField;
    private JLabel _repositoryURLLabel;
    private JTextField _repositoryURLField;
    private JLabel _repositoryUUIDLabel;
    private JTextField _repositoryUUIDField;
    private JLabel _textStatusLabel;
    private JTextField _textStatusField;
    private JLabel _propStatusLabel;
    private JTextField _propStatusField;
    private JLabel _revisionLabel;
    private JTextField _revisionField;
    private JLabel _lastChangedRevLabel;
    private JTextField _lastChangedRevField;
    private JLabel _lastChangedDateLabel;
    private JTextField _lastChangedDateField;
    private JLabel _lastCommitAuthorLabel;
    private JTextField _lastCommitAuthorField;
    private JLabel _textLastChangedDateLabel;
    private JTextField _textLastChangedDateField;
    private JLabel _propLastChangedDateLabel;
    private JTextField _propLastChangedDateField;
    private JLabel _scheduleLabel;
    private JTextField _scheduleField;
    private JLabel _isCopiedLabel;
    private JTextField _isCopiedField;
    private JLabel _copiedSourceURLLabel;
    private JTextField _copiedSourceURLField;
    private JLabel _copiedSourceRevLabel;
    private JTextField _copiedSourceRevField;
    private JLabel _lockOwnerLabel;
    private JTextField _lockOwnerField;
    private JLabel _lockCreationDateLabel;
    private JTextField _lockCreationDateField;
    private JLabel _lockCommentLabel;
    private JTextField _lockCommentField;

    public SVNPropertiesPanelUI() {
        super(new GridBagLayout());
        this.createComponents();
        this.layoutComponents();
    }

    public void setRepositoryRoot(SVNUrl repRootUrl) {
        this.setFieldContent(this._repositoryRootField, repRootUrl != null ? repRootUrl.toString() : null);
    }

    public void setRepositoryUrl(SVNUrl url) {
        this.setFieldContent(this._repositoryURLField, url != null ? url.toString() : null);
    }

    public void setRepositoryUUID(String uuid) {
        this.setFieldContent(this._repositoryUUIDField, uuid);
    }

    public void setTextStatus(SVNStatusKind status) {
        this.setFieldContent(this._textStatusField, status != null ? status.toString() : null);
    }

    public void setPropertyStatus(SVNStatusKind status) {
        this.setFieldContent(this._propStatusField, status != null ? status.toString() : null);
    }

    public void setRevision(long revision) {
        this.setFieldContent(this._revisionField, String.valueOf(revision));
    }

    public void setLastChangedRevision(long revision) {
        this.setFieldContent(this._lastChangedRevField, String.valueOf(revision));
    }

    public void setLastChangedDate(Date date) {
        this.setFieldContent(this._lastChangedDateField, date != null ? sDateFormat.format(date) : null);
    }

    public void setLastCommitAuthor(String author) {
        this.setFieldContent(this._lastCommitAuthorField, author);
    }

    public void setTextLastChanged(Date date) {
        this.setFieldContent(this._textLastChangedDateField, date != null ? sDateFormat.format(date) : null);
    }

    public void setPropertiesLastChanged(Date date) {
        this.setFieldContent(this._propLastChangedDateField, date != null ? sDateFormat.format(date) : null);
    }

    public void setSchedule(SVNScheduleKind schedule) {
        this.setFieldContent(this._scheduleField, schedule != null ? schedule.toString() : null);
    }

    public void setIsCopied(boolean copied) {
        this.setFieldContent(this._isCopiedField, String.valueOf(copied));
        if (!copied) {
            this.removeCopySourcesLater();
        }
    }

    public void setCopySourceUrl(SVNUrl url) {
        this.setFieldContent(this._copiedSourceURLField, url != null ? url.toString() : null);
    }

    public void setCopySourceRevision(long revision) {
        this.setFieldContent(this._copiedSourceRevField, String.valueOf(revision));
    }

    public void setLockOwner(String lockOwner) {
        this.setFieldContent(this._lockOwnerField, lockOwner);
    }

    public void setLockCreationDate(Date date) {
        this.setFieldContent(this._lockCreationDateField, date != null ? sDateFormat.format(date) : null);
    }

    public void setLockComment(String comment) {
        this.setFieldContent(this._lockCommentField, comment);
    }

    private void setFieldContent(JTextField field, String content) {
        field.setText(content != null && content.length() > 0 ? content : "");
    }

    private void createComponents() {
        ResourcePicker res = ResourcePicker.getPicker(SVNProfile.class);
        this._repositoryRootField = new JTextField();
        this._repositoryRootLabel = new JLabel();
        this.initTextField(this._repositoryRootField);
        ResourceUtils.resLabel((JLabel)this._repositoryRootLabel, (Component)this._repositoryRootField, (String)res.getString("URL_PROPS_UI_REPOS_ROOT"));
        this._repositoryURLField = new JTextField();
        this._repositoryURLLabel = new JLabel();
        this.initTextField(this._repositoryURLField);
        ResourceUtils.resLabel((JLabel)this._repositoryURLLabel, (Component)this._repositoryURLField, (String)res.getString("URL_PROPS_UI_REPOS_URL"));
        this._repositoryUUIDField = new JTextField();
        this._repositoryUUIDLabel = new JLabel();
        this.initTextField(this._repositoryUUIDField);
        ResourceUtils.resLabel((JLabel)this._repositoryUUIDLabel, (Component)this._repositoryUUIDField, (String)res.getString("URL_PROPS_UI_REPOS_UUID"));
        this._textStatusField = new JTextField();
        this._textStatusLabel = new JLabel();
        this.initTextField(this._textStatusField);
        ResourceUtils.resLabel((JLabel)this._textStatusLabel, (Component)this._textStatusField, (String)res.getString("URL_PROPS_UI_TEXT_STATUS"));
        this._propStatusField = new JTextField();
        this._propStatusLabel = new JLabel();
        this.initTextField(this._propStatusField);
        ResourceUtils.resLabel((JLabel)this._propStatusLabel, (Component)this._propStatusField, (String)res.getString("URL_PROPS_UI_PROP_STATUS"));
        this._revisionField = new JTextField();
        this._revisionLabel = new JLabel();
        this.initTextField(this._revisionField);
        ResourceUtils.resLabel((JLabel)this._revisionLabel, (Component)this._revisionField, (String)res.getString("URL_PROPS_UI_REVISION"));
        this._lastChangedRevField = new JTextField();
        this._lastChangedRevLabel = new JLabel();
        this.initTextField(this._lastChangedRevField);
        ResourceUtils.resLabel((JLabel)this._lastChangedRevLabel, (Component)this._lastChangedRevField, (String)res.getString("URL_PROPS_UI_LAST_CHANGED_REV"));
        this._lastChangedDateField = new JTextField();
        this._lastChangedDateLabel = new JLabel();
        this.initTextField(this._lastChangedDateField);
        ResourceUtils.resLabel((JLabel)this._lastChangedDateLabel, (Component)this._lastChangedDateField, (String)res.getString("URL_PROPS_UI_LAST_CHANGED_DATE"));
        this._lastCommitAuthorField = new JTextField();
        this._lastCommitAuthorLabel = new JLabel();
        this.initTextField(this._lastCommitAuthorField);
        ResourceUtils.resLabel((JLabel)this._lastCommitAuthorLabel, (Component)this._lastCommitAuthorField, (String)res.getString("URL_PROPS_UI_LAST_COMMIT_AUTHOR"));
        this._textLastChangedDateField = new JTextField();
        this._textLastChangedDateLabel = new JLabel();
        this.initTextField(this._textLastChangedDateField);
        ResourceUtils.resLabel((JLabel)this._textLastChangedDateLabel, (Component)this._textLastChangedDateField, (String)res.getString("URL_PROPS_UI_TEXT_LAST_CHANGED_DATE"));
        this._propLastChangedDateField = new JTextField();
        this._propLastChangedDateLabel = new JLabel();
        this.initTextField(this._propLastChangedDateField);
        ResourceUtils.resLabel((JLabel)this._propLastChangedDateLabel, (Component)this._propLastChangedDateField, (String)res.getString("URL_PROPS_UI_PROPS_LAST_CHANGED_DATE"));
        this._scheduleField = new JTextField();
        this._scheduleLabel = new JLabel();
        this.initTextField(this._scheduleField);
        ResourceUtils.resLabel((JLabel)this._scheduleLabel, (Component)this._scheduleField, (String)res.getString("URL_PROPS_UI_SCHEDULE"));
        this._isCopiedField = new JTextField();
        this._isCopiedLabel = new JLabel();
        this.initTextField(this._isCopiedField);
        ResourceUtils.resLabel((JLabel)this._isCopiedLabel, (Component)this._isCopiedField, (String)res.getString("URL_PROPS_UI_IS_COPIED"));
        this._copiedSourceURLField = new JTextField();
        this._copiedSourceURLLabel = new JLabel();
        this.initTextField(this._copiedSourceURLField);
        ResourceUtils.resLabel((JLabel)this._copiedSourceURLLabel, (Component)this._copiedSourceURLField, (String)res.getString("URL_PROPS_UI_COPIED_SOURCE_URL"));
        this._copiedSourceRevField = new JTextField();
        this._copiedSourceRevLabel = new JLabel();
        this.initTextField(this._copiedSourceRevField);
        ResourceUtils.resLabel((JLabel)this._copiedSourceRevLabel, (Component)this._copiedSourceRevField, (String)res.getString("URL_PROPS_UI_COPIED_SOURCE_REV"));
        this._lockOwnerField = new JTextField();
        this._lockOwnerLabel = new JLabel();
        this.initTextField(this._lockOwnerField);
        ResourceUtils.resLabel((JLabel)this._lockOwnerLabel, (Component)this._lockOwnerField, (String)res.getString("URL_PROPS_UI_LOCK_OWNER"));
        this._lockCreationDateField = new JTextField();
        this._lockCreationDateLabel = new JLabel();
        this.initTextField(this._lockCreationDateField);
        ResourceUtils.resLabel((JLabel)this._lockCreationDateLabel, (Component)this._lockCreationDateField, (String)res.getString("URL_PROPS_UI_LOCK_CREATION_DATE"));
        this._lockCommentField = new JTextField();
        this._lockCommentLabel = new JLabel();
        this.initTextField(this._lockCommentField);
        ResourceUtils.resLabel((JLabel)this._lockCommentLabel, (Component)this._lockCommentField, (String)res.getString("URL_PROPS_UI_LOCK_COMMENT"));
    }

    private void initTextField(JTextField field) {
        if (field != null) {
            field.setBorder(BorderFactory.createEmptyBorder());
            field.setBackground(UIManager.getColor("control"));
            field.setEditable(false);
        }
    }

    private void layoutComponents() {
        Insets labelInsets = new Insets(3, 0, 3, 3);
        Insets fieldInsets = new Insets(3, 3, 3, 0);
        this.add((Component)this._repositoryRootLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._repositoryRootField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._repositoryURLLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._repositoryURLField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._repositoryUUIDLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._repositoryUUIDField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._textStatusLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._textStatusField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._propStatusLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._propStatusField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._revisionLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._revisionField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._lastChangedRevLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._lastChangedRevField, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._lastChangedDateLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._lastChangedDateField, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._lastCommitAuthorLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._lastCommitAuthorField, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._textLastChangedDateLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._textLastChangedDateField, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._propLastChangedDateLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._propLastChangedDateField, new GridBagConstraints(1, 10, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._scheduleLabel, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._scheduleField, new GridBagConstraints(1, 11, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._isCopiedLabel, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._isCopiedField, new GridBagConstraints(1, 12, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._copiedSourceURLLabel, new GridBagConstraints(0, 13, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._copiedSourceURLField, new GridBagConstraints(1, 13, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._copiedSourceRevLabel, new GridBagConstraints(0, 14, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._copiedSourceRevField, new GridBagConstraints(1, 14, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._lockOwnerLabel, new GridBagConstraints(0, 15, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._lockOwnerField, new GridBagConstraints(1, 15, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._lockCreationDateLabel, new GridBagConstraints(0, 16, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._lockCreationDateField, new GridBagConstraints(1, 16, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._lockCommentLabel, new GridBagConstraints(0, 17, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._lockCommentField, new GridBagConstraints(1, 17, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
    }

    private void removeCopySourcesLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component[] components = new Component[]{SVNPropertiesPanelUI.this._copiedSourceURLLabel, SVNPropertiesPanelUI.this._copiedSourceURLField, SVNPropertiesPanelUI.this._copiedSourceRevLabel, SVNPropertiesPanelUI.this._copiedSourceRevField};
                for (int i = 0; i < components.length; ++i) {
                    SVNPropertiesPanelUI.this.remove(components[i]);
                }
            }
        });
    }
}

