/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedHashSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.DockableWindow;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.util.VCSCollectionUtils;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSMenuUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.properties.AbstractPropertiesTableModel;
import oracle.jdevimpl.vcs.svn.properties.DockPropertiesTableModel;
import oracle.jdevimpl.vcs.svn.properties.ViewPropertiesController;
import oracle.jdevimpl.vcs.svn.properties.ui.PropertiesPanel;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SVNPropertiesWindow
extends DockableWindow
implements ContextMenuListener {
    public static final String VIEW_NAME = "SVNPropertiesWindow";
    public static final ViewId VIEW_ID = new ViewId("ViewType_SVNProperties", "SVNPropertiesWindow");
    private Controller _controller;
    public final String ALL_PROP = Resource.get("ACTION_VIEWPROPERTIES_ALL_PROP");
    public final String SVN_PROP = Resource.get("ACTION_VIEWPROPERTIES_SVN_PROP");
    public final String CUSTOM_PROP = Resource.get("ACTION_VIEWPROPERTIES_CUSTOM_PROP");
    private PropertiesPanel _panel;
    private JTable _table;
    private DockPropertiesTableModel _model;
    private Toolbar _toolbar;
    private JComboBox _scopeBox;
    private IdeAction _refreshAction;
    private IdeAction _addAction;
    private IdeAction _deleteAction;
    private IdeAction _saveAction;
    private IdeAction _editAction;
    private JLabel _resourceLabel;
    private ContextMenu _contextMenu;
    private PropActiveViewListener _viewListener;
    private Context _context;
    private File[] _contextResources;
    private PropMouseListener _mouseListener;
    private RowSelectionListener _rowSelectionListener;

    public SVNPropertiesWindow(Context context) {
        super(VIEW_ID.getId());
        this.setViewContext(context);
        this.registerViewListener();
        this.registerMouseListener();
        this.refresh(context);
    }

    public String getTabName() {
        return Resource.get("PROPS_DOCKABLE_TAB_NAME");
    }

    public Icon getTabIcon() {
        return ResourcePicker.getPicker(SVNProfile.class).getImage("ACTION_VIEWPROPERTIES_ICON");
    }

    public String getTitleName() {
        return Resource.get("PROPS_DOCKABLE_TITLE");
    }

    public void stateChange(int newState) {
        super.stateChange(newState);
        switch (newState) {
            case 3: {
                this._panel.setTable(null);
                this._panel.setEnabled(false);
                this._panel = null;
                this.deregisterViewListener();
                this.deregisterMouseListener();
            }
        }
    }

    public Component getGUI() {
        if (this._panel == null) {
            this._panel = new PropertiesPanel(this.getToolbar(), this.getTable());
        }
        return this._panel;
    }

    public final Controller getController() {
        if (this._controller == null) {
            this._controller = new ViewPropertiesController();
        }
        return this._controller;
    }

    public final ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            this._contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        return this._contextMenu;
    }

    public final Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new Toolbar();
            this._toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.initToolbar();
        }
        return this._toolbar;
    }

    private void initToolbar() {
        this._toolbar.add((Component)this.getScopeComboBox());
        this._toolbar.addSeparator();
        this._toolbar.add((ToggleAction)this.getRefreshAction());
        this._toolbar.addSeparator();
        this._toolbar.add((ToggleAction)this.getAddAction());
        this._toolbar.addSeparator();
        this._toolbar.add((ToggleAction)this.getEditAction());
        this._toolbar.addSeparator();
        this._toolbar.add((ToggleAction)this.getDeleteAction());
        this._toolbar.addSeparator();
        this._toolbar.add((ToggleAction)this.getSaveAction());
        this._toolbar.addSeparator();
    }

    private JLabel getResourceLabel() {
        if (this._resourceLabel == null) {
            this._resourceLabel = new JLabel(Resource.get("ACTION_VIEWPROPERTIES_RESOURCE_PROMPT"));
        }
        return this._resourceLabel;
    }

    private JComboBox getScopeComboBox() {
        if (this._scopeBox == null) {
            this._scopeBox = new JComboBox<String>(new String[]{this.ALL_PROP, this.SVN_PROP, this.CUSTOM_PROP});
            this._scopeBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SVNPropertiesWindow.this.refresh();
                }
            });
        }
        DefaultListCellRenderer renderer = new DefaultListCellRenderer();
        Dimension d = new Dimension(SwingUtilities.computeStringWidth(renderer.getFontMetrics(renderer.getFont()), "Customized properties") + 30, this._scopeBox.getPreferredSize().height);
        this._scopeBox.setRenderer(renderer);
        this._scopeBox.setMaximumSize(d);
        this._scopeBox.setPreferredSize(d);
        this._scopeBox.setMinimumSize(d);
        return this._scopeBox;
    }

    private void updateCotroller() {
        this.getController().update(this.getDeleteAction(), this.getContext());
        this.getController().update(this.getSaveAction(), this.getContext());
        this.getAddAction().updateAction();
        this.getEditAction().updateAction();
    }

    private IdeAction getRefreshAction() {
        if (this._refreshAction == null) {
            this._refreshAction = this.getLocalAction(51);
        }
        return this._refreshAction;
    }

    private IdeAction getAddAction() {
        if (this._addAction == null) {
            this._addAction = IdeAction.find((String)"oracle.jdeveloper.subversion.addproperty");
        }
        return this._addAction;
    }

    private IdeAction getDeleteAction() {
        if (this._deleteAction == null) {
            this._deleteAction = this.getLocalAction(20);
        }
        return this._deleteAction;
    }

    private IdeAction getSaveAction() {
        if (this._saveAction == null) {
            this._saveAction = this.getLocalAction(11);
            this._saveAction.setName(Resource.get("ACTION_SAVEPROPERTIES_NAME"));
        }
        return this._saveAction;
    }

    private IdeAction getEditAction() {
        if (this._editAction == null) {
            this._editAction = IdeAction.find((String)"oracle.jdeveloper.subversion.editproperty");
        }
        return this._editAction;
    }

    private IdeAction getLocalAction(int cmdId) {
        IdeAction ideAction = IdeAction.find((int)cmdId);
        if (ideAction != null) {
            IdeAction local = ideAction.newLocalAction((View)this);
            return local;
        }
        throw new IllegalArgumentException("CMDID " + cmdId + " not found");
    }

    public void refresh() {
        this.updatePropertieTable(this._contextResources);
    }

    protected void refresh(Context context) {
        if (context == null) {
            this.refresh();
            return;
        }
        this._contextResources = this.getResourceSelection(context);
        this.updatePropertieTable(this._contextResources);
    }

    protected void remove() {
        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)Resource.get("ACTION_VIEWPROPERTIES_DELETE_MESSAGE"), (String)Resource.get("ACTION_VIEWPROPERTIES_DELETE_TITLE"), null)) {
            return;
        }
        int[] selectedRows = this.getTable().getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            String propName = (String)this.getTableModel().getValueAt(selectedRows[i], 0);
            File resource = new File((String)this.getTableModel().getValueAt(selectedRows[i], 2));
            this.removeProperty(resource, propName);
        }
        this.refresh();
    }

    protected void save() {
        String propName = (String)this.getTableModel().getValueAt(this._panel.getTable().getSelectedRow(), 0);
        this.saveProperty(this._contextResources[0], propName);
    }

    protected void updatePropertieTable(File[] resources) {
        this.setTableData(this.getProperties(resources), this.getScope());
    }

    private void updateFilePromptLabel(String fileName) {
        this.getResourceLabel().setText(Resource.get("ACTION_VIEWPROPERTIES_RESOURCE_PROMPT") + fileName);
    }

    private void registerMouseListener() {
        this._mouseListener = new PropMouseListener();
        this._rowSelectionListener = new RowSelectionListener(this.getTable());
        this.getTable().addMouseListener(this._mouseListener);
        this.getTable().getSelectionModel().addListSelectionListener(this._rowSelectionListener);
    }

    private void deregisterMouseListener() {
        this.getTable().removeMouseListener(this._mouseListener);
        this.getTable().getSelectionModel().removeListSelectionListener(this._rowSelectionListener);
    }

    private void registerViewListener() {
        this._viewListener = new PropActiveViewListener();
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this._viewListener);
    }

    private void deregisterViewListener() {
        this._viewListener.removeSelectionListener();
        Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this._viewListener);
    }

    public File[] getSelectionResources() {
        ArrayList<File> resources = new ArrayList<File>();
        int[] selectedRows = this.getTable().getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            File resource = new File((String)this.getTableModel().getValueAt(selectedRows[i], 2));
            resources.add(resource);
        }
        return (File[])resources.toArray();
    }

    public File[] getContextResources() {
        return this._contextResources;
    }

    public Context getViewContext() {
        return this._context;
    }

    public void setViewContext(Context context) {
        this._context = context;
    }

    private boolean isNavigatorView(View view) {
        return view.getId().equals("ApplicationNavigatorWindow.ApplicationNavigatorName") || view.getId().equals("_SUB_ApplicationNavigatorWindow._SUB_ApplicationNavigatorName");
    }

    public void setTableData(ISVNProperty[] properties, String scope) {
        this.getTableModel().updateProperties(properties, scope);
    }

    public String getScope() {
        return this._scopeBox == null || (String)this._scopeBox.getSelectedItem() == null ? this.ALL_PROP : (String)this._scopeBox.getSelectedItem();
    }

    private ISVNProperty[] getProperties(File[] resources) {
        this._contextResources = resources;
        if (resources == null || resources.length == 0) {
            return null;
        }
        ArrayList<ISVNProperty> properties = new ArrayList<ISVNProperty>();
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            for (int i = 0; i < resources.length; ++i) {
                properties.addAll(Arrays.asList(client.getProperties(resources[i])));
            }
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
            return null;
        }
        return properties.toArray(new ISVNProperty[0]);
    }

    private void saveProperty(File resource, String propertyName) {
        if (resource == null) {
            return;
        }
        SaveURLChooser urlChooser = new SaveURLChooser();
        File dest = null;
        DialogUtil.initURLChooser((URLChooser)urlChooser, (Context)this._context);
        if (urlChooser.showSaveDialog((Component)Ide.getMainWindow()) == 0) {
            dest = new File(URLFileSystem.getPlatformPathName((URL)urlChooser.getSelectedURL()));
        }
        if (dest == null) {
            return;
        }
        FileOutputStream fos = null;
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            byte[] value = client.propertyGet(resource, propertyName).getData();
            fos = new FileOutputStream(dest);
            fos.write(value);
            fos.close();
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
            return;
        }
        catch (FileNotFoundException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).severe(e.getMessage());
        }
        catch (IOException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).severe(e.getMessage());
        }
    }

    private void removeProperty(File resource, String propertyName) {
        if (resource == null) {
            return;
        }
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            client.propertyDel(resource, propertyName, false);
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
            return;
        }
        VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion").getStatusCache().clear(VCSURLFilters.createBaseURLContentsFilter((URL[])new URL[]{resource.isDirectory() ? URLFactory.newDirURL((File)resource) : URLFactory.newFileURL((File)resource)}));
    }

    private File[] getResourceSelection(Context context) {
        Locatable[] locatables = VCSContextUtils.getContextLocatables((Context)context);
        File[] files = SVNUtil.toFiles(VCSModelUtils.convertNodesToURLs((Locatable[])locatables));
        ArrayList<File> parentList = new ArrayList<File>();
        for (File file : files) {
            String name = file.getName();
            if (!name.endsWith(".jws") && !name.endsWith(".jpr")) continue;
            parentList.add(file.getParentFile());
        }
        parentList.addAll(Arrays.asList(files));
        return parentList.toArray(new File[parentList.size()]);
    }

    public JTable getTable() {
        if (this._table == null) {
            AbstractPropertiesTableModel model = this.getTableModel();
            this._table = new NiceTable((TableModel)((Object)model));
            this._table.setAutoResizeMode(0);
            ((NiceTable)this._table).setSortColumn(0, false);
            Object[] prototypeValues = new String[]{"reasonablylongname", "reasonablelongpropertyvaluereasonablelongpropertyvalue", "goodlengthforurlgoodlengthforurlgoodlengthforurlgoodlengthforurl"};
            ((NiceTable)this._table).autoSizeColumnsToFit(prototypeValues);
            for (int col = 0; col < model.getColumnCount(); ++col) {
                if (!model.isShowingIconWithUrl(col)) continue;
                this._table.getColumnModel().getColumn(col).setCellRenderer(new URLRenderer());
            }
        }
        return this._table;
    }

    public AbstractPropertiesTableModel getTableModel() {
        if (this._model == null) {
            this._model = new DockPropertiesTableModel();
        }
        return this._model;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        this.addMenuItems(contextMenu);
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void addMenuItems(ContextMenu contextMenu) {
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getRefreshAction()), 1.0f);
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getAddAction()), 1.0f);
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getEditAction()), 1.0f);
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getDeleteAction()), 1.0f);
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getSaveAction()), 1.0f);
        try {
            boolean gotModified = false;
            Element[] selection = this.getContext().getSelection();
            if (selection == null) {
                return;
            }
            VCSProfile profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
            for (Element e : selection) {
                URL url = VCSModelUtils.getLocatableURL((Object)e);
                if (url == null || profile.getStatusCache().get(url) != profile.getStatusInstance("MODIFIED")) continue;
                gotModified = true;
            }
            if (!gotModified) {
                return;
            }
            VCSMenuUtils.addDynamicMenuItem((ContextMenu)contextMenu, (int)Ide.findCmdID((String)"oracle.jdeveloper.subversion.commit"), (float)MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
            VCSMenuUtils.addDynamicMenuItem((ContextMenu)contextMenu, (int)Ide.findCmdID((String)"oracle.jdeveloper.subversion.revert"), (float)MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
    }

    public Context getContext(EventObject event) {
        Context context = super.getContext(event);
        if (this._table == null) {
            return context;
        }
        int[] rows = this._table.getSelectedRows();
        if (!(((NiceTable)this._table).getBaseModel() instanceof AbstractPropertiesTableModel)) {
            return context;
        }
        int column = this._table.getColumnModel().getColumnIndex(((AbstractPropertiesTableModel)((Object)((NiceTable)this._table).getBaseModel())).HEADER_URL);
        if (column < 0) {
            return context;
        }
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        for (int row : rows) {
            paths.add((String)this._table.getValueAt(row, column));
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths) {
            urls.add(new File(path).isDirectory() ? URLFactory.newDirURL((String)path) : URLFactory.newFileURL((String)path));
        }
        context.setSelection((Element[])VCSCollectionUtils.toArrayType(Arrays.asList(VCSModelUtils.findOrCreateNodes((URL[])urls.toArray(new URL[0]))), Element.class));
        return context;
    }

    private class URLRenderer
    extends DefaultTableCellRenderer {
        private URLRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            URL url = URLFactory.newURL((String)((String)value));
            Icon icon = URLFileSystem.isDirectory((URL)url) ? OracleIcons.getIcon((String)"folder.png") : OracleIcons.getIcon((String)"file.png");
            this.setText((String)value);
            this.setIcon(icon);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class RowSelectionListener
    implements ListSelectionListener {
        JTable table;

        RowSelectionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                SVNPropertiesWindow.this.updateCotroller();
            }
            if (e.getValueIsAdjusting()) {
                // empty if block
            }
        }
    }

    private final class PropMouseListener
    extends MouseAdapter {
        private PropMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SVNPropertiesWindow.this.getContextMenu().show(SVNPropertiesWindow.this.getContext(e));
            }
            if (e.getClickCount() == 2) {
                try {
                    SVNPropertiesWindow.this.getEditAction().performAction();
                }
                catch (Exception ex) {
                    SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(ex.getMessage());
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SVNPropertiesWindow.this.getContextMenu().show(SVNPropertiesWindow.this.getContext(e));
            }
        }
    }

    private class SaveURLChooser
    extends URLChooser {
        private static final String HELP_TOPIC = "f1_svnsaveproperty_html";

        SaveURLChooser() {
            this.setHelpID(HELP_TOPIC);
        }

        protected URL canonicalizeApprovalURL(URL url) {
            if (URLFileSystem.isDirectory((URL)url)) {
                return URLFileSystem.canonicalize((URL)url);
            }
            String fileName = URLFileSystem.getFileName((URL)url);
            URL dirURL = URLFileSystem.canonicalize((URL)URLFileSystem.getParent((URL)url));
            return URLFactory.newURL((URL)dirURL, (String)fileName);
        }
    }

    private class PropViewSelectionListener
    implements ViewSelectionListener {
        private PropViewSelectionListener() {
        }

        public void viewSelectionChanged(ViewSelectionEvent e) {
            SVNPropertiesWindow.this._context = e.getView().getContext();
            File[] resources = SVNPropertiesWindow.this.getResourceSelection(SVNPropertiesWindow.this._context);
            SVNPropertiesWindow.this.updatePropertieTable(resources);
        }
    }

    private class PropActiveViewListener
    implements ActiveViewListener {
        private PropViewSelectionListener _selectionListener;

        public PropActiveViewListener() {
            this._selectionListener = new PropViewSelectionListener();
            this.addSelectionListener();
        }

        public void activeViewChanged(ActiveViewEvent e) {
            View view = e.getOldView();
            if (view != null && SVNPropertiesWindow.this.isNavigatorView(view)) {
                view.removeViewSelectionListener((ViewSelectionListener)this._selectionListener);
            }
            if (SVNPropertiesWindow.this.isNavigatorView(view = e.getNewView())) {
                view.addViewSelectionListener((ViewSelectionListener)this._selectionListener);
                SVNPropertiesWindow.this.refresh(view.getContext());
                SVNPropertiesWindow.this.setViewContext(view.getContext());
            }
        }

        public void removeSelectionListener() {
            if (SVNPropertiesWindow.this._context == null) {
                return;
            }
            View view = SVNPropertiesWindow.this._context.getView();
            if (SVNPropertiesWindow.this.isNavigatorView(view)) {
                view.removeViewSelectionListener((ViewSelectionListener)this._selectionListener);
            }
        }

        public void addSelectionListener() {
            if (SVNPropertiesWindow.this._context == null) {
                return;
            }
            View view = SVNPropertiesWindow.this._context.getView();
            if (SVNPropertiesWindow.this.isNavigatorView(view)) {
                view.addViewSelectionListener((ViewSelectionListener)this._selectionListener);
            }
        }
    }
}

