/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.properties;

import java.io.IOException;
import java.util.ArrayList;
import oracle.javatools.controls.nicetable.DefaultNiceTableModel;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

public abstract class AbstractPropertiesTableModel
extends DefaultNiceTableModel {
    protected ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);
    protected final String ALL_PROP = this._res.getString("ACTION_VIEWPROPERTIES_ALL_PROP");
    protected final String SVN_PROP = this._res.getString("ACTION_VIEWPROPERTIES_SVN_PROP");
    protected final String CUSTOM_PROP = this._res.getString("ACTION_VIEWPROPERTIES_CUSTOM_PROP");
    protected final String HEADER_PROP_NAME = this._res.getString("UI_VIEWPROPERTIES_HEADER_PROP_NAME");
    protected final String HEADER_PROP_VALUE = this._res.getString("UI_VIEWPROPERTIES_HEADER_PROP_VALUE");
    protected final String HEADER_URL = this._res.getString("UI_VIEWPROPERTIES_HEADER_URL");
    private String[] _columnNames;
    private String[][] _properties;

    public AbstractPropertiesTableModel() {
    }

    public AbstractPropertiesTableModel(String[] columnNames) {
        this.setColumnNames(columnNames);
    }

    public int getRowCount() {
        if (this._properties == null) {
            return 0;
        }
        return this._properties.length;
    }

    public int getColumnCount() {
        return this._columnNames.length;
    }

    public String getColumnName(int columnIndex) {
        return this._columnNames[columnIndex];
    }

    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    public int getColumnAlignment(int i) {
        return 2;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this._properties == null) {
            return null;
        }
        return this._properties[rowIndex][columnIndex];
    }

    public void setColumnNames(String[] columnNames) {
        this._columnNames = columnNames;
    }

    public boolean isShowingIconWithUrl(int columnIndex) {
        return false;
    }

    public void updateProperties(ISVNProperty[] properties, String scope) {
        try {
            this._properties = this.parseISVNPropertyArray(properties, scope);
        }
        catch (IOException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
        }
        this.fireTableDataChanged();
    }

    public String[][] parseISVNPropertyArray(ISVNProperty[] properties, String scope) throws IOException {
        if (properties == null || properties.length == 0) {
            return null;
        }
        ArrayList<ISVNProperty> propList = new ArrayList<ISVNProperty>();
        for (int i = 0; i < properties.length; ++i) {
            if (!this.accept(properties[i].getName(), scope)) continue;
            propList.add(properties[i]);
        }
        String[][] strArray = new String[propList.size()][this.getColumnCount()];
        for (int i = 0; i < strArray.length; ++i) {
            this.assignTableValues(strArray[i], (ISVNProperty)propList.get(i));
        }
        return strArray;
    }

    public boolean accept(String propName, String scope) {
        if (scope.equals(this.ALL_PROP)) {
            return true;
        }
        if (scope.equals(this.CUSTOM_PROP)) {
            return !propName.startsWith("svn:");
        }
        if (scope.equals(this.SVN_PROP)) {
            return propName.startsWith("svn:");
        }
        return false;
    }

    public abstract void assignTableValues(String[] var1, ISVNProperty var2);
}

