/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.PlatformUtils;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSPropertyTraversable;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.client.SVNClientRegistry;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SVNClientsTraversable
extends VCSPropertyTraversable {
    private final Map _props = new HashMap(5);
    private final VCSProfile _profile;
    private Component _ui;

    public SVNClientsTraversable() {
        this.setHelpID("f1_svnpreferencesmain_html");
        this._profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        assert (this._profile != null);
    }

    protected String getDataKey() {
        return this._profile.getQualifiedDataKey("CLIENT_TECHNOLOGY");
    }

    protected Map getProperties() {
        this._props.clear();
        this._props.put("clientType", new Integer(((UI)this.getPropertyPage()).getSelectedClientType()));
        return this._props;
    }

    protected void setProperties(Map props) {
        Integer clientType = (Integer)props.get("clientType");
        if (clientType != null) {
            ((UI)this.getPropertyPage()).setSelectedClientType(clientType);
        }
    }

    protected Component getPropertyPage() {
        if (this._ui == null) {
            this._ui = new UI();
        }
        return this._ui;
    }

    protected void validateProperties() throws TraversalException {
    }

    private final class UI
    extends JPanel {
        private JLabel _clientsLabel;
        private JWrappedLabel _clientsUnavailableLabel;
        private JLabel _singleClientLabel;
        private ButtonGroup _radioGroup;
        private JRadioButton _cliRadio;
        private JRadioButton _nativeRadio;
        private JRadioButton _svnkitRadio;
        private final int _clientCount;

        private UI() {
            super(new GridBagLayout());
            this._clientCount = this.countClients();
            this.createComponents();
            this.layoutComponents();
        }

        private int getSelectedClientType() {
            switch (this._clientCount) {
                case 0: {
                    return 2;
                }
                case 1: {
                    if (SVNClientRegistry.getInstance().isNativeClientAvailable()) {
                        return 1;
                    }
                    if (SVNClientRegistry.getInstance().isSVNKitClientAvailable()) {
                        return 2;
                    }
                    if (SVNClientRegistry.getInstance().isCLIClientAvailable()) {
                        return 0;
                    }
                    throw new IllegalStateException();
                }
            }
            if (this._cliRadio != null && this._cliRadio.isSelected()) {
                return 0;
            }
            if (this._nativeRadio.isSelected()) {
                return 1;
            }
            if (this._svnkitRadio != null && this._svnkitRadio.isSelected()) {
                return 2;
            }
            throw new IllegalStateException();
        }

        private void setSelectedClientType(int clientType) {
            block0 : switch (this._clientCount) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    switch (clientType) {
                        case 0: {
                            if (this._cliRadio != null) {
                                this._cliRadio.setSelected(true);
                                break block0;
                            }
                            throw new IllegalArgumentException();
                        }
                        case 1: {
                            this._nativeRadio.setSelected(true);
                            break block0;
                        }
                        case 2: {
                            if (this._svnkitRadio != null) {
                                this._svnkitRadio.setSelected(true);
                                break block0;
                            }
                            throw new IllegalArgumentException();
                        }
                    }
                    throw new IllegalArgumentException();
                }
            }
        }

        private int countClients() {
            int count = 0;
            SVNClientRegistry reg = SVNClientRegistry.getInstance();
            if (reg.isNativeClientAvailable()) {
                ++count;
            }
            if (reg.isSVNKitClientAvailable()) {
                ++count;
            }
            if (reg.isCLIClientAvailable()) {
                ++count;
            }
            return count;
        }

        private void createComponents() {
            ResourcePicker res = ResourcePicker.getPicker(SVNProfile.class);
            this._clientsLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)this._clientsLabel, null, (String)res.getString("UI_SVN_CLIENTS"));
            switch (this._clientCount) {
                case 0: {
                    this.createNoClientComponents(res);
                    break;
                }
                case 1: {
                    this.createSingleClientComponents(res);
                    break;
                }
                default: {
                    this.createMultipleClientComponents(res);
                }
            }
        }

        private void createNoClientComponents(ResourcePicker res) {
            this._clientsUnavailableLabel = new JWrappedLabel();
            if (PlatformUtils.isWindows()) {
                this._clientsUnavailableLabel.setText(res.getString("ERROR_MSG_NO_CLIENTS_WIN32"));
            } else if (PlatformUtils.isLinux()) {
                this._clientsUnavailableLabel.setText(res.getString("ERROR_MSG_NO_CLIENTS_LINUX"));
            } else {
                this._clientsUnavailableLabel.setText(res.getString("ERROR_MSG_NO_CLIENTS_GENERIC"));
            }
        }

        private void createSingleClientComponents(ResourcePicker res) {
            this._singleClientLabel = new JLabel();
            this._singleClientLabel.setFocusTraversalKeysEnabled(true);
            SVNClientRegistry reg = SVNClientRegistry.getInstance();
            if (reg.isNativeClientAvailable()) {
                ResourceUtils.resLabel((JLabel)this._singleClientLabel, (Component)this._singleClientLabel, (String)this.getNativeClientDisplayValue(res));
            } else if (reg.isSVNKitClientAvailable()) {
                ResourceUtils.resLabel((JLabel)this._singleClientLabel, (Component)this._singleClientLabel, (String)this.getSVNKitClientDisplayValue(res));
            } else if (reg.isCLIClientAvailable()) {
                ResourceUtils.resLabel((JLabel)this._singleClientLabel, (Component)this._singleClientLabel, (String)this.getCLIClientDisplayValue(res));
            } else {
                throw new IllegalStateException();
            }
        }

        private void createMultipleClientComponents(ResourcePicker res) {
            SVNClientRegistry reg = SVNClientRegistry.getInstance();
            this._radioGroup = new ButtonGroup();
            this._nativeRadio = new JRadioButton();
            this._radioGroup.add(this._nativeRadio);
            this._nativeRadio.setEnabled(reg.isNativeClientAvailable());
            ResourceUtils.resButton((AbstractButton)this._nativeRadio, (String)this.getNativeClientDisplayValue(res));
            if (reg.isSVNKitClientAvailable()) {
                this._svnkitRadio = new JRadioButton();
                this._svnkitRadio.setEnabled(true);
                this._radioGroup.add(this._svnkitRadio);
                this._svnkitRadio.setText(this.getSVNKitClientDisplayValue(res));
                this._svnkitRadio.setMnemonic('K');
            }
            if (reg.isCLIClientAvailable()) {
                this._cliRadio = new JRadioButton();
                this._radioGroup.add(this._cliRadio);
                this._cliRadio.setEnabled(true);
                ResourceUtils.resButton((AbstractButton)this._cliRadio, (String)this.getCLIClientDisplayValue(res));
            }
        }

        private String getNativeClientDisplayValue(ResourcePicker res) {
            try {
                return res.getString("UI_CLIENTS_NATIVE_V", new Object[]{SVNClientRegistry.getInstance().getNativeClient().getSVNVersion()});
            }
            catch (SVNClientException ce) {
                return res.getString("UI_CLIENTS_NATIVE_NV");
            }
        }

        private String getSVNKitClientDisplayValue(ResourcePicker res) {
            try {
                return SVNClientRegistry.getInstance().getSVNKitClient().getSVNVersion();
            }
            catch (SVNClientException ce) {
                return res.getString("UI_CLIENTS_SVNKIT_NV");
            }
        }

        private String getCLIClientDisplayValue(ResourcePicker res) {
            try {
                return res.getString("UI_CLIENTS_CLI_V", new Object[]{SVNClientRegistry.getInstance().getCLIClient().getSVNVersion()});
            }
            catch (SVNClientException ce) {
                return res.getString("UI_CLIENTS_CLI_NV");
            }
        }

        private void layoutComponents() {
            this.add((Component)this._clientsLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            switch (this._clientCount) {
                case 0: {
                    this.layoutNoClientComponents();
                    break;
                }
                case 1: {
                    this.layoutSingleClientComponents();
                    break;
                }
                default: {
                    this.layoutMultipleClientComponents();
                }
            }
        }

        private void layoutNoClientComponents() {
            this.add((Component)this._clientsUnavailableLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(4, 26, 0, 0), 0, 0));
        }

        private void layoutSingleClientComponents() {
            this.add((Component)this._singleClientLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(4, 26, 0, 0), 0, 0));
        }

        private void layoutMultipleClientComponents() {
            this.add((Component)this._nativeRadio, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(4, 26, 0, 0), 0, 0));
            if (this._svnkitRadio != null) {
                this.add((Component)this._svnkitRadio, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(4, 26, 0, 0), 0, 0));
            }
            if (this._cliRadio != null) {
                this.add((Component)this._cliRadio, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(4, 26, 0, 0), 0, 0));
            }
        }
    }
}

