/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.util.Observable;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRevisionListPanel;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNRevisionLister
extends Observable {
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);
    private SVNRevisionListPanel _panel;
    private JEWTDialog _dialog;
    private ISVNLogMessage[] _logMessages;
    private boolean _allowMultipleSelection = false;
    private SVNUrl _url;
    private SVNRevision _revisionStart;
    private SVNRevision _revisionEnd;
    private File _file;

    public SVNRevisionLister(SVNUrl url, SVNRevision revisionStart, SVNRevision revisionEnd) {
        this._url = url;
        this._revisionStart = revisionStart;
        this._revisionEnd = revisionEnd;
        this._panel = new SVNRevisionListPanel(url, revisionStart, revisionEnd);
        this._dialog = this.createDialog();
    }

    public SVNRevisionLister(File file, SVNRevision revisionStart, SVNRevision revisionEnd) {
        this._file = file;
        this._revisionStart = revisionStart;
        this._revisionEnd = revisionEnd;
        this._panel = new SVNRevisionListPanel(file, revisionStart, revisionEnd);
        this._dialog = this.createDialog();
    }

    @Deprecated
    public SVNRevisionLister(ISVNLogMessage[] logMessages) {
        this._logMessages = logMessages;
        this._panel = new SVNRevisionListPanel(this._logMessages);
        this._dialog = this.createDialog();
    }

    public void showLister() {
        this._dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                    if (SVNRevisionLister.this.getSelectedRevision() != null) {
                        SVNRevisionLister.this.setChanged();
                    }
                    SVNRevisionLister.this.notifyObservers(SVNRevisionLister.this.getSelectedRevision());
                }
            }
        });
        this._dialog.runDialog();
    }

    private JEWTDialog createDialog() {
        String title = this._res.getString("ACTION_REVISION_LISTER_TITLE");
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), title, 7);
        dialog.setDefaultButton(1);
        dialog.setContent((Component)this._panel);
        dialog.setResizable(true);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._panel, "f1_svnrevisionlister_html");
        return dialog;
    }

    public SVNRevision getSelectedRevision() {
        return this._panel.getSelectedRevision();
    }

    public SVNRevisionRange[] getSelectedRevisions() {
        return this._panel.getSelectedRevisions();
    }

    public void setAllowMultipleSelection(boolean allowMultiSelection) {
        this._allowMultipleSelection = allowMultiSelection;
        this._panel.setAllowMultiSelection(allowMultiSelection);
    }

    public boolean isAllowMultipleSelection() {
        return this._allowMultipleSelection;
    }
}

