/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.ui.table.EditableTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableModel;
import oracle.javatools.ui.table.TableHelper;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNExecutorService;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNRevisionListPanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);
    private JLabel _resourceLabel;
    private TableModel _revTableModel;
    private GenericTable _revisionTable;
    private JScrollPane _revScollPane;
    private JLabel _commentLabel;
    private JTextArea _commentArea;
    private JScrollPane _commentScollPane;
    private ISVNLogMessage[] _logs;
    private boolean _allowMultiSelection = false;
    private SVNRevisionRange[] _revisionRanges;
    private JLabel _actionLabel;
    private TableModel _actionTableModel;
    private GenericTable _actionTable;
    private JScrollPane _actionScollPane;
    private JPanel _buttonsPanel;
    private JButton _showallButton;
    private JButton _next25Button;
    private JCheckBox _stoponcopyBox;
    private SVNUrl _url;
    private SVNRevision _revisionStart;
    private SVNRevision _revisionEnd;
    private File _file;
    private boolean _stoponcopy = true;
    private long _limit = 20L;
    private boolean _fetchChangedPaths = true;
    private final String[] _revisionColumnNames = new String[]{this._res.getString("UI_REVISION_LIST_PANEL_TABLEHEADER_REVISION"), this._res.getString("UI_REVISION_LIST_PANEL_TABLEHEADER_ACTION"), this._res.getString("UI_REVISION_LIST_PANEL_TABLEHEADER_DATE"), this._res.getString("UI_REVISION_LIST_PANEL_TABLEHEADER_AUTHOR")};
    private final String[] _actionColumnNames = new String[]{this._res.getString("UI_REVISION_LIST_PANEL_TABLEHEADER_ACTION"), this._res.getString("UI_REVISION_LIST_PANEL_TABLEHEADER_PATH"), this._res.getString("UI_REVISION_LIST_PANEL_TABLEHEADER_COPIEDPATH"), this._res.getString("UI_REVISION_LIST_PANEL_TABLEHEADER_REVISION")};
    private boolean _appendMode = false;
    private SVNRevision _lastRevision = SVNRevision.HEAD;

    public SVNRevisionListPanel(SVNUrl url, SVNRevision revisionStart, SVNRevision revisionEnd) {
        super(new GridBagLayout());
        this._url = url;
        this._revisionStart = revisionStart;
        this._revisionEnd = revisionEnd;
        this.createComponents();
        this.layoutComponents();
        this.initListerners();
        this.setInitialContent();
    }

    public SVNRevisionListPanel(File file, SVNRevision revisionStart, SVNRevision revisionEnd) {
        super(new GridBagLayout());
        this._file = file;
        this._revisionStart = revisionStart;
        this._revisionEnd = revisionEnd;
        this.createComponents();
        this.layoutComponents();
        this.initListerners();
        this.setInitialContent();
    }

    @Deprecated
    public SVNRevisionListPanel(ISVNLogMessage[] logs) {
        super(new GridBagLayout());
        this._logs = logs;
        this.createComponents();
        this.layoutComponents();
    }

    private void createComponents() {
        this._resourceLabel = new JLabel();
        if (this._url != null) {
            this._resourceLabel.setText(this._url.toString());
        } else if (this._file != null) {
            this._resourceLabel.setText(this._file.toString());
        }
        this._revTableModel = new RevisionDefaultTableModel(new Object[0][4], this._revisionColumnNames);
        this._actionTableModel = new RevisionDefaultTableModel(new Object[0][4], this._actionColumnNames);
        this._revisionTable = new GenericTable(this._revTableModel);
        this._revisionTable.setAutoResizeMode(4);
        this._revisionTable.setSelectionMode(0);
        this._revisionTable.setResizeColumnOnDoubleClick(true);
        this._revisionTable.setNoEntryInstructionText("");
        this._revScollPane = new JScrollPane((Component)this._revisionTable);
        this._revScollPane.setBorder(BorderFactory.createEtchedBorder());
        this._buttonsPanel = new JPanel(new FlowLayout(3));
        this._stoponcopyBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._stoponcopyBox, (String)this._res.getString("UI_REVISION_LIST_PANEL_CHECKBOX_STOPONCOPY"));
        this._stoponcopyBox.setSelected(true);
        this._buttonsPanel.add(this._stoponcopyBox);
        this._showallButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._showallButton, (String)this._res.getString("UI_REVISION_LIST_PANEL_BUTTON_ALL"));
        this._buttonsPanel.add(this._showallButton);
        this._next25Button = new JButton();
        ResourceUtils.resButton((AbstractButton)this._next25Button, (String)this._res.getString("UI_REVISION_LIST_PANEL_BUTTON_NEXT"));
        this._buttonsPanel.add(this._next25Button);
        this._commentLabel = new JLabel();
        this._commentArea = new JTextArea();
        ResourceUtils.resLabel((JLabel)this._commentLabel, (Component)this._commentArea, (String)this._res.getString("UI_REVISION_LIST_PANEL_LABEL_COMMENT"));
        this._commentArea.setEditable(false);
        this._commentArea.setRows(3);
        this._commentArea.setText("");
        this._commentScollPane = new JScrollPane();
        this._commentScollPane.getViewport().add(this._commentArea);
        this._actionLabel = new JLabel(this._res.getString("UI_REVISION_LIST_PANEL_LABEL_ACTION"));
        this._actionTable = new GenericTable(this._actionTableModel);
        this._actionTable.setSelectionMode(0);
        this._actionScollPane = new JScrollPane((Component)this._actionTable);
        this._actionScollPane.setBorder(BorderFactory.createEtchedBorder());
        this._actionTable.setNoEntryInstructionText("");
    }

    private void layoutComponents() {
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)this._resourceLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._revScollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
        this.add((Component)this._buttonsPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._commentLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._commentScollPane, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.3, 17, 1, insets, 0, 0));
        this.add((Component)this._actionScollPane, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.3, 17, 1, insets, 0, 0));
    }

    private void initListerners() {
        this._stoponcopyBox.addActionListener(this);
        this._next25Button.addActionListener(this);
        this._showallButton.addActionListener(this);
        this._revisionTable.getSelectionModel().addListSelectionListener(this);
    }

    private void setInitialContent() {
        LogRetriever logRetriever = new LogRetriever(this);
        SVNExecutorService.getInstance().submit(logRetriever);
    }

    public SVNRevision getSelectedRevision() {
        if (this._revisionTable.getSelectedRow() != -1) {
            return this._logs[this._revisionTable.getSelectedRows()[0]].getRevision();
        }
        return SVNRevision.INVALID_REVISION;
    }

    private synchronized void updateTableModel(ISVNLogMessage[] logs) {
        if (logs != null) {
            int row;
            Object[][] data = new Object[logs.length][this._revTableModel.getColumnCount()];
            for (row = 0; row < logs.length; ++row) {
                data[row][0] = logs[row].getRevision().getNumber();
                ISVNLogMessageChangePath[] changedpaths = logs[row].getChangedPaths();
                HashSet<Character> actionSet = new HashSet<Character>();
                for (ISVNLogMessageChangePath path : changedpaths) {
                    actionSet.add(Character.valueOf(path.getAction()));
                }
                String actionStr = " ";
                for (Character actionchar : actionSet) {
                    actionStr = actionStr.concat(",").concat(actionchar.toString());
                }
                actionStr = actionStr.substring(2);
                data[row][1] = actionStr;
                data[row][2] = logs[row].getDate();
                data[row][3] = logs[row].getAuthor();
            }
            if (this._appendMode) {
                ISVNLogMessage[] tmpLogs = new ISVNLogMessage[this._logs.length + logs.length - 1];
                System.arraycopy(this._logs, 0, tmpLogs, 0, this._logs.length);
                System.arraycopy(logs, 1, tmpLogs, this._logs.length, logs.length - 1);
                this._logs = tmpLogs;
                this._appendMode = false;
                this.updateTableModel(this._logs);
            } else {
                this._logs = logs;
                ((RevisionDefaultTableModel)this._revTableModel).removeAllRows();
                for (row = 0; row < data.length; ++row) {
                    ((RevisionDefaultTableModel)this._revTableModel).addRow(data[row]);
                }
                TableHelper.sizeTableToContents((JTable)this._revisionTable);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LogRetriever logRetriever;
        if (e.getSource().equals(this._next25Button)) {
            this._appendMode = true;
            this._revisionStart = this._lastRevision;
            logRetriever = new LogRetriever(this);
            SVNExecutorService.getInstance().submit(logRetriever);
        }
        if (e.getSource().equals(this._showallButton)) {
            this._appendMode = false;
            this._revisionStart = SVNRevision.HEAD;
            this._revisionEnd = new SVNRevision.Number(0L);
            this._limit = 0L;
            logRetriever = new LogRetriever(this);
            SVNExecutorService.getInstance().submit(logRetriever);
            this._next25Button.setEnabled(false);
        }
        if (e.getSource().equals(this._stoponcopyBox)) {
            this._stoponcopy = this._stoponcopyBox.isSelected();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this._revisionTable.getSelectedRow() != -1) {
            this._commentArea.setText(this._logs[this._revisionTable.getSelectedRows()[0]].getMessage());
            ISVNLogMessageChangePath[] changedpaths = this._logs[this._revisionTable.getSelectedRows()[0]].getChangedPaths();
            if (changedpaths != null) {
                Object[][] data = new Object[changedpaths.length][this._actionTableModel.getColumnCount()];
                for (int i = 0; i < changedpaths.length; ++i) {
                    data[i][0] = Character.valueOf(changedpaths[i].getAction());
                    data[i][1] = changedpaths[i].getPath();
                    data[i][2] = changedpaths[i].getCopySrcPath() == null ? "" : changedpaths[i].getCopySrcPath();
                    data[i][3] = changedpaths[i].getCopySrcRevision() == null ? "" : changedpaths[i].getCopySrcRevision().toString();
                }
                ((DefaultTableModel)this._actionTableModel).setDataVector(data, this._actionColumnNames);
                TableHelper.sizeTableToContents((JTable)this._actionTable);
            }
        }
    }

    public SVNRevisionRange[] getSelectedRevisions() {
        if (this._revisionTable.getSelectedRow() != -1) {
            int[] selectedRows = this._revisionTable.getSelectedRows();
            SVNRevision.Number[] selectedrevisions = new SVNRevision.Number[selectedRows.length];
            for (int i = 0; i < selectedRows.length; ++i) {
                selectedrevisions[i] = this._logs[this._revisionTable.getSelectedRows()[i]].getRevision();
            }
            SVNRevision.Number[] allrevisions = new SVNRevision.Number[this._logs.length];
            for (int i = 0; i < allrevisions.length; ++i) {
                allrevisions[i] = this._logs[i].getRevision();
            }
            SVNRevisionRange[] ranges = SVNRevisionRange.getRevisions((SVNRevision.Number[])selectedrevisions, (SVNRevision.Number[])allrevisions);
            return ranges;
        }
        return new SVNRevisionRange[0];
    }

    public void setAllowMultiSelection(boolean allowMultiSelection) {
        this._allowMultiSelection = allowMultiSelection;
        if (allowMultiSelection) {
            this._revisionTable.setSelectionMode(2);
        } else {
            this._revisionTable.setSelectionMode(0);
        }
    }

    public boolean isAllowMultiSelection() {
        return this._allowMultiSelection;
    }

    private class RevisionDefaultTableModel
    extends DefaultTableModel
    implements EditableTableModel,
    GenericTableModel {
        public RevisionDefaultTableModel(Object[][] datas, Object[] cols) {
            super(datas, cols);
        }

        public void removeAllRows() {
            int size = this.dataVector.size();
            this.dataVector.removeAllElements();
            this.fireTableRowsDeleted(0, size);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void insertColumn(int column, Object columnName, Object[] columnData) {
        }

        public void removeColumn(int column) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                Vector row = (Vector)this.dataVector.elementAt(i);
                row.remove(column);
            }
            this.columnIdentifiers.remove(column);
            this.fireTableStructureChanged();
        }

        public int duplicateRow(int row, int nCopy) {
            return -1;
        }

        public int duplicateColumn(int col, int nCopy) {
            return -1;
        }

        public int getColumnAlignment(int column) {
            return 2;
        }

        public boolean canHide(int column) {
            return false;
        }
    }

    private class LogRetriever
    extends Thread {
        private Component m_parentComponent;

        public LogRetriever() {
        }

        public LogRetriever(Component parent) {
            this.m_parentComponent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.m_parentComponent == null) {
                this.m_parentComponent = Ide.getMainWindow();
            }
            IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor(this.m_parentComponent, this.getProgressTitle(), (Object)this.getProgressMessage(), null);
            progress.setCancellable(false);
            progress.setCloseOnFinish(true);
            progress.setMillisToPopup(500);
            try {
                ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
                if (SVNRevisionListPanel.this._url != null) {
                    SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(SVNRevisionListPanel.this._url);
                    SVNOperationLogger.getInstance().beginOperation(client, repoInfo, progress);
                    progress.start();
                    ISVNLogMessage[] mlogs = client.getLogMessages(SVNRevisionListPanel.this._url, SVNRevisionListPanel.this._revisionStart, SVNRevisionListPanel.this._revisionStart, SVNRevisionListPanel.this._revisionEnd, SVNRevisionListPanel.this._stoponcopy, SVNRevisionListPanel.this._fetchChangedPaths, SVNRevisionListPanel.this._limit);
                    if (mlogs.length > 0) {
                        if (SVNRevisionListPanel.this._lastRevision.equals((Object)mlogs[mlogs.length - 1].getRevision())) {
                            SVNRevisionListPanel.this._next25Button.setEnabled(false);
                        }
                        SVNRevisionListPanel.this._lastRevision = (SVNRevision)mlogs[mlogs.length - 1].getRevision();
                        SVNRevisionListPanel.this.updateTableModel(mlogs);
                    }
                } else {
                    SVNUrl svnurl = client.getInfoFromWorkingCopy(SVNRevisionListPanel.this._file).getUrl();
                    if (svnurl == null) {
                        Object mlogs = null;
                        return;
                    }
                    SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(svnurl);
                    SVNOperationLogger.getInstance().beginOperation(client, repoInfo, progress);
                    progress.start();
                    ISVNLogMessage[] mlogs = client.getLogMessages(SVNRevisionListPanel.this._file, SVNRevisionListPanel.this._revisionStart, SVNRevisionListPanel.this._revisionEnd, SVNRevisionListPanel.this._stoponcopy, SVNRevisionListPanel.this._fetchChangedPaths, SVNRevisionListPanel.this._limit);
                    if (mlogs.length > 0) {
                        if (SVNRevisionListPanel.this._lastRevision.equals((Object)mlogs[mlogs.length - 1].getRevision())) {
                            SVNRevisionListPanel.this._next25Button.setEnabled(false);
                        }
                        SVNRevisionListPanel.this._lastRevision = (SVNRevision)mlogs[mlogs.length - 1].getRevision();
                        SVNRevisionListPanel.this.updateTableModel(mlogs);
                    }
                }
            }
            catch (SVNClientException e) {
                SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(e.getMessage());
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
                progress.finish();
            }
        }

        private String getProgressTitle() {
            return SVNRevisionListPanel.this._res.getString("ACTION_LOGMSG_PROGRESS_TITLE");
        }

        private String getProgressMessage() {
            return SVNRevisionListPanel.this._res.getString("ACTION_LOGMSG_PROGRESS_MESSAGE");
        }
    }
}

