/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.javatools.controls.FileField;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryWizard;
import oracle.jdevimpl.vcs.svn.op.ui.MonitoredPanel;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRepositoryBrowser;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRevisionLister;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class BranchPanel
extends MonitoredPanel
implements ActionListener {
    private final ResourcePicker _res;
    private JLabel _fromLabel;
    private FileField _fromField;
    private ButtonGroup _wcrevisionGroup;
    private JRadioButton _wcRadio;
    private JRadioButton _headRadio;
    private JRadioButton _revisionRadio;
    private NumberTextField _revisionField;
    private JButton _revisionButton;
    private JLabel _toLabel;
    private FileField _toField;
    private JButton _toBrowseButton;
    private JLabel _commentLabel;
    private JTextArea _commentArea;
    private JScrollPane _scrollPane;
    private JCheckBox _switchCheckBox;
    private final SVNRevision _revisionStart = SVNRevision.HEAD;
    private final SVNRevision _revisionEnd = new SVNRevision.Number(0L);
    private Context _context;
    public final int FROM_WC = 0;
    public final int FROM_HEAD = 1;
    public final int FROM_REVISION = 2;
    private SVNUrl _toURL;
    private SVNUrl _fromURL;
    private SVNRepositoryInfo _repoInfo;
    private boolean _fromNav = false;

    public BranchPanel() {
        super(new GridBagLayout());
        this._res = ResourcePicker.getPicker(SVNProfile.class);
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
    }

    public BranchPanel(boolean fromNav) {
        super(new GridBagLayout());
        this._res = ResourcePicker.getPicker(SVNProfile.class);
        this.setFromNav(fromNav);
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._revisionRadio.isSelected()) {
            this._revisionField.setEnabled(true);
            this._revisionButton.setEnabled(true);
        } else {
            this._revisionField.setEnabled(false);
            this._revisionButton.setEnabled(false);
        }
        boolean validContent = this.validateContent();
        this.fireValidContent(validContent);
        if (e.getSource().equals(this._revisionButton)) {
            SVNRevisionLister revLister = new SVNRevisionLister(this.getFromURL(), this._revisionStart, this._revisionEnd);
            revLister.addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    BranchPanel.this.setRevisionField((SVNRevision)arg);
                }
            });
            revLister.showLister();
            return;
        }
        if (e.getSource().equals(this._toBrowseButton)) {
            SVNRepositoryBrowser repoBrowser = this.createRepositoryBrowser();
            if (repoBrowser == null) {
                return;
            }
            repoBrowser.addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    BranchPanel.this.setToField(((SVNUrl)arg).toString());
                }
            });
            repoBrowser.showBrowser();
        }
    }

    @Override
    void initListeners() {
        this._toField.getDocument().addDocumentListener(new MonitoredPanel.FieldListener(this));
        this._revisionField.getDocument().addDocumentListener(new MonitoredPanel.FieldListener(this));
    }

    @Override
    boolean validateRevision() {
        return !this._revisionRadio.isSelected() || this.getRevision() != null;
    }

    @Override
    boolean validateURL() {
        this._protocolMatcher.setSource(this.getToField());
        return this._protocolMatcher.containsProtocol();
    }

    public void setContext(Context context) {
        this._context = context;
    }

    public Context getContext() {
        return this._context;
    }

    public void setFromNav(boolean fromNav) {
        this._fromNav = fromNav;
    }

    public void setFromField(String fromString) {
        if (fromString != null) {
            this._fromField.setText(fromString);
        }
    }

    public String getFromField() {
        return this._fromField.getText();
    }

    public void setToField(String toString) {
        if (toString != null) {
            this._toField.setText(toString);
        }
    }

    public String getToField() {
        return this._toField.getText();
    }

    public SVNUrl getToURL() {
        try {
            this._toURL = new SVNUrl(this._toField.getText());
        }
        catch (MalformedURLException e) {
            SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(e.getMessage());
        }
        return this._toURL;
    }

    public SVNUrl getFromURL() {
        try {
            this._fromURL = new SVNUrl(this._fromField.getText());
        }
        catch (MalformedURLException e) {
            SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(e.getMessage());
        }
        return this._fromURL;
    }

    public String getComment() {
        return this._commentArea.getText();
    }

    public boolean getSwitchStatus() {
        return this._switchCheckBox.isSelected();
    }

    public void setRevisionField(SVNRevision svnRevision) {
        this._revisionField.setText(svnRevision.toString());
    }

    public SVNRevision getRevision() {
        return this._headRadio.isSelected() ? SVNRevision.HEAD : this.getFieldRevision(this._revisionField);
    }

    private SVNRevision getFieldRevision(NumberTextField field) {
        if (field.getNumber() == null) {
            return null;
        }
        return new SVNRevision.Number(field.getNumber().longValue());
    }

    public int getFromOption() {
        if (this._wcRadio.isSelected()) {
            return 0;
        }
        if (this._headRadio.isSelected()) {
            return 1;
        }
        if (this._revisionRadio.isSelected()) {
            return 2;
        }
        return 0;
    }

    private void createComponents() {
        this._fromLabel = new JLabel();
        this._fromField = new FileField();
        ResourceUtils.resLabel((JLabel)this._fromLabel, (Component)this._fromField, (String)this._res.getString("UI_BRANCH_PANEL_LABEL_FROM"));
        this._fromField.setEditable(false);
        this._wcrevisionGroup = new ButtonGroup();
        this._wcRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._wcRadio, (String)this._res.getString("UI_BRANCH_PANEL_RADIO_WC"));
        this._wcRadio.addActionListener(this);
        this._wcrevisionGroup.add(this._wcRadio);
        this._wcRadio.setSelected(true);
        this._wcRadio.setEnabled(!this._fromNav);
        this._headRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._headRadio, (String)this._res.getString("UI_BRANCH_PANEL_RADIO_HEAD"));
        this._headRadio.addActionListener(this);
        this._wcrevisionGroup.add(this._headRadio);
        if (this._fromNav) {
            this._headRadio.setSelected(true);
        }
        this._revisionRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._revisionRadio, (String)this._res.getString("UI_BRANCH_PANEL_RADIO_REVISION"));
        this._revisionRadio.addActionListener(this);
        this._wcrevisionGroup.add(this._revisionRadio);
        this._revisionField = new NumberTextField();
        this._revisionField.setColumns(8);
        this._revisionField.setDecimal(false);
        this._revisionField.setDataType(Integer.class);
        this._revisionField.setSigned(false);
        this._revisionField.setEnabled(this._revisionRadio.isSelected());
        this._revisionButton = new JButton();
        this._revisionButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._revisionButton, (String)this._res.getString("UI_BRANCH_PANEL_BUTTON_REVISION"));
        this._revisionButton.setEnabled(this._revisionRadio.isSelected());
        this._toLabel = new JLabel();
        this._toField = new FileField();
        ResourceUtils.resLabel((JLabel)this._toLabel, (Component)this._toField, (String)this._res.getString("UI_BRANCH_PANEL_LABEL_TO"));
        this._toBrowseButton = new JButton();
        this._toBrowseButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._toBrowseButton, (String)this._res.getString("UI_BRANCH_PANEL_BUTTON_BROWSE"));
        this._commentLabel = new JLabel();
        this._commentArea = new JTextArea();
        ResourceUtils.resLabel((JLabel)this._commentLabel, (Component)this._commentArea, (String)this._res.getString("UI_BRANCH_PANEL_LABEL_COMMENT"));
        this._commentArea.setText("");
        this._commentArea.setRows(3);
        this._commentArea.setLineWrap(true);
        this._commentArea.setEditable(true);
        this._scrollPane = new JScrollPane(this._commentArea, 22, 32);
        this._switchCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._switchCheckBox, (String)this._res.getString("UI_BRANCH_PANEL_CHECKBOX_SWITCH"));
        this._switchCheckBox.setEnabled(!this._fromNav);
    }

    private void layoutComponents() {
        Insets insets = new Insets(6, 2, 2, 6);
        Insets insetsRadio = new Insets(6, 18, 2, 6);
        ((GridBagLayout)this.getLayout()).columnWidths = new int[]{0, 0, 80, 0, 0, 0};
        this.add((Component)this._fromLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._fromField, new GridBagConstraints(1, 0, 4, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._wcRadio, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, insetsRadio, 0, 0));
        this.add((Component)this._headRadio, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, insetsRadio, 0, 0));
        this.add((Component)this._revisionRadio, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, insetsRadio, 0, 0));
        this.add((Component)this._revisionField, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._revisionButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._toLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._toField, new GridBagConstraints(1, 4, 3, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._toBrowseButton, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this._commentLabel, new GridBagConstraints(0, 5, 5, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 6, 5, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
        this.add((Component)this._switchCheckBox, new GridBagConstraints(0, 7, 5, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
    }

    private SVNRepositoryBrowser createRepositoryBrowser() {
        boolean repoCreated = true;
        this._repoInfo = this.parseRepositoryInfo(this.getFromURL());
        if (this._repoInfo == null) {
            repoCreated = this.createTheRepository();
            if (repoCreated) {
                this._repoInfo = this.parseRepositoryInfo(this.getFromURL());
            } else {
                return null;
            }
        }
        return new SVNRepositoryBrowser(this._repoInfo, this.getFromURL());
    }

    private SVNRepositoryInfo parseRepositoryInfo(SVNUrl url) {
        return SVNUtil.resolveRepository(url);
    }

    private boolean createTheRepository() {
        Wizard reposWizard = WizardManager.getInstance().getWizard(SVNRepositoryWizard.class);
        Context ctx = this.getContext();
        boolean success = false;
        ctx.setProperty(SVNRepositoryWizard.PROPERTY_NAME_EDITING, (Object)Boolean.FALSE);
        ctx.setProperty("PRESET_REPO_URL", (Object)this.parseRepositoryInfo(this.getFromURL()));
        if (reposWizard != null && reposWizard.isAvailable(ctx)) {
            success = reposWizard.invoke(ctx);
        }
        return success;
    }
}

