/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import oracle.ide.Ide;
import oracle.jdeveloper.vcs.annotations.Annotations;
import oracle.jdeveloper.vcs.annotations.AnnotationsCommand;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SVNOperationViewAnnotation
extends AnnotationsCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.viewannotation";

    public SVNOperationViewAnnotation() {
        super(Ide.findOrCreateCmdID((String)COMMAND_ID));
    }

    protected VCSStatusCache getStatusCache() {
        return VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion").getStatusCache();
    }

    protected boolean isUnmodifiedStatus(VCSStatus status) {
        return status == VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion").getStatusInstance("UNMODIFIED");
    }

    protected Annotations getAnnotations(File file) {
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            return new AnnotationsImpl(client.annotate(file, SVNRevision.START, SVNRevision.BASE));
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
            return null;
        }
    }

    protected Annotations getAnnotations(URL url) {
        return null;
    }

    private class AnnotationsImpl
    extends Annotations {
        private final ISVNAnnotations _delegate;

        AnnotationsImpl(ISVNAnnotations delegate) {
            this._delegate = delegate;
        }

        public Date getChanged(int lineNumber) {
            return this._delegate.getChanged(lineNumber);
        }

        public String getRevision(int lineNumber) {
            return String.valueOf(this._delegate.getRevision(lineNumber));
        }

        public String getAuthor(int lineNumber) {
            return this._delegate.getAuthor(lineNumber);
        }

        public String getLine(int lineNumber) {
            return this._delegate.getLine(lineNumber);
        }

        public InputStream getInputStream() {
            return this._delegate.getInputStream();
        }

        public int getLineCount() {
            return this._delegate.numberOfLines();
        }
    }
}

