/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.svn.op.SVNOperationUpdate;

public final class SVNOperationUpdateWC
extends SVNOperationUpdate {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.update-workingcopy";

    public SVNOperationUpdateWC() {
        super(COMMAND_ID);
    }

    @Override
    protected boolean invokeCommand(VCSProfile profile, CommandState commandState) throws Exception {
        this.collapseSelectionToWorkingCopy(commandState);
        Locatable[] workingCopies = commandState.getLocatables();
        if (workingCopies == null || workingCopies.length == 0 || workingCopies[0] == null) {
            throw new VCSException(this._res.getString("ACTION_UPDATE_WC_ERROR_TITLE"), this._res.getString("ACTION_UPDATE_WC_ERROR_NOWC_MSG"));
        }
        return super.invokeCommand(profile, commandState);
    }

    @Override
    protected void postUpdate(URL[] urls) {
        ArrayList<URL> processUrls = new ArrayList<URL>();
        for (URL url : urls) {
            Workspace wk = Ide.getActiveWorkspace();
            URL wk_url = wk.getURL();
            if (!URLFileSystem.isBaseURLFor((URL)url, (URL)wk_url)) continue;
            Iterator it = wk.getChildren();
            while (it.hasNext()) {
                Element elm = (Element)it.next();
                if (!(elm instanceof Project)) continue;
                URL elmURL = ((Locatable)elm).getURL();
                processUrls.add(URLFileSystem.getParent((URL)elmURL));
            }
        }
        super.postUpdate(processUrls.toArray(new URL[0]));
    }
}

