/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import oracle.ide.model.Locatable;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.LockOptionsCustomizer;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;

public class SVNOperationLock
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.lock";

    public SVNOperationLock() {
        super(COMMAND_ID);
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        VCSCommentsCustomizer customizer = new VCSCommentsCustomizer((VCSOptionsCustomizer)new LockOptionsCustomizer());
        customizer.setShowReuseCommentsOption(false);
        return customizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        DeterminateProgressMonitor progress = new DeterminateProgressMonitor(parentUi, this._res.getString("ACTION_LOCK_PROGRESS_TITLE"), (Object)this._res.getString("ACTION_LOCK_PROGRESS_MESSAGE"), "", 0, -1);
        progress.setCancellable(true);
        progress.setCloseOnFinish(true);
        progress.setMillisToDecideToPopup(500);
        String comments = this.getComments(options);
        boolean steal = this.getStealLocks(options);
        URL[] operands = VCSModelUtils.convertNodesToURLs((Locatable[])commandState.getLocatables());
        SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository(operands);
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(client, repos);
            progress.setMaximum(operands.length + 1);
            progress.setProgress(0);
            Collection processed = this.getProcessedUrlsNotifier(commandState);
            for (int i = 0; i < operands.length && !progress.isCancelled(); ++i) {
                client.lock(new File[]{SVNUtil.toFile(operands[i])}, comments, steal);
                processed.add(operands[i]);
                progress.setProgress(processed.size());
            }
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
            progress.finish();
            commandState.setProperty("oracle.jdeveloper.subversion.STEAL_LOCKS", (Object)steal);
        }
        return true;
    }

    private boolean getStealLocks(Map options) {
        Boolean keepLocks = (Boolean)options.get("oracle.jdeveloper.subversion.STEAL_LOCKS");
        if (keepLocks != null) {
            return keepLocks;
        }
        return false;
    }

    private String getComments(Map options) {
        String commentOption = (String)options.get("setting_comments");
        return commentOption != null ? commentOption : "";
    }
}

