/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.generic.ActionCommand;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.svn.AlreadyExistsException;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNAuthInfo;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.CreateReposPanel;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public final class SVNOperationCreateRepos
extends ActionCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.create-repos";
    private static final String LAST_REPOS_ROOT_KEY = SVNOperationCreateRepos.class.getName() + "." + "lastReposRoot";
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);

    public SVNOperationCreateRepos() {
        super(COMMAND_ID);
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        final CreateReposPanel panel = new CreateReposPanel(this.suggestRepositoryLocation());
        final JEWTDialog dialog = this.createDialog(panel, panel.getInitialFocus());
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)event)) {
                    final URL reposPath = panel.getRepositoryPath();
                    if (reposPath == null) {
                        MessageDialog.error((Component)dialog, (Object)SVNOperationCreateRepos.this._res.getString("ACTION_CREATE_REPOS_ERROR_MESSAGE_DIR"), (String)SVNOperationCreateRepos.this._res.getString("ACTION_CREATE_REPOS_ERROR_TITLE"), null);
                        throw new PropertyVetoException(null, event);
                    }
                    if (URLFileSystem.exists((URL)reposPath)) {
                        if (URLFileSystem.list((URL)reposPath).length > 0) {
                            MessageDialog.error((Component)dialog, (Object)SVNOperationCreateRepos.this._res.getString("ACTION_CREATE_REPOS_ERROR_MESSAGE_EMPTY"), (String)SVNOperationCreateRepos.this._res.getString("ACTION_CREATE_REPOS_ERROR_TITLE"), null);
                            throw new PropertyVetoException(null, event);
                        }
                    } else if (!URLFileSystem.mkdirs((URL)reposPath)) {
                        MessageDialog.error((Component)dialog, (Object)SVNOperationCreateRepos.this._res.getString("ACTION_CREATE_REPOS_ERROR_MESSAGE_CREATE"), (String)SVNOperationCreateRepos.this._res.getString("ACTION_CREATE_REPOS_ERROR_TITLE"), null);
                        throw new PropertyVetoException(null, event);
                    }
                    dialog.setOKButtonEnabled(false);
                    Ide.getDTCache().putString(LAST_REPOS_ROOT_KEY, URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)panel.getRepositoryPath())));
                    new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            final WaitCursor wc = new WaitCursor((Component)panel);
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    wc.show();
                                }
                            });
                            try {
                                SVNOperationCreateRepos.this.createRepository(reposPath, panel.getFileSystemType());
                                SVNOperationCreateRepos.this.createConnection(reposPath, panel.getConnectionName());
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        dialog.setVisible(false);
                                        dialog.dispose();
                                    }
                                });
                                SVNRepositoryNavigatorAPI.getInstance().showRepositoryNavigator();
                            }
                            catch (Exception e) {
                                try {
                                    SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(e.getMessage());
                                    MessageDialog.error((Component)dialog, (Object)e.getMessage(), (String)SVNOperationCreateRepos.this._res.getString("ACTION_CREATE_REPOS_ERROR_TITLE"), null);
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            dialog.setOKButtonEnabled(true);
                                        }
                                    });
                                }
                                catch (Throwable throwable) {
                                    EventQueue.invokeLater(new Runnable(wc){
                                        final /* synthetic */ WaitCursor val$wc;
                                        {
                                            this.val$wc = waitCursor;
                                        }

                                        @Override
                                        public void run() {
                                            this.val$wc.hide();
                                        }
                                    });
                                    throw throwable;
                                }
                                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    }, "svn-repos-create-thread").start();
                    throw new PropertyVetoException(null, event);
                }
            }
        });
        if (WizardLauncher.runDialog((JDialog)dialog)) {
            return 0;
        }
        return 1;
    }

    private void createConnection(URL reposPath, String connectionName) throws MalformedURLException, AlreadyExistsException {
        SVNAuthInfo authInfo = new SVNAuthInfo("", "");
        SVNRepositoryInfo repos = new SVNRepositoryInfo(SVNUtil.toSVNUrl(reposPath), connectionName, authInfo);
        SVNRepositoryNavigatorAPI.getInstance().createRepositoryConnection(repos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRepository(URL reposPath, String fsType) throws SVNClientException {
        ISVNClientAdapter client = SVNUtil.getClientAdapter(AbstractSVNOperation.CLIENT_CONTEXT);
        try {
            SVNOperationLogger.getInstance().beginOperation(client, null);
            client.createRepository(SVNUtil.toFile(reposPath), fsType);
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
    }

    private JEWTDialog createDialog(JComponent content, Component initialFocus) {
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)content, (Component)initialFocus, (String)this._res.getString("ACTION_CREATE_REPOS_DIALOG_TITLE"), (int)7);
        dialog.setResizable(false);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(this._res.getString("ACTION_CREATE_REPOS_DIALOG_HEADER_DESC"));
        dialog.setDialogHeader((Component)header);
        HelpSystem.getHelpSystem().registerTopic(content, "f1_svncreatesubversionrepository_html");
        return dialog;
    }

    private URL suggestRepositoryLocation() {
        String rootLocation = Ide.getDTCache().getString(LAST_REPOS_ROOT_KEY);
        if (rootLocation == null || rootLocation.equals("")) {
            rootLocation = Ide.getTrueUserHomeDirectory();
        }
        URL base = URLFactory.newDirURL((String)rootLocation);
        String token = "repos";
        URL suggestion = URLFactory.newDirURL((URL)base, (String)token);
        int i = 0;
        while (URLFileSystem.exists((URL)suggestion)) {
            suggestion = URLFactory.newDirURL((URL)base, (String)(token + i++));
        }
        return suggestion;
    }
}

