/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.EventQueue;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import oracle.ide.Ide;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSIgnoreFilters;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.generic.util.PatternURLFilter;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.op.SVNOperationCommit;
import oracle.jdevimpl.vcs.svn.prefs.SVNVersionToolsPreferences;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public final class SVNOperationCommitWC
extends SVNOperationCommit {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.commit-workingcopy";

    public SVNOperationCommitWC() {
        super(COMMAND_ID);
    }

    @Override
    protected void invokeCommit(VCSProfile profile, CommandState state, Map options, IndeterminateProgressMonitor progress) throws Exception {
        URL workingCopyRoot = this.getOperands(profile)[0].getURL();
        if (workingCopyRoot == null) {
            return;
        }
        this.autoAddNewFiles(profile, workingCopyRoot);
        super.invokeCommit(profile, state, options, progress);
    }

    @Override
    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        Locatable[] items = super.getOperands(profile);
        if (this.getContext().getView() instanceof ChangeListWindow && (items == null || items.length == 0)) {
            items = VCSModelUtils.getValidLocatables((Object[])((ChangeListWindow)this.getContext().getView()).getChangeList().getElements(), null);
        }
        for (int i = 0; i < items.length; ++i) {
            URL workingCopyRoot = SVNUtil.resolveWorkingCopy(items[i].getURL());
            if (workingCopyRoot == null) continue;
            return VCSModelUtils.findOrCreateNodes((URL[])new URL[]{workingCopyRoot});
        }
        return new Locatable[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean saveDirtyNodes(Locatable[] contextLocatables) throws Exception {
        HashSet<Node> toSave = new HashSet<Node>(20);
        URLFilter filter = this.getProfile().getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Ide.getWaitCursor().show(1000);
            }
        });
        try {
            Iterator it = NodeFactory.getCachedNodes();
            block2: while (it.hasNext()) {
                URL url;
                Node node = (Node)it.next();
                if (!node.isDirty() || !filter.accept(url = node.getURL())) continue;
                for (int i = 0; i < contextLocatables.length; ++i) {
                    if (!VCSFileSystemUtils.isBaseURLFor((URL)contextLocatables[i].getURL(), (URL)url)) continue;
                    toSave.add(node);
                    continue block2;
                }
            }
        }
        catch (Throwable throwable) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Ide.getWaitCursor().hide();
                }
            });
            throw throwable;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        return VCSCommandUtils.saveDirtyNodes((Locatable[])toSave.toArray(new Locatable[toSave.size()]));
    }

    protected void autoAddNewFiles(VCSProfile profile, URL workingCopyRoot) throws Exception {
        boolean autoAdd;
        VCSPropertyMap vtoolsPrefs = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion").getData("oracle.jdeveloper.vcs.data.COMMON_SETTINGS");
        boolean bl = autoAdd = (Boolean)vtoolsPrefs.getMap().get("autoAddFiles") != null ? ((Boolean)vtoolsPrefs.getMap().get("autoAddFiles")).booleanValue() : SVNVersionToolsPreferences.DEFAULT_KEY_AUTO_ADD_NEW_FILES.booleanValue();
        if (!autoAdd) {
            return;
        }
        LinkedHashSet directories = new LinkedHashSet();
        LinkedHashSet files = new LinkedHashSet();
        this.findNewFilesDirs(profile, workingCopyRoot, directories, files);
        this.silentlyAddNewFiles(directories, files);
    }

    protected void findNewFilesDirs(VCSProfile profile, URL directory, HashSet directories, HashSet files) throws Exception {
        VCSStatusFilter unaddedFilter = profile.getStatusFilter("oracle.jdeveloper.subversion.filter.status.UNADDED");
        VCSStatusFilter ignoredFilter = profile.getStatusFilter("oracle.jdeveloper.subversion.filter.status.IGNORED");
        VCSStatusCache cache = profile.getStatusCache();
        PatternURLFilter patternFilter = new PatternURLFilter(VCSIgnoreFilters.getAllIgnoreFilters());
        URL[] children = URLFileSystem.list((URL)directory, (URLFilter)patternFilter);
        for (int i = 0; i < children.length; ++i) {
            if (unaddedFilter.accept(cache.get(children[i])) && !ignoredFilter.accept(cache.get(children[i]))) {
                if (URLFileSystem.isDirectoryPath((URL)children[i])) {
                    directories.add(children[i]);
                    this.findNewFilesDirs(profile, children[i], directories, files);
                    continue;
                }
                files.add(children[i]);
                continue;
            }
            if (!URLFileSystem.isDirectoryPath((URL)children[i])) continue;
            this.findNewFilesDirs(profile, children[i], directories, files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void silentlyAddNewFiles(Set directories, Set files) {
        try {
            ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(svnClient, null);
            for (URL directory : directories) {
                svnClient.addDirectory(new File(URLFileSystem.getPlatformPathName((URL)directory)), false);
            }
            for (URL file : files) {
                svnClient.addFile(new File(URLFileSystem.getPlatformPathName((URL)file)));
            }
        }
        catch (SVNClientException ex) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(ex.getMessage());
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
    }
}

