/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.SVNOperationSwitch;
import oracle.jdevimpl.vcs.svn.op.ui.BranchPanel;
import oracle.jdevimpl.vcs.svn.op.ui.MonitoredPanel;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNOperationBranch
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.branch";
    private BranchPanel _branchPanel;
    private JEWTDialog _dialog;
    private ISVNInfo _wcInfo;
    private boolean _fromNav;

    public SVNOperationBranch() {
        super(COMMAND_ID);
    }

    protected boolean isAvailableImpl(VCSProfile profile) throws Exception {
        if (this.isFromNav()) {
            this._fromNav = true;
            return true;
        }
        this._fromNav = false;
        return super.isAvailableImpl(profile);
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        if (this.isFromNav()) {
            this._fromNav = true;
        }
        this.createPanel();
        this.createDialog();
        this.initListeners();
        if (this._dialog.runDialog()) {
            return 0;
        }
        return 1;
    }

    private boolean isFromNav() {
        SVNRemoteNode remoteNode;
        return SVNUtil.isRepositoryNavigatorView(this.getContext()) && (remoteNode = SVNUtil.getSVNRemoteNode(this.getContext())) != null;
    }

    private void setOKButton(final boolean containsValidContent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SVNOperationBranch.this._dialog.setOKButtonEnabled(containsValidContent);
            }
        });
    }

    private void createPanel() {
        this._branchPanel = new BranchPanel(this._fromNav);
        this._branchPanel.setFromField(this.getFromURLString());
        this._branchPanel.setToField(this.getFromURLString());
        this._branchPanel.setContext(this.getContext());
    }

    private ISVNInfo getWCInfo() {
        Locatable[] locatables = VCSContextUtils.getContextLocatables((Context)this.context);
        if (locatables == null || locatables.length != 1) {
            return null;
        }
        URL url = locatables[0].getURL();
        if (!URLFileSystem.isDirectoryPath((URL)url)) {
            url = URLFileSystem.getParent((URL)url);
        }
        File file = null;
        file = SVNUtil.toFile(url);
        ISVNClientAdapter client = null;
        try {
            client = SVNUtil.getIDEClientAdapter();
            ISVNInfo info = client.getInfoFromWorkingCopy(file);
            return info;
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
            return null;
        }
    }

    private File getWCFile() {
        return this._wcInfo.getFile();
    }

    private String getFromURLString() {
        if (this._fromNav) {
            SVNRemoteNode remoteNode = SVNUtil.getSVNRemoteNode(this.getContext());
            return remoteNode.getSVNUrl().toString();
        }
        this._wcInfo = this.getWCInfo();
        if (this._wcInfo == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)this._res.getString("ACTION_BRANCH_ERROR_MESSAGE_NO_INFO"), (String)this._res.getString("ACTION_BRANCH_ERROR_TITLE_NO_INFO"), null);
        }
        return SVNUtil.canonicalizeSVNUrl(this._wcInfo.getUrl()).toString();
    }

    private void createDialog() {
        String title = this._res.getString("ACTION_BRANCH_DIALOG_TITLE");
        this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)this._branchPanel, (Component)this._branchPanel.getInitialFocus(), (String)title, (int)7);
        this._dialog.setDefaultButton(1);
        this._dialog.setContent((Component)this._branchPanel);
        this._dialog.setResizable(true);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(this._res.getString("ACTION_BRANCH_DIALOG_HEADER_DESC"));
        this._dialog.setDialogHeader((Component)header);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._branchPanel, "f1_svnbranchtag_html");
    }

    private void initListeners() {
        this._dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                    return;
                }
                BranchThread branchThread = new BranchThread();
                branchThread.start();
            }
        });
        this._branchPanel.addListener(new MonitoredPanel.PanelListener(){

            @Override
            public void setContainsURL(boolean containsValidContent) {
                SVNOperationBranch.this.setOKButton(containsValidContent);
            }
        });
    }

    private final class BranchThread
    extends Thread {
        IndeterminateProgressMonitor progressMon;
        SVNUrl trueToURL;

        private BranchThread() {
            super("svn-branch-thread");
        }

        @Override
        public void run() {
            final WaitCursor wc = new WaitCursor(SVNOperationBranch.this._dialog.getContent());
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    wc.show();
                }
            });
            this.executeBranchingWithProgress();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SVNOperationBranch.this._dialog.setVisible(false);
                    SVNOperationBranch.this._dialog.dispose();
                }
            });
            if (SVNOperationBranch.this._branchPanel.getSwitchStatus()) {
                this.swithToWC();
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    wc.hide();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeBranchingWithProgress() {
            this.progressMon = new IndeterminateProgressMonitor((Component)SVNOperationBranch.this._dialog, SVNOperationBranch.this._res.getString("ACTION_BRANCH_PROGRESS_TITLE"), (Object)SVNOperationBranch.this._res.getString("ACTION_BRANCH_PROGRESS_MESSAGE"), null);
            this.progressMon.setMillisToPopup(0);
            this.progressMon.setCloseOnFinish(true);
            this.progressMon.setCancellable(false);
            this.progressMon.start();
            try {
                this.executeBranching();
            }
            finally {
                this.progressMon.finish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeBranching() {
            SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(SVNOperationBranch.this._branchPanel.getFromURL());
            try {
                ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
                SVNOperationLogger.getInstance().beginOperation(svnClient, repoInfo, this.progressMon);
                if (SVNOperationBranch.this._branchPanel.getFromOption() == ((SVNOperationBranch)SVNOperationBranch.this)._branchPanel.FROM_WC) {
                    File fromWC = SVNOperationBranch.this.getWCFile();
                    this.trueToURL = SVNOperationBranch.this._branchPanel.getToURL();
                    this.appendPathTailIfRemotelyExisting();
                    String comment = SVNOperationBranch.this._branchPanel.getComment();
                    svnClient.copy(fromWC, this.trueToURL, comment);
                } else {
                    SVNUrl fromURL = SVNOperationBranch.this._branchPanel.getFromURL();
                    this.trueToURL = SVNOperationBranch.this._branchPanel.getToURL();
                    this.appendPathTailIfRemotelyExisting();
                    String comment = SVNOperationBranch.this._branchPanel.getComment();
                    SVNRevision revision = SVNRevision.HEAD;
                    if (SVNOperationBranch.this._branchPanel.getFromOption() == ((SVNOperationBranch)SVNOperationBranch.this)._branchPanel.FROM_REVISION) {
                        revision = SVNOperationBranch.this._branchPanel.getRevision();
                    }
                    svnClient.copy(fromURL, this.trueToURL, comment, revision);
                }
            }
            catch (SVNClientException e) {
                SVNOperationBranch.this.getExceptionHandler().handleException(SVNExceptionWrapper.wrapException((Exception)((Object)e)));
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
            }
        }

        private void appendPathTailIfRemotelyExisting() {
            SVNUrl fromUrl = SVNOperationBranch.this._branchPanel.getFromURL();
            if (SVNUtil.getSVNNodeKind(fromUrl) == SVNNodeKind.DIR && SVNUtil.isRemotelyExisiting(this.trueToURL)) {
                String lastSeg = fromUrl.getLastPathSegment();
                this.trueToURL = this.trueToURL.appendPath(lastSeg);
            }
        }

        private void swithToWC() {
            Context ctx = SVNOperationBranch.this.getContext();
            ctx.setProperty("destFile", (Object)SVNOperationBranch.this.getWCFile());
            SVNUrl toUrl2 = this.trueToURL;
            if (SVNOperationBranch.this.getWCFile().isFile()) {
                String fn = SVNOperationBranch.this.getWCFile().getName();
                toUrl2 = toUrl2.appendPath(fn);
            }
            ctx.setProperty("toUrl", (Object)toUrl2);
            SVNOperationSwitch command = new SVNOperationSwitch();
            command.setContext(ctx);
            try {
                CommandProcessor.getInstance().invoke((Command)command);
            }
            catch (Exception e) {
                SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(e.getMessage());
            }
        }
    }
}

