/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.generic.ActionCommand;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.op.ui.SVNVersionOperationPanel;
import oracle.jdevimpl.vcs.svn.util.SVNComponents;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;

public abstract class AbstractSVNOperation
extends ActionCommand {
    public static final String OPTION_RECURSIVE = "oracle.jdeveloper.subversion.RECURSIVE";
    public static final String OPTION_REVISION = "oracle.jdeveloper.subversion.REVISION";
    public static final String OPTION_IGNORE_EXTERNALS = "oracle.jdeveloper.subversion.IGNORE_EXTERNALS";
    public static final String OPTION_KEEP_LOCKS = "oracle.jdeveloper.subversion.KEEP_LOCKS";
    public static final String OPTION_STEAL_LOCKS = "oracle.jdeveloper.subversion.STEAL_LOCKS";
    public static final String OPTION_FORCE_UNLOCK = "oracle.jdeveloper.subversion.FORCE_LOCKS";
    public static final String OPTION_DEPTH = "oracle.jdeveloper.subversion.DEPTH";
    public static final String OPTION_FORCE_UPDATE = "oracle.jdeveloper.subversion.FORCE_UPDATE";
    public static final int DEFAULT_OPTION_DEPTH = 3;
    public static Object CLIENT_CONTEXT = new Object();
    protected static final String PROPERTY_RESOURCES_CREATED = AbstractSVNOperation.class.getName() + ".resourcesCreated";
    protected static final String PROPERTY_RESOURCES_DELETED = AbstractSVNOperation.class.getName() + ".resourcesDeleted";
    protected static final String PROPERTY_RESOURCES_STRUCTURE_CHANGED = AbstractSVNOperation.class.getName() + ".resourcesStructChanged";
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(AbstractSVNOperation.class.getName());
    protected ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);
    private static URLFilter _localFilter = VCSContextUtils.createLocalProtocolFilter();

    protected AbstractSVNOperation(String commandId) {
        super(commandId);
    }

    protected static URLFilter getLocalFilter() {
        return _localFilter;
    }

    protected boolean invokeCommand(final VCSProfile profile, final CommandState commandState) throws Exception {
        if (!this.prepareStateForUI(commandState)) {
            return false;
        }
        List<Locatable> nodes = Arrays.asList(commandState.getLocatables());
        VCSOptionsCustomizer customizer = this.createOptionsCustomizer(nodes);
        final JEWTDialog dialog = this.createOperationDialog(nodes, customizer, commandState);
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){

            protected boolean doCommitOperation(Map options) throws Exception {
                SVNVersionOperationPanel panel = AbstractSVNOperation.this.getVersionOperationPanel(dialog);
                Locatable[] locatables = panel.getSelectedLocatables();
                commandState.setLocatables(locatables);
                boolean result = true;
                try {
                    result = AbstractSVNOperation.this.invokeCommandImpl(profile, commandState, (Component)dialog, options);
                }
                catch (Exception ex) {
                    throw SVNExceptionWrapper.wrapException(ex);
                }
                return result;
            }
        });
        return VCSDialogRunner.runDialog((JDialog)dialog);
    }

    protected boolean prepareStateForUI(CommandState commandState) {
        return true;
    }

    private SVNVersionOperationPanel getVersionOperationPanel(JEWTDialog dialog) {
        JPanel content = (JPanel)dialog.getContent();
        return this.getVersionOperationPanel(content);
    }

    private SVNVersionOperationPanel getVersionOperationPanel(Container container) {
        for (Component c : container.getComponents()) {
            if (!(c instanceof SVNVersionOperationPanel)) continue;
            return (SVNVersionOperationPanel)((Object)c);
        }
        for (Component c : container.getComponents()) {
            SVNVersionOperationPanel vop;
            if (!(c instanceof Container) || (vop = this.getVersionOperationPanel((Container)c)) == null) continue;
            return vop;
        }
        return null;
    }

    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer, CommandState commandState) {
        return this.createOperationDialog(nodes, customizer);
    }

    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer) {
        return VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), (String)this.getDialogHint(), (Component)SVNComponents.createFileListerComponent(nodes), (Component)(customizer != null ? customizer.getComponent() : null), (String)this.getHelpTopicId(), (Component)(customizer != null ? customizer.getInitialFocusComponent() : null));
    }

    protected String getDialogTitle() {
        String title = this.getActionInfo().getDialogTitle();
        if (title == null || title.equals("")) {
            title = this._res.getString("ACTION_ABSTRACT_MULTISELECTION_DIALOG_TITLE");
        }
        return title;
    }

    protected String getDialogHint() {
        String msg = this.getActionInfo().getDialogHint();
        if (msg == null || msg.equals("")) {
            msg = this._res.getString("ACTION_ABSTRACT_MULTISELECTION_DIALOG_MESSAGE");
        }
        return msg;
    }

    protected void postInvoke(VCSProfile profile, final CommandState commandState) throws Exception {
        URL[] eventUrls;
        Collection processed = this.getProcessedUrlsNotifier(commandState);
        URL[] urls = processed.toArray(new URL[processed.size()]);
        boolean recursive = false;
        Boolean b = (Boolean)commandState.getProperty(OPTION_RECURSIVE);
        recursive = b != null ? b : false;
        profile.getStatusCache().clear(urls);
        if (processed.size() > 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VCSBufferUtils.reloadBuffers((Map)commandState.getTimestampMap());
                }
            });
        }
        SVNURLInfoCache.getInstance().clear(urls);
        if (recursive) {
            ArrayList<URL> directories = new ArrayList<URL>(urls.length);
            for (int i = 0; i < urls.length; ++i) {
                if (!URLFileSystem.isDirectoryPath((URL)urls[i])) continue;
                directories.add(urls[i]);
            }
            URLFilter f = VCSURLFilters.createBaseURLContentsFilter((URL[])directories.toArray(new URL[directories.size()]));
            profile.getStatusCache().clear(f);
        }
        if ((eventUrls = (URL[])commandState.getProperty(PROPERTY_RESOURCES_CREATED)) != null && eventUrls.length > 0) {
            this.fireSomeFilesCreated(eventUrls);
        }
        if ((eventUrls = (URL[])commandState.getProperty(PROPERTY_RESOURCES_DELETED)) != null && eventUrls.length > 0) {
            this.fireDeletionEvents(eventUrls);
        }
        if ((eventUrls = (URL[])commandState.getProperty(PROPERTY_RESOURCES_STRUCTURE_CHANGED)) != null && eventUrls.length > 0) {
            this.fireFileStructureChanged(eventUrls);
        }
        VCSControlCache.getInstance().fireControlStateChanged(profile.getID());
    }

    protected void collapseSelectionToWorkingCopy(CommandState state) {
        Locatable workingCopyRoot = null;
        Locatable[] selection = state.getLocatables();
        for (int i = 0; i < selection.length && workingCopyRoot == null; ++i) {
            URL url = SVNUtil.resolveWorkingCopy(selection[i].getURL());
            workingCopyRoot = url != null ? VCSModelUtils.findOrCreateNodes((URL[])new URL[]{url})[0] : null;
        }
        state.setLocatables(new Locatable[]{workingCopyRoot});
    }

    private void fireDeletionEvents(URL[] deleted) {
        ArrayList<URL> files = new ArrayList<URL>(deleted.length * 2);
        ArrayList<URL> dirs = new ArrayList<URL>(deleted.length * 2);
        for (int i = 0; i < deleted.length; ++i) {
            if (URLFileSystem.isDirectoryPath((URL)deleted[i])) {
                dirs.add(deleted[i]);
                continue;
            }
            files.add(deleted[i]);
        }
        this.fireSomeFilesDeleted(files.toArray(new URL[files.size()]));
        Iterator it = dirs.iterator();
        while (it.hasNext()) {
            Node[] nodes = VCSModelUtils.findCachedNodes((URLFilter)VCSURLFilters.createBaseURLContentsFilter((URL[])new URL[]{(URL)it.next()}));
            this.fireSomeFilesDeleted(VCSModelUtils.convertNodesToURLs((Locatable[])nodes));
        }
    }

    protected Collection getProcessedUrlsNotifier(CommandState commandState) {
        ArrayList c = (ArrayList)commandState.getProperty("svn.processed.urls");
        if (c == null) {
            c = new ArrayList(30);
            commandState.setProperty("svn.processed.urls", c);
        }
        return c;
    }
}

