/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav.cmd;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorWindow;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNExecutorService;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteContainer;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class DeleteRemoteResourceCommand
extends Command {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.delete-remote-resource";
    private static final ResourcePicker sRes = ResourcePicker.getPicker(SVNProfile.class);

    public DeleteRemoteResourceCommand() {
        super(Ide.findCmdID((String)COMMAND_ID).intValue());
    }

    public int doit() {
        final SVNRemoteNode[] nodes = SVNUtil.getSVNRemoteNodes(this.getContext());
        if (nodes == null || nodes.length == 0) {
            return 1;
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (!SVNNodeKind.DIR.equals((Object)nodes[i].getNodeKind())) continue;
            if (!this.cancelDirectoryDelete()) break;
            return 1;
        }
        final DeleteResourcesUI panel = new DeleteResourcesUI();
        final JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)panel, (Component)panel._commentsUI.getInitialFocusComponent(), (String)sRes.getString("ACTION_DELETE_REMOTE_RESOURCE_DIALOG_TITLE"), (int)7);
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                    return;
                }
                SVNExecutorService.getInstance().submit(new DeleteResourcesTask(dialog, panel, nodes));
                try {
                    SVNRemoteContainer parent = nodes[0].getParent();
                    parent.close();
                }
                catch (IOException e) {
                    throw new PropertyVetoException(e.getMessage(), pce);
                }
            }
        });
        return WizardLauncher.runDialog((JDialog)dialog) ? 0 : 1;
    }

    private boolean cancelDirectoryDelete() {
        return !MessageDialog.optionalConfirm((String)(DeleteRemoteResourceCommand.class.getName() + ".confirmDelete"), (Component)Ide.getMainWindow(), (String)sRes.getString("ACTION_DELETE_REMOTE_RESOURCE_CONF_MSG"), (String)sRes.getString("ACTION_DELETE_REMOTE_RESOURCE_CONF_TITLE"), null);
    }

    private final class DeleteResourcesUI
    extends JPanel {
        private final VCSCommentsCustomizer _commentsUI;

        private DeleteResourcesUI() {
            super(new GridBagLayout());
            this._commentsUI = new VCSCommentsCustomizer();
            this.createComponents();
            this.layoutComponents();
        }

        private String getComments() {
            return (String)this._commentsUI.getOptions().get("setting_comments");
        }

        private void createComponents() {
            this._commentsUI.setShowReuseCommentsOption(false);
            this._commentsUI.setSuppressContextMenu(true);
        }

        private void layoutComponents() {
            this.add(this._commentsUI.getComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private final class DeleteResourcesTask
    implements Runnable {
        private final JEWTDialog _dialog;
        private final DeleteResourcesUI _panel;
        private final SVNRemoteNode[] _nodes;

        private DeleteResourcesTask(JEWTDialog dialog, DeleteResourcesUI panel, SVNRemoteNode[] nodes) {
            this._dialog = dialog;
            this._panel = panel;
            this._nodes = nodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor((Component)VCSWindowUtils.getCurrentWindow(), sRes.getString("ACTION_DELETE_REMOTE_RESOURCE_PROGESS_TITLE"), (Object)sRes.getString("ACTION_DELETE_REMOTE_RESOURCE_PROGRESS_MESSAGE"), null);
            progress.setMillisToPopup(500);
            progress.setCloseOnFinish(true);
            progress.setCancellable(false);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Ide.getWaitCursor().show();
                }
            });
            progress.start();
            SVNUrl[] resources = new SVNUrl[this._nodes.length];
            for (int i = 0; i < this._nodes.length; ++i) {
                resources[i] = this._nodes[i].getSVNUrl();
            }
            NavigatorWindow nav = null;
            TreeExplorer explorer = null;
            TNode rootTNode = null;
            TNode parentT = null;
            try {
                ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
                SVNOperationLogger.getInstance().beginOperation(client, (SVNRepositoryInfo)this._nodes[0].getParentRepository().getData(), progress);
                nav = (NavigatorWindow)DeleteRemoteResourceCommand.this.context.getView();
                explorer = nav.getTreeExplorer();
                rootTNode = explorer.getRoot();
                parentT = explorer.searchTNode((Element)this._nodes[0].getParent(), rootTNode);
                client.remove(resources, this._panel.getComments());
                SVNOperationLogger.getInstance().endOperation();
            }
            catch (SVNClientException ce) {
                try {
                    SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(ce.getMessage());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ExceptionDialog.showExceptionDialog((Component)VCSWindowUtils.getCurrentWindow(), (Throwable)ce, (String)sRes.getString("ACTION_DELETE_REMOTE_RESOURCE_ERROR_TITLE"), (String)ce.getMessage(), null);
                        }
                    });
                    SVNOperationLogger.getInstance().endOperation();
                }
                catch (Throwable throwable) {
                    SVNOperationLogger.getInstance().endOperation();
                    explorer.expand(parentT, false);
                    progress.finish();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Ide.getWaitCursor().hide();
                        }
                    });
                    throw throwable;
                }
                explorer.expand(parentT, false);
                progress.finish();
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            explorer.expand(parentT, false);
            progress.finish();
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }
}

