/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.MalformedURLException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.wizard.Wizard;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.AlreadyExistsException;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.nav.ui.ConnectionPanel;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;

public final class SVNRepositoryWizard
extends Wizard {
    public static final String PROPERTY_NAME_EDITING = SVNRepositoryWizard.class.getName() + ".editing";
    public static final String PRESET_REPO_URL = "PRESET_REPO_URL";
    public static final String PRESET_REPO_NAME = "PRESET_REPO_NAME";
    public static final String PRESET_TESTAREA = "PRESET_NO_TEST";
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);

    public boolean isAvailable(Context context) {
        return true;
    }

    public boolean invoke(Context context) {
        final ConnectionPanel panel = context.getProperty(PRESET_TESTAREA) != null && context.getProperty(PRESET_TESTAREA).equals(Boolean.FALSE) ? new ConnectionPanel(false) : new ConnectionPanel();
        boolean editing = this.isEditing(context);
        final JEWTDialog dialog = this.createDialog(panel, editing);
        final WaitCursor wc = new WaitCursor((Component)panel);
        panel.addListener(new ConnectionPanel.Listener(){

            @Override
            public void setContainsURL(boolean containsUrl) {
                dialog.setOKButtonEnabled(containsUrl);
            }

            @Override
            public void testHasBegun() {
                dialog.setOKButtonEnabled(false);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        wc.show();
                    }
                });
            }

            @Override
            public void testHasFinished() {
                dialog.setOKButtonEnabled(true);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        wc.hide();
                    }
                });
            }
        });
        dialog.addWindowListener(new WindowListener(){

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                panel.cleanupInteraction();
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        if (editing) {
            SVNRepositoryNode reposNode = (SVNRepositoryNode)context.getNode();
            panel.setRepositoryInfo((SVNRepositoryInfo)reposNode.getData());
            dialog.addVetoableChangeListener((VetoableChangeListener)new EditNodeCommitter(dialog, panel, reposNode));
        } else {
            panel.setRepositoryInfo(null);
            dialog.addVetoableChangeListener((VetoableChangeListener)new NewNodeCommitter(dialog, panel));
        }
        if (context.getProperty(PRESET_REPO_URL) != null) {
            panel.setURL((String)context.getProperty(PRESET_REPO_URL));
        }
        if (context.getProperty(PRESET_REPO_NAME) != null) {
            panel.setRepositoryName((String)context.getProperty(PRESET_REPO_NAME));
        }
        return WizardLauncher.runDialog((JDialog)dialog);
    }

    public String getShortLabel() {
        return this._res.getString("NAV_CONNECTION_WIZARD_LABEL");
    }

    public String getLongLabel() {
        return this._res.getString("NAV_CONNECTION_WIZARD_DESCRIPTION");
    }

    public Icon getIcon() {
        return this._res.getImage("NAV_CONNECTION_WIZARD_ICON");
    }

    private boolean isEditing(Context ctx) {
        Boolean editing = (Boolean)ctx.getProperty(PROPERTY_NAME_EDITING);
        if (editing == null) {
            editing = Boolean.FALSE;
        }
        return ctx.getNode() instanceof SVNRepositoryNode && editing != false;
    }

    private JEWTDialog createDialog(JComponent content, boolean editMode) {
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), editMode ? this._res.getString("NAV_CONNECTION_WIZARD_DIALOG_TITLE_EDIT") : this._res.getString("NAV_CONNECTION_WIZARD_DIALOG_TITLE_CREATE"), 7);
        dialog.setDefaultButton(1);
        dialog.setContent((Component)content);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(this._res.getString("NAV_CONNECTION_WIZARD_DIALOG_HEADER_DESC"));
        dialog.setDialogHeader((Component)header);
        HelpSystem.getHelpSystem().registerTopic(content, editMode ? "f1_svneditsvnconnection_html" : "f1_svncreatesvnconnection_html");
        return dialog;
    }

    private final class EditNodeCommitter
    extends NodeCommitter
    implements VetoableChangeListener {
        private final SVNRepositoryNode _originalNode;

        private EditNodeCommitter(JEWTDialog dialog, ConnectionPanel panel, SVNRepositoryNode originalNode) {
            super(dialog, panel);
            this._originalNode = originalNode;
        }

        @Override
        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                SVNRepositoryManager.getInstance().save();
                SVNRepositoryManager.getInstance().reload();
                return;
            }
            try {
                SVNRepositoryInfo reposInfo = this._panel.createRepositoryInfo();
                SVNRepositoryNavigatorAPI.getInstance().removeRepositoryConnection(this._originalNode);
                SVNRepositoryNavigatorAPI.getInstance().createRepositoryConnection(reposInfo);
            }
            catch (MalformedURLException mfue) {
                this.respond(mfue, pce);
            }
            catch (AlreadyExistsException aee) {
                this.respond(aee, pce);
            }
        }
    }

    private final class NewNodeCommitter
    extends NodeCommitter
    implements VetoableChangeListener {
        private NewNodeCommitter(JEWTDialog dialog, ConnectionPanel panel) {
            super(dialog, panel);
        }

        @Override
        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                SVNRepositoryManager.getInstance().save();
                SVNRepositoryManager.getInstance().reload();
                return;
            }
            try {
                SVNRepositoryInfo reposInfo = this._panel.createRepositoryInfo();
                SVNRepositoryNavigatorAPI.getInstance().createRepositoryConnection(reposInfo);
            }
            catch (MalformedURLException mfue) {
                this.respond(mfue, pce);
            }
            catch (AlreadyExistsException aee) {
                this.respond(aee, pce);
            }
        }
    }

    private abstract class NodeCommitter {
        protected final JEWTDialog _dialog;
        protected final ConnectionPanel _panel;

        NodeCommitter(JEWTDialog dialog, ConnectionPanel panel) {
            this._dialog = dialog;
            this._panel = panel;
        }

        protected void respond(MalformedURLException mfue, PropertyChangeEvent pce) throws PropertyVetoException {
            MessageDialog.error((Component)this._panel, (Object)SVNRepositoryWizard.this._res.getString("NAV_CONNECTION_WIZARD_COMMIT_BAD_URL"), (String)SVNRepositoryWizard.this._res.getString("NAV_CONNECTION_WIZARD_COMMIT_ERROR"), null);
            this._dialog.setOKButtonEnabled(false);
            throw new PropertyVetoException(mfue.getMessage(), pce);
        }

        protected void respond(AlreadyExistsException aee, PropertyChangeEvent pce) throws PropertyVetoException {
            MessageDialog.error((Component)this._panel, (Object)SVNRepositoryWizard.this._res.getString("NAV_CONNECTION_WIZARD_COMMIT_NON_UNIQUE"), (String)SVNRepositoryWizard.this._res.getString("NAV_CONNECTION_WIZARD_COMMIT_ERROR"), null);
            this._dialog.setOKButtonEnabled(false);
            throw new PropertyVetoException(null, pce);
        }
    }
}

