/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.jdeveloper.vcs.nav.VersioningNavigatorConstants;
import oracle.jdevimpl.vcs.svn.AlreadyExistsException;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNNavigatorController;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteContainer;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteFile;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteFolder;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoriesNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoriesObservable;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorManager;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.util.browser.VersionBrowsableViewerAddin;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNRepositoryNavigatorAPI {
    public static Object CLIENT_CONTEXT = new Object();
    private static final SVNRepositoryNavigatorAPI sInstance = new SVNRepositoryNavigatorAPI();
    private SVNNavigatorController _controller;
    private SVNRepositoriesNode _repositoriesNode;
    private VersionBrowsableViewerAddin _viewer;

    public static final SVNRepositoryNavigatorAPI getInstance() {
        return sInstance;
    }

    public void activate() {
        SVNRepositoryNavigatorManager navMgr = SVNRepositoryNavigatorManager.getInstance();
        navMgr.initialize();
        this._repositoriesNode = navMgr.getRepositoriesNode();
        Ide.getSettings().getKeyStrokeOptions().solvePostponedMaps();
        this._controller = new SVNNavigatorController();
        IdeAction[] actions = this.getIdeActions();
        for (int i = 0; i < actions.length; ++i) {
            actions[i].addController((Controller)this._controller);
        }
        this._viewer = new VersionBrowsableViewerAddin(SVNRemoteFile.class);
        EditorManager.getEditorManager().registerDynamic((EditorAddin)this._viewer);
    }

    public void showRepositoryNavigator() {
        Runnable runme = new Runnable(){

            @Override
            public void run() {
                IdeAction showNavigatorAction = IdeAction.find((int)VersioningNavigatorConstants.SHOW_NAVIGATOR_CMD_ID);
                try {
                    if (showNavigatorAction != null) {
                        showNavigatorAction.performAction();
                    }
                }
                catch (Exception e) {
                    SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(e.getMessage());
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runme.run();
        } else {
            SwingUtilities.invokeLater(runme);
        }
    }

    public void createRepositoryConnection(SVNRepositoryInfo reposInfo) throws AlreadyExistsException {
        SVNRepositoryManager reposMgr = SVNRepositoryManager.getInstance();
        reposMgr.add(reposInfo);
        reposMgr.save();
        SVNRepositoryNode reposNode = new SVNRepositoryNode(reposInfo);
        this._repositoriesNode.add((Element)reposNode, true);
        if (this._repositoriesNode.isDirty()) {
            this._repositoriesNode.markDirty(false);
        }
        SVNRepositoriesObservable.getObservable().notifyObservers();
    }

    public SVNRepositoryNode getRepositoryNode(SVNUrl url) {
        Iterator it = this._repositoriesNode.getChildren();
        while (it.hasNext()) {
            SVNRepositoryNode reposNode = (SVNRepositoryNode)it.next();
            SVNRepositoryInfo reposInfo = (SVNRepositoryInfo)reposNode.getData();
            if (!reposInfo.getURL().equals((Object)url)) continue;
            return reposNode;
        }
        return null;
    }

    public void removeRepositoryConnection(SVNRepositoryNode reposNode) {
        SVNRepositoryInfo reposInfo = (SVNRepositoryInfo)reposNode.getData();
        SVNRepositoryManager reposMgr = SVNRepositoryManager.getInstance();
        reposMgr.remove(reposInfo.getURL().toString());
        reposMgr.save();
        this._repositoriesNode.remove((Element)reposNode, true);
        if (this._repositoriesNode.isDirty()) {
            this._repositoriesNode.markDirty(false);
        }
        SVNRepositoriesObservable.getObservable().notifyObservers();
    }

    public void saveRepositoryConnections() {
        SVNRepositoryManager reposMgr = SVNRepositoryManager.getInstance();
        reposMgr.save();
        SVNRepositoriesObservable.getObservable().notifyObservers();
    }

    public boolean canRefresh(Node targetNode) {
        if (targetNode != null) {
            return targetNode instanceof SVNRemoteContainer && targetNode.isOpen();
        }
        return false;
    }

    public boolean canRemove(Node targetNode) {
        if (targetNode != null) {
            return targetNode instanceof SVNRepositoryNode || targetNode instanceof SVNRemoteFolder || targetNode instanceof SVNRemoteFile;
        }
        return false;
    }

    private IdeAction[] getIdeActions() {
        int[] actionIds = new int[]{20, 51, 56, Ide.findCmdID((String)"oracle.jdeveloper.subversion.new-connection"), Ide.findCmdID((String)"oracle.jdeveloper.subversion.new-remote-directory")};
        ArrayList<IdeAction> actions = new ArrayList<IdeAction>(10);
        for (int i = 0; i < actionIds.length; ++i) {
            IdeAction action = IdeAction.find((int)actionIds[i]);
            if (action == null) continue;
            actions.add(action);
        }
        return actions.toArray(new IdeAction[actions.size()]);
    }

    private SVNRepositoryNavigatorAPI() {
    }
}

